package software.amazon.awscdk.services.kinesisfirehose;

/**
 * Value class that wraps a Joda Time format string.
 * <p>
 * Use this with the Hive JSON input format for data record format conversion to parse custom timestamp formats.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * HiveJsonInputFormat inputFormat = HiveJsonInputFormat.Builder.create()
 *         .timestampParsers(List.of(TimestampParser.fromFormatString("yyyy-MM-dd"), TimestampParser.EPOCH_MILLIS))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:08.553Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.TimestampParser")
public class TimestampParser extends software.amazon.jsii.JsiiObject {

    protected TimestampParser(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TimestampParser(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        EPOCH_MILLIS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisfirehose.TimestampParser.class, "EPOCH_MILLIS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.TimestampParser.class));
    }

    /**
     * Creates a TimestampParser from the given format string.
     * <p>
     * The format string should be a valid Joda Time pattern string.
     * See <a href="https://docs.aws.amazon.com/https://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html">Class DateTimeFormat</a> for more details
     * <p>
     * @param format the Joda Time format string. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.TimestampParser fromFormatString(final @org.jetbrains.annotations.NotNull java.lang.String format) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kinesisfirehose.TimestampParser.class, "fromFormatString", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.TimestampParser.class), new Object[] { java.util.Objects.requireNonNull(format, "format is required") });
    }

    /**
     * Parses timestamps formatted in milliseconds since epoch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.kinesisfirehose.TimestampParser EPOCH_MILLIS;

    /**
     * The format string to use in Hive JSON input format configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFormat() {
        return software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
