package software.amazon.awscdk.services.lambda;

/**
 * Properties for an ADOT instrumentation in Lambda.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.AdotLambdaExecWrapper;
 * import software.amazon.awscdk.services.lambda.AdotLayerVersion;
 * import software.amazon.awscdk.services.lambda.AdotLambdaLayerJavaScriptSdkVersion;
 * Function fn = Function.Builder.create(this, "MyFunction")
 *         .runtime(Runtime.NODEJS_18_X)
 *         .handler("index.handler")
 *         .code(Code.fromInline("exports.handler = function(event, ctx, cb) { return cb(null, \"hi\"); }"))
 *         .adotInstrumentation(AdotInstrumentationConfig.builder()
 *                 .layerVersion(AdotLayerVersion.fromJavaScriptSdkLayerVersion(AdotLambdaLayerJavaScriptSdkVersion.LATEST))
 *                 .execWrapper(AdotLambdaExecWrapper.REGULAR_HANDLER)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:08.675Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.AdotInstrumentationConfig")
@software.amazon.jsii.Jsii.Proxy(AdotInstrumentationConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AdotInstrumentationConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The startup script to run, see ADOT documentation to pick the right script for your use case: https://aws-otel.github.io/docs/getting-started/lambda.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.AdotLambdaExecWrapper getExecWrapper();

    /**
     * The ADOT Lambda layer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.AdotLayerVersion getLayerVersion();

    /**
     * @return a {@link Builder} of {@link AdotInstrumentationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AdotInstrumentationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AdotInstrumentationConfig> {
        software.amazon.awscdk.services.lambda.AdotLambdaExecWrapper execWrapper;
        software.amazon.awscdk.services.lambda.AdotLayerVersion layerVersion;

        /**
         * Sets the value of {@link AdotInstrumentationConfig#getExecWrapper}
         * @param execWrapper The startup script to run, see ADOT documentation to pick the right script for your use case: https://aws-otel.github.io/docs/getting-started/lambda. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder execWrapper(software.amazon.awscdk.services.lambda.AdotLambdaExecWrapper execWrapper) {
            this.execWrapper = execWrapper;
            return this;
        }

        /**
         * Sets the value of {@link AdotInstrumentationConfig#getLayerVersion}
         * @param layerVersion The ADOT Lambda layer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder layerVersion(software.amazon.awscdk.services.lambda.AdotLayerVersion layerVersion) {
            this.layerVersion = layerVersion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AdotInstrumentationConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AdotInstrumentationConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AdotInstrumentationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdotInstrumentationConfig {
        private final software.amazon.awscdk.services.lambda.AdotLambdaExecWrapper execWrapper;
        private final software.amazon.awscdk.services.lambda.AdotLayerVersion layerVersion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.execWrapper = software.amazon.jsii.Kernel.get(this, "execWrapper", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.AdotLambdaExecWrapper.class));
            this.layerVersion = software.amazon.jsii.Kernel.get(this, "layerVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.AdotLayerVersion.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.execWrapper = java.util.Objects.requireNonNull(builder.execWrapper, "execWrapper is required");
            this.layerVersion = java.util.Objects.requireNonNull(builder.layerVersion, "layerVersion is required");
        }

        @Override
        public final software.amazon.awscdk.services.lambda.AdotLambdaExecWrapper getExecWrapper() {
            return this.execWrapper;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.AdotLayerVersion getLayerVersion() {
            return this.layerVersion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("execWrapper", om.valueToTree(this.getExecWrapper()));
            data.set("layerVersion", om.valueToTree(this.getLayerVersion()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.AdotInstrumentationConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AdotInstrumentationConfig.Jsii$Proxy that = (AdotInstrumentationConfig.Jsii$Proxy) o;

            if (!execWrapper.equals(that.execWrapper)) return false;
            return this.layerVersion.equals(that.layerVersion);
        }

        @Override
        public final int hashCode() {
            int result = this.execWrapper.hashCode();
            result = 31 * result + (this.layerVersion.hashCode());
            return result;
        }
    }
}
