package software.amazon.awscdk.services.lambda;

/**
 * The type of authentication protocol for your schema registry.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSource;
 * import software.amazon.awscdk.services.lambda.eventsources.ConfluentSchemaRegistry;
 * import software.amazon.awscdk.services.secretsmanager.Secret;
 * // Your MSK cluster arn
 * String clusterArn;
 * Function myFunction;
 * // The Kafka topic you want to subscribe to
 * String topic = "some-cool-topic";
 * Secret secret = Secret.Builder.create(this, "Secret").secretName("AmazonMSK_KafkaSecret").build();
 * myFunction.addEventSource(ManagedKafkaEventSource.Builder.create()
 *         .clusterArn(clusterArn)
 *         .topic(topic)
 *         .startingPosition(StartingPosition.TRIM_HORIZON)
 *         .provisionedPollerConfig(ProvisionedPollerConfig.builder()
 *                 .minimumPollers(1)
 *                 .maximumPollers(3)
 *                 .build())
 *         .schemaRegistryConfig(ConfluentSchemaRegistry.Builder.create()
 *                 .schemaRegistryUri("https://example.com")
 *                 .eventRecordFormat(EventRecordFormat.JSON)
 *                 .authenticationType(KafkaSchemaRegistryAccessConfigType.BASIC_AUTH)
 *                 .secret(secret)
 *                 .schemaValidationConfigs(List.of(KafkaSchemaValidationConfig.builder().attribute(KafkaSchemaValidationAttribute.KEY).build()))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:08.874Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.KafkaSchemaRegistryAccessConfigType")
public class KafkaSchemaRegistryAccessConfigType extends software.amazon.jsii.JsiiObject {

    protected KafkaSchemaRegistryAccessConfigType(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected KafkaSchemaRegistryAccessConfigType(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        BASIC_AUTH = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType.class, "BASIC_AUTH", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType.class));
        CLIENT_CERTIFICATE_TLS_AUTH = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType.class, "CLIENT_CERTIFICATE_TLS_AUTH", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType.class));
        SASL_SCRAM_256_AUTH = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType.class, "SASL_SCRAM_256_AUTH", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType.class));
        SASL_SCRAM_512_AUTH = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType.class, "SASL_SCRAM_512_AUTH", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType.class));
        SERVER_ROOT_CA_CERTIFICATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType.class, "SERVER_ROOT_CA_CERTIFICATE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType.class));
        VIRTUAL_HOST = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType.class, "VIRTUAL_HOST", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType.class));
        VPC_SECURITY_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType.class, "VPC_SECURITY_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType.class));
        VPC_SUBNET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType.class, "VPC_SUBNET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType.class));
    }

    /**
     * A custom source access configuration property for schema registry.
     * <p>
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType of(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * The Secrets Manager secret that stores your broker credentials.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType BASIC_AUTH;

    /**
     * The Secrets Manager ARN of your secret key containing the certificate chain (X.509 PEM), private key (PKCS#8 PEM), and private key password (optional) used for mutual TLS authentication of your schema registry.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType CLIENT_CERTIFICATE_TLS_AUTH;

    /**
     * The Secrets Manager ARN of your secret key used for SASL SCRAM-256 authentication of your self-managed broker.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType SASL_SCRAM_256_AUTH;

    /**
     * The Secrets Manager ARN of your secret key used for SASL SCRAM-512 authentication of your self-managed broker.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType SASL_SCRAM_512_AUTH;

    /**
     * The Secrets Manager ARN of your secret key containing the root CA certificate (X.509 PEM) used for TLS encryption of your schema registry.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType SERVER_ROOT_CA_CERTIFICATE;

    /**
     * The name of the virtual host in your schema registry.
     * <p>
     * Lambda uses this broker host as the event source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType VIRTUAL_HOST;

    /**
     * The VPC security group used to manage access to your self-managed brokers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType VPC_SECURITY_GROUP;

    /**
     * The subnets associated with your VPC.
     * <p>
     * Lambda connects to these subnets to fetch data from your self-managed cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType VPC_SUBNET;

    /**
     * The key to use in <code>SchemaRegistryConfig.AccessConfig.Type</code> property in CloudFormation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
