package software.amazon.awscdk.services.lambda;

/**
 * Configuration for collecting metrics from the event source.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.eventsources.*;
 * import software.amazon.awscdk.services.dynamodb.*;
 * Function fn;
 * Table table = Table.Builder.create(this, "Table")
 *         .partitionKey(Attribute.builder()
 *                 .name("id")
 *                 .type(AttributeType.STRING)
 *                 .build())
 *         .stream(StreamViewType.NEW_IMAGE)
 *         .build();
 * fn.addEventSource(DynamoEventSource.Builder.create(table)
 *         .startingPosition(StartingPosition.LATEST)
 *         .metricsConfig(MetricsConfig.builder()
 *                 .metrics(List.of(MetricType.EVENT_COUNT))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:08.881Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.MetricsConfig")
@software.amazon.jsii.Jsii.Proxy(MetricsConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MetricsConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * List of metric types to enable for this event source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.lambda.MetricType> getMetrics();

    /**
     * @return a {@link Builder} of {@link MetricsConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MetricsConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MetricsConfig> {
        java.util.List<software.amazon.awscdk.services.lambda.MetricType> metrics;

        /**
         * Sets the value of {@link MetricsConfig#getMetrics}
         * @param metrics List of metric types to enable for this event source. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder metrics(java.util.List<? extends software.amazon.awscdk.services.lambda.MetricType> metrics) {
            this.metrics = (java.util.List<software.amazon.awscdk.services.lambda.MetricType>)metrics;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MetricsConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MetricsConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MetricsConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricsConfig {
        private final java.util.List<software.amazon.awscdk.services.lambda.MetricType> metrics;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.metrics = software.amazon.jsii.Kernel.get(this, "metrics", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.MetricType.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.metrics = (java.util.List<software.amazon.awscdk.services.lambda.MetricType>)java.util.Objects.requireNonNull(builder.metrics, "metrics is required");
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.lambda.MetricType> getMetrics() {
            return this.metrics;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("metrics", om.valueToTree(this.getMetrics()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.MetricsConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MetricsConfig.Jsii$Proxy that = (MetricsConfig.Jsii$Proxy) o;

            return this.metrics.equals(that.metrics);
        }

        @Override
        public final int hashCode() {
            int result = this.metrics.hashCode();
            return result;
        }
    }
}
