package software.amazon.awscdk.services.lambda;

/**
 * Parameters and Secrets Extension layer version.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.secretsmanager.*;
 * import software.amazon.awscdk.services.ssm.*;
 * Secret secret = new Secret(this, "Secret");
 * StringParameter parameter = StringParameter.Builder.create(this, "Parameter")
 *         .parameterName("mySsmParameterName")
 *         .stringValue("mySsmParameterValue")
 *         .build();
 * ParamsAndSecretsLayerVersion paramsAndSecrets = ParamsAndSecretsLayerVersion.fromVersion(ParamsAndSecretsVersions.V1_0_103, ParamsAndSecretsOptions.builder()
 *         .cacheSize(500)
 *         .logLevel(ParamsAndSecretsLogLevel.DEBUG)
 *         .build());
 * Function lambdaFunction = Function.Builder.create(this, "MyFunction")
 *         .runtime(Runtime.NODEJS_18_X)
 *         .handler("index.handler")
 *         .architecture(Architecture.ARM_64)
 *         .code(Code.fromAsset(join(__dirname, "lambda-handler")))
 *         .paramsAndSecrets(paramsAndSecrets)
 *         .build();
 * secret.grantRead(lambdaFunction);
 * parameter.grantRead(lambdaFunction);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:08.882Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.ParamsAndSecretsLayerVersion")
public abstract class ParamsAndSecretsLayerVersion extends software.amazon.jsii.JsiiObject {

    protected ParamsAndSecretsLayerVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ParamsAndSecretsLayerVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Use a specific version of the Parameters and Secrets Extension to generate a layer version.
     * <p>
     * @param version This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.ParamsAndSecretsLayerVersion fromVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.ParamsAndSecretsVersions version, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.ParamsAndSecretsOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.ParamsAndSecretsLayerVersion.class, "fromVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ParamsAndSecretsLayerVersion.class), new Object[] { java.util.Objects.requireNonNull(version, "version is required"), options });
    }

    /**
     * Use a specific version of the Parameters and Secrets Extension to generate a layer version.
     * <p>
     * @param version This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.ParamsAndSecretsLayerVersion fromVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.ParamsAndSecretsVersions version) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.ParamsAndSecretsLayerVersion.class, "fromVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ParamsAndSecretsLayerVersion.class), new Object[] { java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * Use the Parameters and Secrets Extension associated with the provided ARN.
     * <p>
     * Make sure the ARN is associated
     * with the same region and architecture as your function.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieving-secrets_lambda.html#retrieving-secrets_lambda_ARNs">https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieving-secrets_lambda.html#retrieving-secrets_lambda_ARNs</a>
     * @param arn This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.ParamsAndSecretsLayerVersion fromVersionArn(final @org.jetbrains.annotations.NotNull java.lang.String arn, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.ParamsAndSecretsOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.ParamsAndSecretsLayerVersion.class, "fromVersionArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ParamsAndSecretsLayerVersion.class), new Object[] { java.util.Objects.requireNonNull(arn, "arn is required"), options });
    }

    /**
     * Use the Parameters and Secrets Extension associated with the provided ARN.
     * <p>
     * Make sure the ARN is associated
     * with the same region and architecture as your function.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieving-secrets_lambda.html#retrieving-secrets_lambda_ARNs">https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieving-secrets_lambda.html#retrieving-secrets_lambda_ARNs</a>
     * @param arn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.ParamsAndSecretsLayerVersion fromVersionArn(final @org.jetbrains.annotations.NotNull java.lang.String arn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.ParamsAndSecretsLayerVersion.class, "fromVersionArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ParamsAndSecretsLayerVersion.class), new Object[] { java.util.Objects.requireNonNull(arn, "arn is required") });
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.lambda.ParamsAndSecretsLayerVersion {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
