package software.amazon.awscdk.services.lambda.eventsources;

/**
 * Properties for confluent schema registry configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSource;
 * import software.amazon.awscdk.services.lambda.eventsources.ConfluentSchemaRegistry;
 * import software.amazon.awscdk.services.secretsmanager.Secret;
 * // Your MSK cluster arn
 * String clusterArn;
 * Function myFunction;
 * // The Kafka topic you want to subscribe to
 * String topic = "some-cool-topic";
 * Secret secret = Secret.Builder.create(this, "Secret").secretName("AmazonMSK_KafkaSecret").build();
 * myFunction.addEventSource(ManagedKafkaEventSource.Builder.create()
 *         .clusterArn(clusterArn)
 *         .topic(topic)
 *         .startingPosition(StartingPosition.TRIM_HORIZON)
 *         .provisionedPollerConfig(ProvisionedPollerConfig.builder()
 *                 .minimumPollers(1)
 *                 .maximumPollers(3)
 *                 .build())
 *         .schemaRegistryConfig(ConfluentSchemaRegistry.Builder.create()
 *                 .schemaRegistryUri("https://example.com")
 *                 .eventRecordFormat(EventRecordFormat.JSON)
 *                 .authenticationType(KafkaSchemaRegistryAccessConfigType.BASIC_AUTH)
 *                 .secret(secret)
 *                 .schemaValidationConfigs(List.of(KafkaSchemaValidationConfig.builder().attribute(KafkaSchemaValidationAttribute.KEY).build()))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:08.931Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda_event_sources.ConfluentSchemaRegistryProps")
@software.amazon.jsii.Jsii.Proxy(ConfluentSchemaRegistryProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ConfluentSchemaRegistryProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.lambda.SchemaRegistryProps {

    /**
     * The type of authentication for schema registry credentials.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType getAuthenticationType();

    /**
     * The URI for your schema registry.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSchemaRegistryUri();

    /**
     * The secret with the schema registry credentials.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret getSecret();

    /**
     * @return a {@link Builder} of {@link ConfluentSchemaRegistryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ConfluentSchemaRegistryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ConfluentSchemaRegistryProps> {
        software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType authenticationType;
        java.lang.String schemaRegistryUri;
        software.amazon.awscdk.services.secretsmanager.ISecret secret;
        software.amazon.awscdk.services.lambda.EventRecordFormat eventRecordFormat;
        java.util.List<software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig> schemaValidationConfigs;

        /**
         * Sets the value of {@link ConfluentSchemaRegistryProps#getAuthenticationType}
         * @param authenticationType The type of authentication for schema registry credentials. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationType(software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        /**
         * Sets the value of {@link ConfluentSchemaRegistryProps#getSchemaRegistryUri}
         * @param schemaRegistryUri The URI for your schema registry. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaRegistryUri(java.lang.String schemaRegistryUri) {
            this.schemaRegistryUri = schemaRegistryUri;
            return this;
        }

        /**
         * Sets the value of {@link ConfluentSchemaRegistryProps#getSecret}
         * @param secret The secret with the schema registry credentials. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secret(software.amazon.awscdk.services.secretsmanager.ISecret secret) {
            this.secret = secret;
            return this;
        }

        /**
         * Sets the value of {@link ConfluentSchemaRegistryProps#getEventRecordFormat}
         * @param eventRecordFormat The record format that Lambda delivers to your function after schema validation. This parameter is required.
         *                          <ul>
         *                          <li>Choose JSON to have Lambda deliver the record to your function as a standard JSON object.</li>
         *                          <li>Choose SOURCE to have Lambda deliver the record to your function in its original source format. Lambda removes all schema metadata, such as the schema ID, before sending the record to your function.</li>
         *                          </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventRecordFormat(software.amazon.awscdk.services.lambda.EventRecordFormat eventRecordFormat) {
            this.eventRecordFormat = eventRecordFormat;
            return this;
        }

        /**
         * Sets the value of {@link ConfluentSchemaRegistryProps#getSchemaValidationConfigs}
         * @param schemaValidationConfigs An array of schema validation configuration objects, which tell Lambda the message attributes you want to validate and filter using your schema registry. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder schemaValidationConfigs(java.util.List<? extends software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig> schemaValidationConfigs) {
            this.schemaValidationConfigs = (java.util.List<software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig>)schemaValidationConfigs;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ConfluentSchemaRegistryProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ConfluentSchemaRegistryProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ConfluentSchemaRegistryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfluentSchemaRegistryProps {
        private final software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType authenticationType;
        private final java.lang.String schemaRegistryUri;
        private final software.amazon.awscdk.services.secretsmanager.ISecret secret;
        private final software.amazon.awscdk.services.lambda.EventRecordFormat eventRecordFormat;
        private final java.util.List<software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig> schemaValidationConfigs;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authenticationType = software.amazon.jsii.Kernel.get(this, "authenticationType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType.class));
            this.schemaRegistryUri = software.amazon.jsii.Kernel.get(this, "schemaRegistryUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.secret = software.amazon.jsii.Kernel.get(this, "secret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
            this.eventRecordFormat = software.amazon.jsii.Kernel.get(this, "eventRecordFormat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.EventRecordFormat.class));
            this.schemaValidationConfigs = software.amazon.jsii.Kernel.get(this, "schemaValidationConfigs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authenticationType = java.util.Objects.requireNonNull(builder.authenticationType, "authenticationType is required");
            this.schemaRegistryUri = java.util.Objects.requireNonNull(builder.schemaRegistryUri, "schemaRegistryUri is required");
            this.secret = java.util.Objects.requireNonNull(builder.secret, "secret is required");
            this.eventRecordFormat = java.util.Objects.requireNonNull(builder.eventRecordFormat, "eventRecordFormat is required");
            this.schemaValidationConfigs = (java.util.List<software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig>)java.util.Objects.requireNonNull(builder.schemaValidationConfigs, "schemaValidationConfigs is required");
        }

        @Override
        public final software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType getAuthenticationType() {
            return this.authenticationType;
        }

        @Override
        public final java.lang.String getSchemaRegistryUri() {
            return this.schemaRegistryUri;
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.ISecret getSecret() {
            return this.secret;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.EventRecordFormat getEventRecordFormat() {
            return this.eventRecordFormat;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig> getSchemaValidationConfigs() {
            return this.schemaValidationConfigs;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("authenticationType", om.valueToTree(this.getAuthenticationType()));
            data.set("schemaRegistryUri", om.valueToTree(this.getSchemaRegistryUri()));
            data.set("secret", om.valueToTree(this.getSecret()));
            data.set("eventRecordFormat", om.valueToTree(this.getEventRecordFormat()));
            data.set("schemaValidationConfigs", om.valueToTree(this.getSchemaValidationConfigs()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda_event_sources.ConfluentSchemaRegistryProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ConfluentSchemaRegistryProps.Jsii$Proxy that = (ConfluentSchemaRegistryProps.Jsii$Proxy) o;

            if (!authenticationType.equals(that.authenticationType)) return false;
            if (!schemaRegistryUri.equals(that.schemaRegistryUri)) return false;
            if (!secret.equals(that.secret)) return false;
            if (!eventRecordFormat.equals(that.eventRecordFormat)) return false;
            return this.schemaValidationConfigs.equals(that.schemaValidationConfigs);
        }

        @Override
        public final int hashCode() {
            int result = this.authenticationType.hashCode();
            result = 31 * result + (this.schemaRegistryUri.hashCode());
            result = 31 * result + (this.secret.hashCode());
            result = 31 * result + (this.eventRecordFormat.hashCode());
            result = 31 * result + (this.schemaValidationConfigs.hashCode());
            return result;
        }
    }
}
