package software.amazon.awscdk.services.lex;

/**
 * A reference to a BotAlias resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lex.*;
 * BotAliasReference botAliasReference = BotAliasReference.builder()
 *         .botAliasArn("botAliasArn")
 *         .botAliasId("botAliasId")
 *         .botId("botId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:08.985Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.BotAliasReference")
@software.amazon.jsii.Jsii.Proxy(BotAliasReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BotAliasReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the BotAlias resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBotAliasArn();

    /**
     * The BotAliasId of the BotAlias resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBotAliasId();

    /**
     * The BotId of the BotAlias resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBotId();

    /**
     * @return a {@link Builder} of {@link BotAliasReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BotAliasReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BotAliasReference> {
        java.lang.String botAliasArn;
        java.lang.String botAliasId;
        java.lang.String botId;

        /**
         * Sets the value of {@link BotAliasReference#getBotAliasArn}
         * @param botAliasArn The ARN of the BotAlias resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botAliasArn(java.lang.String botAliasArn) {
            this.botAliasArn = botAliasArn;
            return this;
        }

        /**
         * Sets the value of {@link BotAliasReference#getBotAliasId}
         * @param botAliasId The BotAliasId of the BotAlias resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botAliasId(java.lang.String botAliasId) {
            this.botAliasId = botAliasId;
            return this;
        }

        /**
         * Sets the value of {@link BotAliasReference#getBotId}
         * @param botId The BotId of the BotAlias resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botId(java.lang.String botId) {
            this.botId = botId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BotAliasReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BotAliasReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BotAliasReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BotAliasReference {
        private final java.lang.String botAliasArn;
        private final java.lang.String botAliasId;
        private final java.lang.String botId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.botAliasArn = software.amazon.jsii.Kernel.get(this, "botAliasArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.botAliasId = software.amazon.jsii.Kernel.get(this, "botAliasId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.botId = software.amazon.jsii.Kernel.get(this, "botId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.botAliasArn = java.util.Objects.requireNonNull(builder.botAliasArn, "botAliasArn is required");
            this.botAliasId = java.util.Objects.requireNonNull(builder.botAliasId, "botAliasId is required");
            this.botId = java.util.Objects.requireNonNull(builder.botId, "botId is required");
        }

        @Override
        public final java.lang.String getBotAliasArn() {
            return this.botAliasArn;
        }

        @Override
        public final java.lang.String getBotAliasId() {
            return this.botAliasId;
        }

        @Override
        public final java.lang.String getBotId() {
            return this.botId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("botAliasArn", om.valueToTree(this.getBotAliasArn()));
            data.set("botAliasId", om.valueToTree(this.getBotAliasId()));
            data.set("botId", om.valueToTree(this.getBotId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.BotAliasReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BotAliasReference.Jsii$Proxy that = (BotAliasReference.Jsii$Proxy) o;

            if (!botAliasArn.equals(that.botAliasArn)) return false;
            if (!botAliasId.equals(that.botAliasId)) return false;
            return this.botId.equals(that.botId);
        }

        @Override
        public final int hashCode() {
            int result = this.botAliasArn.hashCode();
            result = 31 * result + (this.botAliasId.hashCode());
            result = 31 * result + (this.botId.hashCode());
            return result;
        }
    }
}
