package software.amazon.awscdk.services.licensemanager;

/**
 * A reference to a License resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.licensemanager.*;
 * LicenseReference licenseReference = LicenseReference.builder()
 *         .licenseArn("licenseArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:09.120Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_licensemanager.LicenseReference")
@software.amazon.jsii.Jsii.Proxy(LicenseReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LicenseReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The LicenseArn of the License resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLicenseArn();

    /**
     * @return a {@link Builder} of {@link LicenseReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LicenseReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LicenseReference> {
        java.lang.String licenseArn;

        /**
         * Sets the value of {@link LicenseReference#getLicenseArn}
         * @param licenseArn The LicenseArn of the License resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder licenseArn(java.lang.String licenseArn) {
            this.licenseArn = licenseArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LicenseReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LicenseReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LicenseReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LicenseReference {
        private final java.lang.String licenseArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.licenseArn = software.amazon.jsii.Kernel.get(this, "licenseArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.licenseArn = java.util.Objects.requireNonNull(builder.licenseArn, "licenseArn is required");
        }

        @Override
        public final java.lang.String getLicenseArn() {
            return this.licenseArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("licenseArn", om.valueToTree(this.getLicenseArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_licensemanager.LicenseReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LicenseReference.Jsii$Proxy that = (LicenseReference.Jsii$Proxy) o;

            return this.licenseArn.equals(that.licenseArn);
        }

        @Override
        public final int hashCode() {
            int result = this.licenseArn.hashCode();
            return result;
        }
    }
}
