package software.amazon.awscdk.services.lightsail;

/**
 * Properties for defining a <code>CfnLoadBalancerTlsCertificate</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lightsail.*;
 * CfnLoadBalancerTlsCertificateProps cfnLoadBalancerTlsCertificateProps = CfnLoadBalancerTlsCertificateProps.builder()
 *         .certificateDomainName("certificateDomainName")
 *         .certificateName("certificateName")
 *         .loadBalancerName("loadBalancerName")
 *         // the properties below are optional
 *         .certificateAlternativeNames(List.of("certificateAlternativeNames"))
 *         .httpsRedirectionEnabled(false)
 *         .isAttached(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancertlscertificate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancertlscertificate.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:09.214Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnLoadBalancerTlsCertificateProps")
@software.amazon.jsii.Jsii.Proxy(CfnLoadBalancerTlsCertificateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLoadBalancerTlsCertificateProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The domain name for the SSL/TLS certificate.
     * <p>
     * For example, <code>example.com</code> or <code>www.example.com</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancertlscertificate.html#cfn-lightsail-loadbalancertlscertificate-certificatedomainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancertlscertificate.html#cfn-lightsail-loadbalancertlscertificate-certificatedomainname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCertificateDomainName();

    /**
     * The name of the SSL/TLS certificate.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancertlscertificate.html#cfn-lightsail-loadbalancertlscertificate-certificatename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancertlscertificate.html#cfn-lightsail-loadbalancertlscertificate-certificatename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCertificateName();

    /**
     * The name of the load balancer that the SSL/TLS certificate is attached to.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancertlscertificate.html#cfn-lightsail-loadbalancertlscertificate-loadbalancername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancertlscertificate.html#cfn-lightsail-loadbalancertlscertificate-loadbalancername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerName();

    /**
     * An array of alternative domain names and subdomain names for your SSL/TLS certificate.
     * <p>
     * In addition to the primary domain name, you can have up to nine alternative domain names. Wildcards (such as <code>*.example.com</code> ) are not supported.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancertlscertificate.html#cfn-lightsail-loadbalancertlscertificate-certificatealternativenames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancertlscertificate.html#cfn-lightsail-loadbalancertlscertificate-certificatealternativenames</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCertificateAlternativeNames() {
        return null;
    }

    /**
     * A Boolean value indicating whether HTTPS redirection is enabled for the load balancer that the TLS certificate is attached to.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancertlscertificate.html#cfn-lightsail-loadbalancertlscertificate-httpsredirectionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancertlscertificate.html#cfn-lightsail-loadbalancertlscertificate-httpsredirectionenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getHttpsRedirectionEnabled() {
        return null;
    }

    /**
     * A Boolean value indicating whether the SSL/TLS certificate is attached to a Lightsail load balancer.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancertlscertificate.html#cfn-lightsail-loadbalancertlscertificate-isattached">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancertlscertificate.html#cfn-lightsail-loadbalancertlscertificate-isattached</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIsAttached() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLoadBalancerTlsCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLoadBalancerTlsCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLoadBalancerTlsCertificateProps> {
        java.lang.String certificateDomainName;
        java.lang.String certificateName;
        java.lang.String loadBalancerName;
        java.util.List<java.lang.String> certificateAlternativeNames;
        java.lang.Object httpsRedirectionEnabled;
        java.lang.Object isAttached;

        /**
         * Sets the value of {@link CfnLoadBalancerTlsCertificateProps#getCertificateDomainName}
         * @param certificateDomainName The domain name for the SSL/TLS certificate. This parameter is required.
         *                              For example, <code>example.com</code> or <code>www.example.com</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateDomainName(java.lang.String certificateDomainName) {
            this.certificateDomainName = certificateDomainName;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerTlsCertificateProps#getCertificateName}
         * @param certificateName The name of the SSL/TLS certificate. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateName(java.lang.String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerTlsCertificateProps#getLoadBalancerName}
         * @param loadBalancerName The name of the load balancer that the SSL/TLS certificate is attached to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerName(java.lang.String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerTlsCertificateProps#getCertificateAlternativeNames}
         * @param certificateAlternativeNames An array of alternative domain names and subdomain names for your SSL/TLS certificate.
         *                                    In addition to the primary domain name, you can have up to nine alternative domain names. Wildcards (such as <code>*.example.com</code> ) are not supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateAlternativeNames(java.util.List<java.lang.String> certificateAlternativeNames) {
            this.certificateAlternativeNames = certificateAlternativeNames;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerTlsCertificateProps#getHttpsRedirectionEnabled}
         * @param httpsRedirectionEnabled A Boolean value indicating whether HTTPS redirection is enabled for the load balancer that the TLS certificate is attached to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpsRedirectionEnabled(java.lang.Boolean httpsRedirectionEnabled) {
            this.httpsRedirectionEnabled = httpsRedirectionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerTlsCertificateProps#getHttpsRedirectionEnabled}
         * @param httpsRedirectionEnabled A Boolean value indicating whether HTTPS redirection is enabled for the load balancer that the TLS certificate is attached to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpsRedirectionEnabled(software.amazon.awscdk.IResolvable httpsRedirectionEnabled) {
            this.httpsRedirectionEnabled = httpsRedirectionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerTlsCertificateProps#getIsAttached}
         * @param isAttached A Boolean value indicating whether the SSL/TLS certificate is attached to a Lightsail load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isAttached(java.lang.Boolean isAttached) {
            this.isAttached = isAttached;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerTlsCertificateProps#getIsAttached}
         * @param isAttached A Boolean value indicating whether the SSL/TLS certificate is attached to a Lightsail load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isAttached(software.amazon.awscdk.IResolvable isAttached) {
            this.isAttached = isAttached;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLoadBalancerTlsCertificateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLoadBalancerTlsCertificateProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLoadBalancerTlsCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLoadBalancerTlsCertificateProps {
        private final java.lang.String certificateDomainName;
        private final java.lang.String certificateName;
        private final java.lang.String loadBalancerName;
        private final java.util.List<java.lang.String> certificateAlternativeNames;
        private final java.lang.Object httpsRedirectionEnabled;
        private final java.lang.Object isAttached;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.certificateDomainName = software.amazon.jsii.Kernel.get(this, "certificateDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.certificateName = software.amazon.jsii.Kernel.get(this, "certificateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loadBalancerName = software.amazon.jsii.Kernel.get(this, "loadBalancerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.certificateAlternativeNames = software.amazon.jsii.Kernel.get(this, "certificateAlternativeNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.httpsRedirectionEnabled = software.amazon.jsii.Kernel.get(this, "httpsRedirectionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.isAttached = software.amazon.jsii.Kernel.get(this, "isAttached", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.certificateDomainName = java.util.Objects.requireNonNull(builder.certificateDomainName, "certificateDomainName is required");
            this.certificateName = java.util.Objects.requireNonNull(builder.certificateName, "certificateName is required");
            this.loadBalancerName = java.util.Objects.requireNonNull(builder.loadBalancerName, "loadBalancerName is required");
            this.certificateAlternativeNames = builder.certificateAlternativeNames;
            this.httpsRedirectionEnabled = builder.httpsRedirectionEnabled;
            this.isAttached = builder.isAttached;
        }

        @Override
        public final java.lang.String getCertificateDomainName() {
            return this.certificateDomainName;
        }

        @Override
        public final java.lang.String getCertificateName() {
            return this.certificateName;
        }

        @Override
        public final java.lang.String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final java.util.List<java.lang.String> getCertificateAlternativeNames() {
            return this.certificateAlternativeNames;
        }

        @Override
        public final java.lang.Object getHttpsRedirectionEnabled() {
            return this.httpsRedirectionEnabled;
        }

        @Override
        public final java.lang.Object getIsAttached() {
            return this.isAttached;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("certificateDomainName", om.valueToTree(this.getCertificateDomainName()));
            data.set("certificateName", om.valueToTree(this.getCertificateName()));
            data.set("loadBalancerName", om.valueToTree(this.getLoadBalancerName()));
            if (this.getCertificateAlternativeNames() != null) {
                data.set("certificateAlternativeNames", om.valueToTree(this.getCertificateAlternativeNames()));
            }
            if (this.getHttpsRedirectionEnabled() != null) {
                data.set("httpsRedirectionEnabled", om.valueToTree(this.getHttpsRedirectionEnabled()));
            }
            if (this.getIsAttached() != null) {
                data.set("isAttached", om.valueToTree(this.getIsAttached()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lightsail.CfnLoadBalancerTlsCertificateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLoadBalancerTlsCertificateProps.Jsii$Proxy that = (CfnLoadBalancerTlsCertificateProps.Jsii$Proxy) o;

            if (!certificateDomainName.equals(that.certificateDomainName)) return false;
            if (!certificateName.equals(that.certificateName)) return false;
            if (!loadBalancerName.equals(that.loadBalancerName)) return false;
            if (this.certificateAlternativeNames != null ? !this.certificateAlternativeNames.equals(that.certificateAlternativeNames) : that.certificateAlternativeNames != null) return false;
            if (this.httpsRedirectionEnabled != null ? !this.httpsRedirectionEnabled.equals(that.httpsRedirectionEnabled) : that.httpsRedirectionEnabled != null) return false;
            return this.isAttached != null ? this.isAttached.equals(that.isAttached) : that.isAttached == null;
        }

        @Override
        public final int hashCode() {
            int result = this.certificateDomainName.hashCode();
            result = 31 * result + (this.certificateName.hashCode());
            result = 31 * result + (this.loadBalancerName.hashCode());
            result = 31 * result + (this.certificateAlternativeNames != null ? this.certificateAlternativeNames.hashCode() : 0);
            result = 31 * result + (this.httpsRedirectionEnabled != null ? this.httpsRedirectionEnabled.hashCode() : 0);
            result = 31 * result + (this.isAttached != null ? this.isAttached.hashCode() : 0);
            return result;
        }
    }
}
