package software.amazon.awscdk.services.lightsail;

/**
 * A reference to a Database resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lightsail.*;
 * DatabaseReference databaseReference = DatabaseReference.builder()
 *         .databaseArn("databaseArn")
 *         .relationalDatabaseName("relationalDatabaseName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:09.216Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.DatabaseReference")
@software.amazon.jsii.Jsii.Proxy(DatabaseReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DatabaseReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Database resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDatabaseArn();

    /**
     * The RelationalDatabaseName of the Database resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRelationalDatabaseName();

    /**
     * @return a {@link Builder} of {@link DatabaseReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DatabaseReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DatabaseReference> {
        java.lang.String databaseArn;
        java.lang.String relationalDatabaseName;

        /**
         * Sets the value of {@link DatabaseReference#getDatabaseArn}
         * @param databaseArn The ARN of the Database resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseArn(java.lang.String databaseArn) {
            this.databaseArn = databaseArn;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseReference#getRelationalDatabaseName}
         * @param relationalDatabaseName The RelationalDatabaseName of the Database resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder relationalDatabaseName(java.lang.String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DatabaseReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DatabaseReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DatabaseReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseReference {
        private final java.lang.String databaseArn;
        private final java.lang.String relationalDatabaseName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.databaseArn = software.amazon.jsii.Kernel.get(this, "databaseArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.relationalDatabaseName = software.amazon.jsii.Kernel.get(this, "relationalDatabaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.databaseArn = java.util.Objects.requireNonNull(builder.databaseArn, "databaseArn is required");
            this.relationalDatabaseName = java.util.Objects.requireNonNull(builder.relationalDatabaseName, "relationalDatabaseName is required");
        }

        @Override
        public final java.lang.String getDatabaseArn() {
            return this.databaseArn;
        }

        @Override
        public final java.lang.String getRelationalDatabaseName() {
            return this.relationalDatabaseName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("databaseArn", om.valueToTree(this.getDatabaseArn()));
            data.set("relationalDatabaseName", om.valueToTree(this.getRelationalDatabaseName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lightsail.DatabaseReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DatabaseReference.Jsii$Proxy that = (DatabaseReference.Jsii$Proxy) o;

            if (!databaseArn.equals(that.databaseArn)) return false;
            return this.relationalDatabaseName.equals(that.relationalDatabaseName);
        }

        @Override
        public final int hashCode() {
            int result = this.databaseArn.hashCode();
            result = 31 * result + (this.relationalDatabaseName.hashCode());
            return result;
        }
    }
}
