package software.amazon.awscdk.services.lightsail;

/**
 * A reference to a DiskSnapshot resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lightsail.*;
 * DiskSnapshotReference diskSnapshotReference = DiskSnapshotReference.builder()
 *         .diskSnapshotArn("diskSnapshotArn")
 *         .diskSnapshotName("diskSnapshotName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:09.216Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.DiskSnapshotReference")
@software.amazon.jsii.Jsii.Proxy(DiskSnapshotReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DiskSnapshotReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the DiskSnapshot resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDiskSnapshotArn();

    /**
     * The DiskSnapshotName of the DiskSnapshot resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDiskSnapshotName();

    /**
     * @return a {@link Builder} of {@link DiskSnapshotReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DiskSnapshotReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DiskSnapshotReference> {
        java.lang.String diskSnapshotArn;
        java.lang.String diskSnapshotName;

        /**
         * Sets the value of {@link DiskSnapshotReference#getDiskSnapshotArn}
         * @param diskSnapshotArn The ARN of the DiskSnapshot resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder diskSnapshotArn(java.lang.String diskSnapshotArn) {
            this.diskSnapshotArn = diskSnapshotArn;
            return this;
        }

        /**
         * Sets the value of {@link DiskSnapshotReference#getDiskSnapshotName}
         * @param diskSnapshotName The DiskSnapshotName of the DiskSnapshot resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder diskSnapshotName(java.lang.String diskSnapshotName) {
            this.diskSnapshotName = diskSnapshotName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DiskSnapshotReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DiskSnapshotReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DiskSnapshotReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DiskSnapshotReference {
        private final java.lang.String diskSnapshotArn;
        private final java.lang.String diskSnapshotName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.diskSnapshotArn = software.amazon.jsii.Kernel.get(this, "diskSnapshotArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.diskSnapshotName = software.amazon.jsii.Kernel.get(this, "diskSnapshotName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.diskSnapshotArn = java.util.Objects.requireNonNull(builder.diskSnapshotArn, "diskSnapshotArn is required");
            this.diskSnapshotName = java.util.Objects.requireNonNull(builder.diskSnapshotName, "diskSnapshotName is required");
        }

        @Override
        public final java.lang.String getDiskSnapshotArn() {
            return this.diskSnapshotArn;
        }

        @Override
        public final java.lang.String getDiskSnapshotName() {
            return this.diskSnapshotName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("diskSnapshotArn", om.valueToTree(this.getDiskSnapshotArn()));
            data.set("diskSnapshotName", om.valueToTree(this.getDiskSnapshotName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lightsail.DiskSnapshotReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DiskSnapshotReference.Jsii$Proxy that = (DiskSnapshotReference.Jsii$Proxy) o;

            if (!diskSnapshotArn.equals(that.diskSnapshotArn)) return false;
            return this.diskSnapshotName.equals(that.diskSnapshotName);
        }

        @Override
        public final int hashCode() {
            int result = this.diskSnapshotArn.hashCode();
            result = 31 * result + (this.diskSnapshotName.hashCode());
            return result;
        }
    }
}
