package software.amazon.awscdk.services.logs;

/**
 * Properties for a CrossAccountDestination.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.logs.*;
 * IRoleRef roleRef;
 * CrossAccountDestinationProps crossAccountDestinationProps = CrossAccountDestinationProps.builder()
 *         .role(roleRef)
 *         .targetArn("targetArn")
 *         // the properties below are optional
 *         .destinationName("destinationName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:09.342Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CrossAccountDestinationProps")
@software.amazon.jsii.Jsii.Proxy(CrossAccountDestinationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CrossAccountDestinationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The role to assume that grants permissions to write to 'target'.
     * <p>
     * The role must be assumable by 'logs.{REGION}.amazonaws.com'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRoleRef getRole();

    /**
     * The log destination target's ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTargetArn();

    /**
     * The name of the log destination.
     * <p>
     * Default: Automatically generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDestinationName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CrossAccountDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CrossAccountDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CrossAccountDestinationProps> {
        software.amazon.awscdk.services.iam.IRoleRef role;
        java.lang.String targetArn;
        java.lang.String destinationName;

        /**
         * Sets the value of {@link CrossAccountDestinationProps#getRole}
         * @param role The role to assume that grants permissions to write to 'target'. This parameter is required.
         *             The role must be assumable by 'logs.{REGION}.amazonaws.com'.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRoleRef role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link CrossAccountDestinationProps#getTargetArn}
         * @param targetArn The log destination target's ARN. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetArn(java.lang.String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        /**
         * Sets the value of {@link CrossAccountDestinationProps#getDestinationName}
         * @param destinationName The name of the log destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationName(java.lang.String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CrossAccountDestinationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CrossAccountDestinationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CrossAccountDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CrossAccountDestinationProps {
        private final software.amazon.awscdk.services.iam.IRoleRef role;
        private final java.lang.String targetArn;
        private final java.lang.String destinationName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRoleRef.class));
            this.targetArn = software.amazon.jsii.Kernel.get(this, "targetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.destinationName = software.amazon.jsii.Kernel.get(this, "destinationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.role = java.util.Objects.requireNonNull(builder.role, "role is required");
            this.targetArn = java.util.Objects.requireNonNull(builder.targetArn, "targetArn is required");
            this.destinationName = builder.destinationName;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRoleRef getRole() {
            return this.role;
        }

        @Override
        public final java.lang.String getTargetArn() {
            return this.targetArn;
        }

        @Override
        public final java.lang.String getDestinationName() {
            return this.destinationName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("role", om.valueToTree(this.getRole()));
            data.set("targetArn", om.valueToTree(this.getTargetArn()));
            if (this.getDestinationName() != null) {
                data.set("destinationName", om.valueToTree(this.getDestinationName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CrossAccountDestinationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CrossAccountDestinationProps.Jsii$Proxy that = (CrossAccountDestinationProps.Jsii$Proxy) o;

            if (!role.equals(that.role)) return false;
            if (!targetArn.equals(that.targetArn)) return false;
            return this.destinationName != null ? this.destinationName.equals(that.destinationName) : that.destinationName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.role.hashCode();
            result = 31 * result + (this.targetArn.hashCode());
            result = 31 * result + (this.destinationName != null ? this.destinationName.hashCode() : 0);
            return result;
        }
    }
}
