package software.amazon.awscdk.services.logs;

/**
 * The CSV processor parses comma-separated values (CSV) from the log events into columns.
 * <p>
 * For more information about this processor including examples, see csv in the CloudWatch Logs User Guide.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * CsvProperty csvProperty = CsvProperty.builder()
 *         .columns(List.of("columns"))
 *         .delimiter(DelimiterCharacter.COMMA)
 *         .quoteCharacter(QuoteCharacter.DOUBLE_QUOTE)
 *         .source("source")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:09.343Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CsvProperty")
@software.amazon.jsii.Jsii.Proxy(CsvProperty.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CsvProperty extends software.amazon.jsii.JsiiSerializable {

    /**
     * An array of names to use for the columns in the transformed log event.
     * <p>
     * Default: - Column names ([column_1, column_2 ...]) are used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getColumns() {
        return null;
    }

    /**
     * Character used to separate each column in the original comma-separated value log event.
     * <p>
     * Default: DelimiterCharacter.COMMA
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.DelimiterCharacter getDelimiter() {
        return null;
    }

    /**
     * Character used as a text qualifier for a single column of data.
     * <p>
     * Default: QuoteCharacter.DOUBLE_QUOTE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.QuoteCharacter getQuoteCharacter() {
        return null;
    }

    /**
     * The path to the field in the log event that has the comma separated values to be parsed.
     * <p>
     * Default: '@message'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSource() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CsvProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CsvProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CsvProperty> {
        java.util.List<java.lang.String> columns;
        software.amazon.awscdk.services.logs.DelimiterCharacter delimiter;
        software.amazon.awscdk.services.logs.QuoteCharacter quoteCharacter;
        java.lang.String source;

        /**
         * Sets the value of {@link CsvProperty#getColumns}
         * @param columns An array of names to use for the columns in the transformed log event.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder columns(java.util.List<java.lang.String> columns) {
            this.columns = columns;
            return this;
        }

        /**
         * Sets the value of {@link CsvProperty#getDelimiter}
         * @param delimiter Character used to separate each column in the original comma-separated value log event.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder delimiter(software.amazon.awscdk.services.logs.DelimiterCharacter delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        /**
         * Sets the value of {@link CsvProperty#getQuoteCharacter}
         * @param quoteCharacter Character used as a text qualifier for a single column of data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder quoteCharacter(software.amazon.awscdk.services.logs.QuoteCharacter quoteCharacter) {
            this.quoteCharacter = quoteCharacter;
            return this;
        }

        /**
         * Sets the value of {@link CsvProperty#getSource}
         * @param source The path to the field in the log event that has the comma separated values to be parsed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(java.lang.String source) {
            this.source = source;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CsvProperty}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CsvProperty build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CsvProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CsvProperty {
        private final java.util.List<java.lang.String> columns;
        private final software.amazon.awscdk.services.logs.DelimiterCharacter delimiter;
        private final software.amazon.awscdk.services.logs.QuoteCharacter quoteCharacter;
        private final java.lang.String source;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.columns = software.amazon.jsii.Kernel.get(this, "columns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.delimiter = software.amazon.jsii.Kernel.get(this, "delimiter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DelimiterCharacter.class));
            this.quoteCharacter = software.amazon.jsii.Kernel.get(this, "quoteCharacter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.QuoteCharacter.class));
            this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.columns = builder.columns;
            this.delimiter = builder.delimiter;
            this.quoteCharacter = builder.quoteCharacter;
            this.source = builder.source;
        }

        @Override
        public final java.util.List<java.lang.String> getColumns() {
            return this.columns;
        }

        @Override
        public final software.amazon.awscdk.services.logs.DelimiterCharacter getDelimiter() {
            return this.delimiter;
        }

        @Override
        public final software.amazon.awscdk.services.logs.QuoteCharacter getQuoteCharacter() {
            return this.quoteCharacter;
        }

        @Override
        public final java.lang.String getSource() {
            return this.source;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getColumns() != null) {
                data.set("columns", om.valueToTree(this.getColumns()));
            }
            if (this.getDelimiter() != null) {
                data.set("delimiter", om.valueToTree(this.getDelimiter()));
            }
            if (this.getQuoteCharacter() != null) {
                data.set("quoteCharacter", om.valueToTree(this.getQuoteCharacter()));
            }
            if (this.getSource() != null) {
                data.set("source", om.valueToTree(this.getSource()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CsvProperty"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CsvProperty.Jsii$Proxy that = (CsvProperty.Jsii$Proxy) o;

            if (this.columns != null ? !this.columns.equals(that.columns) : that.columns != null) return false;
            if (this.delimiter != null ? !this.delimiter.equals(that.delimiter) : that.delimiter != null) return false;
            if (this.quoteCharacter != null ? !this.quoteCharacter.equals(that.quoteCharacter) : that.quoteCharacter != null) return false;
            return this.source != null ? this.source.equals(that.source) : that.source == null;
        }

        @Override
        public final int hashCode() {
            int result = this.columns != null ? this.columns.hashCode() : 0;
            result = 31 * result + (this.delimiter != null ? this.delimiter.hashCode() : 0);
            result = 31 * result + (this.quoteCharacter != null ? this.quoteCharacter.hashCode() : 0);
            result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
            return result;
        }
    }
}
