package software.amazon.awscdk.services.logs;

/**
 * A reference to a Delivery resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * DeliveryReference deliveryReference = DeliveryReference.builder()
 *         .deliveryArn("deliveryArn")
 *         .deliveryId("deliveryId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:09.348Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.DeliveryReference")
@software.amazon.jsii.Jsii.Proxy(DeliveryReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DeliveryReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Delivery resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeliveryArn();

    /**
     * The DeliveryId of the Delivery resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeliveryId();

    /**
     * @return a {@link Builder} of {@link DeliveryReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DeliveryReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DeliveryReference> {
        java.lang.String deliveryArn;
        java.lang.String deliveryId;

        /**
         * Sets the value of {@link DeliveryReference#getDeliveryArn}
         * @param deliveryArn The ARN of the Delivery resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryArn(java.lang.String deliveryArn) {
            this.deliveryArn = deliveryArn;
            return this;
        }

        /**
         * Sets the value of {@link DeliveryReference#getDeliveryId}
         * @param deliveryId The DeliveryId of the Delivery resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryId(java.lang.String deliveryId) {
            this.deliveryId = deliveryId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DeliveryReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DeliveryReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DeliveryReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeliveryReference {
        private final java.lang.String deliveryArn;
        private final java.lang.String deliveryId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deliveryArn = software.amazon.jsii.Kernel.get(this, "deliveryArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deliveryId = software.amazon.jsii.Kernel.get(this, "deliveryId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deliveryArn = java.util.Objects.requireNonNull(builder.deliveryArn, "deliveryArn is required");
            this.deliveryId = java.util.Objects.requireNonNull(builder.deliveryId, "deliveryId is required");
        }

        @Override
        public final java.lang.String getDeliveryArn() {
            return this.deliveryArn;
        }

        @Override
        public final java.lang.String getDeliveryId() {
            return this.deliveryId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("deliveryArn", om.valueToTree(this.getDeliveryArn()));
            data.set("deliveryId", om.valueToTree(this.getDeliveryId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.DeliveryReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DeliveryReference.Jsii$Proxy that = (DeliveryReference.Jsii$Proxy) o;

            if (!deliveryArn.equals(that.deliveryArn)) return false;
            return this.deliveryId.equals(that.deliveryId);
        }

        @Override
        public final int hashCode() {
            int result = this.deliveryArn.hashCode();
            result = 31 * result + (this.deliveryId.hashCode());
            return result;
        }
    }
}
