package software.amazon.awscdk.services.logs;

/**
 * A reference to a MetricFilter resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * MetricFilterReference metricFilterReference = MetricFilterReference.builder()
 *         .filterName("filterName")
 *         .logGroupName("logGroupName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:09.386Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.MetricFilterReference")
@software.amazon.jsii.Jsii.Proxy(MetricFilterReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MetricFilterReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The FilterName of the MetricFilter resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFilterName();

    /**
     * The LogGroupName of the MetricFilter resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLogGroupName();

    /**
     * @return a {@link Builder} of {@link MetricFilterReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MetricFilterReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MetricFilterReference> {
        java.lang.String filterName;
        java.lang.String logGroupName;

        /**
         * Sets the value of {@link MetricFilterReference#getFilterName}
         * @param filterName The FilterName of the MetricFilter resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterName(java.lang.String filterName) {
            this.filterName = filterName;
            return this;
        }

        /**
         * Sets the value of {@link MetricFilterReference#getLogGroupName}
         * @param logGroupName The LogGroupName of the MetricFilter resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupName(java.lang.String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MetricFilterReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MetricFilterReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MetricFilterReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricFilterReference {
        private final java.lang.String filterName;
        private final java.lang.String logGroupName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.filterName = software.amazon.jsii.Kernel.get(this, "filterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logGroupName = software.amazon.jsii.Kernel.get(this, "logGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.filterName = java.util.Objects.requireNonNull(builder.filterName, "filterName is required");
            this.logGroupName = java.util.Objects.requireNonNull(builder.logGroupName, "logGroupName is required");
        }

        @Override
        public final java.lang.String getFilterName() {
            return this.filterName;
        }

        @Override
        public final java.lang.String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("filterName", om.valueToTree(this.getFilterName()));
            data.set("logGroupName", om.valueToTree(this.getLogGroupName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.MetricFilterReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MetricFilterReference.Jsii$Proxy that = (MetricFilterReference.Jsii$Proxy) o;

            if (!filterName.equals(that.filterName)) return false;
            return this.logGroupName.equals(that.logGroupName);
        }

        @Override
        public final int hashCode() {
            int result = this.filterName.hashCode();
            result = 31 * result + (this.logGroupName.hashCode());
            return result;
        }
    }
}
