package software.amazon.awscdk.services.logs;

/**
 * This processor moves a key from one field to another.
 * <p>
 * The original key is deleted.
 * For more information about this processor including examples, see moveKeys in the CloudWatch Logs User Guide.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * MoveKeysProperty moveKeysProperty = MoveKeysProperty.builder()
 *         .entries(List.of(MoveKeyEntryProperty.builder()
 *                 .source("source")
 *                 .target("target")
 *                 // the properties below are optional
 *                 .overwriteIfExists(false)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:09.387Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.MoveKeysProperty")
@software.amazon.jsii.Jsii.Proxy(MoveKeysProperty.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MoveKeysProperty extends software.amazon.jsii.JsiiSerializable {

    /**
     * An array of objects, where each object contains information about one key to move.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.logs.MoveKeyEntryProperty> getEntries();

    /**
     * @return a {@link Builder} of {@link MoveKeysProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MoveKeysProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MoveKeysProperty> {
        java.util.List<software.amazon.awscdk.services.logs.MoveKeyEntryProperty> entries;

        /**
         * Sets the value of {@link MoveKeysProperty#getEntries}
         * @param entries An array of objects, where each object contains information about one key to move. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder entries(java.util.List<? extends software.amazon.awscdk.services.logs.MoveKeyEntryProperty> entries) {
            this.entries = (java.util.List<software.amazon.awscdk.services.logs.MoveKeyEntryProperty>)entries;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MoveKeysProperty}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MoveKeysProperty build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MoveKeysProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MoveKeysProperty {
        private final java.util.List<software.amazon.awscdk.services.logs.MoveKeyEntryProperty> entries;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.entries = software.amazon.jsii.Kernel.get(this, "entries", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.MoveKeyEntryProperty.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.entries = (java.util.List<software.amazon.awscdk.services.logs.MoveKeyEntryProperty>)java.util.Objects.requireNonNull(builder.entries, "entries is required");
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.logs.MoveKeyEntryProperty> getEntries() {
            return this.entries;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("entries", om.valueToTree(this.getEntries()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.MoveKeysProperty"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MoveKeysProperty.Jsii$Proxy that = (MoveKeysProperty.Jsii$Proxy) o;

            return this.entries.equals(that.entries);
        }

        @Override
        public final int hashCode() {
            int result = this.entries.hashCode();
            return result;
        }
    }
}
