package software.amazon.awscdk.services.logs;

/**
 * A reference to a QueryDefinition resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * QueryDefinitionReference queryDefinitionReference = QueryDefinitionReference.builder()
 *         .queryDefinitionId("queryDefinitionId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:09.391Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.QueryDefinitionReference")
@software.amazon.jsii.Jsii.Proxy(QueryDefinitionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface QueryDefinitionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The QueryDefinitionId of the QueryDefinition resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getQueryDefinitionId();

    /**
     * @return a {@link Builder} of {@link QueryDefinitionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link QueryDefinitionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<QueryDefinitionReference> {
        java.lang.String queryDefinitionId;

        /**
         * Sets the value of {@link QueryDefinitionReference#getQueryDefinitionId}
         * @param queryDefinitionId The QueryDefinitionId of the QueryDefinition resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryDefinitionId(java.lang.String queryDefinitionId) {
            this.queryDefinitionId = queryDefinitionId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link QueryDefinitionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public QueryDefinitionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link QueryDefinitionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueryDefinitionReference {
        private final java.lang.String queryDefinitionId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.queryDefinitionId = software.amazon.jsii.Kernel.get(this, "queryDefinitionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.queryDefinitionId = java.util.Objects.requireNonNull(builder.queryDefinitionId, "queryDefinitionId is required");
        }

        @Override
        public final java.lang.String getQueryDefinitionId() {
            return this.queryDefinitionId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("queryDefinitionId", om.valueToTree(this.getQueryDefinitionId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.QueryDefinitionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            QueryDefinitionReference.Jsii$Proxy that = (QueryDefinitionReference.Jsii$Proxy) o;

            return this.queryDefinitionId.equals(that.queryDefinitionId);
        }

        @Override
        public final int hashCode() {
            int result = this.queryDefinitionId.hashCode();
            return result;
        }
    }
}
