package software.amazon.awscdk.services.logs;

/**
 * Represent the L2 construct for the AWS::Logs::Transformer CloudFormation resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create a log group
 * LogGroup logGroup = new LogGroup(this, "MyLogGroup");
 * // Create a JSON parser processor
 * ParserProcessor jsonParser = ParserProcessor.Builder.create()
 *         .type(ParserProcessorType.JSON)
 *         .build();
 * // Create a processor to add keys
 * JsonMutatorProcessor addKeysProcessor = JsonMutatorProcessor.Builder.create()
 *         .type(JsonMutatorType.ADD_KEYS)
 *         .addKeysOptions(AddKeysProperty.builder()
 *                 .entries(List.of(AddKeyEntryProperty.builder()
 *                         .key("metadata.transformed_in")
 *                         .value("CloudWatchLogs")
 *                         .build()))
 *                 .build())
 *         .build();
 * // Create a transformer with these processors
 * // Create a transformer with these processors
 * Transformer.Builder.create(this, "Transformer")
 *         .transformerName("MyTransformer")
 *         .logGroup(logGroup)
 *         .transformerConfig(List.of(jsonParser, addKeysProcessor))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:09.416Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.Transformer")
public class Transformer extends software.amazon.awscdk.Resource {

    protected Transformer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Transformer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.Transformer.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Transformer L2 construct that represents AWS::Logs::Transformer CFN resource.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Transformer(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.TransformerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The property injection ID for this resource class.
     * <p>
     * Used by the CDK frameworks for managing resource lifecycle.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.logs.Transformer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.logs.Transformer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.logs.TransformerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.logs.TransformerProps.Builder();
        }

        /**
         * Existing log group that you want to associate with this transformer.
         * <p>
         * @return {@code this}
         * @param logGroup Existing log group that you want to associate with this transformer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroup(final software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            this.props.logGroup(logGroup);
            return this;
        }

        /**
         * List of processors in a transformer.
         * <p>
         * @return {@code this}
         * @param transformerConfig List of processors in a transformer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transformerConfig(final java.util.List<? extends software.amazon.awscdk.services.logs.IProcessor> transformerConfig) {
            this.props.transformerConfig(transformerConfig);
            return this;
        }

        /**
         * Name of the transformer.
         * <p>
         * @return {@code this}
         * @param transformerName Name of the transformer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transformerName(final java.lang.String transformerName) {
            this.props.transformerName(transformerName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.logs.Transformer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.logs.Transformer build() {
            return new software.amazon.awscdk.services.logs.Transformer(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
