package software.amazon.awscdk.services.logs;

/**
 * Parser processor for AWS vended logs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * VendedLogParser vendedLogParser = VendedLogParser.Builder.create()
 *         .logType(VendedLogType.CLOUDFRONT)
 *         // the properties below are optional
 *         .source("source")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:09.418Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.VendedLogParser")
public class VendedLogParser extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.logs.IProcessor {

    protected VendedLogParser(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VendedLogParser(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates a new vended log parser processor.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public VendedLogParser(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.VendedLogParserProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The type of AWS vended log.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.VendedLogType getLogType() {
        return software.amazon.jsii.Kernel.get(this, "logType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.VendedLogType.class));
    }

    /**
     * The type of AWS vended log.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogType(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.VendedLogType value) {
        software.amazon.jsii.Kernel.set(this, "logType", java.util.Objects.requireNonNull(value, "logType is required"));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.logs.VendedLogParser}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.logs.VendedLogParser> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.logs.VendedLogParserProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.logs.VendedLogParserProps.Builder();
        }

        /**
         * The type of AWS vended log to parse.
         * <p>
         * @return {@code this}
         * @param logType The type of AWS vended log to parse. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logType(final software.amazon.awscdk.services.logs.VendedLogType logType) {
            this.props.logType(logType);
            return this;
        }

        /**
         * Source field to parse.
         * <p>
         * @return {@code this}
         * @param source Source field to parse. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(final java.lang.String source) {
            this.props.source(source);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.logs.VendedLogParser}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.logs.VendedLogParser build() {
            return new software.amazon.awscdk.services.logs.VendedLogParser(
                this.props.build()
            );
        }
    }
}
