package software.amazon.awscdk.services.lookoutequipment;

/**
 * A reference to a InferenceScheduler resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lookoutequipment.*;
 * InferenceSchedulerReference inferenceSchedulerReference = InferenceSchedulerReference.builder()
 *         .inferenceSchedulerArn("inferenceSchedulerArn")
 *         .inferenceSchedulerName("inferenceSchedulerName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:09.427Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lookoutequipment.InferenceSchedulerReference")
@software.amazon.jsii.Jsii.Proxy(InferenceSchedulerReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InferenceSchedulerReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the InferenceScheduler resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInferenceSchedulerArn();

    /**
     * The InferenceSchedulerName of the InferenceScheduler resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInferenceSchedulerName();

    /**
     * @return a {@link Builder} of {@link InferenceSchedulerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InferenceSchedulerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<InferenceSchedulerReference> {
        java.lang.String inferenceSchedulerArn;
        java.lang.String inferenceSchedulerName;

        /**
         * Sets the value of {@link InferenceSchedulerReference#getInferenceSchedulerArn}
         * @param inferenceSchedulerArn The ARN of the InferenceScheduler resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inferenceSchedulerArn(java.lang.String inferenceSchedulerArn) {
            this.inferenceSchedulerArn = inferenceSchedulerArn;
            return this;
        }

        /**
         * Sets the value of {@link InferenceSchedulerReference#getInferenceSchedulerName}
         * @param inferenceSchedulerName The InferenceSchedulerName of the InferenceScheduler resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inferenceSchedulerName(java.lang.String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InferenceSchedulerReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public InferenceSchedulerReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link InferenceSchedulerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InferenceSchedulerReference {
        private final java.lang.String inferenceSchedulerArn;
        private final java.lang.String inferenceSchedulerName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.inferenceSchedulerArn = software.amazon.jsii.Kernel.get(this, "inferenceSchedulerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.inferenceSchedulerName = software.amazon.jsii.Kernel.get(this, "inferenceSchedulerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.inferenceSchedulerArn = java.util.Objects.requireNonNull(builder.inferenceSchedulerArn, "inferenceSchedulerArn is required");
            this.inferenceSchedulerName = java.util.Objects.requireNonNull(builder.inferenceSchedulerName, "inferenceSchedulerName is required");
        }

        @Override
        public final java.lang.String getInferenceSchedulerArn() {
            return this.inferenceSchedulerArn;
        }

        @Override
        public final java.lang.String getInferenceSchedulerName() {
            return this.inferenceSchedulerName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("inferenceSchedulerArn", om.valueToTree(this.getInferenceSchedulerArn()));
            data.set("inferenceSchedulerName", om.valueToTree(this.getInferenceSchedulerName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lookoutequipment.InferenceSchedulerReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InferenceSchedulerReference.Jsii$Proxy that = (InferenceSchedulerReference.Jsii$Proxy) o;

            if (!inferenceSchedulerArn.equals(that.inferenceSchedulerArn)) return false;
            return this.inferenceSchedulerName.equals(that.inferenceSchedulerName);
        }

        @Override
        public final int hashCode() {
            int result = this.inferenceSchedulerArn.hashCode();
            result = 31 * result + (this.inferenceSchedulerName.hashCode());
            return result;
        }
    }
}
