package software.amazon.awscdk.services.macie;

/**
 * A reference to a AllowList resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.macie.*;
 * AllowListReference allowListReference = AllowListReference.builder()
 *         .allowListArn("allowListArn")
 *         .allowListId("allowListId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:09.471Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_macie.AllowListReference")
@software.amazon.jsii.Jsii.Proxy(AllowListReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AllowListReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the AllowList resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAllowListArn();

    /**
     * The Id of the AllowList resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAllowListId();

    /**
     * @return a {@link Builder} of {@link AllowListReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AllowListReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AllowListReference> {
        java.lang.String allowListArn;
        java.lang.String allowListId;

        /**
         * Sets the value of {@link AllowListReference#getAllowListArn}
         * @param allowListArn The ARN of the AllowList resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowListArn(java.lang.String allowListArn) {
            this.allowListArn = allowListArn;
            return this;
        }

        /**
         * Sets the value of {@link AllowListReference#getAllowListId}
         * @param allowListId The Id of the AllowList resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowListId(java.lang.String allowListId) {
            this.allowListId = allowListId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AllowListReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AllowListReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AllowListReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AllowListReference {
        private final java.lang.String allowListArn;
        private final java.lang.String allowListId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowListArn = software.amazon.jsii.Kernel.get(this, "allowListArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.allowListId = software.amazon.jsii.Kernel.get(this, "allowListId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowListArn = java.util.Objects.requireNonNull(builder.allowListArn, "allowListArn is required");
            this.allowListId = java.util.Objects.requireNonNull(builder.allowListId, "allowListId is required");
        }

        @Override
        public final java.lang.String getAllowListArn() {
            return this.allowListArn;
        }

        @Override
        public final java.lang.String getAllowListId() {
            return this.allowListId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("allowListArn", om.valueToTree(this.getAllowListArn()));
            data.set("allowListId", om.valueToTree(this.getAllowListId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_macie.AllowListReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AllowListReference.Jsii$Proxy that = (AllowListReference.Jsii$Proxy) o;

            if (!allowListArn.equals(that.allowListArn)) return false;
            return this.allowListId.equals(that.allowListId);
        }

        @Override
        public final int hashCode() {
            int result = this.allowListArn.hashCode();
            result = 31 * result + (this.allowListId.hashCode());
            return result;
        }
    }
}
