package software.amazon.awscdk.services.macie;

/**
 * A reference to a CustomDataIdentifier resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.macie.*;
 * CustomDataIdentifierReference customDataIdentifierReference = CustomDataIdentifierReference.builder()
 *         .customDataIdentifierArn("customDataIdentifierArn")
 *         .customDataIdentifierId("customDataIdentifierId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:09.481Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_macie.CustomDataIdentifierReference")
@software.amazon.jsii.Jsii.Proxy(CustomDataIdentifierReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CustomDataIdentifierReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the CustomDataIdentifier resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCustomDataIdentifierArn();

    /**
     * The Id of the CustomDataIdentifier resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCustomDataIdentifierId();

    /**
     * @return a {@link Builder} of {@link CustomDataIdentifierReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CustomDataIdentifierReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CustomDataIdentifierReference> {
        java.lang.String customDataIdentifierArn;
        java.lang.String customDataIdentifierId;

        /**
         * Sets the value of {@link CustomDataIdentifierReference#getCustomDataIdentifierArn}
         * @param customDataIdentifierArn The ARN of the CustomDataIdentifier resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customDataIdentifierArn(java.lang.String customDataIdentifierArn) {
            this.customDataIdentifierArn = customDataIdentifierArn;
            return this;
        }

        /**
         * Sets the value of {@link CustomDataIdentifierReference#getCustomDataIdentifierId}
         * @param customDataIdentifierId The Id of the CustomDataIdentifier resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customDataIdentifierId(java.lang.String customDataIdentifierId) {
            this.customDataIdentifierId = customDataIdentifierId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CustomDataIdentifierReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CustomDataIdentifierReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CustomDataIdentifierReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomDataIdentifierReference {
        private final java.lang.String customDataIdentifierArn;
        private final java.lang.String customDataIdentifierId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.customDataIdentifierArn = software.amazon.jsii.Kernel.get(this, "customDataIdentifierArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customDataIdentifierId = software.amazon.jsii.Kernel.get(this, "customDataIdentifierId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.customDataIdentifierArn = java.util.Objects.requireNonNull(builder.customDataIdentifierArn, "customDataIdentifierArn is required");
            this.customDataIdentifierId = java.util.Objects.requireNonNull(builder.customDataIdentifierId, "customDataIdentifierId is required");
        }

        @Override
        public final java.lang.String getCustomDataIdentifierArn() {
            return this.customDataIdentifierArn;
        }

        @Override
        public final java.lang.String getCustomDataIdentifierId() {
            return this.customDataIdentifierId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("customDataIdentifierArn", om.valueToTree(this.getCustomDataIdentifierArn()));
            data.set("customDataIdentifierId", om.valueToTree(this.getCustomDataIdentifierId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_macie.CustomDataIdentifierReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CustomDataIdentifierReference.Jsii$Proxy that = (CustomDataIdentifierReference.Jsii$Proxy) o;

            if (!customDataIdentifierArn.equals(that.customDataIdentifierArn)) return false;
            return this.customDataIdentifierId.equals(that.customDataIdentifierId);
        }

        @Override
        public final int hashCode() {
            int result = this.customDataIdentifierArn.hashCode();
            result = 31 * result + (this.customDataIdentifierId.hashCode());
            return result;
        }
    }
}
