package software.amazon.awscdk.services.managedblockchain;

/**
 * A reference to a Accessor resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.managedblockchain.*;
 * AccessorReference accessorReference = AccessorReference.builder()
 *         .accessorArn("accessorArn")
 *         .accessorId("accessorId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:09.499Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_managedblockchain.AccessorReference")
@software.amazon.jsii.Jsii.Proxy(AccessorReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AccessorReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Accessor resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAccessorArn();

    /**
     * The Id of the Accessor resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAccessorId();

    /**
     * @return a {@link Builder} of {@link AccessorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AccessorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AccessorReference> {
        java.lang.String accessorArn;
        java.lang.String accessorId;

        /**
         * Sets the value of {@link AccessorReference#getAccessorArn}
         * @param accessorArn The ARN of the Accessor resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessorArn(java.lang.String accessorArn) {
            this.accessorArn = accessorArn;
            return this;
        }

        /**
         * Sets the value of {@link AccessorReference#getAccessorId}
         * @param accessorId The Id of the Accessor resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessorId(java.lang.String accessorId) {
            this.accessorId = accessorId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AccessorReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AccessorReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AccessorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessorReference {
        private final java.lang.String accessorArn;
        private final java.lang.String accessorId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessorArn = software.amazon.jsii.Kernel.get(this, "accessorArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessorId = software.amazon.jsii.Kernel.get(this, "accessorId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessorArn = java.util.Objects.requireNonNull(builder.accessorArn, "accessorArn is required");
            this.accessorId = java.util.Objects.requireNonNull(builder.accessorId, "accessorId is required");
        }

        @Override
        public final java.lang.String getAccessorArn() {
            return this.accessorArn;
        }

        @Override
        public final java.lang.String getAccessorId() {
            return this.accessorId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accessorArn", om.valueToTree(this.getAccessorArn()));
            data.set("accessorId", om.valueToTree(this.getAccessorId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_managedblockchain.AccessorReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AccessorReference.Jsii$Proxy that = (AccessorReference.Jsii$Proxy) o;

            if (!accessorArn.equals(that.accessorArn)) return false;
            return this.accessorId.equals(that.accessorId);
        }

        @Override
        public final int hashCode() {
            int result = this.accessorArn.hashCode();
            result = 31 * result + (this.accessorId.hashCode());
            return result;
        }
    }
}
