package software.amazon.awscdk.services.mediaconnect;

/**
 * A reference to a BridgeOutput resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediaconnect.*;
 * BridgeOutputReference bridgeOutputReference = BridgeOutputReference.builder()
 *         .bridgeArn("bridgeArn")
 *         .bridgeOutputName("bridgeOutputName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:09.511Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.BridgeOutputReference")
@software.amazon.jsii.Jsii.Proxy(BridgeOutputReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BridgeOutputReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The BridgeArn of the BridgeOutput resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBridgeArn();

    /**
     * The Name of the BridgeOutput resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBridgeOutputName();

    /**
     * @return a {@link Builder} of {@link BridgeOutputReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BridgeOutputReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BridgeOutputReference> {
        java.lang.String bridgeArn;
        java.lang.String bridgeOutputName;

        /**
         * Sets the value of {@link BridgeOutputReference#getBridgeArn}
         * @param bridgeArn The BridgeArn of the BridgeOutput resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bridgeArn(java.lang.String bridgeArn) {
            this.bridgeArn = bridgeArn;
            return this;
        }

        /**
         * Sets the value of {@link BridgeOutputReference#getBridgeOutputName}
         * @param bridgeOutputName The Name of the BridgeOutput resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bridgeOutputName(java.lang.String bridgeOutputName) {
            this.bridgeOutputName = bridgeOutputName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BridgeOutputReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BridgeOutputReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BridgeOutputReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BridgeOutputReference {
        private final java.lang.String bridgeArn;
        private final java.lang.String bridgeOutputName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bridgeArn = software.amazon.jsii.Kernel.get(this, "bridgeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bridgeOutputName = software.amazon.jsii.Kernel.get(this, "bridgeOutputName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bridgeArn = java.util.Objects.requireNonNull(builder.bridgeArn, "bridgeArn is required");
            this.bridgeOutputName = java.util.Objects.requireNonNull(builder.bridgeOutputName, "bridgeOutputName is required");
        }

        @Override
        public final java.lang.String getBridgeArn() {
            return this.bridgeArn;
        }

        @Override
        public final java.lang.String getBridgeOutputName() {
            return this.bridgeOutputName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bridgeArn", om.valueToTree(this.getBridgeArn()));
            data.set("bridgeOutputName", om.valueToTree(this.getBridgeOutputName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.BridgeOutputReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BridgeOutputReference.Jsii$Proxy that = (BridgeOutputReference.Jsii$Proxy) o;

            if (!bridgeArn.equals(that.bridgeArn)) return false;
            return this.bridgeOutputName.equals(that.bridgeOutputName);
        }

        @Override
        public final int hashCode() {
            int result = this.bridgeArn.hashCode();
            result = 31 * result + (this.bridgeOutputName.hashCode());
            return result;
        }
    }
}
