package software.amazon.awscdk.services.mediaconnect;

/**
 * Properties for defining a <code>CfnGateway</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediaconnect.*;
 * CfnGatewayProps cfnGatewayProps = CfnGatewayProps.builder()
 *         .egressCidrBlocks(List.of("egressCidrBlocks"))
 *         .name("name")
 *         .networks(List.of(GatewayNetworkProperty.builder()
 *                 .cidrBlock("cidrBlock")
 *                 .name("name")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-gateway.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-gateway.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:09.586Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnGatewayProps")
@software.amazon.jsii.Jsii.Proxy(CfnGatewayProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnGatewayProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The range of IP addresses that are allowed to contribute content or initiate output requests for flows communicating with this gateway.
     * <p>
     * These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-gateway.html#cfn-mediaconnect-gateway-egresscidrblocks">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-gateway.html#cfn-mediaconnect-gateway-egresscidrblocks</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getEgressCidrBlocks();

    /**
     * The name of the gateway.
     * <p>
     * This name can not be modified after the gateway is created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-gateway.html#cfn-mediaconnect-gateway-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-gateway.html#cfn-mediaconnect-gateway-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The list of networks in the gateway.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnGateway.GatewayNetworkProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-gateway.html#cfn-mediaconnect-gateway-networks">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-gateway.html#cfn-mediaconnect-gateway-networks</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getNetworks();

    /**
     * @return a {@link Builder} of {@link CfnGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnGatewayProps> {
        java.util.List<java.lang.String> egressCidrBlocks;
        java.lang.String name;
        java.lang.Object networks;

        /**
         * Sets the value of {@link CfnGatewayProps#getEgressCidrBlocks}
         * @param egressCidrBlocks The range of IP addresses that are allowed to contribute content or initiate output requests for flows communicating with this gateway. This parameter is required.
         *                         These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder egressCidrBlocks(java.util.List<java.lang.String> egressCidrBlocks) {
            this.egressCidrBlocks = egressCidrBlocks;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayProps#getName}
         * @param name The name of the gateway. This parameter is required.
         *             This name can not be modified after the gateway is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayProps#getNetworks}
         * @param networks The list of networks in the gateway. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networks(software.amazon.awscdk.IResolvable networks) {
            this.networks = networks;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayProps#getNetworks}
         * @param networks The list of networks in the gateway. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networks(java.util.List<? extends java.lang.Object> networks) {
            this.networks = networks;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnGatewayProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnGatewayProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnGatewayProps {
        private final java.util.List<java.lang.String> egressCidrBlocks;
        private final java.lang.String name;
        private final java.lang.Object networks;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.egressCidrBlocks = software.amazon.jsii.Kernel.get(this, "egressCidrBlocks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networks = software.amazon.jsii.Kernel.get(this, "networks", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.egressCidrBlocks = java.util.Objects.requireNonNull(builder.egressCidrBlocks, "egressCidrBlocks is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.networks = java.util.Objects.requireNonNull(builder.networks, "networks is required");
        }

        @Override
        public final java.util.List<java.lang.String> getEgressCidrBlocks() {
            return this.egressCidrBlocks;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getNetworks() {
            return this.networks;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("egressCidrBlocks", om.valueToTree(this.getEgressCidrBlocks()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("networks", om.valueToTree(this.getNetworks()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnGatewayProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnGatewayProps.Jsii$Proxy that = (CfnGatewayProps.Jsii$Proxy) o;

            if (!egressCidrBlocks.equals(that.egressCidrBlocks)) return false;
            if (!name.equals(that.name)) return false;
            return this.networks.equals(that.networks);
        }

        @Override
        public final int hashCode() {
            int result = this.egressCidrBlocks.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.networks.hashCode());
            return result;
        }
    }
}
