package software.amazon.awscdk.services.medialive;

/**
 * A reference to a InputSecurityGroup resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.medialive.*;
 * InputSecurityGroupReference inputSecurityGroupReference = InputSecurityGroupReference.builder()
 *         .inputSecurityGroupArn("inputSecurityGroupArn")
 *         .inputSecurityGroupId("inputSecurityGroupId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:09.855Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.InputSecurityGroupReference")
@software.amazon.jsii.Jsii.Proxy(InputSecurityGroupReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InputSecurityGroupReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the InputSecurityGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInputSecurityGroupArn();

    /**
     * The Id of the InputSecurityGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInputSecurityGroupId();

    /**
     * @return a {@link Builder} of {@link InputSecurityGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InputSecurityGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<InputSecurityGroupReference> {
        java.lang.String inputSecurityGroupArn;
        java.lang.String inputSecurityGroupId;

        /**
         * Sets the value of {@link InputSecurityGroupReference#getInputSecurityGroupArn}
         * @param inputSecurityGroupArn The ARN of the InputSecurityGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputSecurityGroupArn(java.lang.String inputSecurityGroupArn) {
            this.inputSecurityGroupArn = inputSecurityGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link InputSecurityGroupReference#getInputSecurityGroupId}
         * @param inputSecurityGroupId The Id of the InputSecurityGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputSecurityGroupId(java.lang.String inputSecurityGroupId) {
            this.inputSecurityGroupId = inputSecurityGroupId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InputSecurityGroupReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public InputSecurityGroupReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link InputSecurityGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputSecurityGroupReference {
        private final java.lang.String inputSecurityGroupArn;
        private final java.lang.String inputSecurityGroupId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.inputSecurityGroupArn = software.amazon.jsii.Kernel.get(this, "inputSecurityGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.inputSecurityGroupId = software.amazon.jsii.Kernel.get(this, "inputSecurityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.inputSecurityGroupArn = java.util.Objects.requireNonNull(builder.inputSecurityGroupArn, "inputSecurityGroupArn is required");
            this.inputSecurityGroupId = java.util.Objects.requireNonNull(builder.inputSecurityGroupId, "inputSecurityGroupId is required");
        }

        @Override
        public final java.lang.String getInputSecurityGroupArn() {
            return this.inputSecurityGroupArn;
        }

        @Override
        public final java.lang.String getInputSecurityGroupId() {
            return this.inputSecurityGroupId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("inputSecurityGroupArn", om.valueToTree(this.getInputSecurityGroupArn()));
            data.set("inputSecurityGroupId", om.valueToTree(this.getInputSecurityGroupId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.InputSecurityGroupReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InputSecurityGroupReference.Jsii$Proxy that = (InputSecurityGroupReference.Jsii$Proxy) o;

            if (!inputSecurityGroupArn.equals(that.inputSecurityGroupArn)) return false;
            return this.inputSecurityGroupId.equals(that.inputSecurityGroupId);
        }

        @Override
        public final int hashCode() {
            int result = this.inputSecurityGroupArn.hashCode();
            result = 31 * result + (this.inputSecurityGroupId.hashCode());
            return result;
        }
    }
}
