package software.amazon.awscdk.services.medialive;

/**
 * A reference to a Multiplex resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.medialive.*;
 * MultiplexReference multiplexReference = MultiplexReference.builder()
 *         .multiplexArn("multiplexArn")
 *         .multiplexId("multiplexId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:09.856Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.MultiplexReference")
@software.amazon.jsii.Jsii.Proxy(MultiplexReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MultiplexReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Multiplex resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMultiplexArn();

    /**
     * The Id of the Multiplex resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMultiplexId();

    /**
     * @return a {@link Builder} of {@link MultiplexReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MultiplexReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MultiplexReference> {
        java.lang.String multiplexArn;
        java.lang.String multiplexId;

        /**
         * Sets the value of {@link MultiplexReference#getMultiplexArn}
         * @param multiplexArn The ARN of the Multiplex resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiplexArn(java.lang.String multiplexArn) {
            this.multiplexArn = multiplexArn;
            return this;
        }

        /**
         * Sets the value of {@link MultiplexReference#getMultiplexId}
         * @param multiplexId The Id of the Multiplex resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiplexId(java.lang.String multiplexId) {
            this.multiplexId = multiplexId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MultiplexReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MultiplexReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MultiplexReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MultiplexReference {
        private final java.lang.String multiplexArn;
        private final java.lang.String multiplexId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.multiplexArn = software.amazon.jsii.Kernel.get(this, "multiplexArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.multiplexId = software.amazon.jsii.Kernel.get(this, "multiplexId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.multiplexArn = java.util.Objects.requireNonNull(builder.multiplexArn, "multiplexArn is required");
            this.multiplexId = java.util.Objects.requireNonNull(builder.multiplexId, "multiplexId is required");
        }

        @Override
        public final java.lang.String getMultiplexArn() {
            return this.multiplexArn;
        }

        @Override
        public final java.lang.String getMultiplexId() {
            return this.multiplexId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("multiplexArn", om.valueToTree(this.getMultiplexArn()));
            data.set("multiplexId", om.valueToTree(this.getMultiplexId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.MultiplexReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MultiplexReference.Jsii$Proxy that = (MultiplexReference.Jsii$Proxy) o;

            if (!multiplexArn.equals(that.multiplexArn)) return false;
            return this.multiplexId.equals(that.multiplexId);
        }

        @Override
        public final int hashCode() {
            int result = this.multiplexArn.hashCode();
            result = 31 * result + (this.multiplexId.hashCode());
            return result;
        }
    }
}
