package software.amazon.awscdk.services.medialive;

/**
 * A reference to a Network resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.medialive.*;
 * NetworkReference networkReference = NetworkReference.builder()
 *         .networkArn("networkArn")
 *         .networkId("networkId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:09.856Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.NetworkReference")
@software.amazon.jsii.Jsii.Proxy(NetworkReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NetworkReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Network resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNetworkArn();

    /**
     * The Id of the Network resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNetworkId();

    /**
     * @return a {@link Builder} of {@link NetworkReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NetworkReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NetworkReference> {
        java.lang.String networkArn;
        java.lang.String networkId;

        /**
         * Sets the value of {@link NetworkReference#getNetworkArn}
         * @param networkArn The ARN of the Network resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkArn(java.lang.String networkArn) {
            this.networkArn = networkArn;
            return this;
        }

        /**
         * Sets the value of {@link NetworkReference#getNetworkId}
         * @param networkId The Id of the Network resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkId(java.lang.String networkId) {
            this.networkId = networkId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NetworkReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NetworkReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkReference {
        private final java.lang.String networkArn;
        private final java.lang.String networkId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.networkArn = software.amazon.jsii.Kernel.get(this, "networkArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkId = software.amazon.jsii.Kernel.get(this, "networkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.networkArn = java.util.Objects.requireNonNull(builder.networkArn, "networkArn is required");
            this.networkId = java.util.Objects.requireNonNull(builder.networkId, "networkId is required");
        }

        @Override
        public final java.lang.String getNetworkArn() {
            return this.networkArn;
        }

        @Override
        public final java.lang.String getNetworkId() {
            return this.networkId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("networkArn", om.valueToTree(this.getNetworkArn()));
            data.set("networkId", om.valueToTree(this.getNetworkId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.NetworkReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NetworkReference.Jsii$Proxy that = (NetworkReference.Jsii$Proxy) o;

            if (!networkArn.equals(that.networkArn)) return false;
            return this.networkId.equals(that.networkId);
        }

        @Override
        public final int hashCode() {
            int result = this.networkArn.hashCode();
            result = 31 * result + (this.networkId.hashCode());
            return result;
        }
    }
}
