package software.amazon.awscdk.services.medialive;

/**
 * A reference to a SdiSource resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.medialive.*;
 * SdiSourceReference sdiSourceReference = SdiSourceReference.builder()
 *         .sdiSourceArn("sdiSourceArn")
 *         .sdiSourceId("sdiSourceId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:09.856Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.SdiSourceReference")
@software.amazon.jsii.Jsii.Proxy(SdiSourceReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SdiSourceReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the SdiSource resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSdiSourceArn();

    /**
     * The Id of the SdiSource resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSdiSourceId();

    /**
     * @return a {@link Builder} of {@link SdiSourceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SdiSourceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SdiSourceReference> {
        java.lang.String sdiSourceArn;
        java.lang.String sdiSourceId;

        /**
         * Sets the value of {@link SdiSourceReference#getSdiSourceArn}
         * @param sdiSourceArn The ARN of the SdiSource resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sdiSourceArn(java.lang.String sdiSourceArn) {
            this.sdiSourceArn = sdiSourceArn;
            return this;
        }

        /**
         * Sets the value of {@link SdiSourceReference#getSdiSourceId}
         * @param sdiSourceId The Id of the SdiSource resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sdiSourceId(java.lang.String sdiSourceId) {
            this.sdiSourceId = sdiSourceId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SdiSourceReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SdiSourceReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SdiSourceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SdiSourceReference {
        private final java.lang.String sdiSourceArn;
        private final java.lang.String sdiSourceId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.sdiSourceArn = software.amazon.jsii.Kernel.get(this, "sdiSourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sdiSourceId = software.amazon.jsii.Kernel.get(this, "sdiSourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.sdiSourceArn = java.util.Objects.requireNonNull(builder.sdiSourceArn, "sdiSourceArn is required");
            this.sdiSourceId = java.util.Objects.requireNonNull(builder.sdiSourceId, "sdiSourceId is required");
        }

        @Override
        public final java.lang.String getSdiSourceArn() {
            return this.sdiSourceArn;
        }

        @Override
        public final java.lang.String getSdiSourceId() {
            return this.sdiSourceId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("sdiSourceArn", om.valueToTree(this.getSdiSourceArn()));
            data.set("sdiSourceId", om.valueToTree(this.getSdiSourceId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.SdiSourceReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SdiSourceReference.Jsii$Proxy that = (SdiSourceReference.Jsii$Proxy) o;

            if (!sdiSourceArn.equals(that.sdiSourceArn)) return false;
            return this.sdiSourceId.equals(that.sdiSourceId);
        }

        @Override
        public final int hashCode() {
            int result = this.sdiSourceArn.hashCode();
            result = 31 * result + (this.sdiSourceId.hashCode());
            return result;
        }
    }
}
