package software.amazon.awscdk.services.mediapackage;

/**
 * Properties for defining a <code>CfnPackagingConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediapackage.*;
 * CfnPackagingConfigurationProps cfnPackagingConfigurationProps = CfnPackagingConfigurationProps.builder()
 *         .id("id")
 *         .packagingGroupId("packagingGroupId")
 *         // the properties below are optional
 *         .cmafPackage(CmafPackageProperty.builder()
 *                 .hlsManifests(List.of(HlsManifestProperty.builder()
 *                         .adMarkers("adMarkers")
 *                         .includeIframeOnlyStream(false)
 *                         .manifestName("manifestName")
 *                         .programDateTimeIntervalSeconds(123)
 *                         .repeatExtXKey(false)
 *                         .streamSelection(StreamSelectionProperty.builder()
 *                                 .maxVideoBitsPerSecond(123)
 *                                 .minVideoBitsPerSecond(123)
 *                                 .streamOrder("streamOrder")
 *                                 .build())
 *                         .build()))
 *                 // the properties below are optional
 *                 .encryption(CmafEncryptionProperty.builder()
 *                         .spekeKeyProvider(SpekeKeyProviderProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .systemIds(List.of("systemIds"))
 *                                 .url("url")
 *                                 // the properties below are optional
 *                                 .encryptionContractConfiguration(EncryptionContractConfigurationProperty.builder()
 *                                         .presetSpeke20Audio("presetSpeke20Audio")
 *                                         .presetSpeke20Video("presetSpeke20Video")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .includeEncoderConfigurationInSegments(false)
 *                 .segmentDurationSeconds(123)
 *                 .build())
 *         .dashPackage(DashPackageProperty.builder()
 *                 .dashManifests(List.of(DashManifestProperty.builder()
 *                         .manifestLayout("manifestLayout")
 *                         .manifestName("manifestName")
 *                         .minBufferTimeSeconds(123)
 *                         .profile("profile")
 *                         .scteMarkersSource("scteMarkersSource")
 *                         .streamSelection(StreamSelectionProperty.builder()
 *                                 .maxVideoBitsPerSecond(123)
 *                                 .minVideoBitsPerSecond(123)
 *                                 .streamOrder("streamOrder")
 *                                 .build())
 *                         .build()))
 *                 // the properties below are optional
 *                 .encryption(DashEncryptionProperty.builder()
 *                         .spekeKeyProvider(SpekeKeyProviderProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .systemIds(List.of("systemIds"))
 *                                 .url("url")
 *                                 // the properties below are optional
 *                                 .encryptionContractConfiguration(EncryptionContractConfigurationProperty.builder()
 *                                         .presetSpeke20Audio("presetSpeke20Audio")
 *                                         .presetSpeke20Video("presetSpeke20Video")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .includeEncoderConfigurationInSegments(false)
 *                 .includeIframeOnlyStream(false)
 *                 .periodTriggers(List.of("periodTriggers"))
 *                 .segmentDurationSeconds(123)
 *                 .segmentTemplateFormat("segmentTemplateFormat")
 *                 .build())
 *         .hlsPackage(HlsPackageProperty.builder()
 *                 .hlsManifests(List.of(HlsManifestProperty.builder()
 *                         .adMarkers("adMarkers")
 *                         .includeIframeOnlyStream(false)
 *                         .manifestName("manifestName")
 *                         .programDateTimeIntervalSeconds(123)
 *                         .repeatExtXKey(false)
 *                         .streamSelection(StreamSelectionProperty.builder()
 *                                 .maxVideoBitsPerSecond(123)
 *                                 .minVideoBitsPerSecond(123)
 *                                 .streamOrder("streamOrder")
 *                                 .build())
 *                         .build()))
 *                 // the properties below are optional
 *                 .encryption(HlsEncryptionProperty.builder()
 *                         .spekeKeyProvider(SpekeKeyProviderProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .systemIds(List.of("systemIds"))
 *                                 .url("url")
 *                                 // the properties below are optional
 *                                 .encryptionContractConfiguration(EncryptionContractConfigurationProperty.builder()
 *                                         .presetSpeke20Audio("presetSpeke20Audio")
 *                                         .presetSpeke20Video("presetSpeke20Video")
 *                                         .build())
 *                                 .build())
 *                         // the properties below are optional
 *                         .constantInitializationVector("constantInitializationVector")
 *                         .encryptionMethod("encryptionMethod")
 *                         .build())
 *                 .includeDvbSubtitles(false)
 *                 .segmentDurationSeconds(123)
 *                 .useAudioRenditionGroup(false)
 *                 .build())
 *         .mssPackage(MssPackageProperty.builder()
 *                 .mssManifests(List.of(MssManifestProperty.builder()
 *                         .manifestName("manifestName")
 *                         .streamSelection(StreamSelectionProperty.builder()
 *                                 .maxVideoBitsPerSecond(123)
 *                                 .minVideoBitsPerSecond(123)
 *                                 .streamOrder("streamOrder")
 *                                 .build())
 *                         .build()))
 *                 // the properties below are optional
 *                 .encryption(MssEncryptionProperty.builder()
 *                         .spekeKeyProvider(SpekeKeyProviderProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .systemIds(List.of("systemIds"))
 *                                 .url("url")
 *                                 // the properties below are optional
 *                                 .encryptionContractConfiguration(EncryptionContractConfigurationProperty.builder()
 *                                         .presetSpeke20Audio("presetSpeke20Audio")
 *                                         .presetSpeke20Video("presetSpeke20Video")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .segmentDurationSeconds(123)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:09.906Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnPackagingConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnPackagingConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPackagingConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Unique identifier that you assign to the packaging configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-id</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getId();

    /**
     * The ID of the packaging group associated with this packaging configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-packaginggroupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-packaginggroupid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPackagingGroupId();

    /**
     * Parameters for CMAF packaging.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.CmafPackageProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-cmafpackage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-cmafpackage</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCmafPackage() {
        return null;
    }

    /**
     * Parameters for DASH-ISO packaging.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.DashPackageProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-dashpackage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-dashpackage</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDashPackage() {
        return null;
    }

    /**
     * Parameters for Apple HLS packaging.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.HlsPackageProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-hlspackage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-hlspackage</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getHlsPackage() {
        return null;
    }

    /**
     * Parameters for Microsoft Smooth Streaming packaging.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.MssPackageProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-msspackage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-msspackage</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMssPackage() {
        return null;
    }

    /**
     * The tags to assign to the packaging configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html#cfn-mediapackage-packagingconfiguration-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPackagingConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPackagingConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPackagingConfigurationProps> {
        java.lang.String id;
        java.lang.String packagingGroupId;
        java.lang.Object cmafPackage;
        java.lang.Object dashPackage;
        java.lang.Object hlsPackage;
        java.lang.Object mssPackage;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnPackagingConfigurationProps#getId}
         * @param id Unique identifier that you assign to the packaging configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of {@link CfnPackagingConfigurationProps#getPackagingGroupId}
         * @param packagingGroupId The ID of the packaging group associated with this packaging configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packagingGroupId(java.lang.String packagingGroupId) {
            this.packagingGroupId = packagingGroupId;
            return this;
        }

        /**
         * Sets the value of {@link CfnPackagingConfigurationProps#getCmafPackage}
         * @param cmafPackage Parameters for CMAF packaging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cmafPackage(software.amazon.awscdk.IResolvable cmafPackage) {
            this.cmafPackage = cmafPackage;
            return this;
        }

        /**
         * Sets the value of {@link CfnPackagingConfigurationProps#getCmafPackage}
         * @param cmafPackage Parameters for CMAF packaging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cmafPackage(software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.CmafPackageProperty cmafPackage) {
            this.cmafPackage = cmafPackage;
            return this;
        }

        /**
         * Sets the value of {@link CfnPackagingConfigurationProps#getDashPackage}
         * @param dashPackage Parameters for DASH-ISO packaging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dashPackage(software.amazon.awscdk.IResolvable dashPackage) {
            this.dashPackage = dashPackage;
            return this;
        }

        /**
         * Sets the value of {@link CfnPackagingConfigurationProps#getDashPackage}
         * @param dashPackage Parameters for DASH-ISO packaging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dashPackage(software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.DashPackageProperty dashPackage) {
            this.dashPackage = dashPackage;
            return this;
        }

        /**
         * Sets the value of {@link CfnPackagingConfigurationProps#getHlsPackage}
         * @param hlsPackage Parameters for Apple HLS packaging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hlsPackage(software.amazon.awscdk.IResolvable hlsPackage) {
            this.hlsPackage = hlsPackage;
            return this;
        }

        /**
         * Sets the value of {@link CfnPackagingConfigurationProps#getHlsPackage}
         * @param hlsPackage Parameters for Apple HLS packaging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hlsPackage(software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.HlsPackageProperty hlsPackage) {
            this.hlsPackage = hlsPackage;
            return this;
        }

        /**
         * Sets the value of {@link CfnPackagingConfigurationProps#getMssPackage}
         * @param mssPackage Parameters for Microsoft Smooth Streaming packaging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mssPackage(software.amazon.awscdk.IResolvable mssPackage) {
            this.mssPackage = mssPackage;
            return this;
        }

        /**
         * Sets the value of {@link CfnPackagingConfigurationProps#getMssPackage}
         * @param mssPackage Parameters for Microsoft Smooth Streaming packaging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mssPackage(software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.MssPackageProperty mssPackage) {
            this.mssPackage = mssPackage;
            return this;
        }

        /**
         * Sets the value of {@link CfnPackagingConfigurationProps#getTags}
         * @param tags The tags to assign to the packaging configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPackagingConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPackagingConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPackagingConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPackagingConfigurationProps {
        private final java.lang.String id;
        private final java.lang.String packagingGroupId;
        private final java.lang.Object cmafPackage;
        private final java.lang.Object dashPackage;
        private final java.lang.Object hlsPackage;
        private final java.lang.Object mssPackage;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.packagingGroupId = software.amazon.jsii.Kernel.get(this, "packagingGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cmafPackage = software.amazon.jsii.Kernel.get(this, "cmafPackage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dashPackage = software.amazon.jsii.Kernel.get(this, "dashPackage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.hlsPackage = software.amazon.jsii.Kernel.get(this, "hlsPackage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.mssPackage = software.amazon.jsii.Kernel.get(this, "mssPackage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
            this.packagingGroupId = java.util.Objects.requireNonNull(builder.packagingGroupId, "packagingGroupId is required");
            this.cmafPackage = builder.cmafPackage;
            this.dashPackage = builder.dashPackage;
            this.hlsPackage = builder.hlsPackage;
            this.mssPackage = builder.mssPackage;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getId() {
            return this.id;
        }

        @Override
        public final java.lang.String getPackagingGroupId() {
            return this.packagingGroupId;
        }

        @Override
        public final java.lang.Object getCmafPackage() {
            return this.cmafPackage;
        }

        @Override
        public final java.lang.Object getDashPackage() {
            return this.dashPackage;
        }

        @Override
        public final java.lang.Object getHlsPackage() {
            return this.hlsPackage;
        }

        @Override
        public final java.lang.Object getMssPackage() {
            return this.mssPackage;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("id", om.valueToTree(this.getId()));
            data.set("packagingGroupId", om.valueToTree(this.getPackagingGroupId()));
            if (this.getCmafPackage() != null) {
                data.set("cmafPackage", om.valueToTree(this.getCmafPackage()));
            }
            if (this.getDashPackage() != null) {
                data.set("dashPackage", om.valueToTree(this.getDashPackage()));
            }
            if (this.getHlsPackage() != null) {
                data.set("hlsPackage", om.valueToTree(this.getHlsPackage()));
            }
            if (this.getMssPackage() != null) {
                data.set("mssPackage", om.valueToTree(this.getMssPackage()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.CfnPackagingConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPackagingConfigurationProps.Jsii$Proxy that = (CfnPackagingConfigurationProps.Jsii$Proxy) o;

            if (!id.equals(that.id)) return false;
            if (!packagingGroupId.equals(that.packagingGroupId)) return false;
            if (this.cmafPackage != null ? !this.cmafPackage.equals(that.cmafPackage) : that.cmafPackage != null) return false;
            if (this.dashPackage != null ? !this.dashPackage.equals(that.dashPackage) : that.dashPackage != null) return false;
            if (this.hlsPackage != null ? !this.hlsPackage.equals(that.hlsPackage) : that.hlsPackage != null) return false;
            if (this.mssPackage != null ? !this.mssPackage.equals(that.mssPackage) : that.mssPackage != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + (this.packagingGroupId.hashCode());
            result = 31 * result + (this.cmafPackage != null ? this.cmafPackage.hashCode() : 0);
            result = 31 * result + (this.dashPackage != null ? this.dashPackage.hashCode() : 0);
            result = 31 * result + (this.hlsPackage != null ? this.hlsPackage.hashCode() : 0);
            result = 31 * result + (this.mssPackage != null ? this.mssPackage.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
