package software.amazon.awscdk.services.mediapackage;

/**
 * A reference to a OriginEndpoint resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediapackage.*;
 * OriginEndpointReference originEndpointReference = OriginEndpointReference.builder()
 *         .originEndpointArn("originEndpointArn")
 *         .originEndpointId("originEndpointId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:09.910Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.OriginEndpointReference")
@software.amazon.jsii.Jsii.Proxy(OriginEndpointReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OriginEndpointReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the OriginEndpoint resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOriginEndpointArn();

    /**
     * The Id of the OriginEndpoint resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOriginEndpointId();

    /**
     * @return a {@link Builder} of {@link OriginEndpointReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OriginEndpointReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OriginEndpointReference> {
        java.lang.String originEndpointArn;
        java.lang.String originEndpointId;

        /**
         * Sets the value of {@link OriginEndpointReference#getOriginEndpointArn}
         * @param originEndpointArn The ARN of the OriginEndpoint resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originEndpointArn(java.lang.String originEndpointArn) {
            this.originEndpointArn = originEndpointArn;
            return this;
        }

        /**
         * Sets the value of {@link OriginEndpointReference#getOriginEndpointId}
         * @param originEndpointId The Id of the OriginEndpoint resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originEndpointId(java.lang.String originEndpointId) {
            this.originEndpointId = originEndpointId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OriginEndpointReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OriginEndpointReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OriginEndpointReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginEndpointReference {
        private final java.lang.String originEndpointArn;
        private final java.lang.String originEndpointId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.originEndpointArn = software.amazon.jsii.Kernel.get(this, "originEndpointArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.originEndpointId = software.amazon.jsii.Kernel.get(this, "originEndpointId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.originEndpointArn = java.util.Objects.requireNonNull(builder.originEndpointArn, "originEndpointArn is required");
            this.originEndpointId = java.util.Objects.requireNonNull(builder.originEndpointId, "originEndpointId is required");
        }

        @Override
        public final java.lang.String getOriginEndpointArn() {
            return this.originEndpointArn;
        }

        @Override
        public final java.lang.String getOriginEndpointId() {
            return this.originEndpointId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("originEndpointArn", om.valueToTree(this.getOriginEndpointArn()));
            data.set("originEndpointId", om.valueToTree(this.getOriginEndpointId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.OriginEndpointReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OriginEndpointReference.Jsii$Proxy that = (OriginEndpointReference.Jsii$Proxy) o;

            if (!originEndpointArn.equals(that.originEndpointArn)) return false;
            return this.originEndpointId.equals(that.originEndpointId);
        }

        @Override
        public final int hashCode() {
            int result = this.originEndpointArn.hashCode();
            result = 31 * result + (this.originEndpointId.hashCode());
            return result;
        }
    }
}
