package software.amazon.awscdk.services.mediapackagev2;

/**
 * Specifies the configuration parameters for a MediaPackage V2 origin endpoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediapackagev2.*;
 * CfnOriginEndpoint cfnOriginEndpoint = CfnOriginEndpoint.Builder.create(this, "MyCfnOriginEndpoint")
 *         .channelGroupName("channelGroupName")
 *         .channelName("channelName")
 *         .containerType("containerType")
 *         .originEndpointName("originEndpointName")
 *         // the properties below are optional
 *         .dashManifests(List.of(DashManifestConfigurationProperty.builder()
 *                 .manifestName("manifestName")
 *                 // the properties below are optional
 *                 .baseUrls(List.of(DashBaseUrlProperty.builder()
 *                         .url("url")
 *                         // the properties below are optional
 *                         .dvbPriority(123)
 *                         .dvbWeight(123)
 *                         .serviceLocation("serviceLocation")
 *                         .build()))
 *                 .compactness("compactness")
 *                 .drmSignaling("drmSignaling")
 *                 .dvbSettings(DashDvbSettingsProperty.builder()
 *                         .errorMetrics(List.of(DashDvbMetricsReportingProperty.builder()
 *                                 .reportingUrl("reportingUrl")
 *                                 // the properties below are optional
 *                                 .probability(123)
 *                                 .build()))
 *                         .fontDownload(DashDvbFontDownloadProperty.builder()
 *                                 .fontFamily("fontFamily")
 *                                 .mimeType("mimeType")
 *                                 .url("url")
 *                                 .build())
 *                         .build())
 *                 .filterConfiguration(FilterConfigurationProperty.builder()
 *                         .clipStartTime("clipStartTime")
 *                         .end("end")
 *                         .manifestFilter("manifestFilter")
 *                         .start("start")
 *                         .timeDelaySeconds(123)
 *                         .build())
 *                 .manifestWindowSeconds(123)
 *                 .minBufferTimeSeconds(123)
 *                 .minUpdatePeriodSeconds(123)
 *                 .periodTriggers(List.of("periodTriggers"))
 *                 .profiles(List.of("profiles"))
 *                 .programInformation(DashProgramInformationProperty.builder()
 *                         .copyright("copyright")
 *                         .languageCode("languageCode")
 *                         .moreInformationUrl("moreInformationUrl")
 *                         .source("source")
 *                         .title("title")
 *                         .build())
 *                 .scteDash(ScteDashProperty.builder()
 *                         .adMarkerDash("adMarkerDash")
 *                         .build())
 *                 .segmentTemplateFormat("segmentTemplateFormat")
 *                 .subtitleConfiguration(DashSubtitleConfigurationProperty.builder()
 *                         .ttmlConfiguration(DashTtmlConfigurationProperty.builder()
 *                                 .ttmlProfile("ttmlProfile")
 *                                 .build())
 *                         .build())
 *                 .suggestedPresentationDelaySeconds(123)
 *                 .utcTiming(DashUtcTimingProperty.builder()
 *                         .timingMode("timingMode")
 *                         .timingSource("timingSource")
 *                         .build())
 *                 .build()))
 *         .description("description")
 *         .forceEndpointErrorConfiguration(ForceEndpointErrorConfigurationProperty.builder()
 *                 .endpointErrorConditions(List.of("endpointErrorConditions"))
 *                 .build())
 *         .hlsManifests(List.of(HlsManifestConfigurationProperty.builder()
 *                 .manifestName("manifestName")
 *                 // the properties below are optional
 *                 .childManifestName("childManifestName")
 *                 .filterConfiguration(FilterConfigurationProperty.builder()
 *                         .clipStartTime("clipStartTime")
 *                         .end("end")
 *                         .manifestFilter("manifestFilter")
 *                         .start("start")
 *                         .timeDelaySeconds(123)
 *                         .build())
 *                 .manifestWindowSeconds(123)
 *                 .programDateTimeIntervalSeconds(123)
 *                 .scteHls(ScteHlsProperty.builder()
 *                         .adMarkerHls("adMarkerHls")
 *                         .build())
 *                 .startTag(StartTagProperty.builder()
 *                         .timeOffset(123)
 *                         // the properties below are optional
 *                         .precise(false)
 *                         .build())
 *                 .url("url")
 *                 .urlEncodeChildManifest(false)
 *                 .build()))
 *         .lowLatencyHlsManifests(List.of(LowLatencyHlsManifestConfigurationProperty.builder()
 *                 .manifestName("manifestName")
 *                 // the properties below are optional
 *                 .childManifestName("childManifestName")
 *                 .filterConfiguration(FilterConfigurationProperty.builder()
 *                         .clipStartTime("clipStartTime")
 *                         .end("end")
 *                         .manifestFilter("manifestFilter")
 *                         .start("start")
 *                         .timeDelaySeconds(123)
 *                         .build())
 *                 .manifestWindowSeconds(123)
 *                 .programDateTimeIntervalSeconds(123)
 *                 .scteHls(ScteHlsProperty.builder()
 *                         .adMarkerHls("adMarkerHls")
 *                         .build())
 *                 .startTag(StartTagProperty.builder()
 *                         .timeOffset(123)
 *                         // the properties below are optional
 *                         .precise(false)
 *                         .build())
 *                 .url("url")
 *                 .urlEncodeChildManifest(false)
 *                 .build()))
 *         .mssManifests(List.of(MssManifestConfigurationProperty.builder()
 *                 .manifestName("manifestName")
 *                 // the properties below are optional
 *                 .filterConfiguration(FilterConfigurationProperty.builder()
 *                         .clipStartTime("clipStartTime")
 *                         .end("end")
 *                         .manifestFilter("manifestFilter")
 *                         .start("start")
 *                         .timeDelaySeconds(123)
 *                         .build())
 *                 .manifestLayout("manifestLayout")
 *                 .manifestWindowSeconds(123)
 *                 .build()))
 *         .segment(SegmentProperty.builder()
 *                 .encryption(EncryptionProperty.builder()
 *                         .encryptionMethod(EncryptionMethodProperty.builder()
 *                                 .cmafEncryptionMethod("cmafEncryptionMethod")
 *                                 .ismEncryptionMethod("ismEncryptionMethod")
 *                                 .tsEncryptionMethod("tsEncryptionMethod")
 *                                 .build())
 *                         .spekeKeyProvider(SpekeKeyProviderProperty.builder()
 *                                 .drmSystems(List.of("drmSystems"))
 *                                 .encryptionContractConfiguration(EncryptionContractConfigurationProperty.builder()
 *                                         .presetSpeke20Audio("presetSpeke20Audio")
 *                                         .presetSpeke20Video("presetSpeke20Video")
 *                                         .build())
 *                                 .resourceId("resourceId")
 *                                 .roleArn("roleArn")
 *                                 .url("url")
 *                                 .build())
 *                         // the properties below are optional
 *                         .cmafExcludeSegmentDrmMetadata(false)
 *                         .constantInitializationVector("constantInitializationVector")
 *                         .keyRotationIntervalSeconds(123)
 *                         .build())
 *                 .includeIframeOnlyStreams(false)
 *                 .scte(ScteProperty.builder()
 *                         .scteFilter(List.of("scteFilter"))
 *                         .build())
 *                 .segmentDurationSeconds(123)
 *                 .segmentName("segmentName")
 *                 .tsIncludeDvbSubtitles(false)
 *                 .tsUseAudioRenditionGroup(false)
 *                 .build())
 *         .startoverWindowSeconds(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:09.930Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint")
public class CfnOriginEndpoint extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.services.mediapackagev2.IOriginEndpointRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnOriginEndpoint(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnOriginEndpoint(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnOriginEndpoint(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpointProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the origin endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp of the creation of the origin endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The egress domain URL for stream delivery from MediaPackage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrDashManifestUrls() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrDashManifestUrls", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The egress domain URL for stream delivery from MediaPackage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrHlsManifestUrls() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrHlsManifestUrls", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The egress domain URL for stream delivery from MediaPackage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrLowLatencyHlsManifestUrls() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrLowLatencyHlsManifestUrls", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The timestamp of the modification of the origin endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrModifiedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrModifiedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrMssManifestUrls() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrMssManifestUrls", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a OriginEndpoint resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.mediapackagev2.OriginEndpointReference getOriginEndpointRef() {
        return software.amazon.jsii.Kernel.get(this, "originEndpointRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.mediapackagev2.OriginEndpointReference.class));
    }

    /**
     * The name of the channel group associated with the origin endpoint configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getChannelGroupName() {
        return software.amazon.jsii.Kernel.get(this, "channelGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the channel group associated with the origin endpoint configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChannelGroupName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "channelGroupName", java.util.Objects.requireNonNull(value, "channelGroupName is required"));
    }

    /**
     * The channel name associated with the origin endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getChannelName() {
        return software.amazon.jsii.Kernel.get(this, "channelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The channel name associated with the origin endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChannelName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "channelName", java.util.Objects.requireNonNull(value, "channelName is required"));
    }

    /**
     * The container type associated with the origin endpoint configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getContainerType() {
        return software.amazon.jsii.Kernel.get(this, "containerType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The container type associated with the origin endpoint configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContainerType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "containerType", java.util.Objects.requireNonNull(value, "containerType is required"));
    }

    /**
     * The name of the origin endpoint associated with the origin endpoint configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getOriginEndpointName() {
        return software.amazon.jsii.Kernel.get(this, "originEndpointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the origin endpoint associated with the origin endpoint configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOriginEndpointName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "originEndpointName", java.util.Objects.requireNonNull(value, "originEndpointName is required"));
    }

    /**
     * A DASH manifest configuration.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.DashManifestConfigurationProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDashManifests() {
        return software.amazon.jsii.Kernel.get(this, "dashManifests", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A DASH manifest configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDashManifests(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dashManifests", value);
    }

    /**
     * A DASH manifest configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDashManifests(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.DashManifestConfigurationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.DashManifestConfigurationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "dashManifests", value);
    }

    /**
     * The description associated with the origin endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description associated with the origin endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The failover settings for the endpoint.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.ForceEndpointErrorConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getForceEndpointErrorConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "forceEndpointErrorConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The failover settings for the endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setForceEndpointErrorConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "forceEndpointErrorConfiguration", value);
    }

    /**
     * The failover settings for the endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setForceEndpointErrorConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.ForceEndpointErrorConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "forceEndpointErrorConfiguration", value);
    }

    /**
     * The HLS manifests associated with the origin endpoint configuration.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.HlsManifestConfigurationProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getHlsManifests() {
        return software.amazon.jsii.Kernel.get(this, "hlsManifests", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The HLS manifests associated with the origin endpoint configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHlsManifests(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "hlsManifests", value);
    }

    /**
     * The HLS manifests associated with the origin endpoint configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHlsManifests(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.HlsManifestConfigurationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.HlsManifestConfigurationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "hlsManifests", value);
    }

    /**
     * The low-latency HLS (LL-HLS) manifests associated with the origin endpoint.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.LowLatencyHlsManifestConfigurationProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLowLatencyHlsManifests() {
        return software.amazon.jsii.Kernel.get(this, "lowLatencyHlsManifests", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The low-latency HLS (LL-HLS) manifests associated with the origin endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLowLatencyHlsManifests(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "lowLatencyHlsManifests", value);
    }

    /**
     * The low-latency HLS (LL-HLS) manifests associated with the origin endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLowLatencyHlsManifests(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.LowLatencyHlsManifestConfigurationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.LowLatencyHlsManifestConfigurationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "lowLatencyHlsManifests", value);
    }

    /**
     * A list of Microsoft Smooth Streaming (MSS) manifest configurations associated with the origin endpoint.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.MssManifestConfigurationProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMssManifests() {
        return software.amazon.jsii.Kernel.get(this, "mssManifests", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of Microsoft Smooth Streaming (MSS) manifest configurations associated with the origin endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMssManifests(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "mssManifests", value);
    }

    /**
     * A list of Microsoft Smooth Streaming (MSS) manifest configurations associated with the origin endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMssManifests(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.MssManifestConfigurationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.MssManifestConfigurationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "mssManifests", value);
    }

    /**
     * The segment associated with the origin endpoint.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.SegmentProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSegment() {
        return software.amazon.jsii.Kernel.get(this, "segment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The segment associated with the origin endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSegment(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "segment", value);
    }

    /**
     * The segment associated with the origin endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSegment(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.SegmentProperty value) {
        software.amazon.jsii.Kernel.set(this, "segment", value);
    }

    /**
     * The size of the window (in seconds) to specify a window of the live stream that's available for on-demand viewing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getStartoverWindowSeconds() {
        return software.amazon.jsii.Kernel.get(this, "startoverWindowSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The size of the window (in seconds) to specify a window of the live stream that's available for on-demand viewing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStartoverWindowSeconds(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "startoverWindowSeconds", value);
    }

    /**
     * The tags associated with the origin endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags associated with the origin endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * The base URLs to use for retrieving segments.
     * <p>
     * You can specify multiple locations and indicate the priority and weight for when each should be used, for use in mutli-CDN workflows.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackagev2.*;
     * DashBaseUrlProperty dashBaseUrlProperty = DashBaseUrlProperty.builder()
     *         .url("url")
     *         // the properties below are optional
     *         .dvbPriority(123)
     *         .dvbWeight(123)
     *         .serviceLocation("serviceLocation")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashbaseurl.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashbaseurl.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.DashBaseUrlProperty")
    @software.amazon.jsii.Jsii.Proxy(DashBaseUrlProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DashBaseUrlProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A source location for segments.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashbaseurl.html#cfn-mediapackagev2-originendpoint-dashbaseurl-url">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashbaseurl.html#cfn-mediapackagev2-originendpoint-dashbaseurl-url</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUrl();

        /**
         * For use with DVB-DASH profiles only.
         * <p>
         * The priority of this location for servings segments. The lower the number, the higher the priority.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashbaseurl.html#cfn-mediapackagev2-originendpoint-dashbaseurl-dvbpriority">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashbaseurl.html#cfn-mediapackagev2-originendpoint-dashbaseurl-dvbpriority</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDvbPriority() {
            return null;
        }

        /**
         * For use with DVB-DASH profiles only.
         * <p>
         * The weighting for source locations that have the same priority.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashbaseurl.html#cfn-mediapackagev2-originendpoint-dashbaseurl-dvbweight">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashbaseurl.html#cfn-mediapackagev2-originendpoint-dashbaseurl-dvbweight</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDvbWeight() {
            return null;
        }

        /**
         * The name of the source location.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashbaseurl.html#cfn-mediapackagev2-originendpoint-dashbaseurl-servicelocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashbaseurl.html#cfn-mediapackagev2-originendpoint-dashbaseurl-servicelocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceLocation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DashBaseUrlProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DashBaseUrlProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DashBaseUrlProperty> {
            java.lang.String url;
            java.lang.Number dvbPriority;
            java.lang.Number dvbWeight;
            java.lang.String serviceLocation;

            /**
             * Sets the value of {@link DashBaseUrlProperty#getUrl}
             * @param url A source location for segments. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(java.lang.String url) {
                this.url = url;
                return this;
            }

            /**
             * Sets the value of {@link DashBaseUrlProperty#getDvbPriority}
             * @param dvbPriority For use with DVB-DASH profiles only.
             *                    The priority of this location for servings segments. The lower the number, the higher the priority.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dvbPriority(java.lang.Number dvbPriority) {
                this.dvbPriority = dvbPriority;
                return this;
            }

            /**
             * Sets the value of {@link DashBaseUrlProperty#getDvbWeight}
             * @param dvbWeight For use with DVB-DASH profiles only.
             *                  The weighting for source locations that have the same priority.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dvbWeight(java.lang.Number dvbWeight) {
                this.dvbWeight = dvbWeight;
                return this;
            }

            /**
             * Sets the value of {@link DashBaseUrlProperty#getServiceLocation}
             * @param serviceLocation The name of the source location.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceLocation(java.lang.String serviceLocation) {
                this.serviceLocation = serviceLocation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DashBaseUrlProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DashBaseUrlProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DashBaseUrlProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DashBaseUrlProperty {
            private final java.lang.String url;
            private final java.lang.Number dvbPriority;
            private final java.lang.Number dvbWeight;
            private final java.lang.String serviceLocation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dvbPriority = software.amazon.jsii.Kernel.get(this, "dvbPriority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.dvbWeight = software.amazon.jsii.Kernel.get(this, "dvbWeight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.serviceLocation = software.amazon.jsii.Kernel.get(this, "serviceLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.url = java.util.Objects.requireNonNull(builder.url, "url is required");
                this.dvbPriority = builder.dvbPriority;
                this.dvbWeight = builder.dvbWeight;
                this.serviceLocation = builder.serviceLocation;
            }

            @Override
            public final java.lang.String getUrl() {
                return this.url;
            }

            @Override
            public final java.lang.Number getDvbPriority() {
                return this.dvbPriority;
            }

            @Override
            public final java.lang.Number getDvbWeight() {
                return this.dvbWeight;
            }

            @Override
            public final java.lang.String getServiceLocation() {
                return this.serviceLocation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("url", om.valueToTree(this.getUrl()));
                if (this.getDvbPriority() != null) {
                    data.set("dvbPriority", om.valueToTree(this.getDvbPriority()));
                }
                if (this.getDvbWeight() != null) {
                    data.set("dvbWeight", om.valueToTree(this.getDvbWeight()));
                }
                if (this.getServiceLocation() != null) {
                    data.set("serviceLocation", om.valueToTree(this.getServiceLocation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.DashBaseUrlProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DashBaseUrlProperty.Jsii$Proxy that = (DashBaseUrlProperty.Jsii$Proxy) o;

                if (!url.equals(that.url)) return false;
                if (this.dvbPriority != null ? !this.dvbPriority.equals(that.dvbPriority) : that.dvbPriority != null) return false;
                if (this.dvbWeight != null ? !this.dvbWeight.equals(that.dvbWeight) : that.dvbWeight != null) return false;
                return this.serviceLocation != null ? this.serviceLocation.equals(that.serviceLocation) : that.serviceLocation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.url.hashCode();
                result = 31 * result + (this.dvbPriority != null ? this.dvbPriority.hashCode() : 0);
                result = 31 * result + (this.dvbWeight != null ? this.dvbWeight.hashCode() : 0);
                result = 31 * result + (this.serviceLocation != null ? this.serviceLocation.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * For use with DVB-DASH profiles only.
     * <p>
     * The settings for font downloads that you want AWS Elemental MediaPackage to pass through to the manifest.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackagev2.*;
     * DashDvbFontDownloadProperty dashDvbFontDownloadProperty = DashDvbFontDownloadProperty.builder()
     *         .fontFamily("fontFamily")
     *         .mimeType("mimeType")
     *         .url("url")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashdvbfontdownload.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashdvbfontdownload.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.DashDvbFontDownloadProperty")
    @software.amazon.jsii.Jsii.Proxy(DashDvbFontDownloadProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DashDvbFontDownloadProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The <code>fontFamily</code> name for subtitles, as described in <a href="https://docs.aws.amazon.com/https://tech.ebu.ch/publications/tech3380">EBU-TT-D Subtitling Distribution Format</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashdvbfontdownload.html#cfn-mediapackagev2-originendpoint-dashdvbfontdownload-fontfamily">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashdvbfontdownload.html#cfn-mediapackagev2-originendpoint-dashdvbfontdownload-fontfamily</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFontFamily() {
            return null;
        }

        /**
         * The <code>mimeType</code> of the resource that's at the font download URL.
         * <p>
         * For information about font MIME types, see the <a href="https://docs.aws.amazon.com/https://dvb.org/wp-content/uploads/2021/06/A168r4_MPEG-DASH-Profile-for-Transport-of-ISO-BMFF-Based-DVB-Services_Draft-ts_103-285-v140_November_2021.pdf">MPEG-DASH Profile for Transport of ISO BMFF Based DVB Services over IP Based Networks</a> document.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashdvbfontdownload.html#cfn-mediapackagev2-originendpoint-dashdvbfontdownload-mimetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashdvbfontdownload.html#cfn-mediapackagev2-originendpoint-dashdvbfontdownload-mimetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMimeType() {
            return null;
        }

        /**
         * The URL for downloading fonts for subtitles.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashdvbfontdownload.html#cfn-mediapackagev2-originendpoint-dashdvbfontdownload-url">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashdvbfontdownload.html#cfn-mediapackagev2-originendpoint-dashdvbfontdownload-url</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DashDvbFontDownloadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DashDvbFontDownloadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DashDvbFontDownloadProperty> {
            java.lang.String fontFamily;
            java.lang.String mimeType;
            java.lang.String url;

            /**
             * Sets the value of {@link DashDvbFontDownloadProperty#getFontFamily}
             * @param fontFamily The <code>fontFamily</code> name for subtitles, as described in <a href="https://docs.aws.amazon.com/https://tech.ebu.ch/publications/tech3380">EBU-TT-D Subtitling Distribution Format</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fontFamily(java.lang.String fontFamily) {
                this.fontFamily = fontFamily;
                return this;
            }

            /**
             * Sets the value of {@link DashDvbFontDownloadProperty#getMimeType}
             * @param mimeType The <code>mimeType</code> of the resource that's at the font download URL.
             *                 For information about font MIME types, see the <a href="https://docs.aws.amazon.com/https://dvb.org/wp-content/uploads/2021/06/A168r4_MPEG-DASH-Profile-for-Transport-of-ISO-BMFF-Based-DVB-Services_Draft-ts_103-285-v140_November_2021.pdf">MPEG-DASH Profile for Transport of ISO BMFF Based DVB Services over IP Based Networks</a> document.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mimeType(java.lang.String mimeType) {
                this.mimeType = mimeType;
                return this;
            }

            /**
             * Sets the value of {@link DashDvbFontDownloadProperty#getUrl}
             * @param url The URL for downloading fonts for subtitles.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(java.lang.String url) {
                this.url = url;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DashDvbFontDownloadProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DashDvbFontDownloadProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DashDvbFontDownloadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DashDvbFontDownloadProperty {
            private final java.lang.String fontFamily;
            private final java.lang.String mimeType;
            private final java.lang.String url;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fontFamily = software.amazon.jsii.Kernel.get(this, "fontFamily", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mimeType = software.amazon.jsii.Kernel.get(this, "mimeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fontFamily = builder.fontFamily;
                this.mimeType = builder.mimeType;
                this.url = builder.url;
            }

            @Override
            public final java.lang.String getFontFamily() {
                return this.fontFamily;
            }

            @Override
            public final java.lang.String getMimeType() {
                return this.mimeType;
            }

            @Override
            public final java.lang.String getUrl() {
                return this.url;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFontFamily() != null) {
                    data.set("fontFamily", om.valueToTree(this.getFontFamily()));
                }
                if (this.getMimeType() != null) {
                    data.set("mimeType", om.valueToTree(this.getMimeType()));
                }
                if (this.getUrl() != null) {
                    data.set("url", om.valueToTree(this.getUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.DashDvbFontDownloadProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DashDvbFontDownloadProperty.Jsii$Proxy that = (DashDvbFontDownloadProperty.Jsii$Proxy) o;

                if (this.fontFamily != null ? !this.fontFamily.equals(that.fontFamily) : that.fontFamily != null) return false;
                if (this.mimeType != null ? !this.mimeType.equals(that.mimeType) : that.mimeType != null) return false;
                return this.url != null ? this.url.equals(that.url) : that.url == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fontFamily != null ? this.fontFamily.hashCode() : 0;
                result = 31 * result + (this.mimeType != null ? this.mimeType.hashCode() : 0);
                result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * For use with DVB-DASH profiles only.
     * <p>
     * The settings for error reporting from the playback device that you want AWS Elemental MediaPackage to pass through to the manifest.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackagev2.*;
     * DashDvbMetricsReportingProperty dashDvbMetricsReportingProperty = DashDvbMetricsReportingProperty.builder()
     *         .reportingUrl("reportingUrl")
     *         // the properties below are optional
     *         .probability(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashdvbmetricsreporting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashdvbmetricsreporting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.DashDvbMetricsReportingProperty")
    @software.amazon.jsii.Jsii.Proxy(DashDvbMetricsReportingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DashDvbMetricsReportingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The URL where playback devices send error reports.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashdvbmetricsreporting.html#cfn-mediapackagev2-originendpoint-dashdvbmetricsreporting-reportingurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashdvbmetricsreporting.html#cfn-mediapackagev2-originendpoint-dashdvbmetricsreporting-reportingurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getReportingUrl();

        /**
         * The number of playback devices per 1000 that will send error reports to the reporting URL.
         * <p>
         * This represents the probability that a playback device will be a reporting player for this session.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashdvbmetricsreporting.html#cfn-mediapackagev2-originendpoint-dashdvbmetricsreporting-probability">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashdvbmetricsreporting.html#cfn-mediapackagev2-originendpoint-dashdvbmetricsreporting-probability</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getProbability() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DashDvbMetricsReportingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DashDvbMetricsReportingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DashDvbMetricsReportingProperty> {
            java.lang.String reportingUrl;
            java.lang.Number probability;

            /**
             * Sets the value of {@link DashDvbMetricsReportingProperty#getReportingUrl}
             * @param reportingUrl The URL where playback devices send error reports. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reportingUrl(java.lang.String reportingUrl) {
                this.reportingUrl = reportingUrl;
                return this;
            }

            /**
             * Sets the value of {@link DashDvbMetricsReportingProperty#getProbability}
             * @param probability The number of playback devices per 1000 that will send error reports to the reporting URL.
             *                    This represents the probability that a playback device will be a reporting player for this session.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder probability(java.lang.Number probability) {
                this.probability = probability;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DashDvbMetricsReportingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DashDvbMetricsReportingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DashDvbMetricsReportingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DashDvbMetricsReportingProperty {
            private final java.lang.String reportingUrl;
            private final java.lang.Number probability;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.reportingUrl = software.amazon.jsii.Kernel.get(this, "reportingUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.probability = software.amazon.jsii.Kernel.get(this, "probability", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.reportingUrl = java.util.Objects.requireNonNull(builder.reportingUrl, "reportingUrl is required");
                this.probability = builder.probability;
            }

            @Override
            public final java.lang.String getReportingUrl() {
                return this.reportingUrl;
            }

            @Override
            public final java.lang.Number getProbability() {
                return this.probability;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("reportingUrl", om.valueToTree(this.getReportingUrl()));
                if (this.getProbability() != null) {
                    data.set("probability", om.valueToTree(this.getProbability()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.DashDvbMetricsReportingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DashDvbMetricsReportingProperty.Jsii$Proxy that = (DashDvbMetricsReportingProperty.Jsii$Proxy) o;

                if (!reportingUrl.equals(that.reportingUrl)) return false;
                return this.probability != null ? this.probability.equals(that.probability) : that.probability == null;
            }

            @Override
            public final int hashCode() {
                int result = this.reportingUrl.hashCode();
                result = 31 * result + (this.probability != null ? this.probability.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * For endpoints that use the DVB-DASH profile only.
     * <p>
     * The font download and error reporting information that you want MediaPackage to pass through to the manifest.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackagev2.*;
     * DashDvbSettingsProperty dashDvbSettingsProperty = DashDvbSettingsProperty.builder()
     *         .errorMetrics(List.of(DashDvbMetricsReportingProperty.builder()
     *                 .reportingUrl("reportingUrl")
     *                 // the properties below are optional
     *                 .probability(123)
     *                 .build()))
     *         .fontDownload(DashDvbFontDownloadProperty.builder()
     *                 .fontFamily("fontFamily")
     *                 .mimeType("mimeType")
     *                 .url("url")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashdvbsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashdvbsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.DashDvbSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DashDvbSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DashDvbSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Playback device error reporting settings.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.DashDvbMetricsReportingProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashdvbsettings.html#cfn-mediapackagev2-originendpoint-dashdvbsettings-errormetrics">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashdvbsettings.html#cfn-mediapackagev2-originendpoint-dashdvbsettings-errormetrics</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getErrorMetrics() {
            return null;
        }

        /**
         * Subtitle font settings.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.DashDvbFontDownloadProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashdvbsettings.html#cfn-mediapackagev2-originendpoint-dashdvbsettings-fontdownload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashdvbsettings.html#cfn-mediapackagev2-originendpoint-dashdvbsettings-fontdownload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFontDownload() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DashDvbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DashDvbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DashDvbSettingsProperty> {
            java.lang.Object errorMetrics;
            java.lang.Object fontDownload;

            /**
             * Sets the value of {@link DashDvbSettingsProperty#getErrorMetrics}
             * @param errorMetrics Playback device error reporting settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorMetrics(software.amazon.awscdk.IResolvable errorMetrics) {
                this.errorMetrics = errorMetrics;
                return this;
            }

            /**
             * Sets the value of {@link DashDvbSettingsProperty#getErrorMetrics}
             * @param errorMetrics Playback device error reporting settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorMetrics(java.util.List<? extends java.lang.Object> errorMetrics) {
                this.errorMetrics = errorMetrics;
                return this;
            }

            /**
             * Sets the value of {@link DashDvbSettingsProperty#getFontDownload}
             * @param fontDownload Subtitle font settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fontDownload(software.amazon.awscdk.IResolvable fontDownload) {
                this.fontDownload = fontDownload;
                return this;
            }

            /**
             * Sets the value of {@link DashDvbSettingsProperty#getFontDownload}
             * @param fontDownload Subtitle font settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fontDownload(software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.DashDvbFontDownloadProperty fontDownload) {
                this.fontDownload = fontDownload;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DashDvbSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DashDvbSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DashDvbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DashDvbSettingsProperty {
            private final java.lang.Object errorMetrics;
            private final java.lang.Object fontDownload;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.errorMetrics = software.amazon.jsii.Kernel.get(this, "errorMetrics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fontDownload = software.amazon.jsii.Kernel.get(this, "fontDownload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.errorMetrics = builder.errorMetrics;
                this.fontDownload = builder.fontDownload;
            }

            @Override
            public final java.lang.Object getErrorMetrics() {
                return this.errorMetrics;
            }

            @Override
            public final java.lang.Object getFontDownload() {
                return this.fontDownload;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getErrorMetrics() != null) {
                    data.set("errorMetrics", om.valueToTree(this.getErrorMetrics()));
                }
                if (this.getFontDownload() != null) {
                    data.set("fontDownload", om.valueToTree(this.getFontDownload()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.DashDvbSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DashDvbSettingsProperty.Jsii$Proxy that = (DashDvbSettingsProperty.Jsii$Proxy) o;

                if (this.errorMetrics != null ? !this.errorMetrics.equals(that.errorMetrics) : that.errorMetrics != null) return false;
                return this.fontDownload != null ? this.fontDownload.equals(that.fontDownload) : that.fontDownload == null;
            }

            @Override
            public final int hashCode() {
                int result = this.errorMetrics != null ? this.errorMetrics.hashCode() : 0;
                result = 31 * result + (this.fontDownload != null ? this.fontDownload.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The DASH manifest configuration associated with the origin endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackagev2.*;
     * DashManifestConfigurationProperty dashManifestConfigurationProperty = DashManifestConfigurationProperty.builder()
     *         .manifestName("manifestName")
     *         // the properties below are optional
     *         .baseUrls(List.of(DashBaseUrlProperty.builder()
     *                 .url("url")
     *                 // the properties below are optional
     *                 .dvbPriority(123)
     *                 .dvbWeight(123)
     *                 .serviceLocation("serviceLocation")
     *                 .build()))
     *         .compactness("compactness")
     *         .drmSignaling("drmSignaling")
     *         .dvbSettings(DashDvbSettingsProperty.builder()
     *                 .errorMetrics(List.of(DashDvbMetricsReportingProperty.builder()
     *                         .reportingUrl("reportingUrl")
     *                         // the properties below are optional
     *                         .probability(123)
     *                         .build()))
     *                 .fontDownload(DashDvbFontDownloadProperty.builder()
     *                         .fontFamily("fontFamily")
     *                         .mimeType("mimeType")
     *                         .url("url")
     *                         .build())
     *                 .build())
     *         .filterConfiguration(FilterConfigurationProperty.builder()
     *                 .clipStartTime("clipStartTime")
     *                 .end("end")
     *                 .manifestFilter("manifestFilter")
     *                 .start("start")
     *                 .timeDelaySeconds(123)
     *                 .build())
     *         .manifestWindowSeconds(123)
     *         .minBufferTimeSeconds(123)
     *         .minUpdatePeriodSeconds(123)
     *         .periodTriggers(List.of("periodTriggers"))
     *         .profiles(List.of("profiles"))
     *         .programInformation(DashProgramInformationProperty.builder()
     *                 .copyright("copyright")
     *                 .languageCode("languageCode")
     *                 .moreInformationUrl("moreInformationUrl")
     *                 .source("source")
     *                 .title("title")
     *                 .build())
     *         .scteDash(ScteDashProperty.builder()
     *                 .adMarkerDash("adMarkerDash")
     *                 .build())
     *         .segmentTemplateFormat("segmentTemplateFormat")
     *         .subtitleConfiguration(DashSubtitleConfigurationProperty.builder()
     *                 .ttmlConfiguration(DashTtmlConfigurationProperty.builder()
     *                         .ttmlProfile("ttmlProfile")
     *                         .build())
     *                 .build())
     *         .suggestedPresentationDelaySeconds(123)
     *         .utcTiming(DashUtcTimingProperty.builder()
     *                 .timingMode("timingMode")
     *                 .timingSource("timingSource")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.DashManifestConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DashManifestConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DashManifestConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A short string that's appended to the endpoint URL.
         * <p>
         * The child manifest name creates a unique path to this endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-manifestname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-manifestname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getManifestName();

        /**
         * The base URLs to use for retrieving segments.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.DashBaseUrlProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-baseurls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-baseurls</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBaseUrls() {
            return null;
        }

        /**
         * The layout of the DASH manifest that MediaPackage produces.
         * <p>
         * <code>STANDARD</code> indicates a default manifest, which is compacted. <code>NONE</code> indicates a full manifest.
         * <p>
         * For information about compactness, see <a href="https://docs.aws.amazon.com/mediapackage/latest/userguide/compacted.html">DASH manifest compactness</a> in the <em>AWS Elemental MediaPackage v2 User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-compactness">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-compactness</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCompactness() {
            return null;
        }

        /**
         * Determines how the DASH manifest signals the DRM content.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-drmsignaling">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-drmsignaling</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDrmSignaling() {
            return null;
        }

        /**
         * For endpoints that use the DVB-DASH profile only.
         * <p>
         * The font download and error reporting information that you want MediaPackage to pass through to the manifest.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.DashDvbSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-dvbsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-dvbsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDvbSettings() {
            return null;
        }

        /**
         * Filter configuration includes settings for manifest filtering, start and end times, and time delay that apply to all of your egress requests for this manifest.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.FilterConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-filterconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-filterconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilterConfiguration() {
            return null;
        }

        /**
         * The total duration (in seconds) of the manifest's content.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-manifestwindowseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-manifestwindowseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getManifestWindowSeconds() {
            return null;
        }

        /**
         * Minimum amount of content (in seconds) that a player must keep available in the buffer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-minbuffertimeseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-minbuffertimeseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinBufferTimeSeconds() {
            return null;
        }

        /**
         * Minimum amount of time (in seconds) that the player should wait before requesting updates to the manifest.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-minupdateperiodseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-minupdateperiodseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinUpdatePeriodSeconds() {
            return null;
        }

        /**
         * A list of triggers that controls when AWS Elemental MediaPackage separates the MPEG-DASH manifest into multiple periods.
         * <p>
         * Type <code>ADS</code> to indicate that AWS Elemental MediaPackage must create periods in the output manifest that correspond to SCTE-35 ad markers in the input source. Leave this value empty to indicate that the manifest is contained all in one period. For more information about periods in the DASH manifest, see <a href="https://docs.aws.amazon.com/mediapackage/latest/userguide/multi-period.html">Multi-period DASH in AWS Elemental MediaPackage</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-periodtriggers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-periodtriggers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPeriodTriggers() {
            return null;
        }

        /**
         * The profile that the output is compliant with.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-profiles">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-profiles</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getProfiles() {
            return null;
        }

        /**
         * Details about the content that you want MediaPackage to pass through in the manifest to the playback device.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.DashProgramInformationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-programinformation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-programinformation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProgramInformation() {
            return null;
        }

        /**
         * The SCTE configuration.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.ScteDashProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-sctedash">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-sctedash</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScteDash() {
            return null;
        }

        /**
         * Determines the type of variable used in the <code>media</code> URL of the <code>SegmentTemplate</code> tag in the manifest.
         * <p>
         * Also specifies if segment timeline information is included in <code>SegmentTimeline</code> or <code>SegmentTemplate</code> .
         * <p>
         * Value description:
         * <p>
         * <ul>
         * <li><code>NUMBER_WITH_TIMELINE</code> - The <code>$Number$</code> variable is used in the <code>media</code> URL. The value of this variable is the sequential number of the segment. A full <code>SegmentTimeline</code> object is presented in each <code>SegmentTemplate</code> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-segmenttemplateformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-segmenttemplateformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSegmentTemplateFormat() {
            return null;
        }

        /**
         * The configuration for DASH subtitles.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.DashSubtitleConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-subtitleconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-subtitleconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSubtitleConfiguration() {
            return null;
        }

        /**
         * The amount of time (in seconds) that the player should be from the end of the manifest.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-suggestedpresentationdelayseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-suggestedpresentationdelayseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSuggestedPresentationDelaySeconds() {
            return null;
        }

        /**
         * Determines the type of UTC timing included in the DASH Media Presentation Description (MPD).
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.DashUtcTimingProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-utctiming">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-dashmanifestconfiguration-utctiming</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUtcTiming() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DashManifestConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DashManifestConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DashManifestConfigurationProperty> {
            java.lang.String manifestName;
            java.lang.Object baseUrls;
            java.lang.String compactness;
            java.lang.String drmSignaling;
            java.lang.Object dvbSettings;
            java.lang.Object filterConfiguration;
            java.lang.Number manifestWindowSeconds;
            java.lang.Number minBufferTimeSeconds;
            java.lang.Number minUpdatePeriodSeconds;
            java.util.List<java.lang.String> periodTriggers;
            java.util.List<java.lang.String> profiles;
            java.lang.Object programInformation;
            java.lang.Object scteDash;
            java.lang.String segmentTemplateFormat;
            java.lang.Object subtitleConfiguration;
            java.lang.Number suggestedPresentationDelaySeconds;
            java.lang.Object utcTiming;

            /**
             * Sets the value of {@link DashManifestConfigurationProperty#getManifestName}
             * @param manifestName A short string that's appended to the endpoint URL. This parameter is required.
             *                     The child manifest name creates a unique path to this endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifestName(java.lang.String manifestName) {
                this.manifestName = manifestName;
                return this;
            }

            /**
             * Sets the value of {@link DashManifestConfigurationProperty#getBaseUrls}
             * @param baseUrls The base URLs to use for retrieving segments.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baseUrls(software.amazon.awscdk.IResolvable baseUrls) {
                this.baseUrls = baseUrls;
                return this;
            }

            /**
             * Sets the value of {@link DashManifestConfigurationProperty#getBaseUrls}
             * @param baseUrls The base URLs to use for retrieving segments.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baseUrls(java.util.List<? extends java.lang.Object> baseUrls) {
                this.baseUrls = baseUrls;
                return this;
            }

            /**
             * Sets the value of {@link DashManifestConfigurationProperty#getCompactness}
             * @param compactness The layout of the DASH manifest that MediaPackage produces.
             *                    <code>STANDARD</code> indicates a default manifest, which is compacted. <code>NONE</code> indicates a full manifest.
             *                    <p>
             *                    For information about compactness, see <a href="https://docs.aws.amazon.com/mediapackage/latest/userguide/compacted.html">DASH manifest compactness</a> in the <em>AWS Elemental MediaPackage v2 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compactness(java.lang.String compactness) {
                this.compactness = compactness;
                return this;
            }

            /**
             * Sets the value of {@link DashManifestConfigurationProperty#getDrmSignaling}
             * @param drmSignaling Determines how the DASH manifest signals the DRM content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder drmSignaling(java.lang.String drmSignaling) {
                this.drmSignaling = drmSignaling;
                return this;
            }

            /**
             * Sets the value of {@link DashManifestConfigurationProperty#getDvbSettings}
             * @param dvbSettings For endpoints that use the DVB-DASH profile only.
             *                    The font download and error reporting information that you want MediaPackage to pass through to the manifest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dvbSettings(software.amazon.awscdk.IResolvable dvbSettings) {
                this.dvbSettings = dvbSettings;
                return this;
            }

            /**
             * Sets the value of {@link DashManifestConfigurationProperty#getDvbSettings}
             * @param dvbSettings For endpoints that use the DVB-DASH profile only.
             *                    The font download and error reporting information that you want MediaPackage to pass through to the manifest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dvbSettings(software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.DashDvbSettingsProperty dvbSettings) {
                this.dvbSettings = dvbSettings;
                return this;
            }

            /**
             * Sets the value of {@link DashManifestConfigurationProperty#getFilterConfiguration}
             * @param filterConfiguration Filter configuration includes settings for manifest filtering, start and end times, and time delay that apply to all of your egress requests for this manifest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterConfiguration(software.amazon.awscdk.IResolvable filterConfiguration) {
                this.filterConfiguration = filterConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DashManifestConfigurationProperty#getFilterConfiguration}
             * @param filterConfiguration Filter configuration includes settings for manifest filtering, start and end times, and time delay that apply to all of your egress requests for this manifest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterConfiguration(software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.FilterConfigurationProperty filterConfiguration) {
                this.filterConfiguration = filterConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DashManifestConfigurationProperty#getManifestWindowSeconds}
             * @param manifestWindowSeconds The total duration (in seconds) of the manifest's content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifestWindowSeconds(java.lang.Number manifestWindowSeconds) {
                this.manifestWindowSeconds = manifestWindowSeconds;
                return this;
            }

            /**
             * Sets the value of {@link DashManifestConfigurationProperty#getMinBufferTimeSeconds}
             * @param minBufferTimeSeconds Minimum amount of content (in seconds) that a player must keep available in the buffer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minBufferTimeSeconds(java.lang.Number minBufferTimeSeconds) {
                this.minBufferTimeSeconds = minBufferTimeSeconds;
                return this;
            }

            /**
             * Sets the value of {@link DashManifestConfigurationProperty#getMinUpdatePeriodSeconds}
             * @param minUpdatePeriodSeconds Minimum amount of time (in seconds) that the player should wait before requesting updates to the manifest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minUpdatePeriodSeconds(java.lang.Number minUpdatePeriodSeconds) {
                this.minUpdatePeriodSeconds = minUpdatePeriodSeconds;
                return this;
            }

            /**
             * Sets the value of {@link DashManifestConfigurationProperty#getPeriodTriggers}
             * @param periodTriggers A list of triggers that controls when AWS Elemental MediaPackage separates the MPEG-DASH manifest into multiple periods.
             *                       Type <code>ADS</code> to indicate that AWS Elemental MediaPackage must create periods in the output manifest that correspond to SCTE-35 ad markers in the input source. Leave this value empty to indicate that the manifest is contained all in one period. For more information about periods in the DASH manifest, see <a href="https://docs.aws.amazon.com/mediapackage/latest/userguide/multi-period.html">Multi-period DASH in AWS Elemental MediaPackage</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder periodTriggers(java.util.List<java.lang.String> periodTriggers) {
                this.periodTriggers = periodTriggers;
                return this;
            }

            /**
             * Sets the value of {@link DashManifestConfigurationProperty#getProfiles}
             * @param profiles The profile that the output is compliant with.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder profiles(java.util.List<java.lang.String> profiles) {
                this.profiles = profiles;
                return this;
            }

            /**
             * Sets the value of {@link DashManifestConfigurationProperty#getProgramInformation}
             * @param programInformation Details about the content that you want MediaPackage to pass through in the manifest to the playback device.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder programInformation(software.amazon.awscdk.IResolvable programInformation) {
                this.programInformation = programInformation;
                return this;
            }

            /**
             * Sets the value of {@link DashManifestConfigurationProperty#getProgramInformation}
             * @param programInformation Details about the content that you want MediaPackage to pass through in the manifest to the playback device.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder programInformation(software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.DashProgramInformationProperty programInformation) {
                this.programInformation = programInformation;
                return this;
            }

            /**
             * Sets the value of {@link DashManifestConfigurationProperty#getScteDash}
             * @param scteDash The SCTE configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scteDash(software.amazon.awscdk.IResolvable scteDash) {
                this.scteDash = scteDash;
                return this;
            }

            /**
             * Sets the value of {@link DashManifestConfigurationProperty#getScteDash}
             * @param scteDash The SCTE configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scteDash(software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.ScteDashProperty scteDash) {
                this.scteDash = scteDash;
                return this;
            }

            /**
             * Sets the value of {@link DashManifestConfigurationProperty#getSegmentTemplateFormat}
             * @param segmentTemplateFormat Determines the type of variable used in the <code>media</code> URL of the <code>SegmentTemplate</code> tag in the manifest.
             *                              Also specifies if segment timeline information is included in <code>SegmentTimeline</code> or <code>SegmentTemplate</code> .
             *                              <p>
             *                              Value description:
             *                              <p>
             *                              <ul>
             *                              <li><code>NUMBER_WITH_TIMELINE</code> - The <code>$Number$</code> variable is used in the <code>media</code> URL. The value of this variable is the sequential number of the segment. A full <code>SegmentTimeline</code> object is presented in each <code>SegmentTemplate</code> .</li>
             *                              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder segmentTemplateFormat(java.lang.String segmentTemplateFormat) {
                this.segmentTemplateFormat = segmentTemplateFormat;
                return this;
            }

            /**
             * Sets the value of {@link DashManifestConfigurationProperty#getSubtitleConfiguration}
             * @param subtitleConfiguration The configuration for DASH subtitles.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subtitleConfiguration(software.amazon.awscdk.IResolvable subtitleConfiguration) {
                this.subtitleConfiguration = subtitleConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DashManifestConfigurationProperty#getSubtitleConfiguration}
             * @param subtitleConfiguration The configuration for DASH subtitles.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subtitleConfiguration(software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.DashSubtitleConfigurationProperty subtitleConfiguration) {
                this.subtitleConfiguration = subtitleConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DashManifestConfigurationProperty#getSuggestedPresentationDelaySeconds}
             * @param suggestedPresentationDelaySeconds The amount of time (in seconds) that the player should be from the end of the manifest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder suggestedPresentationDelaySeconds(java.lang.Number suggestedPresentationDelaySeconds) {
                this.suggestedPresentationDelaySeconds = suggestedPresentationDelaySeconds;
                return this;
            }

            /**
             * Sets the value of {@link DashManifestConfigurationProperty#getUtcTiming}
             * @param utcTiming Determines the type of UTC timing included in the DASH Media Presentation Description (MPD).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder utcTiming(software.amazon.awscdk.IResolvable utcTiming) {
                this.utcTiming = utcTiming;
                return this;
            }

            /**
             * Sets the value of {@link DashManifestConfigurationProperty#getUtcTiming}
             * @param utcTiming Determines the type of UTC timing included in the DASH Media Presentation Description (MPD).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder utcTiming(software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.DashUtcTimingProperty utcTiming) {
                this.utcTiming = utcTiming;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DashManifestConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DashManifestConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DashManifestConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DashManifestConfigurationProperty {
            private final java.lang.String manifestName;
            private final java.lang.Object baseUrls;
            private final java.lang.String compactness;
            private final java.lang.String drmSignaling;
            private final java.lang.Object dvbSettings;
            private final java.lang.Object filterConfiguration;
            private final java.lang.Number manifestWindowSeconds;
            private final java.lang.Number minBufferTimeSeconds;
            private final java.lang.Number minUpdatePeriodSeconds;
            private final java.util.List<java.lang.String> periodTriggers;
            private final java.util.List<java.lang.String> profiles;
            private final java.lang.Object programInformation;
            private final java.lang.Object scteDash;
            private final java.lang.String segmentTemplateFormat;
            private final java.lang.Object subtitleConfiguration;
            private final java.lang.Number suggestedPresentationDelaySeconds;
            private final java.lang.Object utcTiming;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.manifestName = software.amazon.jsii.Kernel.get(this, "manifestName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.baseUrls = software.amazon.jsii.Kernel.get(this, "baseUrls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.compactness = software.amazon.jsii.Kernel.get(this, "compactness", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.drmSignaling = software.amazon.jsii.Kernel.get(this, "drmSignaling", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dvbSettings = software.amazon.jsii.Kernel.get(this, "dvbSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.filterConfiguration = software.amazon.jsii.Kernel.get(this, "filterConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.manifestWindowSeconds = software.amazon.jsii.Kernel.get(this, "manifestWindowSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minBufferTimeSeconds = software.amazon.jsii.Kernel.get(this, "minBufferTimeSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minUpdatePeriodSeconds = software.amazon.jsii.Kernel.get(this, "minUpdatePeriodSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.periodTriggers = software.amazon.jsii.Kernel.get(this, "periodTriggers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.profiles = software.amazon.jsii.Kernel.get(this, "profiles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.programInformation = software.amazon.jsii.Kernel.get(this, "programInformation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scteDash = software.amazon.jsii.Kernel.get(this, "scteDash", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.segmentTemplateFormat = software.amazon.jsii.Kernel.get(this, "segmentTemplateFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.subtitleConfiguration = software.amazon.jsii.Kernel.get(this, "subtitleConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.suggestedPresentationDelaySeconds = software.amazon.jsii.Kernel.get(this, "suggestedPresentationDelaySeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.utcTiming = software.amazon.jsii.Kernel.get(this, "utcTiming", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.manifestName = java.util.Objects.requireNonNull(builder.manifestName, "manifestName is required");
                this.baseUrls = builder.baseUrls;
                this.compactness = builder.compactness;
                this.drmSignaling = builder.drmSignaling;
                this.dvbSettings = builder.dvbSettings;
                this.filterConfiguration = builder.filterConfiguration;
                this.manifestWindowSeconds = builder.manifestWindowSeconds;
                this.minBufferTimeSeconds = builder.minBufferTimeSeconds;
                this.minUpdatePeriodSeconds = builder.minUpdatePeriodSeconds;
                this.periodTriggers = builder.periodTriggers;
                this.profiles = builder.profiles;
                this.programInformation = builder.programInformation;
                this.scteDash = builder.scteDash;
                this.segmentTemplateFormat = builder.segmentTemplateFormat;
                this.subtitleConfiguration = builder.subtitleConfiguration;
                this.suggestedPresentationDelaySeconds = builder.suggestedPresentationDelaySeconds;
                this.utcTiming = builder.utcTiming;
            }

            @Override
            public final java.lang.String getManifestName() {
                return this.manifestName;
            }

            @Override
            public final java.lang.Object getBaseUrls() {
                return this.baseUrls;
            }

            @Override
            public final java.lang.String getCompactness() {
                return this.compactness;
            }

            @Override
            public final java.lang.String getDrmSignaling() {
                return this.drmSignaling;
            }

            @Override
            public final java.lang.Object getDvbSettings() {
                return this.dvbSettings;
            }

            @Override
            public final java.lang.Object getFilterConfiguration() {
                return this.filterConfiguration;
            }

            @Override
            public final java.lang.Number getManifestWindowSeconds() {
                return this.manifestWindowSeconds;
            }

            @Override
            public final java.lang.Number getMinBufferTimeSeconds() {
                return this.minBufferTimeSeconds;
            }

            @Override
            public final java.lang.Number getMinUpdatePeriodSeconds() {
                return this.minUpdatePeriodSeconds;
            }

            @Override
            public final java.util.List<java.lang.String> getPeriodTriggers() {
                return this.periodTriggers;
            }

            @Override
            public final java.util.List<java.lang.String> getProfiles() {
                return this.profiles;
            }

            @Override
            public final java.lang.Object getProgramInformation() {
                return this.programInformation;
            }

            @Override
            public final java.lang.Object getScteDash() {
                return this.scteDash;
            }

            @Override
            public final java.lang.String getSegmentTemplateFormat() {
                return this.segmentTemplateFormat;
            }

            @Override
            public final java.lang.Object getSubtitleConfiguration() {
                return this.subtitleConfiguration;
            }

            @Override
            public final java.lang.Number getSuggestedPresentationDelaySeconds() {
                return this.suggestedPresentationDelaySeconds;
            }

            @Override
            public final java.lang.Object getUtcTiming() {
                return this.utcTiming;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("manifestName", om.valueToTree(this.getManifestName()));
                if (this.getBaseUrls() != null) {
                    data.set("baseUrls", om.valueToTree(this.getBaseUrls()));
                }
                if (this.getCompactness() != null) {
                    data.set("compactness", om.valueToTree(this.getCompactness()));
                }
                if (this.getDrmSignaling() != null) {
                    data.set("drmSignaling", om.valueToTree(this.getDrmSignaling()));
                }
                if (this.getDvbSettings() != null) {
                    data.set("dvbSettings", om.valueToTree(this.getDvbSettings()));
                }
                if (this.getFilterConfiguration() != null) {
                    data.set("filterConfiguration", om.valueToTree(this.getFilterConfiguration()));
                }
                if (this.getManifestWindowSeconds() != null) {
                    data.set("manifestWindowSeconds", om.valueToTree(this.getManifestWindowSeconds()));
                }
                if (this.getMinBufferTimeSeconds() != null) {
                    data.set("minBufferTimeSeconds", om.valueToTree(this.getMinBufferTimeSeconds()));
                }
                if (this.getMinUpdatePeriodSeconds() != null) {
                    data.set("minUpdatePeriodSeconds", om.valueToTree(this.getMinUpdatePeriodSeconds()));
                }
                if (this.getPeriodTriggers() != null) {
                    data.set("periodTriggers", om.valueToTree(this.getPeriodTriggers()));
                }
                if (this.getProfiles() != null) {
                    data.set("profiles", om.valueToTree(this.getProfiles()));
                }
                if (this.getProgramInformation() != null) {
                    data.set("programInformation", om.valueToTree(this.getProgramInformation()));
                }
                if (this.getScteDash() != null) {
                    data.set("scteDash", om.valueToTree(this.getScteDash()));
                }
                if (this.getSegmentTemplateFormat() != null) {
                    data.set("segmentTemplateFormat", om.valueToTree(this.getSegmentTemplateFormat()));
                }
                if (this.getSubtitleConfiguration() != null) {
                    data.set("subtitleConfiguration", om.valueToTree(this.getSubtitleConfiguration()));
                }
                if (this.getSuggestedPresentationDelaySeconds() != null) {
                    data.set("suggestedPresentationDelaySeconds", om.valueToTree(this.getSuggestedPresentationDelaySeconds()));
                }
                if (this.getUtcTiming() != null) {
                    data.set("utcTiming", om.valueToTree(this.getUtcTiming()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.DashManifestConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DashManifestConfigurationProperty.Jsii$Proxy that = (DashManifestConfigurationProperty.Jsii$Proxy) o;

                if (!manifestName.equals(that.manifestName)) return false;
                if (this.baseUrls != null ? !this.baseUrls.equals(that.baseUrls) : that.baseUrls != null) return false;
                if (this.compactness != null ? !this.compactness.equals(that.compactness) : that.compactness != null) return false;
                if (this.drmSignaling != null ? !this.drmSignaling.equals(that.drmSignaling) : that.drmSignaling != null) return false;
                if (this.dvbSettings != null ? !this.dvbSettings.equals(that.dvbSettings) : that.dvbSettings != null) return false;
                if (this.filterConfiguration != null ? !this.filterConfiguration.equals(that.filterConfiguration) : that.filterConfiguration != null) return false;
                if (this.manifestWindowSeconds != null ? !this.manifestWindowSeconds.equals(that.manifestWindowSeconds) : that.manifestWindowSeconds != null) return false;
                if (this.minBufferTimeSeconds != null ? !this.minBufferTimeSeconds.equals(that.minBufferTimeSeconds) : that.minBufferTimeSeconds != null) return false;
                if (this.minUpdatePeriodSeconds != null ? !this.minUpdatePeriodSeconds.equals(that.minUpdatePeriodSeconds) : that.minUpdatePeriodSeconds != null) return false;
                if (this.periodTriggers != null ? !this.periodTriggers.equals(that.periodTriggers) : that.periodTriggers != null) return false;
                if (this.profiles != null ? !this.profiles.equals(that.profiles) : that.profiles != null) return false;
                if (this.programInformation != null ? !this.programInformation.equals(that.programInformation) : that.programInformation != null) return false;
                if (this.scteDash != null ? !this.scteDash.equals(that.scteDash) : that.scteDash != null) return false;
                if (this.segmentTemplateFormat != null ? !this.segmentTemplateFormat.equals(that.segmentTemplateFormat) : that.segmentTemplateFormat != null) return false;
                if (this.subtitleConfiguration != null ? !this.subtitleConfiguration.equals(that.subtitleConfiguration) : that.subtitleConfiguration != null) return false;
                if (this.suggestedPresentationDelaySeconds != null ? !this.suggestedPresentationDelaySeconds.equals(that.suggestedPresentationDelaySeconds) : that.suggestedPresentationDelaySeconds != null) return false;
                return this.utcTiming != null ? this.utcTiming.equals(that.utcTiming) : that.utcTiming == null;
            }

            @Override
            public final int hashCode() {
                int result = this.manifestName.hashCode();
                result = 31 * result + (this.baseUrls != null ? this.baseUrls.hashCode() : 0);
                result = 31 * result + (this.compactness != null ? this.compactness.hashCode() : 0);
                result = 31 * result + (this.drmSignaling != null ? this.drmSignaling.hashCode() : 0);
                result = 31 * result + (this.dvbSettings != null ? this.dvbSettings.hashCode() : 0);
                result = 31 * result + (this.filterConfiguration != null ? this.filterConfiguration.hashCode() : 0);
                result = 31 * result + (this.manifestWindowSeconds != null ? this.manifestWindowSeconds.hashCode() : 0);
                result = 31 * result + (this.minBufferTimeSeconds != null ? this.minBufferTimeSeconds.hashCode() : 0);
                result = 31 * result + (this.minUpdatePeriodSeconds != null ? this.minUpdatePeriodSeconds.hashCode() : 0);
                result = 31 * result + (this.periodTriggers != null ? this.periodTriggers.hashCode() : 0);
                result = 31 * result + (this.profiles != null ? this.profiles.hashCode() : 0);
                result = 31 * result + (this.programInformation != null ? this.programInformation.hashCode() : 0);
                result = 31 * result + (this.scteDash != null ? this.scteDash.hashCode() : 0);
                result = 31 * result + (this.segmentTemplateFormat != null ? this.segmentTemplateFormat.hashCode() : 0);
                result = 31 * result + (this.subtitleConfiguration != null ? this.subtitleConfiguration.hashCode() : 0);
                result = 31 * result + (this.suggestedPresentationDelaySeconds != null ? this.suggestedPresentationDelaySeconds.hashCode() : 0);
                result = 31 * result + (this.utcTiming != null ? this.utcTiming.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Details about the content that you want MediaPackage to pass through in the manifest to the playback device.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackagev2.*;
     * DashProgramInformationProperty dashProgramInformationProperty = DashProgramInformationProperty.builder()
     *         .copyright("copyright")
     *         .languageCode("languageCode")
     *         .moreInformationUrl("moreInformationUrl")
     *         .source("source")
     *         .title("title")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashprograminformation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashprograminformation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.DashProgramInformationProperty")
    @software.amazon.jsii.Jsii.Proxy(DashProgramInformationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DashProgramInformationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A copyright statement about the content.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashprograminformation.html#cfn-mediapackagev2-originendpoint-dashprograminformation-copyright">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashprograminformation.html#cfn-mediapackagev2-originendpoint-dashprograminformation-copyright</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCopyright() {
            return null;
        }

        /**
         * The language code for this manifest.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashprograminformation.html#cfn-mediapackagev2-originendpoint-dashprograminformation-languagecode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashprograminformation.html#cfn-mediapackagev2-originendpoint-dashprograminformation-languagecode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLanguageCode() {
            return null;
        }

        /**
         * An absolute URL that contains more information about this content.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashprograminformation.html#cfn-mediapackagev2-originendpoint-dashprograminformation-moreinformationurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashprograminformation.html#cfn-mediapackagev2-originendpoint-dashprograminformation-moreinformationurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMoreInformationUrl() {
            return null;
        }

        /**
         * Information about the content provider.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashprograminformation.html#cfn-mediapackagev2-originendpoint-dashprograminformation-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashprograminformation.html#cfn-mediapackagev2-originendpoint-dashprograminformation-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSource() {
            return null;
        }

        /**
         * The title for the manifest.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashprograminformation.html#cfn-mediapackagev2-originendpoint-dashprograminformation-title">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashprograminformation.html#cfn-mediapackagev2-originendpoint-dashprograminformation-title</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTitle() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DashProgramInformationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DashProgramInformationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DashProgramInformationProperty> {
            java.lang.String copyright;
            java.lang.String languageCode;
            java.lang.String moreInformationUrl;
            java.lang.String source;
            java.lang.String title;

            /**
             * Sets the value of {@link DashProgramInformationProperty#getCopyright}
             * @param copyright A copyright statement about the content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyright(java.lang.String copyright) {
                this.copyright = copyright;
                return this;
            }

            /**
             * Sets the value of {@link DashProgramInformationProperty#getLanguageCode}
             * @param languageCode The language code for this manifest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder languageCode(java.lang.String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            /**
             * Sets the value of {@link DashProgramInformationProperty#getMoreInformationUrl}
             * @param moreInformationUrl An absolute URL that contains more information about this content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder moreInformationUrl(java.lang.String moreInformationUrl) {
                this.moreInformationUrl = moreInformationUrl;
                return this;
            }

            /**
             * Sets the value of {@link DashProgramInformationProperty#getSource}
             * @param source Information about the content provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(java.lang.String source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link DashProgramInformationProperty#getTitle}
             * @param title The title for the manifest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder title(java.lang.String title) {
                this.title = title;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DashProgramInformationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DashProgramInformationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DashProgramInformationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DashProgramInformationProperty {
            private final java.lang.String copyright;
            private final java.lang.String languageCode;
            private final java.lang.String moreInformationUrl;
            private final java.lang.String source;
            private final java.lang.String title;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.copyright = software.amazon.jsii.Kernel.get(this, "copyright", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.languageCode = software.amazon.jsii.Kernel.get(this, "languageCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.moreInformationUrl = software.amazon.jsii.Kernel.get(this, "moreInformationUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.copyright = builder.copyright;
                this.languageCode = builder.languageCode;
                this.moreInformationUrl = builder.moreInformationUrl;
                this.source = builder.source;
                this.title = builder.title;
            }

            @Override
            public final java.lang.String getCopyright() {
                return this.copyright;
            }

            @Override
            public final java.lang.String getLanguageCode() {
                return this.languageCode;
            }

            @Override
            public final java.lang.String getMoreInformationUrl() {
                return this.moreInformationUrl;
            }

            @Override
            public final java.lang.String getSource() {
                return this.source;
            }

            @Override
            public final java.lang.String getTitle() {
                return this.title;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCopyright() != null) {
                    data.set("copyright", om.valueToTree(this.getCopyright()));
                }
                if (this.getLanguageCode() != null) {
                    data.set("languageCode", om.valueToTree(this.getLanguageCode()));
                }
                if (this.getMoreInformationUrl() != null) {
                    data.set("moreInformationUrl", om.valueToTree(this.getMoreInformationUrl()));
                }
                if (this.getSource() != null) {
                    data.set("source", om.valueToTree(this.getSource()));
                }
                if (this.getTitle() != null) {
                    data.set("title", om.valueToTree(this.getTitle()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.DashProgramInformationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DashProgramInformationProperty.Jsii$Proxy that = (DashProgramInformationProperty.Jsii$Proxy) o;

                if (this.copyright != null ? !this.copyright.equals(that.copyright) : that.copyright != null) return false;
                if (this.languageCode != null ? !this.languageCode.equals(that.languageCode) : that.languageCode != null) return false;
                if (this.moreInformationUrl != null ? !this.moreInformationUrl.equals(that.moreInformationUrl) : that.moreInformationUrl != null) return false;
                if (this.source != null ? !this.source.equals(that.source) : that.source != null) return false;
                return this.title != null ? this.title.equals(that.title) : that.title == null;
            }

            @Override
            public final int hashCode() {
                int result = this.copyright != null ? this.copyright.hashCode() : 0;
                result = 31 * result + (this.languageCode != null ? this.languageCode.hashCode() : 0);
                result = 31 * result + (this.moreInformationUrl != null ? this.moreInformationUrl.hashCode() : 0);
                result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
                result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for DASH subtitles.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackagev2.*;
     * DashSubtitleConfigurationProperty dashSubtitleConfigurationProperty = DashSubtitleConfigurationProperty.builder()
     *         .ttmlConfiguration(DashTtmlConfigurationProperty.builder()
     *                 .ttmlProfile("ttmlProfile")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashsubtitleconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashsubtitleconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.DashSubtitleConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DashSubtitleConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DashSubtitleConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Settings for TTML subtitles.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.DashTtmlConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashsubtitleconfiguration.html#cfn-mediapackagev2-originendpoint-dashsubtitleconfiguration-ttmlconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashsubtitleconfiguration.html#cfn-mediapackagev2-originendpoint-dashsubtitleconfiguration-ttmlconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTtmlConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DashSubtitleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DashSubtitleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DashSubtitleConfigurationProperty> {
            java.lang.Object ttmlConfiguration;

            /**
             * Sets the value of {@link DashSubtitleConfigurationProperty#getTtmlConfiguration}
             * @param ttmlConfiguration Settings for TTML subtitles.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ttmlConfiguration(software.amazon.awscdk.IResolvable ttmlConfiguration) {
                this.ttmlConfiguration = ttmlConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DashSubtitleConfigurationProperty#getTtmlConfiguration}
             * @param ttmlConfiguration Settings for TTML subtitles.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ttmlConfiguration(software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.DashTtmlConfigurationProperty ttmlConfiguration) {
                this.ttmlConfiguration = ttmlConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DashSubtitleConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DashSubtitleConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DashSubtitleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DashSubtitleConfigurationProperty {
            private final java.lang.Object ttmlConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ttmlConfiguration = software.amazon.jsii.Kernel.get(this, "ttmlConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ttmlConfiguration = builder.ttmlConfiguration;
            }

            @Override
            public final java.lang.Object getTtmlConfiguration() {
                return this.ttmlConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTtmlConfiguration() != null) {
                    data.set("ttmlConfiguration", om.valueToTree(this.getTtmlConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.DashSubtitleConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DashSubtitleConfigurationProperty.Jsii$Proxy that = (DashSubtitleConfigurationProperty.Jsii$Proxy) o;

                return this.ttmlConfiguration != null ? this.ttmlConfiguration.equals(that.ttmlConfiguration) : that.ttmlConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ttmlConfiguration != null ? this.ttmlConfiguration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The settings for TTML subtitles.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackagev2.*;
     * DashTtmlConfigurationProperty dashTtmlConfigurationProperty = DashTtmlConfigurationProperty.builder()
     *         .ttmlProfile("ttmlProfile")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashttmlconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashttmlconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.DashTtmlConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DashTtmlConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DashTtmlConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The profile that MediaPackage uses when signaling subtitles in the manifest.
         * <p>
         * <code>IMSC</code> is the default profile. <code>EBU-TT-D</code> produces subtitles that are compliant with the EBU-TT-D TTML profile. MediaPackage passes through subtitle styles to the manifest. For more information about EBU-TT-D subtitles, see <a href="https://docs.aws.amazon.com/https://tech.ebu.ch/publications/tech3380">EBU-TT-D Subtitling Distribution Format</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashttmlconfiguration.html#cfn-mediapackagev2-originendpoint-dashttmlconfiguration-ttmlprofile">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashttmlconfiguration.html#cfn-mediapackagev2-originendpoint-dashttmlconfiguration-ttmlprofile</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTtmlProfile();

        /**
         * @return a {@link Builder} of {@link DashTtmlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DashTtmlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DashTtmlConfigurationProperty> {
            java.lang.String ttmlProfile;

            /**
             * Sets the value of {@link DashTtmlConfigurationProperty#getTtmlProfile}
             * @param ttmlProfile The profile that MediaPackage uses when signaling subtitles in the manifest. This parameter is required.
             *                    <code>IMSC</code> is the default profile. <code>EBU-TT-D</code> produces subtitles that are compliant with the EBU-TT-D TTML profile. MediaPackage passes through subtitle styles to the manifest. For more information about EBU-TT-D subtitles, see <a href="https://docs.aws.amazon.com/https://tech.ebu.ch/publications/tech3380">EBU-TT-D Subtitling Distribution Format</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ttmlProfile(java.lang.String ttmlProfile) {
                this.ttmlProfile = ttmlProfile;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DashTtmlConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DashTtmlConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DashTtmlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DashTtmlConfigurationProperty {
            private final java.lang.String ttmlProfile;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ttmlProfile = software.amazon.jsii.Kernel.get(this, "ttmlProfile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ttmlProfile = java.util.Objects.requireNonNull(builder.ttmlProfile, "ttmlProfile is required");
            }

            @Override
            public final java.lang.String getTtmlProfile() {
                return this.ttmlProfile;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("ttmlProfile", om.valueToTree(this.getTtmlProfile()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.DashTtmlConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DashTtmlConfigurationProperty.Jsii$Proxy that = (DashTtmlConfigurationProperty.Jsii$Proxy) o;

                return this.ttmlProfile.equals(that.ttmlProfile);
            }

            @Override
            public final int hashCode() {
                int result = this.ttmlProfile.hashCode();
                return result;
            }
        }
    }
    /**
     * Determines the type of UTC timing included in the DASH Media Presentation Description (MPD).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackagev2.*;
     * DashUtcTimingProperty dashUtcTimingProperty = DashUtcTimingProperty.builder()
     *         .timingMode("timingMode")
     *         .timingSource("timingSource")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashutctiming.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashutctiming.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.DashUtcTimingProperty")
    @software.amazon.jsii.Jsii.Proxy(DashUtcTimingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DashUtcTimingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The UTC timing mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashutctiming.html#cfn-mediapackagev2-originendpoint-dashutctiming-timingmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashutctiming.html#cfn-mediapackagev2-originendpoint-dashutctiming-timingmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimingMode() {
            return null;
        }

        /**
         * The the method that the player uses to synchronize to coordinated universal time (UTC) wall clock time.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashutctiming.html#cfn-mediapackagev2-originendpoint-dashutctiming-timingsource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-dashutctiming.html#cfn-mediapackagev2-originendpoint-dashutctiming-timingsource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimingSource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DashUtcTimingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DashUtcTimingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DashUtcTimingProperty> {
            java.lang.String timingMode;
            java.lang.String timingSource;

            /**
             * Sets the value of {@link DashUtcTimingProperty#getTimingMode}
             * @param timingMode The UTC timing mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timingMode(java.lang.String timingMode) {
                this.timingMode = timingMode;
                return this;
            }

            /**
             * Sets the value of {@link DashUtcTimingProperty#getTimingSource}
             * @param timingSource The the method that the player uses to synchronize to coordinated universal time (UTC) wall clock time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timingSource(java.lang.String timingSource) {
                this.timingSource = timingSource;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DashUtcTimingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DashUtcTimingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DashUtcTimingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DashUtcTimingProperty {
            private final java.lang.String timingMode;
            private final java.lang.String timingSource;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.timingMode = software.amazon.jsii.Kernel.get(this, "timingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timingSource = software.amazon.jsii.Kernel.get(this, "timingSource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.timingMode = builder.timingMode;
                this.timingSource = builder.timingSource;
            }

            @Override
            public final java.lang.String getTimingMode() {
                return this.timingMode;
            }

            @Override
            public final java.lang.String getTimingSource() {
                return this.timingSource;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTimingMode() != null) {
                    data.set("timingMode", om.valueToTree(this.getTimingMode()));
                }
                if (this.getTimingSource() != null) {
                    data.set("timingSource", om.valueToTree(this.getTimingSource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.DashUtcTimingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DashUtcTimingProperty.Jsii$Proxy that = (DashUtcTimingProperty.Jsii$Proxy) o;

                if (this.timingMode != null ? !this.timingMode.equals(that.timingMode) : that.timingMode != null) return false;
                return this.timingSource != null ? this.timingSource.equals(that.timingSource) : that.timingSource == null;
            }

            @Override
            public final int hashCode() {
                int result = this.timingMode != null ? this.timingMode.hashCode() : 0;
                result = 31 * result + (this.timingSource != null ? this.timingSource.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Use <code>encryptionContractConfiguration</code> to configure one or more content encryption keys for your endpoints that use SPEKE Version 2.0. The encryption contract defines which content keys are used to encrypt the audio and video tracks in your stream. To configure the encryption contract, specify which audio and video encryption presets to use.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackagev2.*;
     * EncryptionContractConfigurationProperty encryptionContractConfigurationProperty = EncryptionContractConfigurationProperty.builder()
     *         .presetSpeke20Audio("presetSpeke20Audio")
     *         .presetSpeke20Video("presetSpeke20Video")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-encryptioncontractconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-encryptioncontractconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.EncryptionContractConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionContractConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionContractConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A collection of audio encryption presets.
         * <p>
         * Value description:
         * <p>
         * <ul>
         * <li><code>PRESET-AUDIO-1</code> - Use one content key to encrypt all of the audio tracks in your stream.</li>
         * <li><code>PRESET-AUDIO-2</code> - Use one content key to encrypt all of the stereo audio tracks and one content key to encrypt all of the multichannel audio tracks.</li>
         * <li><code>PRESET-AUDIO-3</code> - Use one content key to encrypt all of the stereo audio tracks, one content key to encrypt all of the multichannel audio tracks with 3 to 6 channels, and one content key to encrypt all of the multichannel audio tracks with more than 6 channels.</li>
         * <li><code>SHARED</code> - Use the same content key for all of the audio and video tracks in your stream.</li>
         * <li><code>UNENCRYPTED</code> - Don't encrypt any of the audio tracks in your stream.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-encryptioncontractconfiguration.html#cfn-mediapackagev2-originendpoint-encryptioncontractconfiguration-presetspeke20audio">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-encryptioncontractconfiguration.html#cfn-mediapackagev2-originendpoint-encryptioncontractconfiguration-presetspeke20audio</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPresetSpeke20Audio();

        /**
         * The SPEKE Version 2.0 preset video associated with the encryption contract configuration of the origin endpoint.
         * <p>
         * A collection of video encryption presets.
         * <p>
         * Value description:
         * <p>
         * <ul>
         * <li><code>PRESET-VIDEO-1</code> - Use one content key to encrypt all of the video tracks in your stream.</li>
         * <li><code>PRESET-VIDEO-2</code> - Use one content key to encrypt all of the SD video tracks and one content key for all HD and higher resolutions video tracks.</li>
         * <li><code>PRESET-VIDEO-3</code> - Use one content key to encrypt all of the SD video tracks, one content key for HD video tracks and one content key for all UHD video tracks.</li>
         * <li><code>PRESET-VIDEO-4</code> - Use one content key to encrypt all of the SD video tracks, one content key for HD video tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.</li>
         * <li><code>PRESET-VIDEO-5</code> - Use one content key to encrypt all of the SD video tracks, one content key for HD1 video tracks, one content key for HD2 video tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.</li>
         * <li><code>PRESET-VIDEO-6</code> - Use one content key to encrypt all of the SD video tracks, one content key for HD1 video tracks, one content key for HD2 video tracks and one content key for all UHD video tracks.</li>
         * <li><code>PRESET-VIDEO-7</code> - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for HD2 video tracks and one content key for all UHD video tracks.</li>
         * <li><code>PRESET-VIDEO-8</code> - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for HD2 video tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.</li>
         * <li><code>SHARED</code> - Use the same content key for all of the video and audio tracks in your stream.</li>
         * <li><code>UNENCRYPTED</code> - Don't encrypt any of the video tracks in your stream.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-encryptioncontractconfiguration.html#cfn-mediapackagev2-originendpoint-encryptioncontractconfiguration-presetspeke20video">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-encryptioncontractconfiguration.html#cfn-mediapackagev2-originendpoint-encryptioncontractconfiguration-presetspeke20video</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPresetSpeke20Video();

        /**
         * @return a {@link Builder} of {@link EncryptionContractConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionContractConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionContractConfigurationProperty> {
            java.lang.String presetSpeke20Audio;
            java.lang.String presetSpeke20Video;

            /**
             * Sets the value of {@link EncryptionContractConfigurationProperty#getPresetSpeke20Audio}
             * @param presetSpeke20Audio A collection of audio encryption presets. This parameter is required.
             *                           Value description:
             *                           <p>
             *                           <ul>
             *                           <li><code>PRESET-AUDIO-1</code> - Use one content key to encrypt all of the audio tracks in your stream.</li>
             *                           <li><code>PRESET-AUDIO-2</code> - Use one content key to encrypt all of the stereo audio tracks and one content key to encrypt all of the multichannel audio tracks.</li>
             *                           <li><code>PRESET-AUDIO-3</code> - Use one content key to encrypt all of the stereo audio tracks, one content key to encrypt all of the multichannel audio tracks with 3 to 6 channels, and one content key to encrypt all of the multichannel audio tracks with more than 6 channels.</li>
             *                           <li><code>SHARED</code> - Use the same content key for all of the audio and video tracks in your stream.</li>
             *                           <li><code>UNENCRYPTED</code> - Don't encrypt any of the audio tracks in your stream.</li>
             *                           </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder presetSpeke20Audio(java.lang.String presetSpeke20Audio) {
                this.presetSpeke20Audio = presetSpeke20Audio;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionContractConfigurationProperty#getPresetSpeke20Video}
             * @param presetSpeke20Video The SPEKE Version 2.0 preset video associated with the encryption contract configuration of the origin endpoint. This parameter is required.
             *                           A collection of video encryption presets.
             *                           <p>
             *                           Value description:
             *                           <p>
             *                           <ul>
             *                           <li><code>PRESET-VIDEO-1</code> - Use one content key to encrypt all of the video tracks in your stream.</li>
             *                           <li><code>PRESET-VIDEO-2</code> - Use one content key to encrypt all of the SD video tracks and one content key for all HD and higher resolutions video tracks.</li>
             *                           <li><code>PRESET-VIDEO-3</code> - Use one content key to encrypt all of the SD video tracks, one content key for HD video tracks and one content key for all UHD video tracks.</li>
             *                           <li><code>PRESET-VIDEO-4</code> - Use one content key to encrypt all of the SD video tracks, one content key for HD video tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.</li>
             *                           <li><code>PRESET-VIDEO-5</code> - Use one content key to encrypt all of the SD video tracks, one content key for HD1 video tracks, one content key for HD2 video tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.</li>
             *                           <li><code>PRESET-VIDEO-6</code> - Use one content key to encrypt all of the SD video tracks, one content key for HD1 video tracks, one content key for HD2 video tracks and one content key for all UHD video tracks.</li>
             *                           <li><code>PRESET-VIDEO-7</code> - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for HD2 video tracks and one content key for all UHD video tracks.</li>
             *                           <li><code>PRESET-VIDEO-8</code> - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for HD2 video tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.</li>
             *                           <li><code>SHARED</code> - Use the same content key for all of the video and audio tracks in your stream.</li>
             *                           <li><code>UNENCRYPTED</code> - Don't encrypt any of the video tracks in your stream.</li>
             *                           </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder presetSpeke20Video(java.lang.String presetSpeke20Video) {
                this.presetSpeke20Video = presetSpeke20Video;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionContractConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionContractConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionContractConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionContractConfigurationProperty {
            private final java.lang.String presetSpeke20Audio;
            private final java.lang.String presetSpeke20Video;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.presetSpeke20Audio = software.amazon.jsii.Kernel.get(this, "presetSpeke20Audio", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.presetSpeke20Video = software.amazon.jsii.Kernel.get(this, "presetSpeke20Video", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.presetSpeke20Audio = java.util.Objects.requireNonNull(builder.presetSpeke20Audio, "presetSpeke20Audio is required");
                this.presetSpeke20Video = java.util.Objects.requireNonNull(builder.presetSpeke20Video, "presetSpeke20Video is required");
            }

            @Override
            public final java.lang.String getPresetSpeke20Audio() {
                return this.presetSpeke20Audio;
            }

            @Override
            public final java.lang.String getPresetSpeke20Video() {
                return this.presetSpeke20Video;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("presetSpeke20Audio", om.valueToTree(this.getPresetSpeke20Audio()));
                data.set("presetSpeke20Video", om.valueToTree(this.getPresetSpeke20Video()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.EncryptionContractConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionContractConfigurationProperty.Jsii$Proxy that = (EncryptionContractConfigurationProperty.Jsii$Proxy) o;

                if (!presetSpeke20Audio.equals(that.presetSpeke20Audio)) return false;
                return this.presetSpeke20Video.equals(that.presetSpeke20Video);
            }

            @Override
            public final int hashCode() {
                int result = this.presetSpeke20Audio.hashCode();
                result = 31 * result + (this.presetSpeke20Video.hashCode());
                return result;
            }
        }
    }
    /**
     * The encryption method associated with the origin endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackagev2.*;
     * EncryptionMethodProperty encryptionMethodProperty = EncryptionMethodProperty.builder()
     *         .cmafEncryptionMethod("cmafEncryptionMethod")
     *         .ismEncryptionMethod("ismEncryptionMethod")
     *         .tsEncryptionMethod("tsEncryptionMethod")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-encryptionmethod.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-encryptionmethod.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.EncryptionMethodProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionMethodProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionMethodProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The encryption method to use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-encryptionmethod.html#cfn-mediapackagev2-originendpoint-encryptionmethod-cmafencryptionmethod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-encryptionmethod.html#cfn-mediapackagev2-originendpoint-encryptionmethod-cmafencryptionmethod</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCmafEncryptionMethod() {
            return null;
        }

        /**
         * The encryption method used for Microsoft Smooth Streaming (MSS) content.
         * <p>
         * This specifies how the MSS segments are encrypted to protect the content during delivery to client players.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-encryptionmethod.html#cfn-mediapackagev2-originendpoint-encryptionmethod-ismencryptionmethod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-encryptionmethod.html#cfn-mediapackagev2-originendpoint-encryptionmethod-ismencryptionmethod</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIsmEncryptionMethod() {
            return null;
        }

        /**
         * The encryption method to use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-encryptionmethod.html#cfn-mediapackagev2-originendpoint-encryptionmethod-tsencryptionmethod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-encryptionmethod.html#cfn-mediapackagev2-originendpoint-encryptionmethod-tsencryptionmethod</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTsEncryptionMethod() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EncryptionMethodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionMethodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionMethodProperty> {
            java.lang.String cmafEncryptionMethod;
            java.lang.String ismEncryptionMethod;
            java.lang.String tsEncryptionMethod;

            /**
             * Sets the value of {@link EncryptionMethodProperty#getCmafEncryptionMethod}
             * @param cmafEncryptionMethod The encryption method to use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cmafEncryptionMethod(java.lang.String cmafEncryptionMethod) {
                this.cmafEncryptionMethod = cmafEncryptionMethod;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionMethodProperty#getIsmEncryptionMethod}
             * @param ismEncryptionMethod The encryption method used for Microsoft Smooth Streaming (MSS) content.
             *                            This specifies how the MSS segments are encrypted to protect the content during delivery to client players.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ismEncryptionMethod(java.lang.String ismEncryptionMethod) {
                this.ismEncryptionMethod = ismEncryptionMethod;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionMethodProperty#getTsEncryptionMethod}
             * @param tsEncryptionMethod The encryption method to use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tsEncryptionMethod(java.lang.String tsEncryptionMethod) {
                this.tsEncryptionMethod = tsEncryptionMethod;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionMethodProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionMethodProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionMethodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionMethodProperty {
            private final java.lang.String cmafEncryptionMethod;
            private final java.lang.String ismEncryptionMethod;
            private final java.lang.String tsEncryptionMethod;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cmafEncryptionMethod = software.amazon.jsii.Kernel.get(this, "cmafEncryptionMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ismEncryptionMethod = software.amazon.jsii.Kernel.get(this, "ismEncryptionMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tsEncryptionMethod = software.amazon.jsii.Kernel.get(this, "tsEncryptionMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cmafEncryptionMethod = builder.cmafEncryptionMethod;
                this.ismEncryptionMethod = builder.ismEncryptionMethod;
                this.tsEncryptionMethod = builder.tsEncryptionMethod;
            }

            @Override
            public final java.lang.String getCmafEncryptionMethod() {
                return this.cmafEncryptionMethod;
            }

            @Override
            public final java.lang.String getIsmEncryptionMethod() {
                return this.ismEncryptionMethod;
            }

            @Override
            public final java.lang.String getTsEncryptionMethod() {
                return this.tsEncryptionMethod;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCmafEncryptionMethod() != null) {
                    data.set("cmafEncryptionMethod", om.valueToTree(this.getCmafEncryptionMethod()));
                }
                if (this.getIsmEncryptionMethod() != null) {
                    data.set("ismEncryptionMethod", om.valueToTree(this.getIsmEncryptionMethod()));
                }
                if (this.getTsEncryptionMethod() != null) {
                    data.set("tsEncryptionMethod", om.valueToTree(this.getTsEncryptionMethod()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.EncryptionMethodProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionMethodProperty.Jsii$Proxy that = (EncryptionMethodProperty.Jsii$Proxy) o;

                if (this.cmafEncryptionMethod != null ? !this.cmafEncryptionMethod.equals(that.cmafEncryptionMethod) : that.cmafEncryptionMethod != null) return false;
                if (this.ismEncryptionMethod != null ? !this.ismEncryptionMethod.equals(that.ismEncryptionMethod) : that.ismEncryptionMethod != null) return false;
                return this.tsEncryptionMethod != null ? this.tsEncryptionMethod.equals(that.tsEncryptionMethod) : that.tsEncryptionMethod == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cmafEncryptionMethod != null ? this.cmafEncryptionMethod.hashCode() : 0;
                result = 31 * result + (this.ismEncryptionMethod != null ? this.ismEncryptionMethod.hashCode() : 0);
                result = 31 * result + (this.tsEncryptionMethod != null ? this.tsEncryptionMethod.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameters for encrypting content.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackagev2.*;
     * EncryptionProperty encryptionProperty = EncryptionProperty.builder()
     *         .encryptionMethod(EncryptionMethodProperty.builder()
     *                 .cmafEncryptionMethod("cmafEncryptionMethod")
     *                 .ismEncryptionMethod("ismEncryptionMethod")
     *                 .tsEncryptionMethod("tsEncryptionMethod")
     *                 .build())
     *         .spekeKeyProvider(SpekeKeyProviderProperty.builder()
     *                 .drmSystems(List.of("drmSystems"))
     *                 .encryptionContractConfiguration(EncryptionContractConfigurationProperty.builder()
     *                         .presetSpeke20Audio("presetSpeke20Audio")
     *                         .presetSpeke20Video("presetSpeke20Video")
     *                         .build())
     *                 .resourceId("resourceId")
     *                 .roleArn("roleArn")
     *                 .url("url")
     *                 .build())
     *         // the properties below are optional
     *         .cmafExcludeSegmentDrmMetadata(false)
     *         .constantInitializationVector("constantInitializationVector")
     *         .keyRotationIntervalSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-encryption.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-encryption.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.EncryptionProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The encryption method to use.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.EncryptionMethodProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-encryption.html#cfn-mediapackagev2-originendpoint-encryption-encryptionmethod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-encryption.html#cfn-mediapackagev2-originendpoint-encryption-encryptionmethod</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEncryptionMethod();

        /**
         * The SPEKE key provider to use for encryption.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.SpekeKeyProviderProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-encryption.html#cfn-mediapackagev2-originendpoint-encryption-spekekeyprovider">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-encryption.html#cfn-mediapackagev2-originendpoint-encryption-spekekeyprovider</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSpekeKeyProvider();

        /**
         * Excludes SEIG and SGPD boxes from segment metadata in CMAF containers.
         * <p>
         * When set to <code>true</code> , MediaPackage omits these DRM metadata boxes from CMAF segments, which can improve compatibility with certain devices and players that don't support these boxes.
         * <p>
         * Important considerations:
         * <p>
         * <ul>
         * <li>This setting only affects CMAF container formats</li>
         * <li>Key rotation can still be handled through media playlist signaling</li>
         * <li>PSSH and TENC boxes remain unaffected</li>
         * <li>Default behavior is preserved when this setting is disabled</li>
         * </ul>
         * <p>
         * Valid values: <code>true</code> | <code>false</code>
         * <p>
         * Default: <code>false</code>
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-encryption.html#cfn-mediapackagev2-originendpoint-encryption-cmafexcludesegmentdrmmetadata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-encryption.html#cfn-mediapackagev2-originendpoint-encryption-cmafexcludesegmentdrmmetadata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCmafExcludeSegmentDrmMetadata() {
            return null;
        }

        /**
         * A 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for encrypting content.
         * <p>
         * If you don't specify a value, then MediaPackage creates the constant initialization vector (IV).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-encryption.html#cfn-mediapackagev2-originendpoint-encryption-constantinitializationvector">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-encryption.html#cfn-mediapackagev2-originendpoint-encryption-constantinitializationvector</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConstantInitializationVector() {
            return null;
        }

        /**
         * The interval, in seconds, to rotate encryption keys for the origin endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-encryption.html#cfn-mediapackagev2-originendpoint-encryption-keyrotationintervalseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-encryption.html#cfn-mediapackagev2-originendpoint-encryption-keyrotationintervalseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getKeyRotationIntervalSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionProperty> {
            java.lang.Object encryptionMethod;
            java.lang.Object spekeKeyProvider;
            java.lang.Object cmafExcludeSegmentDrmMetadata;
            java.lang.String constantInitializationVector;
            java.lang.Number keyRotationIntervalSeconds;

            /**
             * Sets the value of {@link EncryptionProperty#getEncryptionMethod}
             * @param encryptionMethod The encryption method to use. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionMethod(software.amazon.awscdk.IResolvable encryptionMethod) {
                this.encryptionMethod = encryptionMethod;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getEncryptionMethod}
             * @param encryptionMethod The encryption method to use. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionMethod(software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.EncryptionMethodProperty encryptionMethod) {
                this.encryptionMethod = encryptionMethod;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getSpekeKeyProvider}
             * @param spekeKeyProvider The SPEKE key provider to use for encryption. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spekeKeyProvider(software.amazon.awscdk.IResolvable spekeKeyProvider) {
                this.spekeKeyProvider = spekeKeyProvider;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getSpekeKeyProvider}
             * @param spekeKeyProvider The SPEKE key provider to use for encryption. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spekeKeyProvider(software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.SpekeKeyProviderProperty spekeKeyProvider) {
                this.spekeKeyProvider = spekeKeyProvider;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getCmafExcludeSegmentDrmMetadata}
             * @param cmafExcludeSegmentDrmMetadata Excludes SEIG and SGPD boxes from segment metadata in CMAF containers.
             *                                      When set to <code>true</code> , MediaPackage omits these DRM metadata boxes from CMAF segments, which can improve compatibility with certain devices and players that don't support these boxes.
             *                                      <p>
             *                                      Important considerations:
             *                                      <p>
             *                                      <ul>
             *                                      <li>This setting only affects CMAF container formats</li>
             *                                      <li>Key rotation can still be handled through media playlist signaling</li>
             *                                      <li>PSSH and TENC boxes remain unaffected</li>
             *                                      <li>Default behavior is preserved when this setting is disabled</li>
             *                                      </ul>
             *                                      <p>
             *                                      Valid values: <code>true</code> | <code>false</code>
             *                                      <p>
             *                                      Default: <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cmafExcludeSegmentDrmMetadata(java.lang.Boolean cmafExcludeSegmentDrmMetadata) {
                this.cmafExcludeSegmentDrmMetadata = cmafExcludeSegmentDrmMetadata;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getCmafExcludeSegmentDrmMetadata}
             * @param cmafExcludeSegmentDrmMetadata Excludes SEIG and SGPD boxes from segment metadata in CMAF containers.
             *                                      When set to <code>true</code> , MediaPackage omits these DRM metadata boxes from CMAF segments, which can improve compatibility with certain devices and players that don't support these boxes.
             *                                      <p>
             *                                      Important considerations:
             *                                      <p>
             *                                      <ul>
             *                                      <li>This setting only affects CMAF container formats</li>
             *                                      <li>Key rotation can still be handled through media playlist signaling</li>
             *                                      <li>PSSH and TENC boxes remain unaffected</li>
             *                                      <li>Default behavior is preserved when this setting is disabled</li>
             *                                      </ul>
             *                                      <p>
             *                                      Valid values: <code>true</code> | <code>false</code>
             *                                      <p>
             *                                      Default: <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cmafExcludeSegmentDrmMetadata(software.amazon.awscdk.IResolvable cmafExcludeSegmentDrmMetadata) {
                this.cmafExcludeSegmentDrmMetadata = cmafExcludeSegmentDrmMetadata;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getConstantInitializationVector}
             * @param constantInitializationVector A 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for encrypting content.
             *                                     If you don't specify a value, then MediaPackage creates the constant initialization vector (IV).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constantInitializationVector(java.lang.String constantInitializationVector) {
                this.constantInitializationVector = constantInitializationVector;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getKeyRotationIntervalSeconds}
             * @param keyRotationIntervalSeconds The interval, in seconds, to rotate encryption keys for the origin endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyRotationIntervalSeconds(java.lang.Number keyRotationIntervalSeconds) {
                this.keyRotationIntervalSeconds = keyRotationIntervalSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionProperty {
            private final java.lang.Object encryptionMethod;
            private final java.lang.Object spekeKeyProvider;
            private final java.lang.Object cmafExcludeSegmentDrmMetadata;
            private final java.lang.String constantInitializationVector;
            private final java.lang.Number keyRotationIntervalSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encryptionMethod = software.amazon.jsii.Kernel.get(this, "encryptionMethod", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.spekeKeyProvider = software.amazon.jsii.Kernel.get(this, "spekeKeyProvider", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cmafExcludeSegmentDrmMetadata = software.amazon.jsii.Kernel.get(this, "cmafExcludeSegmentDrmMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.constantInitializationVector = software.amazon.jsii.Kernel.get(this, "constantInitializationVector", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyRotationIntervalSeconds = software.amazon.jsii.Kernel.get(this, "keyRotationIntervalSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encryptionMethod = java.util.Objects.requireNonNull(builder.encryptionMethod, "encryptionMethod is required");
                this.spekeKeyProvider = java.util.Objects.requireNonNull(builder.spekeKeyProvider, "spekeKeyProvider is required");
                this.cmafExcludeSegmentDrmMetadata = builder.cmafExcludeSegmentDrmMetadata;
                this.constantInitializationVector = builder.constantInitializationVector;
                this.keyRotationIntervalSeconds = builder.keyRotationIntervalSeconds;
            }

            @Override
            public final java.lang.Object getEncryptionMethod() {
                return this.encryptionMethod;
            }

            @Override
            public final java.lang.Object getSpekeKeyProvider() {
                return this.spekeKeyProvider;
            }

            @Override
            public final java.lang.Object getCmafExcludeSegmentDrmMetadata() {
                return this.cmafExcludeSegmentDrmMetadata;
            }

            @Override
            public final java.lang.String getConstantInitializationVector() {
                return this.constantInitializationVector;
            }

            @Override
            public final java.lang.Number getKeyRotationIntervalSeconds() {
                return this.keyRotationIntervalSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("encryptionMethod", om.valueToTree(this.getEncryptionMethod()));
                data.set("spekeKeyProvider", om.valueToTree(this.getSpekeKeyProvider()));
                if (this.getCmafExcludeSegmentDrmMetadata() != null) {
                    data.set("cmafExcludeSegmentDrmMetadata", om.valueToTree(this.getCmafExcludeSegmentDrmMetadata()));
                }
                if (this.getConstantInitializationVector() != null) {
                    data.set("constantInitializationVector", om.valueToTree(this.getConstantInitializationVector()));
                }
                if (this.getKeyRotationIntervalSeconds() != null) {
                    data.set("keyRotationIntervalSeconds", om.valueToTree(this.getKeyRotationIntervalSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.EncryptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionProperty.Jsii$Proxy that = (EncryptionProperty.Jsii$Proxy) o;

                if (!encryptionMethod.equals(that.encryptionMethod)) return false;
                if (!spekeKeyProvider.equals(that.spekeKeyProvider)) return false;
                if (this.cmafExcludeSegmentDrmMetadata != null ? !this.cmafExcludeSegmentDrmMetadata.equals(that.cmafExcludeSegmentDrmMetadata) : that.cmafExcludeSegmentDrmMetadata != null) return false;
                if (this.constantInitializationVector != null ? !this.constantInitializationVector.equals(that.constantInitializationVector) : that.constantInitializationVector != null) return false;
                return this.keyRotationIntervalSeconds != null ? this.keyRotationIntervalSeconds.equals(that.keyRotationIntervalSeconds) : that.keyRotationIntervalSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encryptionMethod.hashCode();
                result = 31 * result + (this.spekeKeyProvider.hashCode());
                result = 31 * result + (this.cmafExcludeSegmentDrmMetadata != null ? this.cmafExcludeSegmentDrmMetadata.hashCode() : 0);
                result = 31 * result + (this.constantInitializationVector != null ? this.constantInitializationVector.hashCode() : 0);
                result = 31 * result + (this.keyRotationIntervalSeconds != null ? this.keyRotationIntervalSeconds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Filter configuration includes settings for manifest filtering, start and end times, and time delay that apply to all of your egress requests for this manifest.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackagev2.*;
     * FilterConfigurationProperty filterConfigurationProperty = FilterConfigurationProperty.builder()
     *         .clipStartTime("clipStartTime")
     *         .end("end")
     *         .manifestFilter("manifestFilter")
     *         .start("start")
     *         .timeDelaySeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-filterconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-filterconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.FilterConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FilterConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FilterConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Optionally specify the clip start time for all of your manifest egress requests.
         * <p>
         * When you include clip start time, note that you cannot use clip start time query parameters for this manifest's endpoint URL.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-filterconfiguration.html#cfn-mediapackagev2-originendpoint-filterconfiguration-clipstarttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-filterconfiguration.html#cfn-mediapackagev2-originendpoint-filterconfiguration-clipstarttime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClipStartTime() {
            return null;
        }

        /**
         * Optionally specify the end time for all of your manifest egress requests.
         * <p>
         * When you include end time, note that you cannot use end time query parameters for this manifest's endpoint URL.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-filterconfiguration.html#cfn-mediapackagev2-originendpoint-filterconfiguration-end">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-filterconfiguration.html#cfn-mediapackagev2-originendpoint-filterconfiguration-end</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEnd() {
            return null;
        }

        /**
         * Optionally specify one or more manifest filters for all of your manifest egress requests.
         * <p>
         * When you include a manifest filter, note that you cannot use an identical manifest filter query parameter for this manifest's endpoint URL.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-filterconfiguration.html#cfn-mediapackagev2-originendpoint-filterconfiguration-manifestfilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-filterconfiguration.html#cfn-mediapackagev2-originendpoint-filterconfiguration-manifestfilter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getManifestFilter() {
            return null;
        }

        /**
         * Optionally specify the start time for all of your manifest egress requests.
         * <p>
         * When you include start time, note that you cannot use start time query parameters for this manifest's endpoint URL.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-filterconfiguration.html#cfn-mediapackagev2-originendpoint-filterconfiguration-start">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-filterconfiguration.html#cfn-mediapackagev2-originendpoint-filterconfiguration-start</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStart() {
            return null;
        }

        /**
         * Optionally specify the time delay for all of your manifest egress requests.
         * <p>
         * Enter a value that is smaller than your endpoint's startover window. When you include time delay, note that you cannot use time delay query parameters for this manifest's endpoint URL.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-filterconfiguration.html#cfn-mediapackagev2-originendpoint-filterconfiguration-timedelayseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-filterconfiguration.html#cfn-mediapackagev2-originendpoint-filterconfiguration-timedelayseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeDelaySeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FilterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FilterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FilterConfigurationProperty> {
            java.lang.String clipStartTime;
            java.lang.String end;
            java.lang.String manifestFilter;
            java.lang.String start;
            java.lang.Number timeDelaySeconds;

            /**
             * Sets the value of {@link FilterConfigurationProperty#getClipStartTime}
             * @param clipStartTime Optionally specify the clip start time for all of your manifest egress requests.
             *                      When you include clip start time, note that you cannot use clip start time query parameters for this manifest's endpoint URL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clipStartTime(java.lang.String clipStartTime) {
                this.clipStartTime = clipStartTime;
                return this;
            }

            /**
             * Sets the value of {@link FilterConfigurationProperty#getEnd}
             * @param end Optionally specify the end time for all of your manifest egress requests.
             *            When you include end time, note that you cannot use end time query parameters for this manifest's endpoint URL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder end(java.lang.String end) {
                this.end = end;
                return this;
            }

            /**
             * Sets the value of {@link FilterConfigurationProperty#getManifestFilter}
             * @param manifestFilter Optionally specify one or more manifest filters for all of your manifest egress requests.
             *                       When you include a manifest filter, note that you cannot use an identical manifest filter query parameter for this manifest's endpoint URL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifestFilter(java.lang.String manifestFilter) {
                this.manifestFilter = manifestFilter;
                return this;
            }

            /**
             * Sets the value of {@link FilterConfigurationProperty#getStart}
             * @param start Optionally specify the start time for all of your manifest egress requests.
             *              When you include start time, note that you cannot use start time query parameters for this manifest's endpoint URL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder start(java.lang.String start) {
                this.start = start;
                return this;
            }

            /**
             * Sets the value of {@link FilterConfigurationProperty#getTimeDelaySeconds}
             * @param timeDelaySeconds Optionally specify the time delay for all of your manifest egress requests.
             *                         Enter a value that is smaller than your endpoint's startover window. When you include time delay, note that you cannot use time delay query parameters for this manifest's endpoint URL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeDelaySeconds(java.lang.Number timeDelaySeconds) {
                this.timeDelaySeconds = timeDelaySeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FilterConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FilterConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FilterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FilterConfigurationProperty {
            private final java.lang.String clipStartTime;
            private final java.lang.String end;
            private final java.lang.String manifestFilter;
            private final java.lang.String start;
            private final java.lang.Number timeDelaySeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clipStartTime = software.amazon.jsii.Kernel.get(this, "clipStartTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.end = software.amazon.jsii.Kernel.get(this, "end", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.manifestFilter = software.amazon.jsii.Kernel.get(this, "manifestFilter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.start = software.amazon.jsii.Kernel.get(this, "start", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeDelaySeconds = software.amazon.jsii.Kernel.get(this, "timeDelaySeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clipStartTime = builder.clipStartTime;
                this.end = builder.end;
                this.manifestFilter = builder.manifestFilter;
                this.start = builder.start;
                this.timeDelaySeconds = builder.timeDelaySeconds;
            }

            @Override
            public final java.lang.String getClipStartTime() {
                return this.clipStartTime;
            }

            @Override
            public final java.lang.String getEnd() {
                return this.end;
            }

            @Override
            public final java.lang.String getManifestFilter() {
                return this.manifestFilter;
            }

            @Override
            public final java.lang.String getStart() {
                return this.start;
            }

            @Override
            public final java.lang.Number getTimeDelaySeconds() {
                return this.timeDelaySeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClipStartTime() != null) {
                    data.set("clipStartTime", om.valueToTree(this.getClipStartTime()));
                }
                if (this.getEnd() != null) {
                    data.set("end", om.valueToTree(this.getEnd()));
                }
                if (this.getManifestFilter() != null) {
                    data.set("manifestFilter", om.valueToTree(this.getManifestFilter()));
                }
                if (this.getStart() != null) {
                    data.set("start", om.valueToTree(this.getStart()));
                }
                if (this.getTimeDelaySeconds() != null) {
                    data.set("timeDelaySeconds", om.valueToTree(this.getTimeDelaySeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.FilterConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FilterConfigurationProperty.Jsii$Proxy that = (FilterConfigurationProperty.Jsii$Proxy) o;

                if (this.clipStartTime != null ? !this.clipStartTime.equals(that.clipStartTime) : that.clipStartTime != null) return false;
                if (this.end != null ? !this.end.equals(that.end) : that.end != null) return false;
                if (this.manifestFilter != null ? !this.manifestFilter.equals(that.manifestFilter) : that.manifestFilter != null) return false;
                if (this.start != null ? !this.start.equals(that.start) : that.start != null) return false;
                return this.timeDelaySeconds != null ? this.timeDelaySeconds.equals(that.timeDelaySeconds) : that.timeDelaySeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clipStartTime != null ? this.clipStartTime.hashCode() : 0;
                result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
                result = 31 * result + (this.manifestFilter != null ? this.manifestFilter.hashCode() : 0);
                result = 31 * result + (this.start != null ? this.start.hashCode() : 0);
                result = 31 * result + (this.timeDelaySeconds != null ? this.timeDelaySeconds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The failover settings for the endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackagev2.*;
     * ForceEndpointErrorConfigurationProperty forceEndpointErrorConfigurationProperty = ForceEndpointErrorConfigurationProperty.builder()
     *         .endpointErrorConditions(List.of("endpointErrorConditions"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-forceendpointerrorconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-forceendpointerrorconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.ForceEndpointErrorConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ForceEndpointErrorConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ForceEndpointErrorConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The failover conditions for the endpoint. The options are:.
         * <p>
         * <ul>
         * <li><code>STALE_MANIFEST</code> - The manifest stalled and there are no new segments or parts.</li>
         * <li><code>INCOMPLETE_MANIFEST</code> - There is a gap in the manifest.</li>
         * <li><code>MISSING_DRM_KEY</code> - Key rotation is enabled but we're unable to fetch the key for the current key period.</li>
         * <li><code>SLATE_INPUT</code> - The segments which contain slate content are considered to be missing content.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-forceendpointerrorconfiguration.html#cfn-mediapackagev2-originendpoint-forceendpointerrorconfiguration-endpointerrorconditions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-forceendpointerrorconfiguration.html#cfn-mediapackagev2-originendpoint-forceendpointerrorconfiguration-endpointerrorconditions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEndpointErrorConditions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ForceEndpointErrorConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ForceEndpointErrorConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ForceEndpointErrorConfigurationProperty> {
            java.util.List<java.lang.String> endpointErrorConditions;

            /**
             * Sets the value of {@link ForceEndpointErrorConfigurationProperty#getEndpointErrorConditions}
             * @param endpointErrorConditions The failover conditions for the endpoint. The options are:.
             *                                <ul>
             *                                <li><code>STALE_MANIFEST</code> - The manifest stalled and there are no new segments or parts.</li>
             *                                <li><code>INCOMPLETE_MANIFEST</code> - There is a gap in the manifest.</li>
             *                                <li><code>MISSING_DRM_KEY</code> - Key rotation is enabled but we're unable to fetch the key for the current key period.</li>
             *                                <li><code>SLATE_INPUT</code> - The segments which contain slate content are considered to be missing content.</li>
             *                                </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointErrorConditions(java.util.List<java.lang.String> endpointErrorConditions) {
                this.endpointErrorConditions = endpointErrorConditions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ForceEndpointErrorConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ForceEndpointErrorConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ForceEndpointErrorConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ForceEndpointErrorConfigurationProperty {
            private final java.util.List<java.lang.String> endpointErrorConditions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endpointErrorConditions = software.amazon.jsii.Kernel.get(this, "endpointErrorConditions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endpointErrorConditions = builder.endpointErrorConditions;
            }

            @Override
            public final java.util.List<java.lang.String> getEndpointErrorConditions() {
                return this.endpointErrorConditions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEndpointErrorConditions() != null) {
                    data.set("endpointErrorConditions", om.valueToTree(this.getEndpointErrorConditions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.ForceEndpointErrorConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ForceEndpointErrorConfigurationProperty.Jsii$Proxy that = (ForceEndpointErrorConfigurationProperty.Jsii$Proxy) o;

                return this.endpointErrorConditions != null ? this.endpointErrorConditions.equals(that.endpointErrorConditions) : that.endpointErrorConditions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.endpointErrorConditions != null ? this.endpointErrorConditions.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The HLS manifest configuration associated with the origin endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackagev2.*;
     * HlsManifestConfigurationProperty hlsManifestConfigurationProperty = HlsManifestConfigurationProperty.builder()
     *         .manifestName("manifestName")
     *         // the properties below are optional
     *         .childManifestName("childManifestName")
     *         .filterConfiguration(FilterConfigurationProperty.builder()
     *                 .clipStartTime("clipStartTime")
     *                 .end("end")
     *                 .manifestFilter("manifestFilter")
     *                 .start("start")
     *                 .timeDelaySeconds(123)
     *                 .build())
     *         .manifestWindowSeconds(123)
     *         .programDateTimeIntervalSeconds(123)
     *         .scteHls(ScteHlsProperty.builder()
     *                 .adMarkerHls("adMarkerHls")
     *                 .build())
     *         .startTag(StartTagProperty.builder()
     *                 .timeOffset(123)
     *                 // the properties below are optional
     *                 .precise(false)
     *                 .build())
     *         .url("url")
     *         .urlEncodeChildManifest(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-hlsmanifestconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-hlsmanifestconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.HlsManifestConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(HlsManifestConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HlsManifestConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the manifest associated with the HLS manifest configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-hlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-hlsmanifestconfiguration-manifestname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-hlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-hlsmanifestconfiguration-manifestname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getManifestName();

        /**
         * The name of the child manifest associated with the HLS manifest configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-hlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-hlsmanifestconfiguration-childmanifestname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-hlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-hlsmanifestconfiguration-childmanifestname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getChildManifestName() {
            return null;
        }

        /**
         * Filter configuration includes settings for manifest filtering, start and end times, and time delay that apply to all of your egress requests for this manifest.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.FilterConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-hlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-hlsmanifestconfiguration-filterconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-hlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-hlsmanifestconfiguration-filterconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilterConfiguration() {
            return null;
        }

        /**
         * The duration of the manifest window, in seconds, for the HLS manifest configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-hlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-hlsmanifestconfiguration-manifestwindowseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-hlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-hlsmanifestconfiguration-manifestwindowseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getManifestWindowSeconds() {
            return null;
        }

        /**
         * The <code>EXT-X-PROGRAM-DATE-TIME</code> interval, in seconds, associated with the HLS manifest configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-hlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-hlsmanifestconfiguration-programdatetimeintervalseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-hlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-hlsmanifestconfiguration-programdatetimeintervalseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getProgramDateTimeIntervalSeconds() {
            return null;
        }

        /**
         * THE SCTE-35 HLS configuration associated with the HLS manifest configuration.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.ScteHlsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-hlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-hlsmanifestconfiguration-sctehls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-hlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-hlsmanifestconfiguration-sctehls</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScteHls() {
            return null;
        }

        /**
         * To insert an EXT-X-START tag in your HLS playlist, specify a StartTag configuration object with a valid TimeOffset.
         * <p>
         * When you do, you can also optionally specify whether to include a PRECISE value in the EXT-X-START tag.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.StartTagProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-hlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-hlsmanifestconfiguration-starttag">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-hlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-hlsmanifestconfiguration-starttag</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStartTag() {
            return null;
        }

        /**
         * The URL of the HLS manifest configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-hlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-hlsmanifestconfiguration-url">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-hlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-hlsmanifestconfiguration-url</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUrl() {
            return null;
        }

        /**
         * When enabled, MediaPackage URL-encodes the query string for API requests for HLS child manifests to comply with AWS Signature Version 4 (SigV4) signature signing protocol.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_sigv.html">AWS Signature Version 4 for API requests</a> in <em>AWS Identity and Access Management User Guide</em> .
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-hlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-hlsmanifestconfiguration-urlencodechildmanifest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-hlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-hlsmanifestconfiguration-urlencodechildmanifest</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUrlEncodeChildManifest() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HlsManifestConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HlsManifestConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HlsManifestConfigurationProperty> {
            java.lang.String manifestName;
            java.lang.String childManifestName;
            java.lang.Object filterConfiguration;
            java.lang.Number manifestWindowSeconds;
            java.lang.Number programDateTimeIntervalSeconds;
            java.lang.Object scteHls;
            java.lang.Object startTag;
            java.lang.String url;
            java.lang.Object urlEncodeChildManifest;

            /**
             * Sets the value of {@link HlsManifestConfigurationProperty#getManifestName}
             * @param manifestName The name of the manifest associated with the HLS manifest configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifestName(java.lang.String manifestName) {
                this.manifestName = manifestName;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestConfigurationProperty#getChildManifestName}
             * @param childManifestName The name of the child manifest associated with the HLS manifest configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder childManifestName(java.lang.String childManifestName) {
                this.childManifestName = childManifestName;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestConfigurationProperty#getFilterConfiguration}
             * @param filterConfiguration Filter configuration includes settings for manifest filtering, start and end times, and time delay that apply to all of your egress requests for this manifest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterConfiguration(software.amazon.awscdk.IResolvable filterConfiguration) {
                this.filterConfiguration = filterConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestConfigurationProperty#getFilterConfiguration}
             * @param filterConfiguration Filter configuration includes settings for manifest filtering, start and end times, and time delay that apply to all of your egress requests for this manifest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterConfiguration(software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.FilterConfigurationProperty filterConfiguration) {
                this.filterConfiguration = filterConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestConfigurationProperty#getManifestWindowSeconds}
             * @param manifestWindowSeconds The duration of the manifest window, in seconds, for the HLS manifest configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifestWindowSeconds(java.lang.Number manifestWindowSeconds) {
                this.manifestWindowSeconds = manifestWindowSeconds;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestConfigurationProperty#getProgramDateTimeIntervalSeconds}
             * @param programDateTimeIntervalSeconds The <code>EXT-X-PROGRAM-DATE-TIME</code> interval, in seconds, associated with the HLS manifest configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder programDateTimeIntervalSeconds(java.lang.Number programDateTimeIntervalSeconds) {
                this.programDateTimeIntervalSeconds = programDateTimeIntervalSeconds;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestConfigurationProperty#getScteHls}
             * @param scteHls THE SCTE-35 HLS configuration associated with the HLS manifest configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scteHls(software.amazon.awscdk.IResolvable scteHls) {
                this.scteHls = scteHls;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestConfigurationProperty#getScteHls}
             * @param scteHls THE SCTE-35 HLS configuration associated with the HLS manifest configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scteHls(software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.ScteHlsProperty scteHls) {
                this.scteHls = scteHls;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestConfigurationProperty#getStartTag}
             * @param startTag To insert an EXT-X-START tag in your HLS playlist, specify a StartTag configuration object with a valid TimeOffset.
             *                 When you do, you can also optionally specify whether to include a PRECISE value in the EXT-X-START tag.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTag(software.amazon.awscdk.IResolvable startTag) {
                this.startTag = startTag;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestConfigurationProperty#getStartTag}
             * @param startTag To insert an EXT-X-START tag in your HLS playlist, specify a StartTag configuration object with a valid TimeOffset.
             *                 When you do, you can also optionally specify whether to include a PRECISE value in the EXT-X-START tag.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTag(software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.StartTagProperty startTag) {
                this.startTag = startTag;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestConfigurationProperty#getUrl}
             * @param url The URL of the HLS manifest configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(java.lang.String url) {
                this.url = url;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestConfigurationProperty#getUrlEncodeChildManifest}
             * @param urlEncodeChildManifest When enabled, MediaPackage URL-encodes the query string for API requests for HLS child manifests to comply with AWS Signature Version 4 (SigV4) signature signing protocol.
             *                               For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_sigv.html">AWS Signature Version 4 for API requests</a> in <em>AWS Identity and Access Management User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder urlEncodeChildManifest(java.lang.Boolean urlEncodeChildManifest) {
                this.urlEncodeChildManifest = urlEncodeChildManifest;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestConfigurationProperty#getUrlEncodeChildManifest}
             * @param urlEncodeChildManifest When enabled, MediaPackage URL-encodes the query string for API requests for HLS child manifests to comply with AWS Signature Version 4 (SigV4) signature signing protocol.
             *                               For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_sigv.html">AWS Signature Version 4 for API requests</a> in <em>AWS Identity and Access Management User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder urlEncodeChildManifest(software.amazon.awscdk.IResolvable urlEncodeChildManifest) {
                this.urlEncodeChildManifest = urlEncodeChildManifest;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HlsManifestConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HlsManifestConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HlsManifestConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HlsManifestConfigurationProperty {
            private final java.lang.String manifestName;
            private final java.lang.String childManifestName;
            private final java.lang.Object filterConfiguration;
            private final java.lang.Number manifestWindowSeconds;
            private final java.lang.Number programDateTimeIntervalSeconds;
            private final java.lang.Object scteHls;
            private final java.lang.Object startTag;
            private final java.lang.String url;
            private final java.lang.Object urlEncodeChildManifest;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.manifestName = software.amazon.jsii.Kernel.get(this, "manifestName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.childManifestName = software.amazon.jsii.Kernel.get(this, "childManifestName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.filterConfiguration = software.amazon.jsii.Kernel.get(this, "filterConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.manifestWindowSeconds = software.amazon.jsii.Kernel.get(this, "manifestWindowSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.programDateTimeIntervalSeconds = software.amazon.jsii.Kernel.get(this, "programDateTimeIntervalSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.scteHls = software.amazon.jsii.Kernel.get(this, "scteHls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.startTag = software.amazon.jsii.Kernel.get(this, "startTag", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.urlEncodeChildManifest = software.amazon.jsii.Kernel.get(this, "urlEncodeChildManifest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.manifestName = java.util.Objects.requireNonNull(builder.manifestName, "manifestName is required");
                this.childManifestName = builder.childManifestName;
                this.filterConfiguration = builder.filterConfiguration;
                this.manifestWindowSeconds = builder.manifestWindowSeconds;
                this.programDateTimeIntervalSeconds = builder.programDateTimeIntervalSeconds;
                this.scteHls = builder.scteHls;
                this.startTag = builder.startTag;
                this.url = builder.url;
                this.urlEncodeChildManifest = builder.urlEncodeChildManifest;
            }

            @Override
            public final java.lang.String getManifestName() {
                return this.manifestName;
            }

            @Override
            public final java.lang.String getChildManifestName() {
                return this.childManifestName;
            }

            @Override
            public final java.lang.Object getFilterConfiguration() {
                return this.filterConfiguration;
            }

            @Override
            public final java.lang.Number getManifestWindowSeconds() {
                return this.manifestWindowSeconds;
            }

            @Override
            public final java.lang.Number getProgramDateTimeIntervalSeconds() {
                return this.programDateTimeIntervalSeconds;
            }

            @Override
            public final java.lang.Object getScteHls() {
                return this.scteHls;
            }

            @Override
            public final java.lang.Object getStartTag() {
                return this.startTag;
            }

            @Override
            public final java.lang.String getUrl() {
                return this.url;
            }

            @Override
            public final java.lang.Object getUrlEncodeChildManifest() {
                return this.urlEncodeChildManifest;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("manifestName", om.valueToTree(this.getManifestName()));
                if (this.getChildManifestName() != null) {
                    data.set("childManifestName", om.valueToTree(this.getChildManifestName()));
                }
                if (this.getFilterConfiguration() != null) {
                    data.set("filterConfiguration", om.valueToTree(this.getFilterConfiguration()));
                }
                if (this.getManifestWindowSeconds() != null) {
                    data.set("manifestWindowSeconds", om.valueToTree(this.getManifestWindowSeconds()));
                }
                if (this.getProgramDateTimeIntervalSeconds() != null) {
                    data.set("programDateTimeIntervalSeconds", om.valueToTree(this.getProgramDateTimeIntervalSeconds()));
                }
                if (this.getScteHls() != null) {
                    data.set("scteHls", om.valueToTree(this.getScteHls()));
                }
                if (this.getStartTag() != null) {
                    data.set("startTag", om.valueToTree(this.getStartTag()));
                }
                if (this.getUrl() != null) {
                    data.set("url", om.valueToTree(this.getUrl()));
                }
                if (this.getUrlEncodeChildManifest() != null) {
                    data.set("urlEncodeChildManifest", om.valueToTree(this.getUrlEncodeChildManifest()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.HlsManifestConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HlsManifestConfigurationProperty.Jsii$Proxy that = (HlsManifestConfigurationProperty.Jsii$Proxy) o;

                if (!manifestName.equals(that.manifestName)) return false;
                if (this.childManifestName != null ? !this.childManifestName.equals(that.childManifestName) : that.childManifestName != null) return false;
                if (this.filterConfiguration != null ? !this.filterConfiguration.equals(that.filterConfiguration) : that.filterConfiguration != null) return false;
                if (this.manifestWindowSeconds != null ? !this.manifestWindowSeconds.equals(that.manifestWindowSeconds) : that.manifestWindowSeconds != null) return false;
                if (this.programDateTimeIntervalSeconds != null ? !this.programDateTimeIntervalSeconds.equals(that.programDateTimeIntervalSeconds) : that.programDateTimeIntervalSeconds != null) return false;
                if (this.scteHls != null ? !this.scteHls.equals(that.scteHls) : that.scteHls != null) return false;
                if (this.startTag != null ? !this.startTag.equals(that.startTag) : that.startTag != null) return false;
                if (this.url != null ? !this.url.equals(that.url) : that.url != null) return false;
                return this.urlEncodeChildManifest != null ? this.urlEncodeChildManifest.equals(that.urlEncodeChildManifest) : that.urlEncodeChildManifest == null;
            }

            @Override
            public final int hashCode() {
                int result = this.manifestName.hashCode();
                result = 31 * result + (this.childManifestName != null ? this.childManifestName.hashCode() : 0);
                result = 31 * result + (this.filterConfiguration != null ? this.filterConfiguration.hashCode() : 0);
                result = 31 * result + (this.manifestWindowSeconds != null ? this.manifestWindowSeconds.hashCode() : 0);
                result = 31 * result + (this.programDateTimeIntervalSeconds != null ? this.programDateTimeIntervalSeconds.hashCode() : 0);
                result = 31 * result + (this.scteHls != null ? this.scteHls.hashCode() : 0);
                result = 31 * result + (this.startTag != null ? this.startTag.hashCode() : 0);
                result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
                result = 31 * result + (this.urlEncodeChildManifest != null ? this.urlEncodeChildManifest.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specify a low-latency HTTP live streaming (LL-HLS) manifest configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackagev2.*;
     * LowLatencyHlsManifestConfigurationProperty lowLatencyHlsManifestConfigurationProperty = LowLatencyHlsManifestConfigurationProperty.builder()
     *         .manifestName("manifestName")
     *         // the properties below are optional
     *         .childManifestName("childManifestName")
     *         .filterConfiguration(FilterConfigurationProperty.builder()
     *                 .clipStartTime("clipStartTime")
     *                 .end("end")
     *                 .manifestFilter("manifestFilter")
     *                 .start("start")
     *                 .timeDelaySeconds(123)
     *                 .build())
     *         .manifestWindowSeconds(123)
     *         .programDateTimeIntervalSeconds(123)
     *         .scteHls(ScteHlsProperty.builder()
     *                 .adMarkerHls("adMarkerHls")
     *                 .build())
     *         .startTag(StartTagProperty.builder()
     *                 .timeOffset(123)
     *                 // the properties below are optional
     *                 .precise(false)
     *                 .build())
     *         .url("url")
     *         .urlEncodeChildManifest(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.LowLatencyHlsManifestConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LowLatencyHlsManifestConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LowLatencyHlsManifestConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A short string that's appended to the endpoint URL.
         * <p>
         * The manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default manifest name, <code>index</code> . MediaPackage automatically inserts the format extension, such as <code>.m3u8</code> . You can't use the same manifest name if you use HLS manifest and low-latency HLS manifest. The <code>manifestName</code> on the <code>HLSManifest</code> object overrides the <code>manifestName</code> you provided on the <code>originEndpoint</code> object.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration-manifestname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration-manifestname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getManifestName();

        /**
         * The name of the child manifest associated with the low-latency HLS (LL-HLS) manifest configuration of the origin endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration-childmanifestname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration-childmanifestname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getChildManifestName() {
            return null;
        }

        /**
         * Filter configuration includes settings for manifest filtering, start and end times, and time delay that apply to all of your egress requests for this manifest.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.FilterConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration-filterconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration-filterconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilterConfiguration() {
            return null;
        }

        /**
         * The total duration (in seconds) of the manifest's content.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration-manifestwindowseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration-manifestwindowseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getManifestWindowSeconds() {
            return null;
        }

        /**
         * Inserts <code>EXT-X-PROGRAM-DATE-TIME</code> tags in the output manifest at the interval that you specify.
         * <p>
         * If you don't enter an interval, <code>EXT-X-PROGRAM-DATE-TIME</code> tags aren't included in the manifest. The tags sync the stream to the wall clock so that viewers can seek to a specific time in the playback timeline on the player.
         * <p>
         * Irrespective of this parameter, if any <code>ID3Timed</code> metadata is in the HLS input, MediaPackage passes through that metadata to the HLS output.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration-programdatetimeintervalseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration-programdatetimeintervalseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getProgramDateTimeIntervalSeconds() {
            return null;
        }

        /**
         * The SCTE-35 HLS configuration associated with the low-latency HLS (LL-HLS) manifest configuration of the origin endpoint.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.ScteHlsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration-sctehls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration-sctehls</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScteHls() {
            return null;
        }

        /**
         * To insert an EXT-X-START tag in your HLS playlist, specify a StartTag configuration object with a valid TimeOffset.
         * <p>
         * When you do, you can also optionally specify whether to include a PRECISE value in the EXT-X-START tag.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.StartTagProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration-starttag">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration-starttag</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStartTag() {
            return null;
        }

        /**
         * The URL of the low-latency HLS (LL-HLS) manifest configuration of the origin endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration-url">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration-url</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUrl() {
            return null;
        }

        /**
         * When enabled, MediaPackage URL-encodes the query string for API requests for LL-HLS child manifests to comply with AWS Signature Version 4 (SigV4) signature signing protocol.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_sigv.html">AWS Signature Version 4 for API requests</a> in <em>AWS Identity and Access Management User Guide</em> .
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration-urlencodechildmanifest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-lowlatencyhlsmanifestconfiguration-urlencodechildmanifest</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUrlEncodeChildManifest() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LowLatencyHlsManifestConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LowLatencyHlsManifestConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LowLatencyHlsManifestConfigurationProperty> {
            java.lang.String manifestName;
            java.lang.String childManifestName;
            java.lang.Object filterConfiguration;
            java.lang.Number manifestWindowSeconds;
            java.lang.Number programDateTimeIntervalSeconds;
            java.lang.Object scteHls;
            java.lang.Object startTag;
            java.lang.String url;
            java.lang.Object urlEncodeChildManifest;

            /**
             * Sets the value of {@link LowLatencyHlsManifestConfigurationProperty#getManifestName}
             * @param manifestName A short string that's appended to the endpoint URL. This parameter is required.
             *                     The manifest name creates a unique path to this endpoint. If you don't enter a value, MediaPackage uses the default manifest name, <code>index</code> . MediaPackage automatically inserts the format extension, such as <code>.m3u8</code> . You can't use the same manifest name if you use HLS manifest and low-latency HLS manifest. The <code>manifestName</code> on the <code>HLSManifest</code> object overrides the <code>manifestName</code> you provided on the <code>originEndpoint</code> object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifestName(java.lang.String manifestName) {
                this.manifestName = manifestName;
                return this;
            }

            /**
             * Sets the value of {@link LowLatencyHlsManifestConfigurationProperty#getChildManifestName}
             * @param childManifestName The name of the child manifest associated with the low-latency HLS (LL-HLS) manifest configuration of the origin endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder childManifestName(java.lang.String childManifestName) {
                this.childManifestName = childManifestName;
                return this;
            }

            /**
             * Sets the value of {@link LowLatencyHlsManifestConfigurationProperty#getFilterConfiguration}
             * @param filterConfiguration Filter configuration includes settings for manifest filtering, start and end times, and time delay that apply to all of your egress requests for this manifest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterConfiguration(software.amazon.awscdk.IResolvable filterConfiguration) {
                this.filterConfiguration = filterConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link LowLatencyHlsManifestConfigurationProperty#getFilterConfiguration}
             * @param filterConfiguration Filter configuration includes settings for manifest filtering, start and end times, and time delay that apply to all of your egress requests for this manifest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterConfiguration(software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.FilterConfigurationProperty filterConfiguration) {
                this.filterConfiguration = filterConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link LowLatencyHlsManifestConfigurationProperty#getManifestWindowSeconds}
             * @param manifestWindowSeconds The total duration (in seconds) of the manifest's content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifestWindowSeconds(java.lang.Number manifestWindowSeconds) {
                this.manifestWindowSeconds = manifestWindowSeconds;
                return this;
            }

            /**
             * Sets the value of {@link LowLatencyHlsManifestConfigurationProperty#getProgramDateTimeIntervalSeconds}
             * @param programDateTimeIntervalSeconds Inserts <code>EXT-X-PROGRAM-DATE-TIME</code> tags in the output manifest at the interval that you specify.
             *                                       If you don't enter an interval, <code>EXT-X-PROGRAM-DATE-TIME</code> tags aren't included in the manifest. The tags sync the stream to the wall clock so that viewers can seek to a specific time in the playback timeline on the player.
             *                                       <p>
             *                                       Irrespective of this parameter, if any <code>ID3Timed</code> metadata is in the HLS input, MediaPackage passes through that metadata to the HLS output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder programDateTimeIntervalSeconds(java.lang.Number programDateTimeIntervalSeconds) {
                this.programDateTimeIntervalSeconds = programDateTimeIntervalSeconds;
                return this;
            }

            /**
             * Sets the value of {@link LowLatencyHlsManifestConfigurationProperty#getScteHls}
             * @param scteHls The SCTE-35 HLS configuration associated with the low-latency HLS (LL-HLS) manifest configuration of the origin endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scteHls(software.amazon.awscdk.IResolvable scteHls) {
                this.scteHls = scteHls;
                return this;
            }

            /**
             * Sets the value of {@link LowLatencyHlsManifestConfigurationProperty#getScteHls}
             * @param scteHls The SCTE-35 HLS configuration associated with the low-latency HLS (LL-HLS) manifest configuration of the origin endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scteHls(software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.ScteHlsProperty scteHls) {
                this.scteHls = scteHls;
                return this;
            }

            /**
             * Sets the value of {@link LowLatencyHlsManifestConfigurationProperty#getStartTag}
             * @param startTag To insert an EXT-X-START tag in your HLS playlist, specify a StartTag configuration object with a valid TimeOffset.
             *                 When you do, you can also optionally specify whether to include a PRECISE value in the EXT-X-START tag.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTag(software.amazon.awscdk.IResolvable startTag) {
                this.startTag = startTag;
                return this;
            }

            /**
             * Sets the value of {@link LowLatencyHlsManifestConfigurationProperty#getStartTag}
             * @param startTag To insert an EXT-X-START tag in your HLS playlist, specify a StartTag configuration object with a valid TimeOffset.
             *                 When you do, you can also optionally specify whether to include a PRECISE value in the EXT-X-START tag.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTag(software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.StartTagProperty startTag) {
                this.startTag = startTag;
                return this;
            }

            /**
             * Sets the value of {@link LowLatencyHlsManifestConfigurationProperty#getUrl}
             * @param url The URL of the low-latency HLS (LL-HLS) manifest configuration of the origin endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(java.lang.String url) {
                this.url = url;
                return this;
            }

            /**
             * Sets the value of {@link LowLatencyHlsManifestConfigurationProperty#getUrlEncodeChildManifest}
             * @param urlEncodeChildManifest When enabled, MediaPackage URL-encodes the query string for API requests for LL-HLS child manifests to comply with AWS Signature Version 4 (SigV4) signature signing protocol.
             *                               For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_sigv.html">AWS Signature Version 4 for API requests</a> in <em>AWS Identity and Access Management User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder urlEncodeChildManifest(java.lang.Boolean urlEncodeChildManifest) {
                this.urlEncodeChildManifest = urlEncodeChildManifest;
                return this;
            }

            /**
             * Sets the value of {@link LowLatencyHlsManifestConfigurationProperty#getUrlEncodeChildManifest}
             * @param urlEncodeChildManifest When enabled, MediaPackage URL-encodes the query string for API requests for LL-HLS child manifests to comply with AWS Signature Version 4 (SigV4) signature signing protocol.
             *                               For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_sigv.html">AWS Signature Version 4 for API requests</a> in <em>AWS Identity and Access Management User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder urlEncodeChildManifest(software.amazon.awscdk.IResolvable urlEncodeChildManifest) {
                this.urlEncodeChildManifest = urlEncodeChildManifest;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LowLatencyHlsManifestConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LowLatencyHlsManifestConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LowLatencyHlsManifestConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LowLatencyHlsManifestConfigurationProperty {
            private final java.lang.String manifestName;
            private final java.lang.String childManifestName;
            private final java.lang.Object filterConfiguration;
            private final java.lang.Number manifestWindowSeconds;
            private final java.lang.Number programDateTimeIntervalSeconds;
            private final java.lang.Object scteHls;
            private final java.lang.Object startTag;
            private final java.lang.String url;
            private final java.lang.Object urlEncodeChildManifest;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.manifestName = software.amazon.jsii.Kernel.get(this, "manifestName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.childManifestName = software.amazon.jsii.Kernel.get(this, "childManifestName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.filterConfiguration = software.amazon.jsii.Kernel.get(this, "filterConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.manifestWindowSeconds = software.amazon.jsii.Kernel.get(this, "manifestWindowSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.programDateTimeIntervalSeconds = software.amazon.jsii.Kernel.get(this, "programDateTimeIntervalSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.scteHls = software.amazon.jsii.Kernel.get(this, "scteHls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.startTag = software.amazon.jsii.Kernel.get(this, "startTag", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.urlEncodeChildManifest = software.amazon.jsii.Kernel.get(this, "urlEncodeChildManifest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.manifestName = java.util.Objects.requireNonNull(builder.manifestName, "manifestName is required");
                this.childManifestName = builder.childManifestName;
                this.filterConfiguration = builder.filterConfiguration;
                this.manifestWindowSeconds = builder.manifestWindowSeconds;
                this.programDateTimeIntervalSeconds = builder.programDateTimeIntervalSeconds;
                this.scteHls = builder.scteHls;
                this.startTag = builder.startTag;
                this.url = builder.url;
                this.urlEncodeChildManifest = builder.urlEncodeChildManifest;
            }

            @Override
            public final java.lang.String getManifestName() {
                return this.manifestName;
            }

            @Override
            public final java.lang.String getChildManifestName() {
                return this.childManifestName;
            }

            @Override
            public final java.lang.Object getFilterConfiguration() {
                return this.filterConfiguration;
            }

            @Override
            public final java.lang.Number getManifestWindowSeconds() {
                return this.manifestWindowSeconds;
            }

            @Override
            public final java.lang.Number getProgramDateTimeIntervalSeconds() {
                return this.programDateTimeIntervalSeconds;
            }

            @Override
            public final java.lang.Object getScteHls() {
                return this.scteHls;
            }

            @Override
            public final java.lang.Object getStartTag() {
                return this.startTag;
            }

            @Override
            public final java.lang.String getUrl() {
                return this.url;
            }

            @Override
            public final java.lang.Object getUrlEncodeChildManifest() {
                return this.urlEncodeChildManifest;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("manifestName", om.valueToTree(this.getManifestName()));
                if (this.getChildManifestName() != null) {
                    data.set("childManifestName", om.valueToTree(this.getChildManifestName()));
                }
                if (this.getFilterConfiguration() != null) {
                    data.set("filterConfiguration", om.valueToTree(this.getFilterConfiguration()));
                }
                if (this.getManifestWindowSeconds() != null) {
                    data.set("manifestWindowSeconds", om.valueToTree(this.getManifestWindowSeconds()));
                }
                if (this.getProgramDateTimeIntervalSeconds() != null) {
                    data.set("programDateTimeIntervalSeconds", om.valueToTree(this.getProgramDateTimeIntervalSeconds()));
                }
                if (this.getScteHls() != null) {
                    data.set("scteHls", om.valueToTree(this.getScteHls()));
                }
                if (this.getStartTag() != null) {
                    data.set("startTag", om.valueToTree(this.getStartTag()));
                }
                if (this.getUrl() != null) {
                    data.set("url", om.valueToTree(this.getUrl()));
                }
                if (this.getUrlEncodeChildManifest() != null) {
                    data.set("urlEncodeChildManifest", om.valueToTree(this.getUrlEncodeChildManifest()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.LowLatencyHlsManifestConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LowLatencyHlsManifestConfigurationProperty.Jsii$Proxy that = (LowLatencyHlsManifestConfigurationProperty.Jsii$Proxy) o;

                if (!manifestName.equals(that.manifestName)) return false;
                if (this.childManifestName != null ? !this.childManifestName.equals(that.childManifestName) : that.childManifestName != null) return false;
                if (this.filterConfiguration != null ? !this.filterConfiguration.equals(that.filterConfiguration) : that.filterConfiguration != null) return false;
                if (this.manifestWindowSeconds != null ? !this.manifestWindowSeconds.equals(that.manifestWindowSeconds) : that.manifestWindowSeconds != null) return false;
                if (this.programDateTimeIntervalSeconds != null ? !this.programDateTimeIntervalSeconds.equals(that.programDateTimeIntervalSeconds) : that.programDateTimeIntervalSeconds != null) return false;
                if (this.scteHls != null ? !this.scteHls.equals(that.scteHls) : that.scteHls != null) return false;
                if (this.startTag != null ? !this.startTag.equals(that.startTag) : that.startTag != null) return false;
                if (this.url != null ? !this.url.equals(that.url) : that.url != null) return false;
                return this.urlEncodeChildManifest != null ? this.urlEncodeChildManifest.equals(that.urlEncodeChildManifest) : that.urlEncodeChildManifest == null;
            }

            @Override
            public final int hashCode() {
                int result = this.manifestName.hashCode();
                result = 31 * result + (this.childManifestName != null ? this.childManifestName.hashCode() : 0);
                result = 31 * result + (this.filterConfiguration != null ? this.filterConfiguration.hashCode() : 0);
                result = 31 * result + (this.manifestWindowSeconds != null ? this.manifestWindowSeconds.hashCode() : 0);
                result = 31 * result + (this.programDateTimeIntervalSeconds != null ? this.programDateTimeIntervalSeconds.hashCode() : 0);
                result = 31 * result + (this.scteHls != null ? this.scteHls.hashCode() : 0);
                result = 31 * result + (this.startTag != null ? this.startTag.hashCode() : 0);
                result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
                result = 31 * result + (this.urlEncodeChildManifest != null ? this.urlEncodeChildManifest.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <p>Configuration details for a Microsoft Smooth Streaming (MSS) manifest associated with an origin endpoint.
     * <p>
     * This includes all the settings and properties that define how the MSS content is packaged and delivered.</p>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackagev2.*;
     * MssManifestConfigurationProperty mssManifestConfigurationProperty = MssManifestConfigurationProperty.builder()
     *         .manifestName("manifestName")
     *         // the properties below are optional
     *         .filterConfiguration(FilterConfigurationProperty.builder()
     *                 .clipStartTime("clipStartTime")
     *                 .end("end")
     *                 .manifestFilter("manifestFilter")
     *                 .start("start")
     *                 .timeDelaySeconds(123)
     *                 .build())
     *         .manifestLayout("manifestLayout")
     *         .manifestWindowSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-mssmanifestconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-mssmanifestconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.MssManifestConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MssManifestConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MssManifestConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * <p>The name of the MSS manifest.
         * <p>
         * This name is appended to the origin endpoint URL to create the unique path for accessing this specific MSS manifest.</p>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-mssmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-mssmanifestconfiguration-manifestname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-mssmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-mssmanifestconfiguration-manifestname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getManifestName();

        /**
         * <p>Filter configuration includes settings for manifest filtering, start and end times, and time delay that apply to all of your egress requests for this manifest.
         * <p>
         * </p>
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.FilterConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-mssmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-mssmanifestconfiguration-filterconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-mssmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-mssmanifestconfiguration-filterconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilterConfiguration() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-mssmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-mssmanifestconfiguration-manifestlayout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-mssmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-mssmanifestconfiguration-manifestlayout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getManifestLayout() {
            return null;
        }

        /**
         * <p>The duration (in seconds) of the manifest window.
         * <p>
         * This represents the total amount of content available in the manifest at any given time.</p>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-mssmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-mssmanifestconfiguration-manifestwindowseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-mssmanifestconfiguration.html#cfn-mediapackagev2-originendpoint-mssmanifestconfiguration-manifestwindowseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getManifestWindowSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MssManifestConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MssManifestConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MssManifestConfigurationProperty> {
            java.lang.String manifestName;
            java.lang.Object filterConfiguration;
            java.lang.String manifestLayout;
            java.lang.Number manifestWindowSeconds;

            /**
             * Sets the value of {@link MssManifestConfigurationProperty#getManifestName}
             * @param manifestName <p>The name of the MSS manifest. This parameter is required.
             *                     This name is appended to the origin endpoint URL to create the unique path for accessing this specific MSS manifest.</p>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifestName(java.lang.String manifestName) {
                this.manifestName = manifestName;
                return this;
            }

            /**
             * Sets the value of {@link MssManifestConfigurationProperty#getFilterConfiguration}
             * @param filterConfiguration <p>Filter configuration includes settings for manifest filtering, start and end times, and time delay that apply to all of your egress requests for this manifest.
             *                            </p>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterConfiguration(software.amazon.awscdk.IResolvable filterConfiguration) {
                this.filterConfiguration = filterConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MssManifestConfigurationProperty#getFilterConfiguration}
             * @param filterConfiguration <p>Filter configuration includes settings for manifest filtering, start and end times, and time delay that apply to all of your egress requests for this manifest.
             *                            </p>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterConfiguration(software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.FilterConfigurationProperty filterConfiguration) {
                this.filterConfiguration = filterConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MssManifestConfigurationProperty#getManifestLayout}
             * @param manifestLayout the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifestLayout(java.lang.String manifestLayout) {
                this.manifestLayout = manifestLayout;
                return this;
            }

            /**
             * Sets the value of {@link MssManifestConfigurationProperty#getManifestWindowSeconds}
             * @param manifestWindowSeconds <p>The duration (in seconds) of the manifest window.
             *                              This represents the total amount of content available in the manifest at any given time.</p>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifestWindowSeconds(java.lang.Number manifestWindowSeconds) {
                this.manifestWindowSeconds = manifestWindowSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MssManifestConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MssManifestConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MssManifestConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MssManifestConfigurationProperty {
            private final java.lang.String manifestName;
            private final java.lang.Object filterConfiguration;
            private final java.lang.String manifestLayout;
            private final java.lang.Number manifestWindowSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.manifestName = software.amazon.jsii.Kernel.get(this, "manifestName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.filterConfiguration = software.amazon.jsii.Kernel.get(this, "filterConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.manifestLayout = software.amazon.jsii.Kernel.get(this, "manifestLayout", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.manifestWindowSeconds = software.amazon.jsii.Kernel.get(this, "manifestWindowSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.manifestName = java.util.Objects.requireNonNull(builder.manifestName, "manifestName is required");
                this.filterConfiguration = builder.filterConfiguration;
                this.manifestLayout = builder.manifestLayout;
                this.manifestWindowSeconds = builder.manifestWindowSeconds;
            }

            @Override
            public final java.lang.String getManifestName() {
                return this.manifestName;
            }

            @Override
            public final java.lang.Object getFilterConfiguration() {
                return this.filterConfiguration;
            }

            @Override
            public final java.lang.String getManifestLayout() {
                return this.manifestLayout;
            }

            @Override
            public final java.lang.Number getManifestWindowSeconds() {
                return this.manifestWindowSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("manifestName", om.valueToTree(this.getManifestName()));
                if (this.getFilterConfiguration() != null) {
                    data.set("filterConfiguration", om.valueToTree(this.getFilterConfiguration()));
                }
                if (this.getManifestLayout() != null) {
                    data.set("manifestLayout", om.valueToTree(this.getManifestLayout()));
                }
                if (this.getManifestWindowSeconds() != null) {
                    data.set("manifestWindowSeconds", om.valueToTree(this.getManifestWindowSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.MssManifestConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MssManifestConfigurationProperty.Jsii$Proxy that = (MssManifestConfigurationProperty.Jsii$Proxy) o;

                if (!manifestName.equals(that.manifestName)) return false;
                if (this.filterConfiguration != null ? !this.filterConfiguration.equals(that.filterConfiguration) : that.filterConfiguration != null) return false;
                if (this.manifestLayout != null ? !this.manifestLayout.equals(that.manifestLayout) : that.manifestLayout != null) return false;
                return this.manifestWindowSeconds != null ? this.manifestWindowSeconds.equals(that.manifestWindowSeconds) : that.manifestWindowSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.manifestName.hashCode();
                result = 31 * result + (this.filterConfiguration != null ? this.filterConfiguration.hashCode() : 0);
                result = 31 * result + (this.manifestLayout != null ? this.manifestLayout.hashCode() : 0);
                result = 31 * result + (this.manifestWindowSeconds != null ? this.manifestWindowSeconds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The SCTE configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackagev2.*;
     * ScteDashProperty scteDashProperty = ScteDashProperty.builder()
     *         .adMarkerDash("adMarkerDash")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-sctedash.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-sctedash.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.ScteDashProperty")
    @software.amazon.jsii.Jsii.Proxy(ScteDashProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScteDashProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Choose how ad markers are included in the packaged content.
         * <p>
         * If you include ad markers in the content stream in your upstream encoders, then you need to inform MediaPackage what to do with the ad markers in the output.
         * <p>
         * Value description:
         * <p>
         * <ul>
         * <li><code>Binary</code> - The SCTE-35 marker is expressed as a hex-string (Base64 string) rather than full XML.</li>
         * <li><code>XML</code> - The SCTE marker is expressed fully in XML.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-sctedash.html#cfn-mediapackagev2-originendpoint-sctedash-admarkerdash">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-sctedash.html#cfn-mediapackagev2-originendpoint-sctedash-admarkerdash</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdMarkerDash() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScteDashProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScteDashProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScteDashProperty> {
            java.lang.String adMarkerDash;

            /**
             * Sets the value of {@link ScteDashProperty#getAdMarkerDash}
             * @param adMarkerDash Choose how ad markers are included in the packaged content.
             *                     If you include ad markers in the content stream in your upstream encoders, then you need to inform MediaPackage what to do with the ad markers in the output.
             *                     <p>
             *                     Value description:
             *                     <p>
             *                     <ul>
             *                     <li><code>Binary</code> - The SCTE-35 marker is expressed as a hex-string (Base64 string) rather than full XML.</li>
             *                     <li><code>XML</code> - The SCTE marker is expressed fully in XML.</li>
             *                     </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adMarkerDash(java.lang.String adMarkerDash) {
                this.adMarkerDash = adMarkerDash;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScteDashProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScteDashProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScteDashProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScteDashProperty {
            private final java.lang.String adMarkerDash;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.adMarkerDash = software.amazon.jsii.Kernel.get(this, "adMarkerDash", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.adMarkerDash = builder.adMarkerDash;
            }

            @Override
            public final java.lang.String getAdMarkerDash() {
                return this.adMarkerDash;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdMarkerDash() != null) {
                    data.set("adMarkerDash", om.valueToTree(this.getAdMarkerDash()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.ScteDashProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScteDashProperty.Jsii$Proxy that = (ScteDashProperty.Jsii$Proxy) o;

                return this.adMarkerDash != null ? this.adMarkerDash.equals(that.adMarkerDash) : that.adMarkerDash == null;
            }

            @Override
            public final int hashCode() {
                int result = this.adMarkerDash != null ? this.adMarkerDash.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The SCTE-35 HLS configuration associated with the origin endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackagev2.*;
     * ScteHlsProperty scteHlsProperty = ScteHlsProperty.builder()
     *         .adMarkerHls("adMarkerHls")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-sctehls.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-sctehls.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.ScteHlsProperty")
    @software.amazon.jsii.Jsii.Proxy(ScteHlsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScteHlsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The SCTE-35 HLS ad-marker configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-sctehls.html#cfn-mediapackagev2-originendpoint-sctehls-admarkerhls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-sctehls.html#cfn-mediapackagev2-originendpoint-sctehls-admarkerhls</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdMarkerHls() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScteHlsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScteHlsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScteHlsProperty> {
            java.lang.String adMarkerHls;

            /**
             * Sets the value of {@link ScteHlsProperty#getAdMarkerHls}
             * @param adMarkerHls The SCTE-35 HLS ad-marker configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adMarkerHls(java.lang.String adMarkerHls) {
                this.adMarkerHls = adMarkerHls;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScteHlsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScteHlsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScteHlsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScteHlsProperty {
            private final java.lang.String adMarkerHls;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.adMarkerHls = software.amazon.jsii.Kernel.get(this, "adMarkerHls", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.adMarkerHls = builder.adMarkerHls;
            }

            @Override
            public final java.lang.String getAdMarkerHls() {
                return this.adMarkerHls;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdMarkerHls() != null) {
                    data.set("adMarkerHls", om.valueToTree(this.getAdMarkerHls()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.ScteHlsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScteHlsProperty.Jsii$Proxy that = (ScteHlsProperty.Jsii$Proxy) o;

                return this.adMarkerHls != null ? this.adMarkerHls.equals(that.adMarkerHls) : that.adMarkerHls == null;
            }

            @Override
            public final int hashCode() {
                int result = this.adMarkerHls != null ? this.adMarkerHls.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The SCTE-35 configuration associated with the origin endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackagev2.*;
     * ScteProperty scteProperty = ScteProperty.builder()
     *         .scteFilter(List.of("scteFilter"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-scte.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-scte.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.ScteProperty")
    @software.amazon.jsii.Jsii.Proxy(ScteProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScteProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The filter associated with the SCTE-35 configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-scte.html#cfn-mediapackagev2-originendpoint-scte-sctefilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-scte.html#cfn-mediapackagev2-originendpoint-scte-sctefilter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getScteFilter() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScteProperty> {
            java.util.List<java.lang.String> scteFilter;

            /**
             * Sets the value of {@link ScteProperty#getScteFilter}
             * @param scteFilter The filter associated with the SCTE-35 configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scteFilter(java.util.List<java.lang.String> scteFilter) {
                this.scteFilter = scteFilter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScteProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScteProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScteProperty {
            private final java.util.List<java.lang.String> scteFilter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.scteFilter = software.amazon.jsii.Kernel.get(this, "scteFilter", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.scteFilter = builder.scteFilter;
            }

            @Override
            public final java.util.List<java.lang.String> getScteFilter() {
                return this.scteFilter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getScteFilter() != null) {
                    data.set("scteFilter", om.valueToTree(this.getScteFilter()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.ScteProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScteProperty.Jsii$Proxy that = (ScteProperty.Jsii$Proxy) o;

                return this.scteFilter != null ? this.scteFilter.equals(that.scteFilter) : that.scteFilter == null;
            }

            @Override
            public final int hashCode() {
                int result = this.scteFilter != null ? this.scteFilter.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The segment configuration, including the segment name, duration, and other configuration values.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackagev2.*;
     * SegmentProperty segmentProperty = SegmentProperty.builder()
     *         .encryption(EncryptionProperty.builder()
     *                 .encryptionMethod(EncryptionMethodProperty.builder()
     *                         .cmafEncryptionMethod("cmafEncryptionMethod")
     *                         .ismEncryptionMethod("ismEncryptionMethod")
     *                         .tsEncryptionMethod("tsEncryptionMethod")
     *                         .build())
     *                 .spekeKeyProvider(SpekeKeyProviderProperty.builder()
     *                         .drmSystems(List.of("drmSystems"))
     *                         .encryptionContractConfiguration(EncryptionContractConfigurationProperty.builder()
     *                                 .presetSpeke20Audio("presetSpeke20Audio")
     *                                 .presetSpeke20Video("presetSpeke20Video")
     *                                 .build())
     *                         .resourceId("resourceId")
     *                         .roleArn("roleArn")
     *                         .url("url")
     *                         .build())
     *                 // the properties below are optional
     *                 .cmafExcludeSegmentDrmMetadata(false)
     *                 .constantInitializationVector("constantInitializationVector")
     *                 .keyRotationIntervalSeconds(123)
     *                 .build())
     *         .includeIframeOnlyStreams(false)
     *         .scte(ScteProperty.builder()
     *                 .scteFilter(List.of("scteFilter"))
     *                 .build())
     *         .segmentDurationSeconds(123)
     *         .segmentName("segmentName")
     *         .tsIncludeDvbSubtitles(false)
     *         .tsUseAudioRenditionGroup(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-segment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-segment.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.SegmentProperty")
    @software.amazon.jsii.Jsii.Proxy(SegmentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SegmentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether to use encryption for the segment.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.EncryptionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-segment.html#cfn-mediapackagev2-originendpoint-segment-encryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-segment.html#cfn-mediapackagev2-originendpoint-segment-encryption</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryption() {
            return null;
        }

        /**
         * Whether the segment includes I-frame-only streams.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-segment.html#cfn-mediapackagev2-originendpoint-segment-includeiframeonlystreams">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-segment.html#cfn-mediapackagev2-originendpoint-segment-includeiframeonlystreams</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeIframeOnlyStreams() {
            return null;
        }

        /**
         * The SCTE-35 configuration associated with the segment.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.ScteProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-segment.html#cfn-mediapackagev2-originendpoint-segment-scte">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-segment.html#cfn-mediapackagev2-originendpoint-segment-scte</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScte() {
            return null;
        }

        /**
         * The duration of the segment, in seconds.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-segment.html#cfn-mediapackagev2-originendpoint-segment-segmentdurationseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-segment.html#cfn-mediapackagev2-originendpoint-segment-segmentdurationseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSegmentDurationSeconds() {
            return null;
        }

        /**
         * The name of the segment associated with the origin endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-segment.html#cfn-mediapackagev2-originendpoint-segment-segmentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-segment.html#cfn-mediapackagev2-originendpoint-segment-segmentname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSegmentName() {
            return null;
        }

        /**
         * Whether the segment includes DVB subtitles.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-segment.html#cfn-mediapackagev2-originendpoint-segment-tsincludedvbsubtitles">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-segment.html#cfn-mediapackagev2-originendpoint-segment-tsincludedvbsubtitles</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTsIncludeDvbSubtitles() {
            return null;
        }

        /**
         * Whether the segment is an audio rendition group.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-segment.html#cfn-mediapackagev2-originendpoint-segment-tsuseaudiorenditiongroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-segment.html#cfn-mediapackagev2-originendpoint-segment-tsuseaudiorenditiongroup</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTsUseAudioRenditionGroup() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SegmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SegmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SegmentProperty> {
            java.lang.Object encryption;
            java.lang.Object includeIframeOnlyStreams;
            java.lang.Object scte;
            java.lang.Number segmentDurationSeconds;
            java.lang.String segmentName;
            java.lang.Object tsIncludeDvbSubtitles;
            java.lang.Object tsUseAudioRenditionGroup;

            /**
             * Sets the value of {@link SegmentProperty#getEncryption}
             * @param encryption Whether to use encryption for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryption(software.amazon.awscdk.IResolvable encryption) {
                this.encryption = encryption;
                return this;
            }

            /**
             * Sets the value of {@link SegmentProperty#getEncryption}
             * @param encryption Whether to use encryption for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryption(software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.EncryptionProperty encryption) {
                this.encryption = encryption;
                return this;
            }

            /**
             * Sets the value of {@link SegmentProperty#getIncludeIframeOnlyStreams}
             * @param includeIframeOnlyStreams Whether the segment includes I-frame-only streams.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeIframeOnlyStreams(java.lang.Boolean includeIframeOnlyStreams) {
                this.includeIframeOnlyStreams = includeIframeOnlyStreams;
                return this;
            }

            /**
             * Sets the value of {@link SegmentProperty#getIncludeIframeOnlyStreams}
             * @param includeIframeOnlyStreams Whether the segment includes I-frame-only streams.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeIframeOnlyStreams(software.amazon.awscdk.IResolvable includeIframeOnlyStreams) {
                this.includeIframeOnlyStreams = includeIframeOnlyStreams;
                return this;
            }

            /**
             * Sets the value of {@link SegmentProperty#getScte}
             * @param scte The SCTE-35 configuration associated with the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte(software.amazon.awscdk.IResolvable scte) {
                this.scte = scte;
                return this;
            }

            /**
             * Sets the value of {@link SegmentProperty#getScte}
             * @param scte The SCTE-35 configuration associated with the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte(software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.ScteProperty scte) {
                this.scte = scte;
                return this;
            }

            /**
             * Sets the value of {@link SegmentProperty#getSegmentDurationSeconds}
             * @param segmentDurationSeconds The duration of the segment, in seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder segmentDurationSeconds(java.lang.Number segmentDurationSeconds) {
                this.segmentDurationSeconds = segmentDurationSeconds;
                return this;
            }

            /**
             * Sets the value of {@link SegmentProperty#getSegmentName}
             * @param segmentName The name of the segment associated with the origin endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder segmentName(java.lang.String segmentName) {
                this.segmentName = segmentName;
                return this;
            }

            /**
             * Sets the value of {@link SegmentProperty#getTsIncludeDvbSubtitles}
             * @param tsIncludeDvbSubtitles Whether the segment includes DVB subtitles.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tsIncludeDvbSubtitles(java.lang.Boolean tsIncludeDvbSubtitles) {
                this.tsIncludeDvbSubtitles = tsIncludeDvbSubtitles;
                return this;
            }

            /**
             * Sets the value of {@link SegmentProperty#getTsIncludeDvbSubtitles}
             * @param tsIncludeDvbSubtitles Whether the segment includes DVB subtitles.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tsIncludeDvbSubtitles(software.amazon.awscdk.IResolvable tsIncludeDvbSubtitles) {
                this.tsIncludeDvbSubtitles = tsIncludeDvbSubtitles;
                return this;
            }

            /**
             * Sets the value of {@link SegmentProperty#getTsUseAudioRenditionGroup}
             * @param tsUseAudioRenditionGroup Whether the segment is an audio rendition group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tsUseAudioRenditionGroup(java.lang.Boolean tsUseAudioRenditionGroup) {
                this.tsUseAudioRenditionGroup = tsUseAudioRenditionGroup;
                return this;
            }

            /**
             * Sets the value of {@link SegmentProperty#getTsUseAudioRenditionGroup}
             * @param tsUseAudioRenditionGroup Whether the segment is an audio rendition group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tsUseAudioRenditionGroup(software.amazon.awscdk.IResolvable tsUseAudioRenditionGroup) {
                this.tsUseAudioRenditionGroup = tsUseAudioRenditionGroup;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SegmentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SegmentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SegmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SegmentProperty {
            private final java.lang.Object encryption;
            private final java.lang.Object includeIframeOnlyStreams;
            private final java.lang.Object scte;
            private final java.lang.Number segmentDurationSeconds;
            private final java.lang.String segmentName;
            private final java.lang.Object tsIncludeDvbSubtitles;
            private final java.lang.Object tsUseAudioRenditionGroup;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encryption = software.amazon.jsii.Kernel.get(this, "encryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeIframeOnlyStreams = software.amazon.jsii.Kernel.get(this, "includeIframeOnlyStreams", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scte = software.amazon.jsii.Kernel.get(this, "scte", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.segmentDurationSeconds = software.amazon.jsii.Kernel.get(this, "segmentDurationSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.segmentName = software.amazon.jsii.Kernel.get(this, "segmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tsIncludeDvbSubtitles = software.amazon.jsii.Kernel.get(this, "tsIncludeDvbSubtitles", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tsUseAudioRenditionGroup = software.amazon.jsii.Kernel.get(this, "tsUseAudioRenditionGroup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encryption = builder.encryption;
                this.includeIframeOnlyStreams = builder.includeIframeOnlyStreams;
                this.scte = builder.scte;
                this.segmentDurationSeconds = builder.segmentDurationSeconds;
                this.segmentName = builder.segmentName;
                this.tsIncludeDvbSubtitles = builder.tsIncludeDvbSubtitles;
                this.tsUseAudioRenditionGroup = builder.tsUseAudioRenditionGroup;
            }

            @Override
            public final java.lang.Object getEncryption() {
                return this.encryption;
            }

            @Override
            public final java.lang.Object getIncludeIframeOnlyStreams() {
                return this.includeIframeOnlyStreams;
            }

            @Override
            public final java.lang.Object getScte() {
                return this.scte;
            }

            @Override
            public final java.lang.Number getSegmentDurationSeconds() {
                return this.segmentDurationSeconds;
            }

            @Override
            public final java.lang.String getSegmentName() {
                return this.segmentName;
            }

            @Override
            public final java.lang.Object getTsIncludeDvbSubtitles() {
                return this.tsIncludeDvbSubtitles;
            }

            @Override
            public final java.lang.Object getTsUseAudioRenditionGroup() {
                return this.tsUseAudioRenditionGroup;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEncryption() != null) {
                    data.set("encryption", om.valueToTree(this.getEncryption()));
                }
                if (this.getIncludeIframeOnlyStreams() != null) {
                    data.set("includeIframeOnlyStreams", om.valueToTree(this.getIncludeIframeOnlyStreams()));
                }
                if (this.getScte() != null) {
                    data.set("scte", om.valueToTree(this.getScte()));
                }
                if (this.getSegmentDurationSeconds() != null) {
                    data.set("segmentDurationSeconds", om.valueToTree(this.getSegmentDurationSeconds()));
                }
                if (this.getSegmentName() != null) {
                    data.set("segmentName", om.valueToTree(this.getSegmentName()));
                }
                if (this.getTsIncludeDvbSubtitles() != null) {
                    data.set("tsIncludeDvbSubtitles", om.valueToTree(this.getTsIncludeDvbSubtitles()));
                }
                if (this.getTsUseAudioRenditionGroup() != null) {
                    data.set("tsUseAudioRenditionGroup", om.valueToTree(this.getTsUseAudioRenditionGroup()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.SegmentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SegmentProperty.Jsii$Proxy that = (SegmentProperty.Jsii$Proxy) o;

                if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
                if (this.includeIframeOnlyStreams != null ? !this.includeIframeOnlyStreams.equals(that.includeIframeOnlyStreams) : that.includeIframeOnlyStreams != null) return false;
                if (this.scte != null ? !this.scte.equals(that.scte) : that.scte != null) return false;
                if (this.segmentDurationSeconds != null ? !this.segmentDurationSeconds.equals(that.segmentDurationSeconds) : that.segmentDurationSeconds != null) return false;
                if (this.segmentName != null ? !this.segmentName.equals(that.segmentName) : that.segmentName != null) return false;
                if (this.tsIncludeDvbSubtitles != null ? !this.tsIncludeDvbSubtitles.equals(that.tsIncludeDvbSubtitles) : that.tsIncludeDvbSubtitles != null) return false;
                return this.tsUseAudioRenditionGroup != null ? this.tsUseAudioRenditionGroup.equals(that.tsUseAudioRenditionGroup) : that.tsUseAudioRenditionGroup == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encryption != null ? this.encryption.hashCode() : 0;
                result = 31 * result + (this.includeIframeOnlyStreams != null ? this.includeIframeOnlyStreams.hashCode() : 0);
                result = 31 * result + (this.scte != null ? this.scte.hashCode() : 0);
                result = 31 * result + (this.segmentDurationSeconds != null ? this.segmentDurationSeconds.hashCode() : 0);
                result = 31 * result + (this.segmentName != null ? this.segmentName.hashCode() : 0);
                result = 31 * result + (this.tsIncludeDvbSubtitles != null ? this.tsIncludeDvbSubtitles.hashCode() : 0);
                result = 31 * result + (this.tsUseAudioRenditionGroup != null ? this.tsUseAudioRenditionGroup.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameters for the SPEKE key provider.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackagev2.*;
     * SpekeKeyProviderProperty spekeKeyProviderProperty = SpekeKeyProviderProperty.builder()
     *         .drmSystems(List.of("drmSystems"))
     *         .encryptionContractConfiguration(EncryptionContractConfigurationProperty.builder()
     *                 .presetSpeke20Audio("presetSpeke20Audio")
     *                 .presetSpeke20Video("presetSpeke20Video")
     *                 .build())
     *         .resourceId("resourceId")
     *         .roleArn("roleArn")
     *         .url("url")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-spekekeyprovider.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-spekekeyprovider.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.SpekeKeyProviderProperty")
    @software.amazon.jsii.Jsii.Proxy(SpekeKeyProviderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpekeKeyProviderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The DRM solution provider you're using to protect your content during distribution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-spekekeyprovider.html#cfn-mediapackagev2-originendpoint-spekekeyprovider-drmsystems">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-spekekeyprovider.html#cfn-mediapackagev2-originendpoint-spekekeyprovider-drmsystems</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getDrmSystems();

        /**
         * The encryption contract configuration associated with the SPEKE key provider.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.EncryptionContractConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-spekekeyprovider.html#cfn-mediapackagev2-originendpoint-spekekeyprovider-encryptioncontractconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-spekekeyprovider.html#cfn-mediapackagev2-originendpoint-spekekeyprovider-encryptioncontractconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEncryptionContractConfiguration();

        /**
         * The unique identifier for the content.
         * <p>
         * The service sends this identifier to the key server to identify the current endpoint. How unique you make this identifier depends on how fine-grained you want access controls to be. The service does not permit you to use the same ID for two simultaneous encryption processes. The resource ID is also known as the content ID.
         * <p>
         * The following example shows a resource ID: <code>MovieNight20171126093045</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-spekekeyprovider.html#cfn-mediapackagev2-originendpoint-spekekeyprovider-resourceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-spekekeyprovider.html#cfn-mediapackagev2-originendpoint-spekekeyprovider-resourceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceId();

        /**
         * The ARN for the IAM role granted by the key provider that provides access to the key provider API.
         * <p>
         * This role must have a trust policy that allows MediaPackage to assume the role, and it must have a sufficient permissions policy to allow access to the specific key retrieval URL. Get this from your DRM solution provider.
         * <p>
         * Valid format: <code>arn:aws:iam::{accountID}:role/{name}</code> . The following example shows a role ARN: <code>arn:aws:iam::444455556666:role/SpekeAccess</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-spekekeyprovider.html#cfn-mediapackagev2-originendpoint-spekekeyprovider-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-spekekeyprovider.html#cfn-mediapackagev2-originendpoint-spekekeyprovider-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The URL of the SPEKE key provider.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-spekekeyprovider.html#cfn-mediapackagev2-originendpoint-spekekeyprovider-url">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-spekekeyprovider.html#cfn-mediapackagev2-originendpoint-spekekeyprovider-url</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUrl();

        /**
         * @return a {@link Builder} of {@link SpekeKeyProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpekeKeyProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpekeKeyProviderProperty> {
            java.util.List<java.lang.String> drmSystems;
            java.lang.Object encryptionContractConfiguration;
            java.lang.String resourceId;
            java.lang.String roleArn;
            java.lang.String url;

            /**
             * Sets the value of {@link SpekeKeyProviderProperty#getDrmSystems}
             * @param drmSystems The DRM solution provider you're using to protect your content during distribution. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder drmSystems(java.util.List<java.lang.String> drmSystems) {
                this.drmSystems = drmSystems;
                return this;
            }

            /**
             * Sets the value of {@link SpekeKeyProviderProperty#getEncryptionContractConfiguration}
             * @param encryptionContractConfiguration The encryption contract configuration associated with the SPEKE key provider. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionContractConfiguration(software.amazon.awscdk.IResolvable encryptionContractConfiguration) {
                this.encryptionContractConfiguration = encryptionContractConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SpekeKeyProviderProperty#getEncryptionContractConfiguration}
             * @param encryptionContractConfiguration The encryption contract configuration associated with the SPEKE key provider. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionContractConfiguration(software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.EncryptionContractConfigurationProperty encryptionContractConfiguration) {
                this.encryptionContractConfiguration = encryptionContractConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SpekeKeyProviderProperty#getResourceId}
             * @param resourceId The unique identifier for the content. This parameter is required.
             *                   The service sends this identifier to the key server to identify the current endpoint. How unique you make this identifier depends on how fine-grained you want access controls to be. The service does not permit you to use the same ID for two simultaneous encryption processes. The resource ID is also known as the content ID.
             *                   <p>
             *                   The following example shows a resource ID: <code>MovieNight20171126093045</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceId(java.lang.String resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            /**
             * Sets the value of {@link SpekeKeyProviderProperty#getRoleArn}
             * @param roleArn The ARN for the IAM role granted by the key provider that provides access to the key provider API. This parameter is required.
             *                This role must have a trust policy that allows MediaPackage to assume the role, and it must have a sufficient permissions policy to allow access to the specific key retrieval URL. Get this from your DRM solution provider.
             *                <p>
             *                Valid format: <code>arn:aws:iam::{accountID}:role/{name}</code> . The following example shows a role ARN: <code>arn:aws:iam::444455556666:role/SpekeAccess</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link SpekeKeyProviderProperty#getUrl}
             * @param url The URL of the SPEKE key provider. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(java.lang.String url) {
                this.url = url;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpekeKeyProviderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpekeKeyProviderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SpekeKeyProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpekeKeyProviderProperty {
            private final java.util.List<java.lang.String> drmSystems;
            private final java.lang.Object encryptionContractConfiguration;
            private final java.lang.String resourceId;
            private final java.lang.String roleArn;
            private final java.lang.String url;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.drmSystems = software.amazon.jsii.Kernel.get(this, "drmSystems", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.encryptionContractConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionContractConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceId = software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.drmSystems = java.util.Objects.requireNonNull(builder.drmSystems, "drmSystems is required");
                this.encryptionContractConfiguration = java.util.Objects.requireNonNull(builder.encryptionContractConfiguration, "encryptionContractConfiguration is required");
                this.resourceId = java.util.Objects.requireNonNull(builder.resourceId, "resourceId is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.url = java.util.Objects.requireNonNull(builder.url, "url is required");
            }

            @Override
            public final java.util.List<java.lang.String> getDrmSystems() {
                return this.drmSystems;
            }

            @Override
            public final java.lang.Object getEncryptionContractConfiguration() {
                return this.encryptionContractConfiguration;
            }

            @Override
            public final java.lang.String getResourceId() {
                return this.resourceId;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getUrl() {
                return this.url;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("drmSystems", om.valueToTree(this.getDrmSystems()));
                data.set("encryptionContractConfiguration", om.valueToTree(this.getEncryptionContractConfiguration()));
                data.set("resourceId", om.valueToTree(this.getResourceId()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("url", om.valueToTree(this.getUrl()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.SpekeKeyProviderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpekeKeyProviderProperty.Jsii$Proxy that = (SpekeKeyProviderProperty.Jsii$Proxy) o;

                if (!drmSystems.equals(that.drmSystems)) return false;
                if (!encryptionContractConfiguration.equals(that.encryptionContractConfiguration)) return false;
                if (!resourceId.equals(that.resourceId)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                return this.url.equals(that.url);
            }

            @Override
            public final int hashCode() {
                int result = this.drmSystems.hashCode();
                result = 31 * result + (this.encryptionContractConfiguration.hashCode());
                result = 31 * result + (this.resourceId.hashCode());
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.url.hashCode());
                return result;
            }
        }
    }
    /**
     * To insert an EXT-X-START tag in your HLS playlist, specify a StartTag configuration object with a valid TimeOffset.
     * <p>
     * When you do, you can also optionally specify whether to include a PRECISE value in the EXT-X-START tag.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackagev2.*;
     * StartTagProperty startTagProperty = StartTagProperty.builder()
     *         .timeOffset(123)
     *         // the properties below are optional
     *         .precise(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-starttag.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-starttag.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.StartTagProperty")
    @software.amazon.jsii.Jsii.Proxy(StartTagProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StartTagProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specify the value for TIME-OFFSET within your EXT-X-START tag.
         * <p>
         * Enter a signed floating point value which, if positive, must be less than the configured manifest duration minus three times the configured segment target duration. If negative, the absolute value must be larger than three times the configured segment target duration, and the absolute value must be smaller than the configured manifest duration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-starttag.html#cfn-mediapackagev2-originendpoint-starttag-timeoffset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-starttag.html#cfn-mediapackagev2-originendpoint-starttag-timeoffset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTimeOffset();

        /**
         * Specify the value for PRECISE within your EXT-X-START tag.
         * <p>
         * Leave blank, or choose false, to use the default value NO. Choose yes to use the value YES.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-starttag.html#cfn-mediapackagev2-originendpoint-starttag-precise">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpoint-starttag.html#cfn-mediapackagev2-originendpoint-starttag-precise</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrecise() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StartTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StartTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StartTagProperty> {
            java.lang.Number timeOffset;
            java.lang.Object precise;

            /**
             * Sets the value of {@link StartTagProperty#getTimeOffset}
             * @param timeOffset Specify the value for TIME-OFFSET within your EXT-X-START tag. This parameter is required.
             *                   Enter a signed floating point value which, if positive, must be less than the configured manifest duration minus three times the configured segment target duration. If negative, the absolute value must be larger than three times the configured segment target duration, and the absolute value must be smaller than the configured manifest duration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeOffset(java.lang.Number timeOffset) {
                this.timeOffset = timeOffset;
                return this;
            }

            /**
             * Sets the value of {@link StartTagProperty#getPrecise}
             * @param precise Specify the value for PRECISE within your EXT-X-START tag.
             *                Leave blank, or choose false, to use the default value NO. Choose yes to use the value YES.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder precise(java.lang.Boolean precise) {
                this.precise = precise;
                return this;
            }

            /**
             * Sets the value of {@link StartTagProperty#getPrecise}
             * @param precise Specify the value for PRECISE within your EXT-X-START tag.
             *                Leave blank, or choose false, to use the default value NO. Choose yes to use the value YES.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder precise(software.amazon.awscdk.IResolvable precise) {
                this.precise = precise;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StartTagProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StartTagProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StartTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StartTagProperty {
            private final java.lang.Number timeOffset;
            private final java.lang.Object precise;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.timeOffset = software.amazon.jsii.Kernel.get(this, "timeOffset", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.precise = software.amazon.jsii.Kernel.get(this, "precise", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.timeOffset = java.util.Objects.requireNonNull(builder.timeOffset, "timeOffset is required");
                this.precise = builder.precise;
            }

            @Override
            public final java.lang.Number getTimeOffset() {
                return this.timeOffset;
            }

            @Override
            public final java.lang.Object getPrecise() {
                return this.precise;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("timeOffset", om.valueToTree(this.getTimeOffset()));
                if (this.getPrecise() != null) {
                    data.set("precise", om.valueToTree(this.getPrecise()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpoint.StartTagProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StartTagProperty.Jsii$Proxy that = (StartTagProperty.Jsii$Proxy) o;

                if (!timeOffset.equals(that.timeOffset)) return false;
                return this.precise != null ? this.precise.equals(that.precise) : that.precise == null;
            }

            @Override
            public final int hashCode() {
                int result = this.timeOffset.hashCode();
                result = 31 * result + (this.precise != null ? this.precise.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpointProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpointProps.Builder();
        }

        /**
         * The name of the channel group associated with the origin endpoint configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-channelgroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-channelgroupname</a>
         * @param channelGroupName The name of the channel group associated with the origin endpoint configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelGroupName(final java.lang.String channelGroupName) {
            this.props.channelGroupName(channelGroupName);
            return this;
        }

        /**
         * The channel name associated with the origin endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-channelname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-channelname</a>
         * @param channelName The channel name associated with the origin endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelName(final java.lang.String channelName) {
            this.props.channelName(channelName);
            return this;
        }

        /**
         * The container type associated with the origin endpoint configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-containertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-containertype</a>
         * @param containerType The container type associated with the origin endpoint configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerType(final java.lang.String containerType) {
            this.props.containerType(containerType);
            return this;
        }

        /**
         * The name of the origin endpoint associated with the origin endpoint configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-originendpointname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-originendpointname</a>
         * @param originEndpointName The name of the origin endpoint associated with the origin endpoint configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originEndpointName(final java.lang.String originEndpointName) {
            this.props.originEndpointName(originEndpointName);
            return this;
        }

        /**
         * A DASH manifest configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-dashmanifests">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-dashmanifests</a>
         * @param dashManifests A DASH manifest configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dashManifests(final software.amazon.awscdk.IResolvable dashManifests) {
            this.props.dashManifests(dashManifests);
            return this;
        }
        /**
         * A DASH manifest configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-dashmanifests">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-dashmanifests</a>
         * @param dashManifests A DASH manifest configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dashManifests(final java.util.List<? extends java.lang.Object> dashManifests) {
            this.props.dashManifests(dashManifests);
            return this;
        }

        /**
         * The description associated with the origin endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-description</a>
         * @param description The description associated with the origin endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The failover settings for the endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-forceendpointerrorconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-forceendpointerrorconfiguration</a>
         * @param forceEndpointErrorConfiguration The failover settings for the endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forceEndpointErrorConfiguration(final software.amazon.awscdk.IResolvable forceEndpointErrorConfiguration) {
            this.props.forceEndpointErrorConfiguration(forceEndpointErrorConfiguration);
            return this;
        }
        /**
         * The failover settings for the endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-forceendpointerrorconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-forceendpointerrorconfiguration</a>
         * @param forceEndpointErrorConfiguration The failover settings for the endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forceEndpointErrorConfiguration(final software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.ForceEndpointErrorConfigurationProperty forceEndpointErrorConfiguration) {
            this.props.forceEndpointErrorConfiguration(forceEndpointErrorConfiguration);
            return this;
        }

        /**
         * The HLS manifests associated with the origin endpoint configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-hlsmanifests">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-hlsmanifests</a>
         * @param hlsManifests The HLS manifests associated with the origin endpoint configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hlsManifests(final software.amazon.awscdk.IResolvable hlsManifests) {
            this.props.hlsManifests(hlsManifests);
            return this;
        }
        /**
         * The HLS manifests associated with the origin endpoint configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-hlsmanifests">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-hlsmanifests</a>
         * @param hlsManifests The HLS manifests associated with the origin endpoint configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hlsManifests(final java.util.List<? extends java.lang.Object> hlsManifests) {
            this.props.hlsManifests(hlsManifests);
            return this;
        }

        /**
         * The low-latency HLS (LL-HLS) manifests associated with the origin endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-lowlatencyhlsmanifests">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-lowlatencyhlsmanifests</a>
         * @param lowLatencyHlsManifests The low-latency HLS (LL-HLS) manifests associated with the origin endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lowLatencyHlsManifests(final software.amazon.awscdk.IResolvable lowLatencyHlsManifests) {
            this.props.lowLatencyHlsManifests(lowLatencyHlsManifests);
            return this;
        }
        /**
         * The low-latency HLS (LL-HLS) manifests associated with the origin endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-lowlatencyhlsmanifests">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-lowlatencyhlsmanifests</a>
         * @param lowLatencyHlsManifests The low-latency HLS (LL-HLS) manifests associated with the origin endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lowLatencyHlsManifests(final java.util.List<? extends java.lang.Object> lowLatencyHlsManifests) {
            this.props.lowLatencyHlsManifests(lowLatencyHlsManifests);
            return this;
        }

        /**
         * A list of Microsoft Smooth Streaming (MSS) manifest configurations associated with the origin endpoint.
         * <p>
         * Each configuration represents a different MSS streaming option available from this endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-mssmanifests">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-mssmanifests</a>
         * @param mssManifests A list of Microsoft Smooth Streaming (MSS) manifest configurations associated with the origin endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mssManifests(final software.amazon.awscdk.IResolvable mssManifests) {
            this.props.mssManifests(mssManifests);
            return this;
        }
        /**
         * A list of Microsoft Smooth Streaming (MSS) manifest configurations associated with the origin endpoint.
         * <p>
         * Each configuration represents a different MSS streaming option available from this endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-mssmanifests">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-mssmanifests</a>
         * @param mssManifests A list of Microsoft Smooth Streaming (MSS) manifest configurations associated with the origin endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mssManifests(final java.util.List<? extends java.lang.Object> mssManifests) {
            this.props.mssManifests(mssManifests);
            return this;
        }

        /**
         * The segment associated with the origin endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-segment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-segment</a>
         * @param segment The segment associated with the origin endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder segment(final software.amazon.awscdk.IResolvable segment) {
            this.props.segment(segment);
            return this;
        }
        /**
         * The segment associated with the origin endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-segment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-segment</a>
         * @param segment The segment associated with the origin endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder segment(final software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint.SegmentProperty segment) {
            this.props.segment(segment);
            return this;
        }

        /**
         * The size of the window (in seconds) to specify a window of the live stream that's available for on-demand viewing.
         * <p>
         * Viewers can start-over or catch-up on content that falls within the window.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-startoverwindowseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-startoverwindowseconds</a>
         * @param startoverWindowSeconds The size of the window (in seconds) to specify a window of the live stream that's available for on-demand viewing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startoverWindowSeconds(final java.lang.Number startoverWindowSeconds) {
            this.props.startoverWindowSeconds(startoverWindowSeconds);
            return this;
        }

        /**
         * The tags associated with the origin endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpoint.html#cfn-mediapackagev2-originendpoint-tags</a>
         * @param tags The tags associated with the origin endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint build() {
            return new software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpoint(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
