package software.amazon.awscdk.services.mediapackagev2;

/**
 * Specifies the configuration parameters of a policy associated with a MediaPackage V2 origin endpoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediapackagev2.*;
 * Object policy;
 * CfnOriginEndpointPolicy cfnOriginEndpointPolicy = CfnOriginEndpointPolicy.Builder.create(this, "MyCfnOriginEndpointPolicy")
 *         .channelGroupName("channelGroupName")
 *         .channelName("channelName")
 *         .originEndpointName("originEndpointName")
 *         .policy(policy)
 *         // the properties below are optional
 *         .cdnAuthConfiguration(CdnAuthConfigurationProperty.builder()
 *                 .cdnIdentifierSecretArns(List.of("cdnIdentifierSecretArns"))
 *                 .secretsRoleArn("secretsRoleArn")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpointpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpointpolicy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:09.946Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpointPolicy")
public class CfnOriginEndpointPolicy extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.services.mediapackagev2.IOriginEndpointPolicyRef {

    protected CfnOriginEndpointPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnOriginEndpointPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpointPolicy.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnOriginEndpointPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpointPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a OriginEndpointPolicy resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.mediapackagev2.OriginEndpointPolicyReference getOriginEndpointPolicyRef() {
        return software.amazon.jsii.Kernel.get(this, "originEndpointPolicyRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.mediapackagev2.OriginEndpointPolicyReference.class));
    }

    /**
     * The name of the channel group associated with the origin endpoint policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getChannelGroupName() {
        return software.amazon.jsii.Kernel.get(this, "channelGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the channel group associated with the origin endpoint policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChannelGroupName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "channelGroupName", java.util.Objects.requireNonNull(value, "channelGroupName is required"));
    }

    /**
     * The channel name associated with the origin endpoint policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getChannelName() {
        return software.amazon.jsii.Kernel.get(this, "channelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The channel name associated with the origin endpoint policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChannelName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "channelName", java.util.Objects.requireNonNull(value, "channelName is required"));
    }

    /**
     * The name of the origin endpoint associated with the origin endpoint policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getOriginEndpointName() {
        return software.amazon.jsii.Kernel.get(this, "originEndpointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the origin endpoint associated with the origin endpoint policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOriginEndpointName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "originEndpointName", java.util.Objects.requireNonNull(value, "originEndpointName is required"));
    }

    /**
     * The policy associated with the origin endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getPolicy() {
        return software.amazon.jsii.Kernel.get(this, "policy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The policy associated with the origin endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicy(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "policy", java.util.Objects.requireNonNull(value, "policy is required"));
    }

    /**
     * The settings to enable CDN authorization headers in MediaPackage.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpointPolicy.CdnAuthConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCdnAuthConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "cdnAuthConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The settings to enable CDN authorization headers in MediaPackage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCdnAuthConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "cdnAuthConfiguration", value);
    }

    /**
     * The settings to enable CDN authorization headers in MediaPackage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCdnAuthConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpointPolicy.CdnAuthConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "cdnAuthConfiguration", value);
    }
    /**
     * The settings to enable CDN authorization headers in MediaPackage.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackagev2.*;
     * CdnAuthConfigurationProperty cdnAuthConfigurationProperty = CdnAuthConfigurationProperty.builder()
     *         .cdnIdentifierSecretArns(List.of("cdnIdentifierSecretArns"))
     *         .secretsRoleArn("secretsRoleArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpointpolicy-cdnauthconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpointpolicy-cdnauthconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpointPolicy.CdnAuthConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CdnAuthConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CdnAuthConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN for the secret in Secrets Manager that your CDN uses for authorization to access the endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpointpolicy-cdnauthconfiguration.html#cfn-mediapackagev2-originendpointpolicy-cdnauthconfiguration-cdnidentifiersecretarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpointpolicy-cdnauthconfiguration.html#cfn-mediapackagev2-originendpointpolicy-cdnauthconfiguration-cdnidentifiersecretarns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getCdnIdentifierSecretArns();

        /**
         * The ARN for the IAM role that gives MediaPackage read access to Secrets Manager and AWS KMS for CDN authorization.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpointpolicy-cdnauthconfiguration.html#cfn-mediapackagev2-originendpointpolicy-cdnauthconfiguration-secretsrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediapackagev2-originendpointpolicy-cdnauthconfiguration.html#cfn-mediapackagev2-originendpointpolicy-cdnauthconfiguration-secretsrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretsRoleArn();

        /**
         * @return a {@link Builder} of {@link CdnAuthConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CdnAuthConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CdnAuthConfigurationProperty> {
            java.util.List<java.lang.String> cdnIdentifierSecretArns;
            java.lang.String secretsRoleArn;

            /**
             * Sets the value of {@link CdnAuthConfigurationProperty#getCdnIdentifierSecretArns}
             * @param cdnIdentifierSecretArns The ARN for the secret in Secrets Manager that your CDN uses for authorization to access the endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cdnIdentifierSecretArns(java.util.List<java.lang.String> cdnIdentifierSecretArns) {
                this.cdnIdentifierSecretArns = cdnIdentifierSecretArns;
                return this;
            }

            /**
             * Sets the value of {@link CdnAuthConfigurationProperty#getSecretsRoleArn}
             * @param secretsRoleArn The ARN for the IAM role that gives MediaPackage read access to Secrets Manager and AWS KMS for CDN authorization. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsRoleArn(java.lang.String secretsRoleArn) {
                this.secretsRoleArn = secretsRoleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CdnAuthConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CdnAuthConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CdnAuthConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CdnAuthConfigurationProperty {
            private final java.util.List<java.lang.String> cdnIdentifierSecretArns;
            private final java.lang.String secretsRoleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cdnIdentifierSecretArns = software.amazon.jsii.Kernel.get(this, "cdnIdentifierSecretArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.secretsRoleArn = software.amazon.jsii.Kernel.get(this, "secretsRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cdnIdentifierSecretArns = java.util.Objects.requireNonNull(builder.cdnIdentifierSecretArns, "cdnIdentifierSecretArns is required");
                this.secretsRoleArn = java.util.Objects.requireNonNull(builder.secretsRoleArn, "secretsRoleArn is required");
            }

            @Override
            public final java.util.List<java.lang.String> getCdnIdentifierSecretArns() {
                return this.cdnIdentifierSecretArns;
            }

            @Override
            public final java.lang.String getSecretsRoleArn() {
                return this.secretsRoleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cdnIdentifierSecretArns", om.valueToTree(this.getCdnIdentifierSecretArns()));
                data.set("secretsRoleArn", om.valueToTree(this.getSecretsRoleArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackagev2.CfnOriginEndpointPolicy.CdnAuthConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CdnAuthConfigurationProperty.Jsii$Proxy that = (CdnAuthConfigurationProperty.Jsii$Proxy) o;

                if (!cdnIdentifierSecretArns.equals(that.cdnIdentifierSecretArns)) return false;
                return this.secretsRoleArn.equals(that.secretsRoleArn);
            }

            @Override
            public final int hashCode() {
                int result = this.cdnIdentifierSecretArns.hashCode();
                result = 31 * result + (this.secretsRoleArn.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpointPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpointPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpointPolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpointPolicyProps.Builder();
        }

        /**
         * The name of the channel group associated with the origin endpoint policy.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpointpolicy.html#cfn-mediapackagev2-originendpointpolicy-channelgroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpointpolicy.html#cfn-mediapackagev2-originendpointpolicy-channelgroupname</a>
         * @param channelGroupName The name of the channel group associated with the origin endpoint policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelGroupName(final java.lang.String channelGroupName) {
            this.props.channelGroupName(channelGroupName);
            return this;
        }

        /**
         * The channel name associated with the origin endpoint policy.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpointpolicy.html#cfn-mediapackagev2-originendpointpolicy-channelname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpointpolicy.html#cfn-mediapackagev2-originendpointpolicy-channelname</a>
         * @param channelName The channel name associated with the origin endpoint policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelName(final java.lang.String channelName) {
            this.props.channelName(channelName);
            return this;
        }

        /**
         * The name of the origin endpoint associated with the origin endpoint policy.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpointpolicy.html#cfn-mediapackagev2-originendpointpolicy-originendpointname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpointpolicy.html#cfn-mediapackagev2-originendpointpolicy-originendpointname</a>
         * @param originEndpointName The name of the origin endpoint associated with the origin endpoint policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originEndpointName(final java.lang.String originEndpointName) {
            this.props.originEndpointName(originEndpointName);
            return this;
        }

        /**
         * The policy associated with the origin endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpointpolicy.html#cfn-mediapackagev2-originendpointpolicy-policy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpointpolicy.html#cfn-mediapackagev2-originendpointpolicy-policy</a>
         * @param policy The policy associated with the origin endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(final java.lang.Object policy) {
            this.props.policy(policy);
            return this;
        }

        /**
         * The settings to enable CDN authorization headers in MediaPackage.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpointpolicy.html#cfn-mediapackagev2-originendpointpolicy-cdnauthconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpointpolicy.html#cfn-mediapackagev2-originendpointpolicy-cdnauthconfiguration</a>
         * @param cdnAuthConfiguration The settings to enable CDN authorization headers in MediaPackage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cdnAuthConfiguration(final software.amazon.awscdk.IResolvable cdnAuthConfiguration) {
            this.props.cdnAuthConfiguration(cdnAuthConfiguration);
            return this;
        }
        /**
         * The settings to enable CDN authorization headers in MediaPackage.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpointpolicy.html#cfn-mediapackagev2-originendpointpolicy-cdnauthconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackagev2-originendpointpolicy.html#cfn-mediapackagev2-originendpointpolicy-cdnauthconfiguration</a>
         * @param cdnAuthConfiguration The settings to enable CDN authorization headers in MediaPackage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cdnAuthConfiguration(final software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpointPolicy.CdnAuthConfigurationProperty cdnAuthConfiguration) {
            this.props.cdnAuthConfiguration(cdnAuthConfiguration);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpointPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpointPolicy build() {
            return new software.amazon.awscdk.services.mediapackagev2.CfnOriginEndpointPolicy(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
