package software.amazon.awscdk.services.mediapackagev2;

/**
 * A reference to a ChannelPolicy resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediapackagev2.*;
 * ChannelPolicyReference channelPolicyReference = ChannelPolicyReference.builder()
 *         .channelGroupName("channelGroupName")
 *         .channelName("channelName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:09.950Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackagev2.ChannelPolicyReference")
@software.amazon.jsii.Jsii.Proxy(ChannelPolicyReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ChannelPolicyReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ChannelGroupName of the ChannelPolicy resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getChannelGroupName();

    /**
     * The ChannelName of the ChannelPolicy resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getChannelName();

    /**
     * @return a {@link Builder} of {@link ChannelPolicyReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ChannelPolicyReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ChannelPolicyReference> {
        java.lang.String channelGroupName;
        java.lang.String channelName;

        /**
         * Sets the value of {@link ChannelPolicyReference#getChannelGroupName}
         * @param channelGroupName The ChannelGroupName of the ChannelPolicy resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelGroupName(java.lang.String channelGroupName) {
            this.channelGroupName = channelGroupName;
            return this;
        }

        /**
         * Sets the value of {@link ChannelPolicyReference#getChannelName}
         * @param channelName The ChannelName of the ChannelPolicy resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelName(java.lang.String channelName) {
            this.channelName = channelName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ChannelPolicyReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ChannelPolicyReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ChannelPolicyReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ChannelPolicyReference {
        private final java.lang.String channelGroupName;
        private final java.lang.String channelName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.channelGroupName = software.amazon.jsii.Kernel.get(this, "channelGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.channelName = software.amazon.jsii.Kernel.get(this, "channelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.channelGroupName = java.util.Objects.requireNonNull(builder.channelGroupName, "channelGroupName is required");
            this.channelName = java.util.Objects.requireNonNull(builder.channelName, "channelName is required");
        }

        @Override
        public final java.lang.String getChannelGroupName() {
            return this.channelGroupName;
        }

        @Override
        public final java.lang.String getChannelName() {
            return this.channelName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("channelGroupName", om.valueToTree(this.getChannelGroupName()));
            data.set("channelName", om.valueToTree(this.getChannelName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackagev2.ChannelPolicyReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ChannelPolicyReference.Jsii$Proxy that = (ChannelPolicyReference.Jsii$Proxy) o;

            if (!channelGroupName.equals(that.channelGroupName)) return false;
            return this.channelName.equals(that.channelName);
        }

        @Override
        public final int hashCode() {
            int result = this.channelGroupName.hashCode();
            result = 31 * result + (this.channelName.hashCode());
            return result;
        }
    }
}
