package software.amazon.awscdk.services.mediatailor;

/**
 * A reference to a SourceLocation resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediatailor.*;
 * SourceLocationReference sourceLocationReference = SourceLocationReference.builder()
 *         .sourceLocationArn("sourceLocationArn")
 *         .sourceLocationName("sourceLocationName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:10.019Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediatailor.SourceLocationReference")
@software.amazon.jsii.Jsii.Proxy(SourceLocationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SourceLocationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the SourceLocation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSourceLocationArn();

    /**
     * The SourceLocationName of the SourceLocation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSourceLocationName();

    /**
     * @return a {@link Builder} of {@link SourceLocationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SourceLocationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SourceLocationReference> {
        java.lang.String sourceLocationArn;
        java.lang.String sourceLocationName;

        /**
         * Sets the value of {@link SourceLocationReference#getSourceLocationArn}
         * @param sourceLocationArn The ARN of the SourceLocation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceLocationArn(java.lang.String sourceLocationArn) {
            this.sourceLocationArn = sourceLocationArn;
            return this;
        }

        /**
         * Sets the value of {@link SourceLocationReference#getSourceLocationName}
         * @param sourceLocationName The SourceLocationName of the SourceLocation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceLocationName(java.lang.String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SourceLocationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SourceLocationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SourceLocationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceLocationReference {
        private final java.lang.String sourceLocationArn;
        private final java.lang.String sourceLocationName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.sourceLocationArn = software.amazon.jsii.Kernel.get(this, "sourceLocationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceLocationName = software.amazon.jsii.Kernel.get(this, "sourceLocationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.sourceLocationArn = java.util.Objects.requireNonNull(builder.sourceLocationArn, "sourceLocationArn is required");
            this.sourceLocationName = java.util.Objects.requireNonNull(builder.sourceLocationName, "sourceLocationName is required");
        }

        @Override
        public final java.lang.String getSourceLocationArn() {
            return this.sourceLocationArn;
        }

        @Override
        public final java.lang.String getSourceLocationName() {
            return this.sourceLocationName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("sourceLocationArn", om.valueToTree(this.getSourceLocationArn()));
            data.set("sourceLocationName", om.valueToTree(this.getSourceLocationName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediatailor.SourceLocationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SourceLocationReference.Jsii$Proxy that = (SourceLocationReference.Jsii$Proxy) o;

            if (!sourceLocationArn.equals(that.sourceLocationArn)) return false;
            return this.sourceLocationName.equals(that.sourceLocationName);
        }

        @Override
        public final int hashCode() {
            int result = this.sourceLocationArn.hashCode();
            result = 31 * result + (this.sourceLocationName.hashCode());
            return result;
        }
    }
}
