package software.amazon.awscdk.services.memorydb;

/**
 * A reference to a ACL resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.memorydb.*;
 * ACLReference aCLReference = ACLReference.builder()
 *         .aclArn("aclArn")
 *         .aclName("aclName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:10.020Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_memorydb.ACLReference")
@software.amazon.jsii.Jsii.Proxy(ACLReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ACLReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the ACL resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAclArn();

    /**
     * The ACLName of the ACL resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAclName();

    /**
     * @return a {@link Builder} of {@link ACLReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ACLReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ACLReference> {
        java.lang.String aclArn;
        java.lang.String aclName;

        /**
         * Sets the value of {@link ACLReference#getAclArn}
         * @param aclArn The ARN of the ACL resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aclArn(java.lang.String aclArn) {
            this.aclArn = aclArn;
            return this;
        }

        /**
         * Sets the value of {@link ACLReference#getAclName}
         * @param aclName The ACLName of the ACL resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aclName(java.lang.String aclName) {
            this.aclName = aclName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ACLReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ACLReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ACLReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ACLReference {
        private final java.lang.String aclArn;
        private final java.lang.String aclName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.aclArn = software.amazon.jsii.Kernel.get(this, "aclArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.aclName = software.amazon.jsii.Kernel.get(this, "aclName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.aclArn = java.util.Objects.requireNonNull(builder.aclArn, "aclArn is required");
            this.aclName = java.util.Objects.requireNonNull(builder.aclName, "aclName is required");
        }

        @Override
        public final java.lang.String getAclArn() {
            return this.aclArn;
        }

        @Override
        public final java.lang.String getAclName() {
            return this.aclName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("aclArn", om.valueToTree(this.getAclArn()));
            data.set("aclName", om.valueToTree(this.getAclName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_memorydb.ACLReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ACLReference.Jsii$Proxy that = (ACLReference.Jsii$Proxy) o;

            if (!aclArn.equals(that.aclArn)) return false;
            return this.aclName.equals(that.aclName);
        }

        @Override
        public final int hashCode() {
            int result = this.aclArn.hashCode();
            result = 31 * result + (this.aclName.hashCode());
            return result;
        }
    }
}
