package software.amazon.awscdk.services.networkmanager;

/**
 * A reference to a CoreNetwork resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.networkmanager.*;
 * CoreNetworkReference coreNetworkReference = CoreNetworkReference.builder()
 *         .coreNetworkArn("coreNetworkArn")
 *         .coreNetworkId("coreNetworkId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:10.303Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkmanager.CoreNetworkReference")
@software.amazon.jsii.Jsii.Proxy(CoreNetworkReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CoreNetworkReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the CoreNetwork resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCoreNetworkArn();

    /**
     * The CoreNetworkId of the CoreNetwork resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCoreNetworkId();

    /**
     * @return a {@link Builder} of {@link CoreNetworkReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CoreNetworkReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CoreNetworkReference> {
        java.lang.String coreNetworkArn;
        java.lang.String coreNetworkId;

        /**
         * Sets the value of {@link CoreNetworkReference#getCoreNetworkArn}
         * @param coreNetworkArn The ARN of the CoreNetwork resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder coreNetworkArn(java.lang.String coreNetworkArn) {
            this.coreNetworkArn = coreNetworkArn;
            return this;
        }

        /**
         * Sets the value of {@link CoreNetworkReference#getCoreNetworkId}
         * @param coreNetworkId The CoreNetworkId of the CoreNetwork resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder coreNetworkId(java.lang.String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CoreNetworkReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CoreNetworkReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CoreNetworkReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CoreNetworkReference {
        private final java.lang.String coreNetworkArn;
        private final java.lang.String coreNetworkId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.coreNetworkArn = software.amazon.jsii.Kernel.get(this, "coreNetworkArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.coreNetworkId = software.amazon.jsii.Kernel.get(this, "coreNetworkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.coreNetworkArn = java.util.Objects.requireNonNull(builder.coreNetworkArn, "coreNetworkArn is required");
            this.coreNetworkId = java.util.Objects.requireNonNull(builder.coreNetworkId, "coreNetworkId is required");
        }

        @Override
        public final java.lang.String getCoreNetworkArn() {
            return this.coreNetworkArn;
        }

        @Override
        public final java.lang.String getCoreNetworkId() {
            return this.coreNetworkId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("coreNetworkArn", om.valueToTree(this.getCoreNetworkArn()));
            data.set("coreNetworkId", om.valueToTree(this.getCoreNetworkId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkmanager.CoreNetworkReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CoreNetworkReference.Jsii$Proxy that = (CoreNetworkReference.Jsii$Proxy) o;

            if (!coreNetworkArn.equals(that.coreNetworkArn)) return false;
            return this.coreNetworkId.equals(that.coreNetworkId);
        }

        @Override
        public final int hashCode() {
            int result = this.coreNetworkArn.hashCode();
            result = 31 * result + (this.coreNetworkId.hashCode());
            return result;
        }
    }
}
