package software.amazon.awscdk.services.networkmanager;

/**
 * A reference to a Link resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.networkmanager.*;
 * LinkReference linkReference = LinkReference.builder()
 *         .globalNetworkId("globalNetworkId")
 *         .linkArn("linkArn")
 *         .linkId("linkId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:10.309Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkmanager.LinkReference")
@software.amazon.jsii.Jsii.Proxy(LinkReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LinkReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The GlobalNetworkId of the Link resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGlobalNetworkId();

    /**
     * The ARN of the Link resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLinkArn();

    /**
     * The LinkId of the Link resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLinkId();

    /**
     * @return a {@link Builder} of {@link LinkReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LinkReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LinkReference> {
        java.lang.String globalNetworkId;
        java.lang.String linkArn;
        java.lang.String linkId;

        /**
         * Sets the value of {@link LinkReference#getGlobalNetworkId}
         * @param globalNetworkId The GlobalNetworkId of the Link resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalNetworkId(java.lang.String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        /**
         * Sets the value of {@link LinkReference#getLinkArn}
         * @param linkArn The ARN of the Link resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder linkArn(java.lang.String linkArn) {
            this.linkArn = linkArn;
            return this;
        }

        /**
         * Sets the value of {@link LinkReference#getLinkId}
         * @param linkId The LinkId of the Link resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder linkId(java.lang.String linkId) {
            this.linkId = linkId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LinkReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LinkReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LinkReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LinkReference {
        private final java.lang.String globalNetworkId;
        private final java.lang.String linkArn;
        private final java.lang.String linkId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.globalNetworkId = software.amazon.jsii.Kernel.get(this, "globalNetworkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.linkArn = software.amazon.jsii.Kernel.get(this, "linkArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.linkId = software.amazon.jsii.Kernel.get(this, "linkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.globalNetworkId = java.util.Objects.requireNonNull(builder.globalNetworkId, "globalNetworkId is required");
            this.linkArn = java.util.Objects.requireNonNull(builder.linkArn, "linkArn is required");
            this.linkId = java.util.Objects.requireNonNull(builder.linkId, "linkId is required");
        }

        @Override
        public final java.lang.String getGlobalNetworkId() {
            return this.globalNetworkId;
        }

        @Override
        public final java.lang.String getLinkArn() {
            return this.linkArn;
        }

        @Override
        public final java.lang.String getLinkId() {
            return this.linkId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("globalNetworkId", om.valueToTree(this.getGlobalNetworkId()));
            data.set("linkArn", om.valueToTree(this.getLinkArn()));
            data.set("linkId", om.valueToTree(this.getLinkId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkmanager.LinkReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LinkReference.Jsii$Proxy that = (LinkReference.Jsii$Proxy) o;

            if (!globalNetworkId.equals(that.globalNetworkId)) return false;
            if (!linkArn.equals(that.linkArn)) return false;
            return this.linkId.equals(that.linkId);
        }

        @Override
        public final int hashCode() {
            int result = this.globalNetworkId.hashCode();
            result = 31 * result + (this.linkArn.hashCode());
            result = 31 * result + (this.linkId.hashCode());
            return result;
        }
    }
}
