package software.amazon.awscdk.services.notifications;

/**
 * A reference to a EventRule resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.notifications.*;
 * EventRuleReference eventRuleReference = EventRuleReference.builder()
 *         .eventRuleArn("eventRuleArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:10.351Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_notifications.EventRuleReference")
@software.amazon.jsii.Jsii.Proxy(EventRuleReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EventRuleReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the EventRule resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEventRuleArn();

    /**
     * @return a {@link Builder} of {@link EventRuleReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EventRuleReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EventRuleReference> {
        java.lang.String eventRuleArn;

        /**
         * Sets the value of {@link EventRuleReference#getEventRuleArn}
         * @param eventRuleArn The Arn of the EventRule resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventRuleArn(java.lang.String eventRuleArn) {
            this.eventRuleArn = eventRuleArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EventRuleReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EventRuleReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EventRuleReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventRuleReference {
        private final java.lang.String eventRuleArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.eventRuleArn = software.amazon.jsii.Kernel.get(this, "eventRuleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.eventRuleArn = java.util.Objects.requireNonNull(builder.eventRuleArn, "eventRuleArn is required");
        }

        @Override
        public final java.lang.String getEventRuleArn() {
            return this.eventRuleArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("eventRuleArn", om.valueToTree(this.getEventRuleArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_notifications.EventRuleReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EventRuleReference.Jsii$Proxy that = (EventRuleReference.Jsii$Proxy) o;

            return this.eventRuleArn.equals(that.eventRuleArn);
        }

        @Override
        public final int hashCode() {
            int result = this.eventRuleArn.hashCode();
            return result;
        }
    }
}
