package software.amazon.awscdk.services.notificationscontacts;

/**
 * A reference to a EmailContact resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.notificationscontacts.*;
 * EmailContactReference emailContactReference = EmailContactReference.builder()
 *         .emailContactArn("emailContactArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:10.358Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_notificationscontacts.EmailContactReference")
@software.amazon.jsii.Jsii.Proxy(EmailContactReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EmailContactReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the EmailContact resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEmailContactArn();

    /**
     * @return a {@link Builder} of {@link EmailContactReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EmailContactReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EmailContactReference> {
        java.lang.String emailContactArn;

        /**
         * Sets the value of {@link EmailContactReference#getEmailContactArn}
         * @param emailContactArn The Arn of the EmailContact resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailContactArn(java.lang.String emailContactArn) {
            this.emailContactArn = emailContactArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EmailContactReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EmailContactReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EmailContactReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmailContactReference {
        private final java.lang.String emailContactArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.emailContactArn = software.amazon.jsii.Kernel.get(this, "emailContactArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.emailContactArn = java.util.Objects.requireNonNull(builder.emailContactArn, "emailContactArn is required");
        }

        @Override
        public final java.lang.String getEmailContactArn() {
            return this.emailContactArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("emailContactArn", om.valueToTree(this.getEmailContactArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_notificationscontacts.EmailContactReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EmailContactReference.Jsii$Proxy that = (EmailContactReference.Jsii$Proxy) o;

            return this.emailContactArn.equals(that.emailContactArn);
        }

        @Override
        public final int hashCode() {
            int result = this.emailContactArn.hashCode();
            return result;
        }
    }
}
