package software.amazon.awscdk.services.observabilityadmin;

/**
 * Defines how telemetry data should be centralized across an AWS Organization, including source and destination configurations.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.observabilityadmin.*;
 * CfnOrganizationCentralizationRule cfnOrganizationCentralizationRule = CfnOrganizationCentralizationRule.Builder.create(this, "MyCfnOrganizationCentralizationRule")
 *         .rule(CentralizationRuleProperty.builder()
 *                 .destination(CentralizationRuleDestinationProperty.builder()
 *                         .region("region")
 *                         // the properties below are optional
 *                         .account("account")
 *                         .destinationLogsConfiguration(DestinationLogsConfigurationProperty.builder()
 *                                 .backupConfiguration(LogsBackupConfigurationProperty.builder()
 *                                         .region("region")
 *                                         // the properties below are optional
 *                                         .kmsKeyArn("kmsKeyArn")
 *                                         .build())
 *                                 .logsEncryptionConfiguration(LogsEncryptionConfigurationProperty.builder()
 *                                         .encryptionStrategy("encryptionStrategy")
 *                                         // the properties below are optional
 *                                         .encryptionConflictResolutionStrategy("encryptionConflictResolutionStrategy")
 *                                         .kmsKeyArn("kmsKeyArn")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .source(CentralizationRuleSourceProperty.builder()
 *                         .regions(List.of("regions"))
 *                         // the properties below are optional
 *                         .scope("scope")
 *                         .sourceLogsConfiguration(SourceLogsConfigurationProperty.builder()
 *                                 .encryptedLogGroupStrategy("encryptedLogGroupStrategy")
 *                                 .logGroupSelectionCriteria("logGroupSelectionCriteria")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .ruleName("ruleName")
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-observabilityadmin-organizationcentralizationrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-observabilityadmin-organizationcentralizationrule.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:10.365Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_observabilityadmin.CfnOrganizationCentralizationRule")
public class CfnOrganizationCentralizationRule extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.services.observabilityadmin.IOrganizationCentralizationRuleRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnOrganizationCentralizationRule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnOrganizationCentralizationRule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.observabilityadmin.CfnOrganizationCentralizationRule.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnOrganizationCentralizationRule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.observabilityadmin.CfnOrganizationCentralizationRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the organization centralization rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRuleArn() {
        return software.amazon.jsii.Kernel.get(this, "attrRuleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a OrganizationCentralizationRule resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.observabilityadmin.OrganizationCentralizationRuleReference getOrganizationCentralizationRuleRef() {
        return software.amazon.jsii.Kernel.get(this, "organizationCentralizationRuleRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.observabilityadmin.OrganizationCentralizationRuleReference.class));
    }

    /**
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.observabilityadmin.CfnOrganizationCentralizationRule.CentralizationRuleProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getRule() {
        return software.amazon.jsii.Kernel.get(this, "rule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "rule", java.util.Objects.requireNonNull(value, "rule is required"));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.observabilityadmin.CfnOrganizationCentralizationRule.CentralizationRuleProperty value) {
        software.amazon.jsii.Kernel.set(this, "rule", java.util.Objects.requireNonNull(value, "rule is required"));
    }

    /**
     * The name of the organization centralization rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRuleName() {
        return software.amazon.jsii.Kernel.get(this, "ruleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the organization centralization rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuleName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ruleName", java.util.Objects.requireNonNull(value, "ruleName is required"));
    }

    /**
     * A key-value pair to filter resources based on tags associated with the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A key-value pair to filter resources based on tags associated with the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Configuration specifying the primary destination for centralized telemetry data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.observabilityadmin.*;
     * CentralizationRuleDestinationProperty centralizationRuleDestinationProperty = CentralizationRuleDestinationProperty.builder()
     *         .region("region")
     *         // the properties below are optional
     *         .account("account")
     *         .destinationLogsConfiguration(DestinationLogsConfigurationProperty.builder()
     *                 .backupConfiguration(LogsBackupConfigurationProperty.builder()
     *                         .region("region")
     *                         // the properties below are optional
     *                         .kmsKeyArn("kmsKeyArn")
     *                         .build())
     *                 .logsEncryptionConfiguration(LogsEncryptionConfigurationProperty.builder()
     *                         .encryptionStrategy("encryptionStrategy")
     *                         // the properties below are optional
     *                         .encryptionConflictResolutionStrategy("encryptionConflictResolutionStrategy")
     *                         .kmsKeyArn("kmsKeyArn")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-centralizationruledestination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-centralizationruledestination.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_observabilityadmin.CfnOrganizationCentralizationRule.CentralizationRuleDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(CentralizationRuleDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CentralizationRuleDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The primary destination region to which telemetry data should be centralized.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-centralizationruledestination.html#cfn-observabilityadmin-organizationcentralizationrule-centralizationruledestination-region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-centralizationruledestination.html#cfn-observabilityadmin-organizationcentralizationrule-centralizationruledestination-region</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRegion();

        /**
         * The destination account (within the organization) to which the telemetry data should be centralized.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-centralizationruledestination.html#cfn-observabilityadmin-organizationcentralizationrule-centralizationruledestination-account">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-centralizationruledestination.html#cfn-observabilityadmin-organizationcentralizationrule-centralizationruledestination-account</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccount() {
            return null;
        }

        /**
         * Log specific configuration for centralization destination log groups.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.observabilityadmin.CfnOrganizationCentralizationRule.DestinationLogsConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-centralizationruledestination.html#cfn-observabilityadmin-organizationcentralizationrule-centralizationruledestination-destinationlogsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-centralizationruledestination.html#cfn-observabilityadmin-organizationcentralizationrule-centralizationruledestination-destinationlogsconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDestinationLogsConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CentralizationRuleDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CentralizationRuleDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CentralizationRuleDestinationProperty> {
            java.lang.String region;
            java.lang.String account;
            java.lang.Object destinationLogsConfiguration;

            /**
             * Sets the value of {@link CentralizationRuleDestinationProperty#getRegion}
             * @param region The primary destination region to which telemetry data should be centralized. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Sets the value of {@link CentralizationRuleDestinationProperty#getAccount}
             * @param account The destination account (within the organization) to which the telemetry data should be centralized.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder account(java.lang.String account) {
                this.account = account;
                return this;
            }

            /**
             * Sets the value of {@link CentralizationRuleDestinationProperty#getDestinationLogsConfiguration}
             * @param destinationLogsConfiguration Log specific configuration for centralization destination log groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationLogsConfiguration(software.amazon.awscdk.IResolvable destinationLogsConfiguration) {
                this.destinationLogsConfiguration = destinationLogsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CentralizationRuleDestinationProperty#getDestinationLogsConfiguration}
             * @param destinationLogsConfiguration Log specific configuration for centralization destination log groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationLogsConfiguration(software.amazon.awscdk.services.observabilityadmin.CfnOrganizationCentralizationRule.DestinationLogsConfigurationProperty destinationLogsConfiguration) {
                this.destinationLogsConfiguration = destinationLogsConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CentralizationRuleDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CentralizationRuleDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CentralizationRuleDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CentralizationRuleDestinationProperty {
            private final java.lang.String region;
            private final java.lang.String account;
            private final java.lang.Object destinationLogsConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.account = software.amazon.jsii.Kernel.get(this, "account", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.destinationLogsConfiguration = software.amazon.jsii.Kernel.get(this, "destinationLogsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.region = java.util.Objects.requireNonNull(builder.region, "region is required");
                this.account = builder.account;
                this.destinationLogsConfiguration = builder.destinationLogsConfiguration;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            public final java.lang.String getAccount() {
                return this.account;
            }

            @Override
            public final java.lang.Object getDestinationLogsConfiguration() {
                return this.destinationLogsConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("region", om.valueToTree(this.getRegion()));
                if (this.getAccount() != null) {
                    data.set("account", om.valueToTree(this.getAccount()));
                }
                if (this.getDestinationLogsConfiguration() != null) {
                    data.set("destinationLogsConfiguration", om.valueToTree(this.getDestinationLogsConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_observabilityadmin.CfnOrganizationCentralizationRule.CentralizationRuleDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CentralizationRuleDestinationProperty.Jsii$Proxy that = (CentralizationRuleDestinationProperty.Jsii$Proxy) o;

                if (!region.equals(that.region)) return false;
                if (this.account != null ? !this.account.equals(that.account) : that.account != null) return false;
                return this.destinationLogsConfiguration != null ? this.destinationLogsConfiguration.equals(that.destinationLogsConfiguration) : that.destinationLogsConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.region.hashCode();
                result = 31 * result + (this.account != null ? this.account.hashCode() : 0);
                result = 31 * result + (this.destinationLogsConfiguration != null ? this.destinationLogsConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines how telemetry data should be centralized across an AWS Organization, including source and destination configurations.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.observabilityadmin.*;
     * CentralizationRuleProperty centralizationRuleProperty = CentralizationRuleProperty.builder()
     *         .destination(CentralizationRuleDestinationProperty.builder()
     *                 .region("region")
     *                 // the properties below are optional
     *                 .account("account")
     *                 .destinationLogsConfiguration(DestinationLogsConfigurationProperty.builder()
     *                         .backupConfiguration(LogsBackupConfigurationProperty.builder()
     *                                 .region("region")
     *                                 // the properties below are optional
     *                                 .kmsKeyArn("kmsKeyArn")
     *                                 .build())
     *                         .logsEncryptionConfiguration(LogsEncryptionConfigurationProperty.builder()
     *                                 .encryptionStrategy("encryptionStrategy")
     *                                 // the properties below are optional
     *                                 .encryptionConflictResolutionStrategy("encryptionConflictResolutionStrategy")
     *                                 .kmsKeyArn("kmsKeyArn")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .source(CentralizationRuleSourceProperty.builder()
     *                 .regions(List.of("regions"))
     *                 // the properties below are optional
     *                 .scope("scope")
     *                 .sourceLogsConfiguration(SourceLogsConfigurationProperty.builder()
     *                         .encryptedLogGroupStrategy("encryptedLogGroupStrategy")
     *                         .logGroupSelectionCriteria("logGroupSelectionCriteria")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-centralizationrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-centralizationrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_observabilityadmin.CfnOrganizationCentralizationRule.CentralizationRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(CentralizationRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CentralizationRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration determining where the telemetry data should be centralized, backed up, as well as encryption configuration for the primary and backup destinations.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.observabilityadmin.CfnOrganizationCentralizationRule.CentralizationRuleDestinationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-centralizationrule.html#cfn-observabilityadmin-organizationcentralizationrule-centralizationrule-destination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-centralizationrule.html#cfn-observabilityadmin-organizationcentralizationrule-centralizationrule-destination</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDestination();

        /**
         * Configuration determining the source of the telemetry data to be centralized.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.observabilityadmin.CfnOrganizationCentralizationRule.CentralizationRuleSourceProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-centralizationrule.html#cfn-observabilityadmin-organizationcentralizationrule-centralizationrule-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-centralizationrule.html#cfn-observabilityadmin-organizationcentralizationrule-centralizationrule-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSource();

        /**
         * @return a {@link Builder} of {@link CentralizationRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CentralizationRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CentralizationRuleProperty> {
            java.lang.Object destination;
            java.lang.Object source;

            /**
             * Sets the value of {@link CentralizationRuleProperty#getDestination}
             * @param destination Configuration determining where the telemetry data should be centralized, backed up, as well as encryption configuration for the primary and backup destinations. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.IResolvable destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link CentralizationRuleProperty#getDestination}
             * @param destination Configuration determining where the telemetry data should be centralized, backed up, as well as encryption configuration for the primary and backup destinations. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.services.observabilityadmin.CfnOrganizationCentralizationRule.CentralizationRuleDestinationProperty destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link CentralizationRuleProperty#getSource}
             * @param source Configuration determining the source of the telemetry data to be centralized. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.IResolvable source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link CentralizationRuleProperty#getSource}
             * @param source Configuration determining the source of the telemetry data to be centralized. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.services.observabilityadmin.CfnOrganizationCentralizationRule.CentralizationRuleSourceProperty source) {
                this.source = source;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CentralizationRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CentralizationRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CentralizationRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CentralizationRuleProperty {
            private final java.lang.Object destination;
            private final java.lang.Object source;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destination = java.util.Objects.requireNonNull(builder.destination, "destination is required");
                this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
            }

            @Override
            public final java.lang.Object getDestination() {
                return this.destination;
            }

            @Override
            public final java.lang.Object getSource() {
                return this.source;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destination", om.valueToTree(this.getDestination()));
                data.set("source", om.valueToTree(this.getSource()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_observabilityadmin.CfnOrganizationCentralizationRule.CentralizationRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CentralizationRuleProperty.Jsii$Proxy that = (CentralizationRuleProperty.Jsii$Proxy) o;

                if (!destination.equals(that.destination)) return false;
                return this.source.equals(that.source);
            }

            @Override
            public final int hashCode() {
                int result = this.destination.hashCode();
                result = 31 * result + (this.source.hashCode());
                return result;
            }
        }
    }
    /**
     * Configuration specifying the source of telemetry data to be centralized.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.observabilityadmin.*;
     * CentralizationRuleSourceProperty centralizationRuleSourceProperty = CentralizationRuleSourceProperty.builder()
     *         .regions(List.of("regions"))
     *         // the properties below are optional
     *         .scope("scope")
     *         .sourceLogsConfiguration(SourceLogsConfigurationProperty.builder()
     *                 .encryptedLogGroupStrategy("encryptedLogGroupStrategy")
     *                 .logGroupSelectionCriteria("logGroupSelectionCriteria")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-centralizationrulesource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-centralizationrulesource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_observabilityadmin.CfnOrganizationCentralizationRule.CentralizationRuleSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(CentralizationRuleSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CentralizationRuleSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of source regions from which telemetry data should be centralized.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-centralizationrulesource.html#cfn-observabilityadmin-organizationcentralizationrule-centralizationrulesource-regions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-centralizationrulesource.html#cfn-observabilityadmin-organizationcentralizationrule-centralizationrulesource-regions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getRegions();

        /**
         * The organizational scope from which telemetry data should be centralized, specified using organization id, accounts or organizational unit ids.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-centralizationrulesource.html#cfn-observabilityadmin-organizationcentralizationrule-centralizationrulesource-scope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-centralizationrulesource.html#cfn-observabilityadmin-organizationcentralizationrule-centralizationrulesource-scope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScope() {
            return null;
        }

        /**
         * Log specific configuration for centralization source log groups.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.observabilityadmin.CfnOrganizationCentralizationRule.SourceLogsConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-centralizationrulesource.html#cfn-observabilityadmin-organizationcentralizationrule-centralizationrulesource-sourcelogsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-centralizationrulesource.html#cfn-observabilityadmin-organizationcentralizationrule-centralizationrulesource-sourcelogsconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSourceLogsConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CentralizationRuleSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CentralizationRuleSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CentralizationRuleSourceProperty> {
            java.util.List<java.lang.String> regions;
            java.lang.String scope;
            java.lang.Object sourceLogsConfiguration;

            /**
             * Sets the value of {@link CentralizationRuleSourceProperty#getRegions}
             * @param regions The list of source regions from which telemetry data should be centralized. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regions(java.util.List<java.lang.String> regions) {
                this.regions = regions;
                return this;
            }

            /**
             * Sets the value of {@link CentralizationRuleSourceProperty#getScope}
             * @param scope The organizational scope from which telemetry data should be centralized, specified using organization id, accounts or organizational unit ids.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scope(java.lang.String scope) {
                this.scope = scope;
                return this;
            }

            /**
             * Sets the value of {@link CentralizationRuleSourceProperty#getSourceLogsConfiguration}
             * @param sourceLogsConfiguration Log specific configuration for centralization source log groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceLogsConfiguration(software.amazon.awscdk.IResolvable sourceLogsConfiguration) {
                this.sourceLogsConfiguration = sourceLogsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CentralizationRuleSourceProperty#getSourceLogsConfiguration}
             * @param sourceLogsConfiguration Log specific configuration for centralization source log groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceLogsConfiguration(software.amazon.awscdk.services.observabilityadmin.CfnOrganizationCentralizationRule.SourceLogsConfigurationProperty sourceLogsConfiguration) {
                this.sourceLogsConfiguration = sourceLogsConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CentralizationRuleSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CentralizationRuleSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CentralizationRuleSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CentralizationRuleSourceProperty {
            private final java.util.List<java.lang.String> regions;
            private final java.lang.String scope;
            private final java.lang.Object sourceLogsConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.regions = software.amazon.jsii.Kernel.get(this, "regions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceLogsConfiguration = software.amazon.jsii.Kernel.get(this, "sourceLogsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.regions = java.util.Objects.requireNonNull(builder.regions, "regions is required");
                this.scope = builder.scope;
                this.sourceLogsConfiguration = builder.sourceLogsConfiguration;
            }

            @Override
            public final java.util.List<java.lang.String> getRegions() {
                return this.regions;
            }

            @Override
            public final java.lang.String getScope() {
                return this.scope;
            }

            @Override
            public final java.lang.Object getSourceLogsConfiguration() {
                return this.sourceLogsConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("regions", om.valueToTree(this.getRegions()));
                if (this.getScope() != null) {
                    data.set("scope", om.valueToTree(this.getScope()));
                }
                if (this.getSourceLogsConfiguration() != null) {
                    data.set("sourceLogsConfiguration", om.valueToTree(this.getSourceLogsConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_observabilityadmin.CfnOrganizationCentralizationRule.CentralizationRuleSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CentralizationRuleSourceProperty.Jsii$Proxy that = (CentralizationRuleSourceProperty.Jsii$Proxy) o;

                if (!regions.equals(that.regions)) return false;
                if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) return false;
                return this.sourceLogsConfiguration != null ? this.sourceLogsConfiguration.equals(that.sourceLogsConfiguration) : that.sourceLogsConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.regions.hashCode();
                result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
                result = 31 * result + (this.sourceLogsConfiguration != null ? this.sourceLogsConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for centralization destination log groups, including encryption and backup settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.observabilityadmin.*;
     * DestinationLogsConfigurationProperty destinationLogsConfigurationProperty = DestinationLogsConfigurationProperty.builder()
     *         .backupConfiguration(LogsBackupConfigurationProperty.builder()
     *                 .region("region")
     *                 // the properties below are optional
     *                 .kmsKeyArn("kmsKeyArn")
     *                 .build())
     *         .logsEncryptionConfiguration(LogsEncryptionConfigurationProperty.builder()
     *                 .encryptionStrategy("encryptionStrategy")
     *                 // the properties below are optional
     *                 .encryptionConflictResolutionStrategy("encryptionConflictResolutionStrategy")
     *                 .kmsKeyArn("kmsKeyArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-destinationlogsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-destinationlogsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_observabilityadmin.CfnOrganizationCentralizationRule.DestinationLogsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DestinationLogsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DestinationLogsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration defining the backup region and an optional KMS key for the backup destination.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.observabilityadmin.CfnOrganizationCentralizationRule.LogsBackupConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-destinationlogsconfiguration.html#cfn-observabilityadmin-organizationcentralizationrule-destinationlogsconfiguration-backupconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-destinationlogsconfiguration.html#cfn-observabilityadmin-organizationcentralizationrule-destinationlogsconfiguration-backupconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBackupConfiguration() {
            return null;
        }

        /**
         * The encryption configuration for centralization destination log groups.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.observabilityadmin.CfnOrganizationCentralizationRule.LogsEncryptionConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-destinationlogsconfiguration.html#cfn-observabilityadmin-organizationcentralizationrule-destinationlogsconfiguration-logsencryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-destinationlogsconfiguration.html#cfn-observabilityadmin-organizationcentralizationrule-destinationlogsconfiguration-logsencryptionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLogsEncryptionConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DestinationLogsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DestinationLogsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DestinationLogsConfigurationProperty> {
            java.lang.Object backupConfiguration;
            java.lang.Object logsEncryptionConfiguration;

            /**
             * Sets the value of {@link DestinationLogsConfigurationProperty#getBackupConfiguration}
             * @param backupConfiguration Configuration defining the backup region and an optional KMS key for the backup destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder backupConfiguration(software.amazon.awscdk.IResolvable backupConfiguration) {
                this.backupConfiguration = backupConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DestinationLogsConfigurationProperty#getBackupConfiguration}
             * @param backupConfiguration Configuration defining the backup region and an optional KMS key for the backup destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder backupConfiguration(software.amazon.awscdk.services.observabilityadmin.CfnOrganizationCentralizationRule.LogsBackupConfigurationProperty backupConfiguration) {
                this.backupConfiguration = backupConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DestinationLogsConfigurationProperty#getLogsEncryptionConfiguration}
             * @param logsEncryptionConfiguration The encryption configuration for centralization destination log groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logsEncryptionConfiguration(software.amazon.awscdk.IResolvable logsEncryptionConfiguration) {
                this.logsEncryptionConfiguration = logsEncryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DestinationLogsConfigurationProperty#getLogsEncryptionConfiguration}
             * @param logsEncryptionConfiguration The encryption configuration for centralization destination log groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logsEncryptionConfiguration(software.amazon.awscdk.services.observabilityadmin.CfnOrganizationCentralizationRule.LogsEncryptionConfigurationProperty logsEncryptionConfiguration) {
                this.logsEncryptionConfiguration = logsEncryptionConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DestinationLogsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DestinationLogsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DestinationLogsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DestinationLogsConfigurationProperty {
            private final java.lang.Object backupConfiguration;
            private final java.lang.Object logsEncryptionConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.backupConfiguration = software.amazon.jsii.Kernel.get(this, "backupConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.logsEncryptionConfiguration = software.amazon.jsii.Kernel.get(this, "logsEncryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.backupConfiguration = builder.backupConfiguration;
                this.logsEncryptionConfiguration = builder.logsEncryptionConfiguration;
            }

            @Override
            public final java.lang.Object getBackupConfiguration() {
                return this.backupConfiguration;
            }

            @Override
            public final java.lang.Object getLogsEncryptionConfiguration() {
                return this.logsEncryptionConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBackupConfiguration() != null) {
                    data.set("backupConfiguration", om.valueToTree(this.getBackupConfiguration()));
                }
                if (this.getLogsEncryptionConfiguration() != null) {
                    data.set("logsEncryptionConfiguration", om.valueToTree(this.getLogsEncryptionConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_observabilityadmin.CfnOrganizationCentralizationRule.DestinationLogsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DestinationLogsConfigurationProperty.Jsii$Proxy that = (DestinationLogsConfigurationProperty.Jsii$Proxy) o;

                if (this.backupConfiguration != null ? !this.backupConfiguration.equals(that.backupConfiguration) : that.backupConfiguration != null) return false;
                return this.logsEncryptionConfiguration != null ? this.logsEncryptionConfiguration.equals(that.logsEncryptionConfiguration) : that.logsEncryptionConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.backupConfiguration != null ? this.backupConfiguration.hashCode() : 0;
                result = 31 * result + (this.logsEncryptionConfiguration != null ? this.logsEncryptionConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for backing up centralized log data to a secondary region.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.observabilityadmin.*;
     * LogsBackupConfigurationProperty logsBackupConfigurationProperty = LogsBackupConfigurationProperty.builder()
     *         .region("region")
     *         // the properties below are optional
     *         .kmsKeyArn("kmsKeyArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-logsbackupconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-logsbackupconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_observabilityadmin.CfnOrganizationCentralizationRule.LogsBackupConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LogsBackupConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogsBackupConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Logs specific backup destination region within the primary destination account to which log data should be centralized.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-logsbackupconfiguration.html#cfn-observabilityadmin-organizationcentralizationrule-logsbackupconfiguration-region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-logsbackupconfiguration.html#cfn-observabilityadmin-organizationcentralizationrule-logsbackupconfiguration-region</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRegion();

        /**
         * KMS Key ARN belonging to the primary destination account and backup region, to encrypt newly created central log groups in the backup destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-logsbackupconfiguration.html#cfn-observabilityadmin-organizationcentralizationrule-logsbackupconfiguration-kmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-logsbackupconfiguration.html#cfn-observabilityadmin-organizationcentralizationrule-logsbackupconfiguration-kmskeyarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LogsBackupConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogsBackupConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogsBackupConfigurationProperty> {
            java.lang.String region;
            java.lang.String kmsKeyArn;

            /**
             * Sets the value of {@link LogsBackupConfigurationProperty#getRegion}
             * @param region Logs specific backup destination region within the primary destination account to which log data should be centralized. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Sets the value of {@link LogsBackupConfigurationProperty#getKmsKeyArn}
             * @param kmsKeyArn KMS Key ARN belonging to the primary destination account and backup region, to encrypt newly created central log groups in the backup destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogsBackupConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogsBackupConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogsBackupConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogsBackupConfigurationProperty {
            private final java.lang.String region;
            private final java.lang.String kmsKeyArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.region = java.util.Objects.requireNonNull(builder.region, "region is required");
                this.kmsKeyArn = builder.kmsKeyArn;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            public final java.lang.String getKmsKeyArn() {
                return this.kmsKeyArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("region", om.valueToTree(this.getRegion()));
                if (this.getKmsKeyArn() != null) {
                    data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_observabilityadmin.CfnOrganizationCentralizationRule.LogsBackupConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogsBackupConfigurationProperty.Jsii$Proxy that = (LogsBackupConfigurationProperty.Jsii$Proxy) o;

                if (!region.equals(that.region)) return false;
                return this.kmsKeyArn != null ? this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.region.hashCode();
                result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for encrypting centralized log groups.
     * <p>
     * This configuration is only applied to destination log groups for which the corresponding source log groups are encrypted using Customer Managed KMS Keys.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.observabilityadmin.*;
     * LogsEncryptionConfigurationProperty logsEncryptionConfigurationProperty = LogsEncryptionConfigurationProperty.builder()
     *         .encryptionStrategy("encryptionStrategy")
     *         // the properties below are optional
     *         .encryptionConflictResolutionStrategy("encryptionConflictResolutionStrategy")
     *         .kmsKeyArn("kmsKeyArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-logsencryptionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-logsencryptionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_observabilityadmin.CfnOrganizationCentralizationRule.LogsEncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LogsEncryptionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogsEncryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration that determines the encryption strategy of the destination log groups.
         * <p>
         * CUSTOMER_MANAGED uses the configured KmsKeyArn to encrypt newly created destination log groups.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-logsencryptionconfiguration.html#cfn-observabilityadmin-organizationcentralizationrule-logsencryptionconfiguration-encryptionstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-logsencryptionconfiguration.html#cfn-observabilityadmin-organizationcentralizationrule-logsencryptionconfiguration-encryptionstrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEncryptionStrategy();

        /**
         * Conflict resolution strategy for centralization if the encryption strategy is set to CUSTOMER_MANAGED and the destination log group is encrypted with an AWS_OWNED KMS Key.
         * <p>
         * ALLOW lets centralization go through while SKIP prevents centralization into the destination log group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-logsencryptionconfiguration.html#cfn-observabilityadmin-organizationcentralizationrule-logsencryptionconfiguration-encryptionconflictresolutionstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-logsencryptionconfiguration.html#cfn-observabilityadmin-organizationcentralizationrule-logsencryptionconfiguration-encryptionconflictresolutionstrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEncryptionConflictResolutionStrategy() {
            return null;
        }

        /**
         * KMS Key ARN belonging to the primary destination account and region, to encrypt newly created central log groups in the primary destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-logsencryptionconfiguration.html#cfn-observabilityadmin-organizationcentralizationrule-logsencryptionconfiguration-kmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-logsencryptionconfiguration.html#cfn-observabilityadmin-organizationcentralizationrule-logsencryptionconfiguration-kmskeyarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LogsEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogsEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogsEncryptionConfigurationProperty> {
            java.lang.String encryptionStrategy;
            java.lang.String encryptionConflictResolutionStrategy;
            java.lang.String kmsKeyArn;

            /**
             * Sets the value of {@link LogsEncryptionConfigurationProperty#getEncryptionStrategy}
             * @param encryptionStrategy Configuration that determines the encryption strategy of the destination log groups. This parameter is required.
             *                           CUSTOMER_MANAGED uses the configured KmsKeyArn to encrypt newly created destination log groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionStrategy(java.lang.String encryptionStrategy) {
                this.encryptionStrategy = encryptionStrategy;
                return this;
            }

            /**
             * Sets the value of {@link LogsEncryptionConfigurationProperty#getEncryptionConflictResolutionStrategy}
             * @param encryptionConflictResolutionStrategy Conflict resolution strategy for centralization if the encryption strategy is set to CUSTOMER_MANAGED and the destination log group is encrypted with an AWS_OWNED KMS Key.
             *                                             ALLOW lets centralization go through while SKIP prevents centralization into the destination log group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConflictResolutionStrategy(java.lang.String encryptionConflictResolutionStrategy) {
                this.encryptionConflictResolutionStrategy = encryptionConflictResolutionStrategy;
                return this;
            }

            /**
             * Sets the value of {@link LogsEncryptionConfigurationProperty#getKmsKeyArn}
             * @param kmsKeyArn KMS Key ARN belonging to the primary destination account and region, to encrypt newly created central log groups in the primary destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogsEncryptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogsEncryptionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogsEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogsEncryptionConfigurationProperty {
            private final java.lang.String encryptionStrategy;
            private final java.lang.String encryptionConflictResolutionStrategy;
            private final java.lang.String kmsKeyArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encryptionStrategy = software.amazon.jsii.Kernel.get(this, "encryptionStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.encryptionConflictResolutionStrategy = software.amazon.jsii.Kernel.get(this, "encryptionConflictResolutionStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encryptionStrategy = java.util.Objects.requireNonNull(builder.encryptionStrategy, "encryptionStrategy is required");
                this.encryptionConflictResolutionStrategy = builder.encryptionConflictResolutionStrategy;
                this.kmsKeyArn = builder.kmsKeyArn;
            }

            @Override
            public final java.lang.String getEncryptionStrategy() {
                return this.encryptionStrategy;
            }

            @Override
            public final java.lang.String getEncryptionConflictResolutionStrategy() {
                return this.encryptionConflictResolutionStrategy;
            }

            @Override
            public final java.lang.String getKmsKeyArn() {
                return this.kmsKeyArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("encryptionStrategy", om.valueToTree(this.getEncryptionStrategy()));
                if (this.getEncryptionConflictResolutionStrategy() != null) {
                    data.set("encryptionConflictResolutionStrategy", om.valueToTree(this.getEncryptionConflictResolutionStrategy()));
                }
                if (this.getKmsKeyArn() != null) {
                    data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_observabilityadmin.CfnOrganizationCentralizationRule.LogsEncryptionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogsEncryptionConfigurationProperty.Jsii$Proxy that = (LogsEncryptionConfigurationProperty.Jsii$Proxy) o;

                if (!encryptionStrategy.equals(that.encryptionStrategy)) return false;
                if (this.encryptionConflictResolutionStrategy != null ? !this.encryptionConflictResolutionStrategy.equals(that.encryptionConflictResolutionStrategy) : that.encryptionConflictResolutionStrategy != null) return false;
                return this.kmsKeyArn != null ? this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encryptionStrategy.hashCode();
                result = 31 * result + (this.encryptionConflictResolutionStrategy != null ? this.encryptionConflictResolutionStrategy.hashCode() : 0);
                result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for selecting and handling source log groups for centralization.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.observabilityadmin.*;
     * SourceLogsConfigurationProperty sourceLogsConfigurationProperty = SourceLogsConfigurationProperty.builder()
     *         .encryptedLogGroupStrategy("encryptedLogGroupStrategy")
     *         .logGroupSelectionCriteria("logGroupSelectionCriteria")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-sourcelogsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-sourcelogsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_observabilityadmin.CfnOrganizationCentralizationRule.SourceLogsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceLogsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceLogsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A strategy determining whether to centralize source log groups that are encrypted with customer managed KMS keys (CMK).
         * <p>
         * ALLOW will consider CMK encrypted source log groups for centralization while SKIP will skip CMK encrypted source log groups from centralization.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-sourcelogsconfiguration.html#cfn-observabilityadmin-organizationcentralizationrule-sourcelogsconfiguration-encryptedloggroupstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-sourcelogsconfiguration.html#cfn-observabilityadmin-organizationcentralizationrule-sourcelogsconfiguration-encryptedloggroupstrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEncryptedLogGroupStrategy();

        /**
         * The selection criteria that specifies which source log groups to centralize.
         * <p>
         * The selection criteria uses the same format as OAM link filters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-sourcelogsconfiguration.html#cfn-observabilityadmin-organizationcentralizationrule-sourcelogsconfiguration-loggroupselectioncriteria">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-observabilityadmin-organizationcentralizationrule-sourcelogsconfiguration.html#cfn-observabilityadmin-organizationcentralizationrule-sourcelogsconfiguration-loggroupselectioncriteria</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogGroupSelectionCriteria();

        /**
         * @return a {@link Builder} of {@link SourceLogsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceLogsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceLogsConfigurationProperty> {
            java.lang.String encryptedLogGroupStrategy;
            java.lang.String logGroupSelectionCriteria;

            /**
             * Sets the value of {@link SourceLogsConfigurationProperty#getEncryptedLogGroupStrategy}
             * @param encryptedLogGroupStrategy A strategy determining whether to centralize source log groups that are encrypted with customer managed KMS keys (CMK). This parameter is required.
             *                                  ALLOW will consider CMK encrypted source log groups for centralization while SKIP will skip CMK encrypted source log groups from centralization.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptedLogGroupStrategy(java.lang.String encryptedLogGroupStrategy) {
                this.encryptedLogGroupStrategy = encryptedLogGroupStrategy;
                return this;
            }

            /**
             * Sets the value of {@link SourceLogsConfigurationProperty#getLogGroupSelectionCriteria}
             * @param logGroupSelectionCriteria The selection criteria that specifies which source log groups to centralize. This parameter is required.
             *                                  The selection criteria uses the same format as OAM link filters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logGroupSelectionCriteria(java.lang.String logGroupSelectionCriteria) {
                this.logGroupSelectionCriteria = logGroupSelectionCriteria;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceLogsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceLogsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceLogsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceLogsConfigurationProperty {
            private final java.lang.String encryptedLogGroupStrategy;
            private final java.lang.String logGroupSelectionCriteria;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encryptedLogGroupStrategy = software.amazon.jsii.Kernel.get(this, "encryptedLogGroupStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logGroupSelectionCriteria = software.amazon.jsii.Kernel.get(this, "logGroupSelectionCriteria", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encryptedLogGroupStrategy = java.util.Objects.requireNonNull(builder.encryptedLogGroupStrategy, "encryptedLogGroupStrategy is required");
                this.logGroupSelectionCriteria = java.util.Objects.requireNonNull(builder.logGroupSelectionCriteria, "logGroupSelectionCriteria is required");
            }

            @Override
            public final java.lang.String getEncryptedLogGroupStrategy() {
                return this.encryptedLogGroupStrategy;
            }

            @Override
            public final java.lang.String getLogGroupSelectionCriteria() {
                return this.logGroupSelectionCriteria;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("encryptedLogGroupStrategy", om.valueToTree(this.getEncryptedLogGroupStrategy()));
                data.set("logGroupSelectionCriteria", om.valueToTree(this.getLogGroupSelectionCriteria()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_observabilityadmin.CfnOrganizationCentralizationRule.SourceLogsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceLogsConfigurationProperty.Jsii$Proxy that = (SourceLogsConfigurationProperty.Jsii$Proxy) o;

                if (!encryptedLogGroupStrategy.equals(that.encryptedLogGroupStrategy)) return false;
                return this.logGroupSelectionCriteria.equals(that.logGroupSelectionCriteria);
            }

            @Override
            public final int hashCode() {
                int result = this.encryptedLogGroupStrategy.hashCode();
                result = 31 * result + (this.logGroupSelectionCriteria.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.observabilityadmin.CfnOrganizationCentralizationRule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.observabilityadmin.CfnOrganizationCentralizationRule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.observabilityadmin.CfnOrganizationCentralizationRuleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.observabilityadmin.CfnOrganizationCentralizationRuleProps.Builder();
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-observabilityadmin-organizationcentralizationrule.html#cfn-observabilityadmin-organizationcentralizationrule-rule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-observabilityadmin-organizationcentralizationrule.html#cfn-observabilityadmin-organizationcentralizationrule-rule</a>
         * @param rule This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rule(final software.amazon.awscdk.IResolvable rule) {
            this.props.rule(rule);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-observabilityadmin-organizationcentralizationrule.html#cfn-observabilityadmin-organizationcentralizationrule-rule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-observabilityadmin-organizationcentralizationrule.html#cfn-observabilityadmin-organizationcentralizationrule-rule</a>
         * @param rule This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rule(final software.amazon.awscdk.services.observabilityadmin.CfnOrganizationCentralizationRule.CentralizationRuleProperty rule) {
            this.props.rule(rule);
            return this;
        }

        /**
         * The name of the organization centralization rule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-observabilityadmin-organizationcentralizationrule.html#cfn-observabilityadmin-organizationcentralizationrule-rulename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-observabilityadmin-organizationcentralizationrule.html#cfn-observabilityadmin-organizationcentralizationrule-rulename</a>
         * @param ruleName The name of the organization centralization rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleName(final java.lang.String ruleName) {
            this.props.ruleName(ruleName);
            return this;
        }

        /**
         * A key-value pair to filter resources based on tags associated with the resource.
         * <p>
         * For more information about tags, see <a href="https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/what-are-tags.html">What are tags?</a>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-observabilityadmin-organizationcentralizationrule.html#cfn-observabilityadmin-organizationcentralizationrule-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-observabilityadmin-organizationcentralizationrule.html#cfn-observabilityadmin-organizationcentralizationrule-tags</a>
         * @param tags A key-value pair to filter resources based on tags associated with the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.observabilityadmin.CfnOrganizationCentralizationRule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.observabilityadmin.CfnOrganizationCentralizationRule build() {
            return new software.amazon.awscdk.services.observabilityadmin.CfnOrganizationCentralizationRule(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
