package software.amazon.awscdk.services.odb;

/**
 * The <code>AWS::ODB::CloudAutonomousVmCluster</code> resource creates an Autonomous VM cluster.
 * <p>
 * An Autonomous VM cluster provides the infrastructure for running Autonomous Databases.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.odb.*;
 * CfnCloudAutonomousVmCluster cfnCloudAutonomousVmCluster = CfnCloudAutonomousVmCluster.Builder.create(this, "MyCfnCloudAutonomousVmCluster")
 *         .autonomousDataStorageSizeInTBs(123)
 *         .cloudExadataInfrastructureId("cloudExadataInfrastructureId")
 *         .cpuCoreCountPerNode(123)
 *         .dbServers(List.of("dbServers"))
 *         .description("description")
 *         .displayName("displayName")
 *         .isMtlsEnabledVmCluster(false)
 *         .licenseModel("licenseModel")
 *         .maintenanceWindow(MaintenanceWindowProperty.builder()
 *                 .daysOfWeek(List.of("daysOfWeek"))
 *                 .hoursOfDay(List.of(123))
 *                 .leadTimeInWeeks(123)
 *                 .months(List.of("months"))
 *                 .preference("preference")
 *                 .weeksOfMonth(List.of(123))
 *                 .build())
 *         .memoryPerOracleComputeUnitInGBs(123)
 *         .odbNetworkId("odbNetworkId")
 *         .scanListenerPortNonTls(123)
 *         .scanListenerPortTls(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .timeZone("timeZone")
 *         .totalContainerDatabases(123)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:10.395Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_odb.CfnCloudAutonomousVmCluster")
public class CfnCloudAutonomousVmCluster extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.services.odb.ICloudAutonomousVmClusterRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnCloudAutonomousVmCluster(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCloudAutonomousVmCluster(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.odb.CfnCloudAutonomousVmCluster.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCloudAutonomousVmCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.odb.CfnCloudAutonomousVmClusterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCloudAutonomousVmCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The percentage of data storage currently in use for Autonomous Databases in the Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrAutonomousDataStoragePercentage() {
        return software.amazon.jsii.Kernel.get(this, "attrAutonomousDataStoragePercentage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The available data storage space for Autonomous Databases in the Autonomous VM cluster, in TB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrAvailableAutonomousDataStorageSizeInTBs() {
        return software.amazon.jsii.Kernel.get(this, "attrAvailableAutonomousDataStorageSizeInTBs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The number of Autonomous CDBs that you can create with the currently available storage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrAvailableContainerDatabases() {
        return software.amazon.jsii.Kernel.get(this, "attrAvailableContainerDatabases", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of CPU cores available for allocation to Autonomous Databases.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrAvailableCpus() {
        return software.amazon.jsii.Kernel.get(this, "attrAvailableCpus", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The Amazon Resource Name (ARN) for the Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCloudAutonomousVmClusterArn() {
        return software.amazon.jsii.Kernel.get(this, "attrCloudAutonomousVmClusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCloudAutonomousVmClusterId() {
        return software.amazon.jsii.Kernel.get(this, "attrCloudAutonomousVmClusterId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The compute model of the Autonomous VM cluster: ECPU or OCPU.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrComputeModel() {
        return software.amazon.jsii.Kernel.get(this, "attrComputeModel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The total number of CPU cores in the Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrCpuCoreCount() {
        return software.amazon.jsii.Kernel.get(this, "attrCpuCoreCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The percentage of total CPU cores currently in use in the Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrCpuPercentage() {
        return software.amazon.jsii.Kernel.get(this, "attrCpuPercentage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The total data storage allocated to the Autonomous VM cluster, in GB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrDataStorageSizeInGBs() {
        return software.amazon.jsii.Kernel.get(this, "attrDataStorageSizeInGBs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The total data storage allocated to the Autonomous VM cluster, in TB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrDataStorageSizeInTBs() {
        return software.amazon.jsii.Kernel.get(this, "attrDataStorageSizeInTBs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The local node storage allocated to the Autonomous VM cluster, in gigabytes (GB).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrDbNodeStorageSizeInGBs() {
        return software.amazon.jsii.Kernel.get(this, "attrDbNodeStorageSizeInGBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The domain name for the Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDomain() {
        return software.amazon.jsii.Kernel.get(this, "attrDomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The minimum value to which you can scale down the Exadata storage, in TB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrExadataStorageInTBsLowestScaledValue() {
        return software.amazon.jsii.Kernel.get(this, "attrExadataStorageInTBsLowestScaledValue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The hostname for the Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrHostname() {
        return software.amazon.jsii.Kernel.get(this, "attrHostname", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The minimum value to which you can scale down the maximum number of Autonomous CDBs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrMaxAcdsLowestScaledValue() {
        return software.amazon.jsii.Kernel.get(this, "attrMaxAcdsLowestScaledValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The total amount of memory allocated to the Autonomous VM cluster, in gigabytes (GB).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrMemorySizeInGBs() {
        return software.amazon.jsii.Kernel.get(this, "attrMemorySizeInGBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of database server nodes in the Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrNodeCount() {
        return software.amazon.jsii.Kernel.get(this, "attrNodeCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of Autonomous CDBs that can't be provisioned because of resource constraints.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrNonProvisionableAutonomousContainerDatabases() {
        return software.amazon.jsii.Kernel.get(this, "attrNonProvisionableAutonomousContainerDatabases", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The Oracle Cloud Identifier (OCID) of the Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrOcid() {
        return software.amazon.jsii.Kernel.get(this, "attrOcid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the OCI resource anchor associated with this Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrOciResourceAnchorName() {
        return software.amazon.jsii.Kernel.get(this, "attrOciResourceAnchorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The URL for accessing the OCI console page for this Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrOciUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrOciUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The number of Autonomous CDBs that can be provisioned in the Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrProvisionableAutonomousContainerDatabases() {
        return software.amazon.jsii.Kernel.get(this, "attrProvisionableAutonomousContainerDatabases", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of Autonomous CDBs currently provisioned in the Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrProvisionedAutonomousContainerDatabases() {
        return software.amazon.jsii.Kernel.get(this, "attrProvisionedAutonomousContainerDatabases", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of CPU cores currently provisioned in the Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrProvisionedCpus() {
        return software.amazon.jsii.Kernel.get(this, "attrProvisionedCpus", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The number of CPU cores that can be reclaimed from terminated or scaled-down Autonomous Databases.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrReclaimableCpus() {
        return software.amazon.jsii.Kernel.get(this, "attrReclaimableCpus", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The number of CPU cores reserved for system operations and redundancy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrReservedCpus() {
        return software.amazon.jsii.Kernel.get(this, "attrReservedCpus", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The shape of the Exadata infrastructure for the Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrShape() {
        return software.amazon.jsii.Kernel.get(this, "attrShape", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a CloudAutonomousVmCluster resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.odb.CloudAutonomousVmClusterReference getCloudAutonomousVmClusterRef() {
        return software.amazon.jsii.Kernel.get(this, "cloudAutonomousVmClusterRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.odb.CloudAutonomousVmClusterReference.class));
    }

    /**
     * The data storage size allocated for Autonomous Databases in the Autonomous VM cluster, in TB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getAutonomousDataStorageSizeInTBs() {
        return software.amazon.jsii.Kernel.get(this, "autonomousDataStorageSizeInTBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The data storage size allocated for Autonomous Databases in the Autonomous VM cluster, in TB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutonomousDataStorageSizeInTBs(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "autonomousDataStorageSizeInTBs", value);
    }

    /**
     * The unique identifier of the Cloud Exadata Infrastructure containing this Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCloudExadataInfrastructureId() {
        return software.amazon.jsii.Kernel.get(this, "cloudExadataInfrastructureId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the Cloud Exadata Infrastructure containing this Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCloudExadataInfrastructureId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cloudExadataInfrastructureId", value);
    }

    /**
     * The number of CPU cores enabled per node in the Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getCpuCoreCountPerNode() {
        return software.amazon.jsii.Kernel.get(this, "cpuCoreCountPerNode", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of CPU cores enabled per node in the Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCpuCoreCountPerNode(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "cpuCoreCountPerNode", value);
    }

    /**
     * The list of database servers associated with the Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDbServers() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "dbServers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The list of database servers associated with the Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbServers(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "dbServers", value);
    }

    /**
     * The user-provided description of the Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The user-provided description of the Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The display name of the Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDisplayName() {
        return software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The display name of the Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisplayName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "displayName", value);
    }

    /**
     * Specifies whether mutual TLS (mTLS) authentication is enabled for the Autonomous VM cluster.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIsMtlsEnabledVmCluster() {
        return software.amazon.jsii.Kernel.get(this, "isMtlsEnabledVmCluster", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether mutual TLS (mTLS) authentication is enabled for the Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsMtlsEnabledVmCluster(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "isMtlsEnabledVmCluster", value);
    }

    /**
     * Specifies whether mutual TLS (mTLS) authentication is enabled for the Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsMtlsEnabledVmCluster(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "isMtlsEnabledVmCluster", value);
    }

    /**
     * The Oracle license model that applies to the Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLicenseModel() {
        return software.amazon.jsii.Kernel.get(this, "licenseModel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Oracle license model that applies to the Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLicenseModel(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "licenseModel", value);
    }

    /**
     * The scheduling details for the maintenance window.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.odb.CfnCloudAutonomousVmCluster.MaintenanceWindowProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMaintenanceWindow() {
        return software.amazon.jsii.Kernel.get(this, "maintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The scheduling details for the maintenance window.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaintenanceWindow(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "maintenanceWindow", value);
    }

    /**
     * The scheduling details for the maintenance window.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaintenanceWindow(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.odb.CfnCloudAutonomousVmCluster.MaintenanceWindowProperty value) {
        software.amazon.jsii.Kernel.set(this, "maintenanceWindow", value);
    }

    /**
     * The amount of memory allocated per Oracle Compute Unit, in GB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMemoryPerOracleComputeUnitInGBs() {
        return software.amazon.jsii.Kernel.get(this, "memoryPerOracleComputeUnitInGBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The amount of memory allocated per Oracle Compute Unit, in GB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMemoryPerOracleComputeUnitInGBs(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "memoryPerOracleComputeUnitInGBs", value);
    }

    /**
     * The unique identifier of the ODB network associated with this Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getOdbNetworkId() {
        return software.amazon.jsii.Kernel.get(this, "odbNetworkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the ODB network associated with this Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOdbNetworkId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "odbNetworkId", value);
    }

    /**
     * The SCAN listener port for non-TLS (TCP) protocol.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getScanListenerPortNonTls() {
        return software.amazon.jsii.Kernel.get(this, "scanListenerPortNonTls", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The SCAN listener port for non-TLS (TCP) protocol.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScanListenerPortNonTls(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "scanListenerPortNonTls", value);
    }

    /**
     * The SCAN listener port for TLS (TCP) protocol.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getScanListenerPortTls() {
        return software.amazon.jsii.Kernel.get(this, "scanListenerPortTls", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The SCAN listener port for TLS (TCP) protocol.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScanListenerPortTls(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "scanListenerPortTls", value);
    }

    /**
     * Tags to assign to the Autonomous Vm Cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Tags to assign to the Autonomous Vm Cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * The time zone of the Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTimeZone() {
        return software.amazon.jsii.Kernel.get(this, "timeZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time zone of the Autonomous VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeZone(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "timeZone", value);
    }

    /**
     * The total number of Autonomous Container Databases that can be created with the allocated local storage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getTotalContainerDatabases() {
        return software.amazon.jsii.Kernel.get(this, "totalContainerDatabases", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The total number of Autonomous Container Databases that can be created with the allocated local storage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTotalContainerDatabases(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "totalContainerDatabases", value);
    }
    /**
     * The scheduling details for the maintenance window.
     * <p>
     * Patching and system updates take place during the maintenance window.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.odb.*;
     * MaintenanceWindowProperty maintenanceWindowProperty = MaintenanceWindowProperty.builder()
     *         .daysOfWeek(List.of("daysOfWeek"))
     *         .hoursOfDay(List.of(123))
     *         .leadTimeInWeeks(123)
     *         .months(List.of("months"))
     *         .preference("preference")
     *         .weeksOfMonth(List.of(123))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudautonomousvmcluster-maintenancewindow.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudautonomousvmcluster-maintenancewindow.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_odb.CfnCloudAutonomousVmCluster.MaintenanceWindowProperty")
    @software.amazon.jsii.Jsii.Proxy(MaintenanceWindowProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MaintenanceWindowProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The days of the week when maintenance can be performed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudautonomousvmcluster-maintenancewindow.html#cfn-odb-cloudautonomousvmcluster-maintenancewindow-daysofweek">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudautonomousvmcluster-maintenancewindow.html#cfn-odb-cloudautonomousvmcluster-maintenancewindow-daysofweek</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDaysOfWeek() {
            return null;
        }

        /**
         * The hours of the day when maintenance can be performed.
         * <p>
         * Returns union: either List<{@link java.lang.Number}> or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudautonomousvmcluster-maintenancewindow.html#cfn-odb-cloudautonomousvmcluster-maintenancewindow-hoursofday">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudautonomousvmcluster-maintenancewindow.html#cfn-odb-cloudautonomousvmcluster-maintenancewindow-hoursofday</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHoursOfDay() {
            return null;
        }

        /**
         * The lead time in weeks before the maintenance window.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudautonomousvmcluster-maintenancewindow.html#cfn-odb-cloudautonomousvmcluster-maintenancewindow-leadtimeinweeks">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudautonomousvmcluster-maintenancewindow.html#cfn-odb-cloudautonomousvmcluster-maintenancewindow-leadtimeinweeks</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLeadTimeInWeeks() {
            return null;
        }

        /**
         * The months when maintenance can be performed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudautonomousvmcluster-maintenancewindow.html#cfn-odb-cloudautonomousvmcluster-maintenancewindow-months">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudautonomousvmcluster-maintenancewindow.html#cfn-odb-cloudautonomousvmcluster-maintenancewindow-months</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMonths() {
            return null;
        }

        /**
         * The preference for the maintenance window scheduling.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudautonomousvmcluster-maintenancewindow.html#cfn-odb-cloudautonomousvmcluster-maintenancewindow-preference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudautonomousvmcluster-maintenancewindow.html#cfn-odb-cloudautonomousvmcluster-maintenancewindow-preference</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPreference() {
            return null;
        }

        /**
         * The weeks of the month when maintenance can be performed.
         * <p>
         * Returns union: either List<{@link java.lang.Number}> or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudautonomousvmcluster-maintenancewindow.html#cfn-odb-cloudautonomousvmcluster-maintenancewindow-weeksofmonth">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudautonomousvmcluster-maintenancewindow.html#cfn-odb-cloudautonomousvmcluster-maintenancewindow-weeksofmonth</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWeeksOfMonth() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MaintenanceWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MaintenanceWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MaintenanceWindowProperty> {
            java.util.List<java.lang.String> daysOfWeek;
            java.lang.Object hoursOfDay;
            java.lang.Number leadTimeInWeeks;
            java.util.List<java.lang.String> months;
            java.lang.String preference;
            java.lang.Object weeksOfMonth;

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getDaysOfWeek}
             * @param daysOfWeek The days of the week when maintenance can be performed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder daysOfWeek(java.util.List<java.lang.String> daysOfWeek) {
                this.daysOfWeek = daysOfWeek;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getHoursOfDay}
             * @param hoursOfDay The hours of the day when maintenance can be performed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hoursOfDay(java.util.List<? extends java.lang.Number> hoursOfDay) {
                this.hoursOfDay = hoursOfDay;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getHoursOfDay}
             * @param hoursOfDay The hours of the day when maintenance can be performed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hoursOfDay(software.amazon.awscdk.IResolvable hoursOfDay) {
                this.hoursOfDay = hoursOfDay;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getLeadTimeInWeeks}
             * @param leadTimeInWeeks The lead time in weeks before the maintenance window.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder leadTimeInWeeks(java.lang.Number leadTimeInWeeks) {
                this.leadTimeInWeeks = leadTimeInWeeks;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getMonths}
             * @param months The months when maintenance can be performed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder months(java.util.List<java.lang.String> months) {
                this.months = months;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getPreference}
             * @param preference The preference for the maintenance window scheduling.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preference(java.lang.String preference) {
                this.preference = preference;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getWeeksOfMonth}
             * @param weeksOfMonth The weeks of the month when maintenance can be performed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weeksOfMonth(java.util.List<? extends java.lang.Number> weeksOfMonth) {
                this.weeksOfMonth = weeksOfMonth;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getWeeksOfMonth}
             * @param weeksOfMonth The weeks of the month when maintenance can be performed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weeksOfMonth(software.amazon.awscdk.IResolvable weeksOfMonth) {
                this.weeksOfMonth = weeksOfMonth;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MaintenanceWindowProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MaintenanceWindowProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MaintenanceWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MaintenanceWindowProperty {
            private final java.util.List<java.lang.String> daysOfWeek;
            private final java.lang.Object hoursOfDay;
            private final java.lang.Number leadTimeInWeeks;
            private final java.util.List<java.lang.String> months;
            private final java.lang.String preference;
            private final java.lang.Object weeksOfMonth;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.daysOfWeek = software.amazon.jsii.Kernel.get(this, "daysOfWeek", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.hoursOfDay = software.amazon.jsii.Kernel.get(this, "hoursOfDay", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.leadTimeInWeeks = software.amazon.jsii.Kernel.get(this, "leadTimeInWeeks", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.months = software.amazon.jsii.Kernel.get(this, "months", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.preference = software.amazon.jsii.Kernel.get(this, "preference", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.weeksOfMonth = software.amazon.jsii.Kernel.get(this, "weeksOfMonth", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.daysOfWeek = builder.daysOfWeek;
                this.hoursOfDay = builder.hoursOfDay;
                this.leadTimeInWeeks = builder.leadTimeInWeeks;
                this.months = builder.months;
                this.preference = builder.preference;
                this.weeksOfMonth = builder.weeksOfMonth;
            }

            @Override
            public final java.util.List<java.lang.String> getDaysOfWeek() {
                return this.daysOfWeek;
            }

            @Override
            public final java.lang.Object getHoursOfDay() {
                return this.hoursOfDay;
            }

            @Override
            public final java.lang.Number getLeadTimeInWeeks() {
                return this.leadTimeInWeeks;
            }

            @Override
            public final java.util.List<java.lang.String> getMonths() {
                return this.months;
            }

            @Override
            public final java.lang.String getPreference() {
                return this.preference;
            }

            @Override
            public final java.lang.Object getWeeksOfMonth() {
                return this.weeksOfMonth;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDaysOfWeek() != null) {
                    data.set("daysOfWeek", om.valueToTree(this.getDaysOfWeek()));
                }
                if (this.getHoursOfDay() != null) {
                    data.set("hoursOfDay", om.valueToTree(this.getHoursOfDay()));
                }
                if (this.getLeadTimeInWeeks() != null) {
                    data.set("leadTimeInWeeks", om.valueToTree(this.getLeadTimeInWeeks()));
                }
                if (this.getMonths() != null) {
                    data.set("months", om.valueToTree(this.getMonths()));
                }
                if (this.getPreference() != null) {
                    data.set("preference", om.valueToTree(this.getPreference()));
                }
                if (this.getWeeksOfMonth() != null) {
                    data.set("weeksOfMonth", om.valueToTree(this.getWeeksOfMonth()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_odb.CfnCloudAutonomousVmCluster.MaintenanceWindowProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MaintenanceWindowProperty.Jsii$Proxy that = (MaintenanceWindowProperty.Jsii$Proxy) o;

                if (this.daysOfWeek != null ? !this.daysOfWeek.equals(that.daysOfWeek) : that.daysOfWeek != null) return false;
                if (this.hoursOfDay != null ? !this.hoursOfDay.equals(that.hoursOfDay) : that.hoursOfDay != null) return false;
                if (this.leadTimeInWeeks != null ? !this.leadTimeInWeeks.equals(that.leadTimeInWeeks) : that.leadTimeInWeeks != null) return false;
                if (this.months != null ? !this.months.equals(that.months) : that.months != null) return false;
                if (this.preference != null ? !this.preference.equals(that.preference) : that.preference != null) return false;
                return this.weeksOfMonth != null ? this.weeksOfMonth.equals(that.weeksOfMonth) : that.weeksOfMonth == null;
            }

            @Override
            public final int hashCode() {
                int result = this.daysOfWeek != null ? this.daysOfWeek.hashCode() : 0;
                result = 31 * result + (this.hoursOfDay != null ? this.hoursOfDay.hashCode() : 0);
                result = 31 * result + (this.leadTimeInWeeks != null ? this.leadTimeInWeeks.hashCode() : 0);
                result = 31 * result + (this.months != null ? this.months.hashCode() : 0);
                result = 31 * result + (this.preference != null ? this.preference.hashCode() : 0);
                result = 31 * result + (this.weeksOfMonth != null ? this.weeksOfMonth.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.odb.CfnCloudAutonomousVmCluster}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.odb.CfnCloudAutonomousVmCluster> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.odb.CfnCloudAutonomousVmClusterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The data storage size allocated for Autonomous Databases in the Autonomous VM cluster, in TB.
         * <p>
         * Required when creating an Autonomous VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-autonomousdatastoragesizeintbs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-autonomousdatastoragesizeintbs</a>
         * @param autonomousDataStorageSizeInTBs The data storage size allocated for Autonomous Databases in the Autonomous VM cluster, in TB. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autonomousDataStorageSizeInTBs(final java.lang.Number autonomousDataStorageSizeInTBs) {
            this.props().autonomousDataStorageSizeInTBs(autonomousDataStorageSizeInTBs);
            return this;
        }

        /**
         * The unique identifier of the Cloud Exadata Infrastructure containing this Autonomous VM cluster.
         * <p>
         * Required when creating an Autonomous VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-cloudexadatainfrastructureid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-cloudexadatainfrastructureid</a>
         * @param cloudExadataInfrastructureId The unique identifier of the Cloud Exadata Infrastructure containing this Autonomous VM cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudExadataInfrastructureId(final java.lang.String cloudExadataInfrastructureId) {
            this.props().cloudExadataInfrastructureId(cloudExadataInfrastructureId);
            return this;
        }

        /**
         * The number of CPU cores enabled per node in the Autonomous VM cluster.
         * <p>
         * Required when creating an Autonomous VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-cpucorecountpernode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-cpucorecountpernode</a>
         * @param cpuCoreCountPerNode The number of CPU cores enabled per node in the Autonomous VM cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpuCoreCountPerNode(final java.lang.Number cpuCoreCountPerNode) {
            this.props().cpuCoreCountPerNode(cpuCoreCountPerNode);
            return this;
        }

        /**
         * The list of database servers associated with the Autonomous VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-dbservers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-dbservers</a>
         * @param dbServers The list of database servers associated with the Autonomous VM cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbServers(final java.util.List<java.lang.String> dbServers) {
            this.props().dbServers(dbServers);
            return this;
        }

        /**
         * The user-provided description of the Autonomous VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-description</a>
         * @param description The user-provided description of the Autonomous VM cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * The display name of the Autonomous VM cluster.
         * <p>
         * Required when creating an Autonomous VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-displayname</a>
         * @param displayName The display name of the Autonomous VM cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(final java.lang.String displayName) {
            this.props().displayName(displayName);
            return this;
        }

        /**
         * Specifies whether mutual TLS (mTLS) authentication is enabled for the Autonomous VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-ismtlsenabledvmcluster">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-ismtlsenabledvmcluster</a>
         * @param isMtlsEnabledVmCluster Specifies whether mutual TLS (mTLS) authentication is enabled for the Autonomous VM cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isMtlsEnabledVmCluster(final java.lang.Boolean isMtlsEnabledVmCluster) {
            this.props().isMtlsEnabledVmCluster(isMtlsEnabledVmCluster);
            return this;
        }
        /**
         * Specifies whether mutual TLS (mTLS) authentication is enabled for the Autonomous VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-ismtlsenabledvmcluster">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-ismtlsenabledvmcluster</a>
         * @param isMtlsEnabledVmCluster Specifies whether mutual TLS (mTLS) authentication is enabled for the Autonomous VM cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isMtlsEnabledVmCluster(final software.amazon.awscdk.IResolvable isMtlsEnabledVmCluster) {
            this.props().isMtlsEnabledVmCluster(isMtlsEnabledVmCluster);
            return this;
        }

        /**
         * The Oracle license model that applies to the Autonomous VM cluster.
         * <p>
         * Valid values are <code>LICENSE_INCLUDED</code> or <code>BRING_YOUR_OWN_LICENSE</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-licensemodel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-licensemodel</a>
         * @param licenseModel The Oracle license model that applies to the Autonomous VM cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder licenseModel(final java.lang.String licenseModel) {
            this.props().licenseModel(licenseModel);
            return this;
        }

        /**
         * The scheduling details for the maintenance window.
         * <p>
         * Patching and system updates take place during the maintenance window.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-maintenancewindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-maintenancewindow</a>
         * @param maintenanceWindow The scheduling details for the maintenance window. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceWindow(final software.amazon.awscdk.IResolvable maintenanceWindow) {
            this.props().maintenanceWindow(maintenanceWindow);
            return this;
        }
        /**
         * The scheduling details for the maintenance window.
         * <p>
         * Patching and system updates take place during the maintenance window.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-maintenancewindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-maintenancewindow</a>
         * @param maintenanceWindow The scheduling details for the maintenance window. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceWindow(final software.amazon.awscdk.services.odb.CfnCloudAutonomousVmCluster.MaintenanceWindowProperty maintenanceWindow) {
            this.props().maintenanceWindow(maintenanceWindow);
            return this;
        }

        /**
         * The amount of memory allocated per Oracle Compute Unit, in GB.
         * <p>
         * Required when creating an Autonomous VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-memoryperoraclecomputeunitingbs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-memoryperoraclecomputeunitingbs</a>
         * @param memoryPerOracleComputeUnitInGBs The amount of memory allocated per Oracle Compute Unit, in GB. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryPerOracleComputeUnitInGBs(final java.lang.Number memoryPerOracleComputeUnitInGBs) {
            this.props().memoryPerOracleComputeUnitInGBs(memoryPerOracleComputeUnitInGBs);
            return this;
        }

        /**
         * The unique identifier of the ODB network associated with this Autonomous VM cluster.
         * <p>
         * Required when creating an Autonomous VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-odbnetworkid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-odbnetworkid</a>
         * @param odbNetworkId The unique identifier of the ODB network associated with this Autonomous VM cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder odbNetworkId(final java.lang.String odbNetworkId) {
            this.props().odbNetworkId(odbNetworkId);
            return this;
        }

        /**
         * The SCAN listener port for non-TLS (TCP) protocol.
         * <p>
         * The default is 1521.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-scanlistenerportnontls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-scanlistenerportnontls</a>
         * @param scanListenerPortNonTls The SCAN listener port for non-TLS (TCP) protocol. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scanListenerPortNonTls(final java.lang.Number scanListenerPortNonTls) {
            this.props().scanListenerPortNonTls(scanListenerPortNonTls);
            return this;
        }

        /**
         * The SCAN listener port for TLS (TCP) protocol.
         * <p>
         * The default is 2484.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-scanlistenerporttls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-scanlistenerporttls</a>
         * @param scanListenerPortTls The SCAN listener port for TLS (TCP) protocol. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scanListenerPortTls(final java.lang.Number scanListenerPortTls) {
            this.props().scanListenerPortTls(scanListenerPortTls);
            return this;
        }

        /**
         * Tags to assign to the Autonomous Vm Cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-tags</a>
         * @param tags Tags to assign to the Autonomous Vm Cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * The time zone of the Autonomous VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-timezone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-timezone</a>
         * @param timeZone The time zone of the Autonomous VM cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeZone(final java.lang.String timeZone) {
            this.props().timeZone(timeZone);
            return this;
        }

        /**
         * The total number of Autonomous Container Databases that can be created with the allocated local storage.
         * <p>
         * Required when creating an Autonomous VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-totalcontainerdatabases">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudautonomousvmcluster.html#cfn-odb-cloudautonomousvmcluster-totalcontainerdatabases</a>
         * @param totalContainerDatabases The total number of Autonomous Container Databases that can be created with the allocated local storage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder totalContainerDatabases(final java.lang.Number totalContainerDatabases) {
            this.props().totalContainerDatabases(totalContainerDatabases);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.odb.CfnCloudAutonomousVmCluster}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.odb.CfnCloudAutonomousVmCluster build() {
            return new software.amazon.awscdk.services.odb.CfnCloudAutonomousVmCluster(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.odb.CfnCloudAutonomousVmClusterProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.odb.CfnCloudAutonomousVmClusterProps.Builder();
            }
            return this.props;
        }
    }
}
