package software.amazon.awscdk.services.omics;

/**
 * A reference to a ReferenceStore resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.omics.*;
 * ReferenceStoreReference referenceStoreReference = ReferenceStoreReference.builder()
 *         .referenceStoreArn("referenceStoreArn")
 *         .referenceStoreId("referenceStoreId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:10.476Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_omics.ReferenceStoreReference")
@software.amazon.jsii.Jsii.Proxy(ReferenceStoreReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ReferenceStoreReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the ReferenceStore resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getReferenceStoreArn();

    /**
     * The ReferenceStoreId of the ReferenceStore resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getReferenceStoreId();

    /**
     * @return a {@link Builder} of {@link ReferenceStoreReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ReferenceStoreReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ReferenceStoreReference> {
        java.lang.String referenceStoreArn;
        java.lang.String referenceStoreId;

        /**
         * Sets the value of {@link ReferenceStoreReference#getReferenceStoreArn}
         * @param referenceStoreArn The ARN of the ReferenceStore resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder referenceStoreArn(java.lang.String referenceStoreArn) {
            this.referenceStoreArn = referenceStoreArn;
            return this;
        }

        /**
         * Sets the value of {@link ReferenceStoreReference#getReferenceStoreId}
         * @param referenceStoreId The ReferenceStoreId of the ReferenceStore resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder referenceStoreId(java.lang.String referenceStoreId) {
            this.referenceStoreId = referenceStoreId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ReferenceStoreReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ReferenceStoreReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ReferenceStoreReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReferenceStoreReference {
        private final java.lang.String referenceStoreArn;
        private final java.lang.String referenceStoreId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.referenceStoreArn = software.amazon.jsii.Kernel.get(this, "referenceStoreArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.referenceStoreId = software.amazon.jsii.Kernel.get(this, "referenceStoreId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.referenceStoreArn = java.util.Objects.requireNonNull(builder.referenceStoreArn, "referenceStoreArn is required");
            this.referenceStoreId = java.util.Objects.requireNonNull(builder.referenceStoreId, "referenceStoreId is required");
        }

        @Override
        public final java.lang.String getReferenceStoreArn() {
            return this.referenceStoreArn;
        }

        @Override
        public final java.lang.String getReferenceStoreId() {
            return this.referenceStoreId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("referenceStoreArn", om.valueToTree(this.getReferenceStoreArn()));
            data.set("referenceStoreId", om.valueToTree(this.getReferenceStoreId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_omics.ReferenceStoreReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ReferenceStoreReference.Jsii$Proxy that = (ReferenceStoreReference.Jsii$Proxy) o;

            if (!referenceStoreArn.equals(that.referenceStoreArn)) return false;
            return this.referenceStoreId.equals(that.referenceStoreId);
        }

        @Override
        public final int hashCode() {
            int result = this.referenceStoreArn.hashCode();
            result = 31 * result + (this.referenceStoreId.hashCode());
            return result;
        }
    }
}
