package software.amazon.awscdk.services.organizations;

/**
 * A reference to a OrganizationalUnit resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.organizations.*;
 * OrganizationalUnitReference organizationalUnitReference = OrganizationalUnitReference.builder()
 *         .organizationalUnitArn("organizationalUnitArn")
 *         .organizationalUnitId("organizationalUnitId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:10.677Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_organizations.OrganizationalUnitReference")
@software.amazon.jsii.Jsii.Proxy(OrganizationalUnitReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OrganizationalUnitReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the OrganizationalUnit resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOrganizationalUnitArn();

    /**
     * The Id of the OrganizationalUnit resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOrganizationalUnitId();

    /**
     * @return a {@link Builder} of {@link OrganizationalUnitReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OrganizationalUnitReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OrganizationalUnitReference> {
        java.lang.String organizationalUnitArn;
        java.lang.String organizationalUnitId;

        /**
         * Sets the value of {@link OrganizationalUnitReference#getOrganizationalUnitArn}
         * @param organizationalUnitArn The ARN of the OrganizationalUnit resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationalUnitArn(java.lang.String organizationalUnitArn) {
            this.organizationalUnitArn = organizationalUnitArn;
            return this;
        }

        /**
         * Sets the value of {@link OrganizationalUnitReference#getOrganizationalUnitId}
         * @param organizationalUnitId The Id of the OrganizationalUnit resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationalUnitId(java.lang.String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OrganizationalUnitReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OrganizationalUnitReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OrganizationalUnitReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OrganizationalUnitReference {
        private final java.lang.String organizationalUnitArn;
        private final java.lang.String organizationalUnitId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.organizationalUnitArn = software.amazon.jsii.Kernel.get(this, "organizationalUnitArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.organizationalUnitId = software.amazon.jsii.Kernel.get(this, "organizationalUnitId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.organizationalUnitArn = java.util.Objects.requireNonNull(builder.organizationalUnitArn, "organizationalUnitArn is required");
            this.organizationalUnitId = java.util.Objects.requireNonNull(builder.organizationalUnitId, "organizationalUnitId is required");
        }

        @Override
        public final java.lang.String getOrganizationalUnitArn() {
            return this.organizationalUnitArn;
        }

        @Override
        public final java.lang.String getOrganizationalUnitId() {
            return this.organizationalUnitId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("organizationalUnitArn", om.valueToTree(this.getOrganizationalUnitArn()));
            data.set("organizationalUnitId", om.valueToTree(this.getOrganizationalUnitId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_organizations.OrganizationalUnitReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OrganizationalUnitReference.Jsii$Proxy that = (OrganizationalUnitReference.Jsii$Proxy) o;

            if (!organizationalUnitArn.equals(that.organizationalUnitArn)) return false;
            return this.organizationalUnitId.equals(that.organizationalUnitId);
        }

        @Override
        public final int hashCode() {
            int result = this.organizationalUnitArn.hashCode();
            result = 31 * result + (this.organizationalUnitId.hashCode());
            return result;
        }
    }
}
