package software.amazon.awscdk.services.pcs;

/**
 * A reference to a ComputeNodeGroup resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.pcs.*;
 * ComputeNodeGroupReference computeNodeGroupReference = ComputeNodeGroupReference.builder()
 *         .computeNodeGroupArn("computeNodeGroupArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:10.799Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcs.ComputeNodeGroupReference")
@software.amazon.jsii.Jsii.Proxy(ComputeNodeGroupReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ComputeNodeGroupReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the ComputeNodeGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getComputeNodeGroupArn();

    /**
     * @return a {@link Builder} of {@link ComputeNodeGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ComputeNodeGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ComputeNodeGroupReference> {
        java.lang.String computeNodeGroupArn;

        /**
         * Sets the value of {@link ComputeNodeGroupReference#getComputeNodeGroupArn}
         * @param computeNodeGroupArn The Arn of the ComputeNodeGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeNodeGroupArn(java.lang.String computeNodeGroupArn) {
            this.computeNodeGroupArn = computeNodeGroupArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ComputeNodeGroupReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ComputeNodeGroupReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ComputeNodeGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComputeNodeGroupReference {
        private final java.lang.String computeNodeGroupArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.computeNodeGroupArn = software.amazon.jsii.Kernel.get(this, "computeNodeGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.computeNodeGroupArn = java.util.Objects.requireNonNull(builder.computeNodeGroupArn, "computeNodeGroupArn is required");
        }

        @Override
        public final java.lang.String getComputeNodeGroupArn() {
            return this.computeNodeGroupArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("computeNodeGroupArn", om.valueToTree(this.getComputeNodeGroupArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcs.ComputeNodeGroupReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ComputeNodeGroupReference.Jsii$Proxy that = (ComputeNodeGroupReference.Jsii$Proxy) o;

            return this.computeNodeGroupArn.equals(that.computeNodeGroupArn);
        }

        @Override
        public final int hashCode() {
            int result = this.computeNodeGroupArn.hashCode();
            return result;
        }
    }
}
