package software.amazon.awscdk.services.pinpoint;

/**
 * Creates a message template that you can use in messages that are sent through a push notification channel.
 * <p>
 * A <em>message template</em> is a set of content and settings that you can define, save, and reuse in messages for any of your Amazon Pinpoint applications.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.pinpoint.*;
 * Object tags;
 * CfnPushTemplate cfnPushTemplate = CfnPushTemplate.Builder.create(this, "MyCfnPushTemplate")
 *         .templateName("templateName")
 *         // the properties below are optional
 *         .adm(AndroidPushNotificationTemplateProperty.builder()
 *                 .action("action")
 *                 .body("body")
 *                 .imageIconUrl("imageIconUrl")
 *                 .imageUrl("imageUrl")
 *                 .smallImageIconUrl("smallImageIconUrl")
 *                 .sound("sound")
 *                 .title("title")
 *                 .url("url")
 *                 .build())
 *         .apns(APNSPushNotificationTemplateProperty.builder()
 *                 .action("action")
 *                 .body("body")
 *                 .mediaUrl("mediaUrl")
 *                 .sound("sound")
 *                 .title("title")
 *                 .url("url")
 *                 .build())
 *         .baidu(AndroidPushNotificationTemplateProperty.builder()
 *                 .action("action")
 *                 .body("body")
 *                 .imageIconUrl("imageIconUrl")
 *                 .imageUrl("imageUrl")
 *                 .smallImageIconUrl("smallImageIconUrl")
 *                 .sound("sound")
 *                 .title("title")
 *                 .url("url")
 *                 .build())
 *         .default(DefaultPushNotificationTemplateProperty.builder()
 *                 .action("action")
 *                 .body("body")
 *                 .sound("sound")
 *                 .title("title")
 *                 .url("url")
 *                 .build())
 *         .defaultSubstitutions("defaultSubstitutions")
 *         .gcm(AndroidPushNotificationTemplateProperty.builder()
 *                 .action("action")
 *                 .body("body")
 *                 .imageIconUrl("imageIconUrl")
 *                 .imageUrl("imageUrl")
 *                 .smallImageIconUrl("smallImageIconUrl")
 *                 .sound("sound")
 *                 .title("title")
 *                 .url("url")
 *                 .build())
 *         .tags(tags)
 *         .templateDescription("templateDescription")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:10.916Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnPushTemplate")
public class CfnPushTemplate extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.services.pinpoint.IPushTemplateRef, software.amazon.awscdk.ITaggable {

    protected CfnPushTemplate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPushTemplate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.pinpoint.CfnPushTemplate.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPushTemplate(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.pinpoint.CfnPushTemplateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the message template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a PushTemplate resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.pinpoint.PushTemplateReference getPushTemplateRef() {
        return software.amazon.jsii.Kernel.get(this, "pushTemplateRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.pinpoint.PushTemplateReference.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the message template to use for the message.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTemplateName() {
        return software.amazon.jsii.Kernel.get(this, "templateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the message template to use for the message.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTemplateName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "templateName", java.util.Objects.requireNonNull(value, "templateName is required"));
    }

    /**
     * The message template to use for the ADM (Amazon Device Messaging) channel.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.pinpoint.CfnPushTemplate.AndroidPushNotificationTemplateProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAdm() {
        return software.amazon.jsii.Kernel.get(this, "adm", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The message template to use for the ADM (Amazon Device Messaging) channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdm(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "adm", value);
    }

    /**
     * The message template to use for the ADM (Amazon Device Messaging) channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdm(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.pinpoint.CfnPushTemplate.AndroidPushNotificationTemplateProperty value) {
        software.amazon.jsii.Kernel.set(this, "adm", value);
    }

    /**
     * The message template to use for the APNs (Apple Push Notification service) channel.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.pinpoint.CfnPushTemplate.APNSPushNotificationTemplateProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getApns() {
        return software.amazon.jsii.Kernel.get(this, "apns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The message template to use for the APNs (Apple Push Notification service) channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApns(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "apns", value);
    }

    /**
     * The message template to use for the APNs (Apple Push Notification service) channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApns(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.pinpoint.CfnPushTemplate.APNSPushNotificationTemplateProperty value) {
        software.amazon.jsii.Kernel.set(this, "apns", value);
    }

    /**
     * The message template to use for the Baidu (Baidu Cloud Push) channel.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.pinpoint.CfnPushTemplate.AndroidPushNotificationTemplateProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBaidu() {
        return software.amazon.jsii.Kernel.get(this, "baidu", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The message template to use for the Baidu (Baidu Cloud Push) channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBaidu(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "baidu", value);
    }

    /**
     * The message template to use for the Baidu (Baidu Cloud Push) channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBaidu(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.pinpoint.CfnPushTemplate.AndroidPushNotificationTemplateProperty value) {
        software.amazon.jsii.Kernel.set(this, "baidu", value);
    }

    /**
     * The default message template to use for push notification channels.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.pinpoint.CfnPushTemplate.DefaultPushNotificationTemplateProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDefaultValue() {
        return software.amazon.jsii.Kernel.get(this, "default", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The default message template to use for push notification channels.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultValue(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "default", value);
    }

    /**
     * The default message template to use for push notification channels.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultValue(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.pinpoint.CfnPushTemplate.DefaultPushNotificationTemplateProperty value) {
        software.amazon.jsii.Kernel.set(this, "default", value);
    }

    /**
     * A JSON object that specifies the default values to use for message variables in the message template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDefaultSubstitutions() {
        return software.amazon.jsii.Kernel.get(this, "defaultSubstitutions", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A JSON object that specifies the default values to use for message variables in the message template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultSubstitutions(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "defaultSubstitutions", value);
    }

    /**
     * The message template to use for the GCM channel, which is used to send notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.pinpoint.CfnPushTemplate.AndroidPushNotificationTemplateProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getGcm() {
        return software.amazon.jsii.Kernel.get(this, "gcm", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The message template to use for the GCM channel, which is used to send notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGcm(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "gcm", value);
    }

    /**
     * The message template to use for the GCM channel, which is used to send notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGcm(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.pinpoint.CfnPushTemplate.AndroidPushNotificationTemplateProperty value) {
        software.amazon.jsii.Kernel.set(this, "gcm", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTagsRaw() {
        return software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * A custom description of the message template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTemplateDescription() {
        return software.amazon.jsii.Kernel.get(this, "templateDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A custom description of the message template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTemplateDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "templateDescription", value);
    }
    /**
     * Specifies channel-specific content and settings for a message template that can be used in push notifications that are sent through the APNs (Apple Push Notification service) channel.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * APNSPushNotificationTemplateProperty aPNSPushNotificationTemplateProperty = APNSPushNotificationTemplateProperty.builder()
     *         .action("action")
     *         .body("body")
     *         .mediaUrl("mediaUrl")
     *         .sound("sound")
     *         .title("title")
     *         .url("url")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnPushTemplate.APNSPushNotificationTemplateProperty")
    @software.amazon.jsii.Jsii.Proxy(APNSPushNotificationTemplateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface APNSPushNotificationTemplateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action to occur if a recipient taps a push notification that's based on the message template.
         * <p>
         * Valid values are:
         * <p>
         * <ul>
         * <li><code>OPEN_APP</code> – Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</li>
         * <li><code>DEEP_LINK</code> – Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of the iOS platform.</li>
         * <li><code>URL</code> – The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAction() {
            return null;
        }

        /**
         * The message body to use in push notifications that are based on the message template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-body">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-body</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBody() {
            return null;
        }

        /**
         * The URL of an image or video to display in push notifications that are based on the message template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-mediaurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-mediaurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMediaUrl() {
            return null;
        }

        /**
         * The key for the sound to play when the recipient receives a push notification that's based on the message template.
         * <p>
         * The value for this key is the name of a sound file in your app's main bundle or the <code>Library/Sounds</code> folder in your app's data container. If the sound file can't be found or you specify <code>default</code> for the value, the system plays the default alert sound.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-sound">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-sound</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSound() {
            return null;
        }

        /**
         * The title to use in push notifications that are based on the message template.
         * <p>
         * This title appears above the notification message on a recipient's device.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-title">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-title</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTitle() {
            return null;
        }

        /**
         * The URL to open in the recipient's default mobile browser, if a recipient taps a push notification that's based on the message template and the value of the <code>Action</code> property is <code>URL</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-url">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-url</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link APNSPushNotificationTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link APNSPushNotificationTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<APNSPushNotificationTemplateProperty> {
            java.lang.String action;
            java.lang.String body;
            java.lang.String mediaUrl;
            java.lang.String sound;
            java.lang.String title;
            java.lang.String url;

            /**
             * Sets the value of {@link APNSPushNotificationTemplateProperty#getAction}
             * @param action The action to occur if a recipient taps a push notification that's based on the message template.
             *               Valid values are:
             *               <p>
             *               <ul>
             *               <li><code>OPEN_APP</code> – Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</li>
             *               <li><code>DEEP_LINK</code> – Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of the iOS platform.</li>
             *               <li><code>URL</code> – The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.</li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link APNSPushNotificationTemplateProperty#getBody}
             * @param body The message body to use in push notifications that are based on the message template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder body(java.lang.String body) {
                this.body = body;
                return this;
            }

            /**
             * Sets the value of {@link APNSPushNotificationTemplateProperty#getMediaUrl}
             * @param mediaUrl The URL of an image or video to display in push notifications that are based on the message template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mediaUrl(java.lang.String mediaUrl) {
                this.mediaUrl = mediaUrl;
                return this;
            }

            /**
             * Sets the value of {@link APNSPushNotificationTemplateProperty#getSound}
             * @param sound The key for the sound to play when the recipient receives a push notification that's based on the message template.
             *              The value for this key is the name of a sound file in your app's main bundle or the <code>Library/Sounds</code> folder in your app's data container. If the sound file can't be found or you specify <code>default</code> for the value, the system plays the default alert sound.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sound(java.lang.String sound) {
                this.sound = sound;
                return this;
            }

            /**
             * Sets the value of {@link APNSPushNotificationTemplateProperty#getTitle}
             * @param title The title to use in push notifications that are based on the message template.
             *              This title appears above the notification message on a recipient's device.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder title(java.lang.String title) {
                this.title = title;
                return this;
            }

            /**
             * Sets the value of {@link APNSPushNotificationTemplateProperty#getUrl}
             * @param url The URL to open in the recipient's default mobile browser, if a recipient taps a push notification that's based on the message template and the value of the <code>Action</code> property is <code>URL</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(java.lang.String url) {
                this.url = url;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link APNSPushNotificationTemplateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public APNSPushNotificationTemplateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link APNSPushNotificationTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements APNSPushNotificationTemplateProperty {
            private final java.lang.String action;
            private final java.lang.String body;
            private final java.lang.String mediaUrl;
            private final java.lang.String sound;
            private final java.lang.String title;
            private final java.lang.String url;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.body = software.amazon.jsii.Kernel.get(this, "body", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mediaUrl = software.amazon.jsii.Kernel.get(this, "mediaUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sound = software.amazon.jsii.Kernel.get(this, "sound", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = builder.action;
                this.body = builder.body;
                this.mediaUrl = builder.mediaUrl;
                this.sound = builder.sound;
                this.title = builder.title;
                this.url = builder.url;
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            public final java.lang.String getBody() {
                return this.body;
            }

            @Override
            public final java.lang.String getMediaUrl() {
                return this.mediaUrl;
            }

            @Override
            public final java.lang.String getSound() {
                return this.sound;
            }

            @Override
            public final java.lang.String getTitle() {
                return this.title;
            }

            @Override
            public final java.lang.String getUrl() {
                return this.url;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAction() != null) {
                    data.set("action", om.valueToTree(this.getAction()));
                }
                if (this.getBody() != null) {
                    data.set("body", om.valueToTree(this.getBody()));
                }
                if (this.getMediaUrl() != null) {
                    data.set("mediaUrl", om.valueToTree(this.getMediaUrl()));
                }
                if (this.getSound() != null) {
                    data.set("sound", om.valueToTree(this.getSound()));
                }
                if (this.getTitle() != null) {
                    data.set("title", om.valueToTree(this.getTitle()));
                }
                if (this.getUrl() != null) {
                    data.set("url", om.valueToTree(this.getUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnPushTemplate.APNSPushNotificationTemplateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                APNSPushNotificationTemplateProperty.Jsii$Proxy that = (APNSPushNotificationTemplateProperty.Jsii$Proxy) o;

                if (this.action != null ? !this.action.equals(that.action) : that.action != null) return false;
                if (this.body != null ? !this.body.equals(that.body) : that.body != null) return false;
                if (this.mediaUrl != null ? !this.mediaUrl.equals(that.mediaUrl) : that.mediaUrl != null) return false;
                if (this.sound != null ? !this.sound.equals(that.sound) : that.sound != null) return false;
                if (this.title != null ? !this.title.equals(that.title) : that.title != null) return false;
                return this.url != null ? this.url.equals(that.url) : that.url == null;
            }

            @Override
            public final int hashCode() {
                int result = this.action != null ? this.action.hashCode() : 0;
                result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
                result = 31 * result + (this.mediaUrl != null ? this.mediaUrl.hashCode() : 0);
                result = 31 * result + (this.sound != null ? this.sound.hashCode() : 0);
                result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
                result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies channel-specific content and settings for a message template that can be used in push notifications that are sent through the ADM (Amazon Device Messaging), Baidu (Baidu Cloud Push), or GCM (Firebase Cloud Messaging, formerly Google Cloud Messaging) channel.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * AndroidPushNotificationTemplateProperty androidPushNotificationTemplateProperty = AndroidPushNotificationTemplateProperty.builder()
     *         .action("action")
     *         .body("body")
     *         .imageIconUrl("imageIconUrl")
     *         .imageUrl("imageUrl")
     *         .smallImageIconUrl("smallImageIconUrl")
     *         .sound("sound")
     *         .title("title")
     *         .url("url")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnPushTemplate.AndroidPushNotificationTemplateProperty")
    @software.amazon.jsii.Jsii.Proxy(AndroidPushNotificationTemplateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AndroidPushNotificationTemplateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action to occur if a recipient taps a push notification that's based on the message template.
         * <p>
         * Valid values are:
         * <p>
         * <ul>
         * <li><code>OPEN_APP</code> – Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</li>
         * <li><code>DEEP_LINK</code> – Your app opens and displays a designated user interface in the app. This action uses the deep-linking features of the Android platform.</li>
         * <li><code>URL</code> – The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAction() {
            return null;
        }

        /**
         * The message body to use in a push notification that's based on the message template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-body">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-body</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBody() {
            return null;
        }

        /**
         * The URL of the large icon image to display in the content view of a push notification that's based on the message template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-imageiconurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-imageiconurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImageIconUrl() {
            return null;
        }

        /**
         * The URL of an image to display in a push notification that's based on the message template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-imageurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-imageurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImageUrl() {
            return null;
        }

        /**
         * The URL of the small icon image to display in the status bar and the content view of a push notification that's based on the message template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-smallimageiconurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-smallimageiconurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSmallImageIconUrl() {
            return null;
        }

        /**
         * The sound to play when a recipient receives a push notification that's based on the message template.
         * <p>
         * You can use the default stream or specify the file name of a sound resource that's bundled in your app. On an Android platform, the sound file must reside in <code>/res/raw/</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-sound">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-sound</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSound() {
            return null;
        }

        /**
         * The title to use in a push notification that's based on the message template.
         * <p>
         * This title appears above the notification message on a recipient's device.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-title">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-title</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTitle() {
            return null;
        }

        /**
         * The URL to open in a recipient's default mobile browser, if a recipient taps a push notification that's based on the message template and the value of the <code>Action</code> property is <code>URL</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-url">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-url</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AndroidPushNotificationTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AndroidPushNotificationTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AndroidPushNotificationTemplateProperty> {
            java.lang.String action;
            java.lang.String body;
            java.lang.String imageIconUrl;
            java.lang.String imageUrl;
            java.lang.String smallImageIconUrl;
            java.lang.String sound;
            java.lang.String title;
            java.lang.String url;

            /**
             * Sets the value of {@link AndroidPushNotificationTemplateProperty#getAction}
             * @param action The action to occur if a recipient taps a push notification that's based on the message template.
             *               Valid values are:
             *               <p>
             *               <ul>
             *               <li><code>OPEN_APP</code> – Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</li>
             *               <li><code>DEEP_LINK</code> – Your app opens and displays a designated user interface in the app. This action uses the deep-linking features of the Android platform.</li>
             *               <li><code>URL</code> – The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.</li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link AndroidPushNotificationTemplateProperty#getBody}
             * @param body The message body to use in a push notification that's based on the message template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder body(java.lang.String body) {
                this.body = body;
                return this;
            }

            /**
             * Sets the value of {@link AndroidPushNotificationTemplateProperty#getImageIconUrl}
             * @param imageIconUrl The URL of the large icon image to display in the content view of a push notification that's based on the message template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageIconUrl(java.lang.String imageIconUrl) {
                this.imageIconUrl = imageIconUrl;
                return this;
            }

            /**
             * Sets the value of {@link AndroidPushNotificationTemplateProperty#getImageUrl}
             * @param imageUrl The URL of an image to display in a push notification that's based on the message template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageUrl(java.lang.String imageUrl) {
                this.imageUrl = imageUrl;
                return this;
            }

            /**
             * Sets the value of {@link AndroidPushNotificationTemplateProperty#getSmallImageIconUrl}
             * @param smallImageIconUrl The URL of the small icon image to display in the status bar and the content view of a push notification that's based on the message template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smallImageIconUrl(java.lang.String smallImageIconUrl) {
                this.smallImageIconUrl = smallImageIconUrl;
                return this;
            }

            /**
             * Sets the value of {@link AndroidPushNotificationTemplateProperty#getSound}
             * @param sound The sound to play when a recipient receives a push notification that's based on the message template.
             *              You can use the default stream or specify the file name of a sound resource that's bundled in your app. On an Android platform, the sound file must reside in <code>/res/raw/</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sound(java.lang.String sound) {
                this.sound = sound;
                return this;
            }

            /**
             * Sets the value of {@link AndroidPushNotificationTemplateProperty#getTitle}
             * @param title The title to use in a push notification that's based on the message template.
             *              This title appears above the notification message on a recipient's device.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder title(java.lang.String title) {
                this.title = title;
                return this;
            }

            /**
             * Sets the value of {@link AndroidPushNotificationTemplateProperty#getUrl}
             * @param url The URL to open in a recipient's default mobile browser, if a recipient taps a push notification that's based on the message template and the value of the <code>Action</code> property is <code>URL</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(java.lang.String url) {
                this.url = url;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AndroidPushNotificationTemplateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AndroidPushNotificationTemplateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AndroidPushNotificationTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AndroidPushNotificationTemplateProperty {
            private final java.lang.String action;
            private final java.lang.String body;
            private final java.lang.String imageIconUrl;
            private final java.lang.String imageUrl;
            private final java.lang.String smallImageIconUrl;
            private final java.lang.String sound;
            private final java.lang.String title;
            private final java.lang.String url;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.body = software.amazon.jsii.Kernel.get(this, "body", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.imageIconUrl = software.amazon.jsii.Kernel.get(this, "imageIconUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.imageUrl = software.amazon.jsii.Kernel.get(this, "imageUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.smallImageIconUrl = software.amazon.jsii.Kernel.get(this, "smallImageIconUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sound = software.amazon.jsii.Kernel.get(this, "sound", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = builder.action;
                this.body = builder.body;
                this.imageIconUrl = builder.imageIconUrl;
                this.imageUrl = builder.imageUrl;
                this.smallImageIconUrl = builder.smallImageIconUrl;
                this.sound = builder.sound;
                this.title = builder.title;
                this.url = builder.url;
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            public final java.lang.String getBody() {
                return this.body;
            }

            @Override
            public final java.lang.String getImageIconUrl() {
                return this.imageIconUrl;
            }

            @Override
            public final java.lang.String getImageUrl() {
                return this.imageUrl;
            }

            @Override
            public final java.lang.String getSmallImageIconUrl() {
                return this.smallImageIconUrl;
            }

            @Override
            public final java.lang.String getSound() {
                return this.sound;
            }

            @Override
            public final java.lang.String getTitle() {
                return this.title;
            }

            @Override
            public final java.lang.String getUrl() {
                return this.url;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAction() != null) {
                    data.set("action", om.valueToTree(this.getAction()));
                }
                if (this.getBody() != null) {
                    data.set("body", om.valueToTree(this.getBody()));
                }
                if (this.getImageIconUrl() != null) {
                    data.set("imageIconUrl", om.valueToTree(this.getImageIconUrl()));
                }
                if (this.getImageUrl() != null) {
                    data.set("imageUrl", om.valueToTree(this.getImageUrl()));
                }
                if (this.getSmallImageIconUrl() != null) {
                    data.set("smallImageIconUrl", om.valueToTree(this.getSmallImageIconUrl()));
                }
                if (this.getSound() != null) {
                    data.set("sound", om.valueToTree(this.getSound()));
                }
                if (this.getTitle() != null) {
                    data.set("title", om.valueToTree(this.getTitle()));
                }
                if (this.getUrl() != null) {
                    data.set("url", om.valueToTree(this.getUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnPushTemplate.AndroidPushNotificationTemplateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AndroidPushNotificationTemplateProperty.Jsii$Proxy that = (AndroidPushNotificationTemplateProperty.Jsii$Proxy) o;

                if (this.action != null ? !this.action.equals(that.action) : that.action != null) return false;
                if (this.body != null ? !this.body.equals(that.body) : that.body != null) return false;
                if (this.imageIconUrl != null ? !this.imageIconUrl.equals(that.imageIconUrl) : that.imageIconUrl != null) return false;
                if (this.imageUrl != null ? !this.imageUrl.equals(that.imageUrl) : that.imageUrl != null) return false;
                if (this.smallImageIconUrl != null ? !this.smallImageIconUrl.equals(that.smallImageIconUrl) : that.smallImageIconUrl != null) return false;
                if (this.sound != null ? !this.sound.equals(that.sound) : that.sound != null) return false;
                if (this.title != null ? !this.title.equals(that.title) : that.title != null) return false;
                return this.url != null ? this.url.equals(that.url) : that.url == null;
            }

            @Override
            public final int hashCode() {
                int result = this.action != null ? this.action.hashCode() : 0;
                result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
                result = 31 * result + (this.imageIconUrl != null ? this.imageIconUrl.hashCode() : 0);
                result = 31 * result + (this.imageUrl != null ? this.imageUrl.hashCode() : 0);
                result = 31 * result + (this.smallImageIconUrl != null ? this.smallImageIconUrl.hashCode() : 0);
                result = 31 * result + (this.sound != null ? this.sound.hashCode() : 0);
                result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
                result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the default settings and content for a message template that can be used in messages that are sent through a push notification channel.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * DefaultPushNotificationTemplateProperty defaultPushNotificationTemplateProperty = DefaultPushNotificationTemplateProperty.builder()
     *         .action("action")
     *         .body("body")
     *         .sound("sound")
     *         .title("title")
     *         .url("url")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnPushTemplate.DefaultPushNotificationTemplateProperty")
    @software.amazon.jsii.Jsii.Proxy(DefaultPushNotificationTemplateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DefaultPushNotificationTemplateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action to occur if a recipient taps a push notification that's based on the message template.
         * <p>
         * Valid values are:
         * <p>
         * <ul>
         * <li><code>OPEN_APP</code> – Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</li>
         * <li><code>DEEP_LINK</code> – Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of the iOS and Android platforms.</li>
         * <li><code>URL</code> – The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-defaultpushnotificationtemplate-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-defaultpushnotificationtemplate-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAction() {
            return null;
        }

        /**
         * The message body to use in push notifications that are based on the message template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-defaultpushnotificationtemplate-body">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-defaultpushnotificationtemplate-body</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBody() {
            return null;
        }

        /**
         * The sound to play when a recipient receives a push notification that's based on the message template.
         * <p>
         * You can use the default stream or specify the file name of a sound resource that's bundled in your app. On an Android platform, the sound file must reside in <code>/res/raw/</code> .
         * <p>
         * For an iOS platform, this value is the key for the name of a sound file in your app's main bundle or the <code>Library/Sounds</code> folder in your app's data container. If the sound file can't be found or you specify <code>default</code> for the value, the system plays the default alert sound.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-defaultpushnotificationtemplate-sound">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-defaultpushnotificationtemplate-sound</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSound() {
            return null;
        }

        /**
         * The title to use in push notifications that are based on the message template.
         * <p>
         * This title appears above the notification message on a recipient's device.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-defaultpushnotificationtemplate-title">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-defaultpushnotificationtemplate-title</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTitle() {
            return null;
        }

        /**
         * The URL to open in a recipient's default mobile browser, if a recipient taps a push notification that's based on the message template and the value of the <code>Action</code> property is <code>URL</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-defaultpushnotificationtemplate-url">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-defaultpushnotificationtemplate-url</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DefaultPushNotificationTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DefaultPushNotificationTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DefaultPushNotificationTemplateProperty> {
            java.lang.String action;
            java.lang.String body;
            java.lang.String sound;
            java.lang.String title;
            java.lang.String url;

            /**
             * Sets the value of {@link DefaultPushNotificationTemplateProperty#getAction}
             * @param action The action to occur if a recipient taps a push notification that's based on the message template.
             *               Valid values are:
             *               <p>
             *               <ul>
             *               <li><code>OPEN_APP</code> – Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</li>
             *               <li><code>DEEP_LINK</code> – Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of the iOS and Android platforms.</li>
             *               <li><code>URL</code> – The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.</li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link DefaultPushNotificationTemplateProperty#getBody}
             * @param body The message body to use in push notifications that are based on the message template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder body(java.lang.String body) {
                this.body = body;
                return this;
            }

            /**
             * Sets the value of {@link DefaultPushNotificationTemplateProperty#getSound}
             * @param sound The sound to play when a recipient receives a push notification that's based on the message template.
             *              You can use the default stream or specify the file name of a sound resource that's bundled in your app. On an Android platform, the sound file must reside in <code>/res/raw/</code> .
             *              <p>
             *              For an iOS platform, this value is the key for the name of a sound file in your app's main bundle or the <code>Library/Sounds</code> folder in your app's data container. If the sound file can't be found or you specify <code>default</code> for the value, the system plays the default alert sound.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sound(java.lang.String sound) {
                this.sound = sound;
                return this;
            }

            /**
             * Sets the value of {@link DefaultPushNotificationTemplateProperty#getTitle}
             * @param title The title to use in push notifications that are based on the message template.
             *              This title appears above the notification message on a recipient's device.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder title(java.lang.String title) {
                this.title = title;
                return this;
            }

            /**
             * Sets the value of {@link DefaultPushNotificationTemplateProperty#getUrl}
             * @param url The URL to open in a recipient's default mobile browser, if a recipient taps a push notification that's based on the message template and the value of the <code>Action</code> property is <code>URL</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(java.lang.String url) {
                this.url = url;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DefaultPushNotificationTemplateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DefaultPushNotificationTemplateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DefaultPushNotificationTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefaultPushNotificationTemplateProperty {
            private final java.lang.String action;
            private final java.lang.String body;
            private final java.lang.String sound;
            private final java.lang.String title;
            private final java.lang.String url;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.body = software.amazon.jsii.Kernel.get(this, "body", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sound = software.amazon.jsii.Kernel.get(this, "sound", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = builder.action;
                this.body = builder.body;
                this.sound = builder.sound;
                this.title = builder.title;
                this.url = builder.url;
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            public final java.lang.String getBody() {
                return this.body;
            }

            @Override
            public final java.lang.String getSound() {
                return this.sound;
            }

            @Override
            public final java.lang.String getTitle() {
                return this.title;
            }

            @Override
            public final java.lang.String getUrl() {
                return this.url;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAction() != null) {
                    data.set("action", om.valueToTree(this.getAction()));
                }
                if (this.getBody() != null) {
                    data.set("body", om.valueToTree(this.getBody()));
                }
                if (this.getSound() != null) {
                    data.set("sound", om.valueToTree(this.getSound()));
                }
                if (this.getTitle() != null) {
                    data.set("title", om.valueToTree(this.getTitle()));
                }
                if (this.getUrl() != null) {
                    data.set("url", om.valueToTree(this.getUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnPushTemplate.DefaultPushNotificationTemplateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DefaultPushNotificationTemplateProperty.Jsii$Proxy that = (DefaultPushNotificationTemplateProperty.Jsii$Proxy) o;

                if (this.action != null ? !this.action.equals(that.action) : that.action != null) return false;
                if (this.body != null ? !this.body.equals(that.body) : that.body != null) return false;
                if (this.sound != null ? !this.sound.equals(that.sound) : that.sound != null) return false;
                if (this.title != null ? !this.title.equals(that.title) : that.title != null) return false;
                return this.url != null ? this.url.equals(that.url) : that.url == null;
            }

            @Override
            public final int hashCode() {
                int result = this.action != null ? this.action.hashCode() : 0;
                result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
                result = 31 * result + (this.sound != null ? this.sound.hashCode() : 0);
                result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
                result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.pinpoint.CfnPushTemplate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.pinpoint.CfnPushTemplate> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.pinpoint.CfnPushTemplateProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.pinpoint.CfnPushTemplateProps.Builder();
        }

        /**
         * The name of the message template to use for the message.
         * <p>
         * If specified, this value must match the name of an existing message template.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-templatename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-templatename</a>
         * @param templateName The name of the message template to use for the message. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateName(final java.lang.String templateName) {
            this.props.templateName(templateName);
            return this;
        }

        /**
         * The message template to use for the ADM (Amazon Device Messaging) channel.
         * <p>
         * This message template overrides the default template for push notification channels ( <code>Default</code> ).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-adm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-adm</a>
         * @param adm The message template to use for the ADM (Amazon Device Messaging) channel. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adm(final software.amazon.awscdk.IResolvable adm) {
            this.props.adm(adm);
            return this;
        }
        /**
         * The message template to use for the ADM (Amazon Device Messaging) channel.
         * <p>
         * This message template overrides the default template for push notification channels ( <code>Default</code> ).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-adm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-adm</a>
         * @param adm The message template to use for the ADM (Amazon Device Messaging) channel. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adm(final software.amazon.awscdk.services.pinpoint.CfnPushTemplate.AndroidPushNotificationTemplateProperty adm) {
            this.props.adm(adm);
            return this;
        }

        /**
         * The message template to use for the APNs (Apple Push Notification service) channel.
         * <p>
         * This message template overrides the default template for push notification channels ( <code>Default</code> ).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-apns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-apns</a>
         * @param apns The message template to use for the APNs (Apple Push Notification service) channel. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apns(final software.amazon.awscdk.IResolvable apns) {
            this.props.apns(apns);
            return this;
        }
        /**
         * The message template to use for the APNs (Apple Push Notification service) channel.
         * <p>
         * This message template overrides the default template for push notification channels ( <code>Default</code> ).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-apns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-apns</a>
         * @param apns The message template to use for the APNs (Apple Push Notification service) channel. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apns(final software.amazon.awscdk.services.pinpoint.CfnPushTemplate.APNSPushNotificationTemplateProperty apns) {
            this.props.apns(apns);
            return this;
        }

        /**
         * The message template to use for the Baidu (Baidu Cloud Push) channel.
         * <p>
         * This message template overrides the default template for push notification channels ( <code>Default</code> ).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-baidu">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-baidu</a>
         * @param baidu The message template to use for the Baidu (Baidu Cloud Push) channel. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder baidu(final software.amazon.awscdk.IResolvable baidu) {
            this.props.baidu(baidu);
            return this;
        }
        /**
         * The message template to use for the Baidu (Baidu Cloud Push) channel.
         * <p>
         * This message template overrides the default template for push notification channels ( <code>Default</code> ).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-baidu">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-baidu</a>
         * @param baidu The message template to use for the Baidu (Baidu Cloud Push) channel. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder baidu(final software.amazon.awscdk.services.pinpoint.CfnPushTemplate.AndroidPushNotificationTemplateProperty baidu) {
            this.props.baidu(baidu);
            return this;
        }

        /**
         * The default message template to use for push notification channels.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-default">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-default</a>
         * @param defaultValue The default message template to use for push notification channels. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultValue(final software.amazon.awscdk.IResolvable defaultValue) {
            this.props.defaultValue(defaultValue);
            return this;
        }
        /**
         * The default message template to use for push notification channels.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-default">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-default</a>
         * @param defaultValue The default message template to use for push notification channels. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultValue(final software.amazon.awscdk.services.pinpoint.CfnPushTemplate.DefaultPushNotificationTemplateProperty defaultValue) {
            this.props.defaultValue(defaultValue);
            return this;
        }

        /**
         * A JSON object that specifies the default values to use for message variables in the message template.
         * <p>
         * This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-defaultsubstitutions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-defaultsubstitutions</a>
         * @param defaultSubstitutions A JSON object that specifies the default values to use for message variables in the message template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultSubstitutions(final java.lang.String defaultSubstitutions) {
            this.props.defaultSubstitutions(defaultSubstitutions);
            return this;
        }

        /**
         * The message template to use for the GCM channel, which is used to send notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.
         * <p>
         * This message template overrides the default template for push notification channels ( <code>Default</code> ).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-gcm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-gcm</a>
         * @param gcm The message template to use for the GCM channel, which is used to send notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gcm(final software.amazon.awscdk.IResolvable gcm) {
            this.props.gcm(gcm);
            return this;
        }
        /**
         * The message template to use for the GCM channel, which is used to send notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.
         * <p>
         * This message template overrides the default template for push notification channels ( <code>Default</code> ).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-gcm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-gcm</a>
         * @param gcm The message template to use for the GCM channel, which is used to send notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gcm(final software.amazon.awscdk.services.pinpoint.CfnPushTemplate.AndroidPushNotificationTemplateProperty gcm) {
            this.props.gcm(gcm);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.lang.Object tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * A custom description of the message template.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-templatedescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-templatedescription</a>
         * @param templateDescription A custom description of the message template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateDescription(final java.lang.String templateDescription) {
            this.props.templateDescription(templateDescription);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.pinpoint.CfnPushTemplate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.pinpoint.CfnPushTemplate build() {
            return new software.amazon.awscdk.services.pinpoint.CfnPushTemplate(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
