package software.amazon.awscdk.services.pinpoint;

/**
 * A reference to a EmailChannel resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.pinpoint.*;
 * EmailChannelReference emailChannelReference = EmailChannelReference.builder()
 *         .emailChannelId("emailChannelId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:10.935Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.EmailChannelReference")
@software.amazon.jsii.Jsii.Proxy(EmailChannelReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EmailChannelReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the EmailChannel resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEmailChannelId();

    /**
     * @return a {@link Builder} of {@link EmailChannelReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EmailChannelReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EmailChannelReference> {
        java.lang.String emailChannelId;

        /**
         * Sets the value of {@link EmailChannelReference#getEmailChannelId}
         * @param emailChannelId The Id of the EmailChannel resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailChannelId(java.lang.String emailChannelId) {
            this.emailChannelId = emailChannelId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EmailChannelReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EmailChannelReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EmailChannelReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmailChannelReference {
        private final java.lang.String emailChannelId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.emailChannelId = software.amazon.jsii.Kernel.get(this, "emailChannelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.emailChannelId = java.util.Objects.requireNonNull(builder.emailChannelId, "emailChannelId is required");
        }

        @Override
        public final java.lang.String getEmailChannelId() {
            return this.emailChannelId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("emailChannelId", om.valueToTree(this.getEmailChannelId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.EmailChannelReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EmailChannelReference.Jsii$Proxy that = (EmailChannelReference.Jsii$Proxy) o;

            return this.emailChannelId.equals(that.emailChannelId);
        }

        @Override
        public final int hashCode() {
            int result = this.emailChannelId.hashCode();
            return result;
        }
    }
}
