package software.amazon.awscdk.services.qbusiness;

/**
 * Properties for defining a <code>CfnPlugin</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.qbusiness.*;
 * Object noAuthConfiguration;
 * CfnPluginProps cfnPluginProps = CfnPluginProps.builder()
 *         .authConfiguration(PluginAuthConfigurationProperty.builder()
 *                 .basicAuthConfiguration(BasicAuthConfigurationProperty.builder()
 *                         .roleArn("roleArn")
 *                         .secretArn("secretArn")
 *                         .build())
 *                 .noAuthConfiguration(noAuthConfiguration)
 *                 .oAuth2ClientCredentialConfiguration(OAuth2ClientCredentialConfigurationProperty.builder()
 *                         .roleArn("roleArn")
 *                         .secretArn("secretArn")
 *                         // the properties below are optional
 *                         .authorizationUrl("authorizationUrl")
 *                         .tokenUrl("tokenUrl")
 *                         .build())
 *                 .build())
 *         .displayName("displayName")
 *         .type("type")
 *         // the properties below are optional
 *         .applicationId("applicationId")
 *         .customPluginConfiguration(CustomPluginConfigurationProperty.builder()
 *                 .apiSchema(APISchemaProperty.builder()
 *                         .payload("payload")
 *                         .s3(S3Property.builder()
 *                                 .bucket("bucket")
 *                                 .key("key")
 *                                 .build())
 *                         .build())
 *                 .apiSchemaType("apiSchemaType")
 *                 .description("description")
 *                 .build())
 *         .serverUrl("serverUrl")
 *         .state("state")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:11.100Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnPluginProps")
@software.amazon.jsii.Jsii.Proxy(CfnPluginProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPluginProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Authentication configuration information for an Amazon Q Business plugin.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.qbusiness.CfnPlugin.PluginAuthConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-authconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-authconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getAuthConfiguration();

    /**
     * The name of the plugin.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-displayname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDisplayName();

    /**
     * The type of the plugin.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * The identifier of the application that will contain the plugin.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-applicationid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-applicationid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApplicationId() {
        return null;
    }

    /**
     * Configuration information required to create a custom plugin.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.qbusiness.CfnPlugin.CustomPluginConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-custompluginconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-custompluginconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCustomPluginConfiguration() {
        return null;
    }

    /**
     * The plugin server URL used for configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-serverurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-serverurl</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServerUrl() {
        return null;
    }

    /**
     * The current status of the plugin.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-state</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getState() {
        return null;
    }

    /**
     * A list of key-value pairs that identify or categorize the data source connector.
     * <p>
     * You can also use tags to help control access to the data source connector. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + -
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPluginProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPluginProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPluginProps> {
        java.lang.Object authConfiguration;
        java.lang.String displayName;
        java.lang.String type;
        java.lang.String applicationId;
        java.lang.Object customPluginConfiguration;
        java.lang.String serverUrl;
        java.lang.String state;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnPluginProps#getAuthConfiguration}
         * @param authConfiguration Authentication configuration information for an Amazon Q Business plugin. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authConfiguration(software.amazon.awscdk.IResolvable authConfiguration) {
            this.authConfiguration = authConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnPluginProps#getAuthConfiguration}
         * @param authConfiguration Authentication configuration information for an Amazon Q Business plugin. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authConfiguration(software.amazon.awscdk.services.qbusiness.CfnPlugin.PluginAuthConfigurationProperty authConfiguration) {
            this.authConfiguration = authConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnPluginProps#getDisplayName}
         * @param displayName The name of the plugin. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnPluginProps#getType}
         * @param type The type of the plugin. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnPluginProps#getApplicationId}
         * @param applicationId The identifier of the application that will contain the plugin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationId(java.lang.String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        /**
         * Sets the value of {@link CfnPluginProps#getCustomPluginConfiguration}
         * @param customPluginConfiguration Configuration information required to create a custom plugin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customPluginConfiguration(software.amazon.awscdk.IResolvable customPluginConfiguration) {
            this.customPluginConfiguration = customPluginConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnPluginProps#getCustomPluginConfiguration}
         * @param customPluginConfiguration Configuration information required to create a custom plugin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customPluginConfiguration(software.amazon.awscdk.services.qbusiness.CfnPlugin.CustomPluginConfigurationProperty customPluginConfiguration) {
            this.customPluginConfiguration = customPluginConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnPluginProps#getServerUrl}
         * @param serverUrl The plugin server URL used for configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverUrl(java.lang.String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        /**
         * Sets the value of {@link CfnPluginProps#getState}
         * @param state The current status of the plugin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder state(java.lang.String state) {
            this.state = state;
            return this;
        }

        /**
         * Sets the value of {@link CfnPluginProps#getTags}
         * @param tags A list of key-value pairs that identify or categorize the data source connector.
         *             You can also use tags to help control access to the data source connector. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + -
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPluginProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPluginProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPluginProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPluginProps {
        private final java.lang.Object authConfiguration;
        private final java.lang.String displayName;
        private final java.lang.String type;
        private final java.lang.String applicationId;
        private final java.lang.Object customPluginConfiguration;
        private final java.lang.String serverUrl;
        private final java.lang.String state;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authConfiguration = software.amazon.jsii.Kernel.get(this, "authConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.applicationId = software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customPluginConfiguration = software.amazon.jsii.Kernel.get(this, "customPluginConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.serverUrl = software.amazon.jsii.Kernel.get(this, "serverUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authConfiguration = java.util.Objects.requireNonNull(builder.authConfiguration, "authConfiguration is required");
            this.displayName = java.util.Objects.requireNonNull(builder.displayName, "displayName is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.applicationId = builder.applicationId;
            this.customPluginConfiguration = builder.customPluginConfiguration;
            this.serverUrl = builder.serverUrl;
            this.state = builder.state;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getAuthConfiguration() {
            return this.authConfiguration;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final java.lang.Object getCustomPluginConfiguration() {
            return this.customPluginConfiguration;
        }

        @Override
        public final java.lang.String getServerUrl() {
            return this.serverUrl;
        }

        @Override
        public final java.lang.String getState() {
            return this.state;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("authConfiguration", om.valueToTree(this.getAuthConfiguration()));
            data.set("displayName", om.valueToTree(this.getDisplayName()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getApplicationId() != null) {
                data.set("applicationId", om.valueToTree(this.getApplicationId()));
            }
            if (this.getCustomPluginConfiguration() != null) {
                data.set("customPluginConfiguration", om.valueToTree(this.getCustomPluginConfiguration()));
            }
            if (this.getServerUrl() != null) {
                data.set("serverUrl", om.valueToTree(this.getServerUrl()));
            }
            if (this.getState() != null) {
                data.set("state", om.valueToTree(this.getState()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnPluginProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPluginProps.Jsii$Proxy that = (CfnPluginProps.Jsii$Proxy) o;

            if (!authConfiguration.equals(that.authConfiguration)) return false;
            if (!displayName.equals(that.displayName)) return false;
            if (!type.equals(that.type)) return false;
            if (this.applicationId != null ? !this.applicationId.equals(that.applicationId) : that.applicationId != null) return false;
            if (this.customPluginConfiguration != null ? !this.customPluginConfiguration.equals(that.customPluginConfiguration) : that.customPluginConfiguration != null) return false;
            if (this.serverUrl != null ? !this.serverUrl.equals(that.serverUrl) : that.serverUrl != null) return false;
            if (this.state != null ? !this.state.equals(that.state) : that.state != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authConfiguration.hashCode();
            result = 31 * result + (this.displayName.hashCode());
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.applicationId != null ? this.applicationId.hashCode() : 0);
            result = 31 * result + (this.customPluginConfiguration != null ? this.customPluginConfiguration.hashCode() : 0);
            result = 31 * result + (this.serverUrl != null ? this.serverUrl.hashCode() : 0);
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
