package software.amazon.awscdk.services.qbusiness;

/**
 * A reference to a Plugin resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.qbusiness.*;
 * PluginReference pluginReference = PluginReference.builder()
 *         .applicationId("applicationId")
 *         .pluginArn("pluginArn")
 *         .pluginId("pluginId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:11.128Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.PluginReference")
@software.amazon.jsii.Jsii.Proxy(PluginReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PluginReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ApplicationId of the Plugin resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationId();

    /**
     * The ARN of the Plugin resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPluginArn();

    /**
     * The PluginId of the Plugin resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPluginId();

    /**
     * @return a {@link Builder} of {@link PluginReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PluginReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PluginReference> {
        java.lang.String applicationId;
        java.lang.String pluginArn;
        java.lang.String pluginId;

        /**
         * Sets the value of {@link PluginReference#getApplicationId}
         * @param applicationId The ApplicationId of the Plugin resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationId(java.lang.String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        /**
         * Sets the value of {@link PluginReference#getPluginArn}
         * @param pluginArn The ARN of the Plugin resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pluginArn(java.lang.String pluginArn) {
            this.pluginArn = pluginArn;
            return this;
        }

        /**
         * Sets the value of {@link PluginReference#getPluginId}
         * @param pluginId The PluginId of the Plugin resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pluginId(java.lang.String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PluginReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PluginReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PluginReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PluginReference {
        private final java.lang.String applicationId;
        private final java.lang.String pluginArn;
        private final java.lang.String pluginId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationId = software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pluginArn = software.amazon.jsii.Kernel.get(this, "pluginArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pluginId = software.amazon.jsii.Kernel.get(this, "pluginId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationId = java.util.Objects.requireNonNull(builder.applicationId, "applicationId is required");
            this.pluginArn = java.util.Objects.requireNonNull(builder.pluginArn, "pluginArn is required");
            this.pluginId = java.util.Objects.requireNonNull(builder.pluginId, "pluginId is required");
        }

        @Override
        public final java.lang.String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final java.lang.String getPluginArn() {
            return this.pluginArn;
        }

        @Override
        public final java.lang.String getPluginId() {
            return this.pluginId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationId", om.valueToTree(this.getApplicationId()));
            data.set("pluginArn", om.valueToTree(this.getPluginArn()));
            data.set("pluginId", om.valueToTree(this.getPluginId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.PluginReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PluginReference.Jsii$Proxy that = (PluginReference.Jsii$Proxy) o;

            if (!applicationId.equals(that.applicationId)) return false;
            if (!pluginArn.equals(that.pluginArn)) return false;
            return this.pluginId.equals(that.pluginId);
        }

        @Override
        public final int hashCode() {
            int result = this.applicationId.hashCode();
            result = 31 * result + (this.pluginArn.hashCode());
            result = 31 * result + (this.pluginId.hashCode());
            return result;
        }
    }
}
