package software.amazon.awscdk.services.qbusiness;

/**
 * A reference to a Retriever resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.qbusiness.*;
 * RetrieverReference retrieverReference = RetrieverReference.builder()
 *         .applicationId("applicationId")
 *         .retrieverArn("retrieverArn")
 *         .retrieverId("retrieverId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:11.129Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.RetrieverReference")
@software.amazon.jsii.Jsii.Proxy(RetrieverReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RetrieverReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ApplicationId of the Retriever resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationId();

    /**
     * The ARN of the Retriever resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRetrieverArn();

    /**
     * The RetrieverId of the Retriever resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRetrieverId();

    /**
     * @return a {@link Builder} of {@link RetrieverReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RetrieverReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RetrieverReference> {
        java.lang.String applicationId;
        java.lang.String retrieverArn;
        java.lang.String retrieverId;

        /**
         * Sets the value of {@link RetrieverReference#getApplicationId}
         * @param applicationId The ApplicationId of the Retriever resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationId(java.lang.String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        /**
         * Sets the value of {@link RetrieverReference#getRetrieverArn}
         * @param retrieverArn The ARN of the Retriever resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retrieverArn(java.lang.String retrieverArn) {
            this.retrieverArn = retrieverArn;
            return this;
        }

        /**
         * Sets the value of {@link RetrieverReference#getRetrieverId}
         * @param retrieverId The RetrieverId of the Retriever resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retrieverId(java.lang.String retrieverId) {
            this.retrieverId = retrieverId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RetrieverReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RetrieverReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RetrieverReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RetrieverReference {
        private final java.lang.String applicationId;
        private final java.lang.String retrieverArn;
        private final java.lang.String retrieverId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationId = software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.retrieverArn = software.amazon.jsii.Kernel.get(this, "retrieverArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.retrieverId = software.amazon.jsii.Kernel.get(this, "retrieverId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationId = java.util.Objects.requireNonNull(builder.applicationId, "applicationId is required");
            this.retrieverArn = java.util.Objects.requireNonNull(builder.retrieverArn, "retrieverArn is required");
            this.retrieverId = java.util.Objects.requireNonNull(builder.retrieverId, "retrieverId is required");
        }

        @Override
        public final java.lang.String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final java.lang.String getRetrieverArn() {
            return this.retrieverArn;
        }

        @Override
        public final java.lang.String getRetrieverId() {
            return this.retrieverId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationId", om.valueToTree(this.getApplicationId()));
            data.set("retrieverArn", om.valueToTree(this.getRetrieverArn()));
            data.set("retrieverId", om.valueToTree(this.getRetrieverId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.RetrieverReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RetrieverReference.Jsii$Proxy that = (RetrieverReference.Jsii$Proxy) o;

            if (!applicationId.equals(that.applicationId)) return false;
            if (!retrieverArn.equals(that.retrieverArn)) return false;
            return this.retrieverId.equals(that.retrieverId);
        }

        @Override
        public final int hashCode() {
            int result = this.applicationId.hashCode();
            result = 31 * result + (this.retrieverArn.hashCode());
            result = 31 * result + (this.retrieverId.hashCode());
            return result;
        }
    }
}
